/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_lsa.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_security.h"
_PUBLIC_ enum ndr_err_code ndr_push_lsa_String(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_String *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 2 * strlen_m(r->string)));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 2 * strlen_m(r->string)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->string));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 2 * strlen_m(r->string) / 2));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 2 * strlen_m(r->string) / 2));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->string, 2 * strlen_m(r->string) / 2, sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_String(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_String *r)
{
	uint32_t _ptr_string;
	uint32_t size_string_1 = 0;
	uint32_t length_string_1 = 0;
	TALLOC_CTX *_mem_save_string_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_string));
		if (_ptr_string) {
			NDR_PULL_ALLOC(ndr, r->string);
		} else {
			r->string = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			_mem_save_string_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->string, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->string));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->string));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->string, &size_string_1));
			NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->string, &length_string_1));
			if (length_string_1 > size_string_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_string_1, length_string_1);
			}
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->string, length_string_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string_0, 0);
		}
		if (r->string) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->string, r->size / 2));
		}
		if (r->string) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->string, r->length / 2));
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_String(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_String *r)
{
	ndr_print_lsa_String(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_String(struct ndr_print *ndr, const char *name, const struct lsa_String *r)
{
	ndr_print_struct(ndr, name, "lsa_String");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m(r->string):r->length);
	ndr_print_uint16(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m(r->string):r->size);
	ndr_print_ptr(ndr, "string", r->string);
	ndr->depth++;
	if (r->string) {
		ndr_print_string(ndr, "string", r->string);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_StringLarge(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_StringLarge *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 2 * strlen_m(r->string)));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 2 * strlen_m_term(r->string)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->string));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 2 * strlen_m_term(r->string) / 2));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 2 * strlen_m(r->string) / 2));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->string, 2 * strlen_m(r->string) / 2, sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_StringLarge(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_StringLarge *r)
{
	uint32_t _ptr_string;
	uint32_t size_string_1 = 0;
	uint32_t length_string_1 = 0;
	TALLOC_CTX *_mem_save_string_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_string));
		if (_ptr_string) {
			NDR_PULL_ALLOC(ndr, r->string);
		} else {
			r->string = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			_mem_save_string_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->string, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->string));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->string));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->string, &size_string_1));
			NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->string, &length_string_1));
			if (length_string_1 > size_string_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_string_1, length_string_1);
			}
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->string, length_string_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string_0, 0);
		}
		if (r->string) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->string, r->size / 2));
		}
		if (r->string) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->string, r->length / 2));
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_StringLarge(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_StringLarge *r)
{
	ndr_print_lsa_StringLarge(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_StringLarge(struct ndr_print *ndr, const char *name, const struct lsa_StringLarge *r)
{
	ndr_print_struct(ndr, name, "lsa_StringLarge");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m(r->string):r->length);
	ndr_print_uint16(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m_term(r->string):r->size);
	ndr_print_ptr(ndr, "string", r->string);
	ndr->depth++;
	if (r->string) {
		ndr_print_string(ndr, "string", r->string);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_Strings(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_Strings *r)
{
	uint32_t cntr_names_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->names));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_names_1 = 0; cntr_names_1 < (r->count); cntr_names_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < (r->count); cntr_names_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_Strings(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_Strings *r)
{
	uint32_t _ptr_names;
	uint32_t size_names_1 = 0;
	uint32_t cntr_names_1;
	TALLOC_CTX *_mem_save_names_0 = NULL;
	TALLOC_CTX *_mem_save_names_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_names));
		if (_ptr_names) {
			NDR_PULL_ALLOC(ndr, r->names);
		} else {
			r->names = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->names));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->names, &size_names_1));
			NDR_PULL_ALLOC_N(ndr, r->names, size_names_1);
			_mem_save_names_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			for (cntr_names_1 = 0; cntr_names_1 < (size_names_1); cntr_names_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < (size_names_1); cntr_names_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		}
		if (r->names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->names, r->count));
		}
		for (cntr_names_1 = 0; cntr_names_1 < (size_names_1); cntr_names_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_Strings(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_Strings *r)
{
	ndr_print_lsa_Strings(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_Strings(struct ndr_print *ndr, const char *name, const struct lsa_Strings *r)
{
	uint32_t cntr_names_1;
	ndr_print_struct(ndr, name, "lsa_Strings");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "names", r->names);
	ndr->depth++;
	if (r->names) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "names", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_names_1 = 0; cntr_names_1 < (r->count); cntr_names_1++) {
			ndr_print_lsa_String(ndr, "names", &r->names[cntr_names_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_AsciiString(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_AsciiString *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, strlen_m(r->string)));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, strlen_m(r->string)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->string));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, strlen_m(r->string)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, strlen_m(r->string)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->string, strlen_m(r->string), sizeof(uint8_t), CH_DOS));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_AsciiString(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_AsciiString *r)
{
	uint32_t _ptr_string;
	uint32_t size_string_1 = 0;
	uint32_t length_string_1 = 0;
	TALLOC_CTX *_mem_save_string_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_string));
		if (_ptr_string) {
			NDR_PULL_ALLOC(ndr, r->string);
		} else {
			r->string = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			_mem_save_string_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->string, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->string));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->string));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->string, &size_string_1));
			NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->string, &length_string_1));
			if (length_string_1 > size_string_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_string_1, length_string_1);
			}
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->string, length_string_1, sizeof(uint8_t), CH_DOS));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string_0, 0);
		}
		if (r->string) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->string, r->size));
		}
		if (r->string) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->string, r->length));
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_AsciiString(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_AsciiString *r)
{
	ndr_print_lsa_AsciiString(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_AsciiString(struct ndr_print *ndr, const char *name, const struct lsa_AsciiString *r)
{
	ndr_print_struct(ndr, name, "lsa_AsciiString");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m(r->string):r->length);
	ndr_print_uint16(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m(r->string):r->size);
	ndr_print_ptr(ndr, "string", r->string);
	ndr->depth++;
	if (r->string) {
		ndr_print_string(ndr, "string", r->string);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_AsciiStringLarge(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_AsciiStringLarge *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, strlen_m(r->string)));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, strlen_m_term(r->string)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->string));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, strlen_m_term(r->string)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, strlen_m(r->string)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->string, strlen_m(r->string), sizeof(uint8_t), CH_DOS));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_AsciiStringLarge(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_AsciiStringLarge *r)
{
	uint32_t _ptr_string;
	uint32_t size_string_1 = 0;
	uint32_t length_string_1 = 0;
	TALLOC_CTX *_mem_save_string_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_string));
		if (_ptr_string) {
			NDR_PULL_ALLOC(ndr, r->string);
		} else {
			r->string = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			_mem_save_string_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->string, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->string));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->string));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->string, &size_string_1));
			NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->string, &length_string_1));
			if (length_string_1 > size_string_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_string_1, length_string_1);
			}
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->string, length_string_1, sizeof(uint8_t), CH_DOS));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string_0, 0);
		}
		if (r->string) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->string, r->size));
		}
		if (r->string) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->string, r->length));
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_AsciiStringLarge(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_AsciiStringLarge *r)
{
	ndr_print_lsa_AsciiStringLarge(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_AsciiStringLarge(struct ndr_print *ndr, const char *name, const struct lsa_AsciiStringLarge *r)
{
	ndr_print_struct(ndr, name, "lsa_AsciiStringLarge");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m(r->string):r->length);
	ndr_print_uint16(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m_term(r->string):r->size);
	ndr_print_ptr(ndr, "string", r->string);
	ndr->depth++;
	if (r->string) {
		ndr_print_string(ndr, "string", r->string);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_BinaryString(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_BinaryString *r)
{
	uint32_t cntr_array_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->size / 2));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->length / 2));
			for (cntr_array_1 = 0; cntr_array_1 < (r->length / 2); cntr_array_1++) {
				NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_BinaryString(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_BinaryString *r)
{
	uint32_t _ptr_array;
	uint32_t size_array_1 = 0;
	uint32_t length_array_1 = 0;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	TALLOC_CTX *_mem_save_array_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->array));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_1));
			NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->array, &length_array_1));
			if (length_array_1 > size_array_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_array_1, length_array_1);
			}
			NDR_PULL_ALLOC_N(ndr, r->array, size_array_1);
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < (length_array_1); cntr_array_1++) {
				NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->array, r->size / 2));
		}
		if (r->array) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->array, r->length / 2));
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_BinaryString(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_BinaryString *r)
{
	ndr_print_lsa_BinaryString(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_BinaryString(struct ndr_print *ndr, const char *name, const struct lsa_BinaryString *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "lsa_BinaryString");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "length", r->length);
	ndr_print_uint16(ndr, "size", r->size);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->length / 2));
		ndr->depth++;
		for (cntr_array_1 = 0; cntr_array_1 < (r->length / 2); cntr_array_1++) {
			ndr_print_uint16(ndr, "array", r->array[cntr_array_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_LUID(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_LUID *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->low));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->high));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_LUID(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_LUID *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->low));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->high));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LUID(struct ndr_print *ndr, const char *name, const struct lsa_LUID *r)
{
	ndr_print_struct(ndr, name, "lsa_LUID");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "low", r->low);
	ndr_print_uint32(ndr, "high", r->high);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_PrivEntry(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_PrivEntry *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_push_lsa_LUID(ndr, NDR_SCALARS, &r->luid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->name));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_PrivEntry(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_PrivEntry *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_lsa_LUID(ndr, NDR_SCALARS, &r->luid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->name));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_PrivEntry(struct ndr_print *ndr, const char *name, const struct lsa_PrivEntry *r)
{
	ndr_print_struct(ndr, name, "lsa_PrivEntry");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_StringLarge(ndr, "name", &r->name);
	ndr_print_lsa_LUID(ndr, "luid", &r->luid);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_PrivArray(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_PrivArray *r)
{
	uint32_t cntr_privs_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->privs));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->privs) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_privs_1 = 0; cntr_privs_1 < (r->count); cntr_privs_1++) {
				NDR_CHECK(ndr_push_lsa_PrivEntry(ndr, NDR_SCALARS, &r->privs[cntr_privs_1]));
			}
			for (cntr_privs_1 = 0; cntr_privs_1 < (r->count); cntr_privs_1++) {
				NDR_CHECK(ndr_push_lsa_PrivEntry(ndr, NDR_BUFFERS, &r->privs[cntr_privs_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_PrivArray(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_PrivArray *r)
{
	uint32_t _ptr_privs;
	uint32_t size_privs_1 = 0;
	uint32_t cntr_privs_1;
	TALLOC_CTX *_mem_save_privs_0 = NULL;
	TALLOC_CTX *_mem_save_privs_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_privs));
		if (_ptr_privs) {
			NDR_PULL_ALLOC(ndr, r->privs);
		} else {
			r->privs = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->privs) {
			_mem_save_privs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->privs, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->privs));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->privs, &size_privs_1));
			NDR_PULL_ALLOC_N(ndr, r->privs, size_privs_1);
			_mem_save_privs_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->privs, 0);
			for (cntr_privs_1 = 0; cntr_privs_1 < (size_privs_1); cntr_privs_1++) {
				NDR_CHECK(ndr_pull_lsa_PrivEntry(ndr, NDR_SCALARS, &r->privs[cntr_privs_1]));
			}
			for (cntr_privs_1 = 0; cntr_privs_1 < (size_privs_1); cntr_privs_1++) {
				NDR_CHECK(ndr_pull_lsa_PrivEntry(ndr, NDR_BUFFERS, &r->privs[cntr_privs_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privs_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privs_0, 0);
		}
		if (r->privs) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->privs, r->count));
		}
		for (cntr_privs_1 = 0; cntr_privs_1 < (size_privs_1); cntr_privs_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_PrivArray(struct ndr_print *ndr, const char *name, const struct lsa_PrivArray *r)
{
	uint32_t cntr_privs_1;
	ndr_print_struct(ndr, name, "lsa_PrivArray");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "privs", r->privs);
	ndr->depth++;
	if (r->privs) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "privs", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_privs_1 = 0; cntr_privs_1 < (r->count); cntr_privs_1++) {
			ndr_print_lsa_PrivEntry(ndr, "privs", &r->privs[cntr_privs_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_SecurityImpersonationLevel(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum lsa_SecurityImpersonationLevel r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_SecurityImpersonationLevel(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum lsa_SecurityImpersonationLevel *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_SecurityImpersonationLevel(struct ndr_print *ndr, const char *name, enum lsa_SecurityImpersonationLevel r)
{
	const char *val = NULL;

	switch (r) {
		case LSA_SECURITY_ANONYMOUS: val = "LSA_SECURITY_ANONYMOUS"; break;
		case LSA_SECURITY_IDENTIFICATION: val = "LSA_SECURITY_IDENTIFICATION"; break;
		case LSA_SECURITY_IMPERSONATION: val = "LSA_SECURITY_IMPERSONATION"; break;
		case LSA_SECURITY_DELEGATION: val = "LSA_SECURITY_DELEGATION"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_lsa_QosInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_QosInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->len));
		NDR_CHECK(ndr_push_lsa_SecurityImpersonationLevel(ndr, NDR_SCALARS, r->impersonation_level));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->context_mode));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->effective_only));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_QosInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_QosInfo *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &r->len));
		NDR_CHECK(ndr_pull_lsa_SecurityImpersonationLevel(ndr, NDR_SCALARS, &r->impersonation_level));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->context_mode));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->effective_only));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_QosInfo(struct ndr_print *ndr, const char *name, const struct lsa_QosInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_QosInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint3264(ndr, "len", r->len);
	ndr_print_lsa_SecurityImpersonationLevel(ndr, "impersonation_level", r->impersonation_level);
	ndr_print_uint8(ndr, "context_mode", r->context_mode);
	ndr_print_uint8(ndr, "effective_only", r->effective_only);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_ObjectAttribute(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_ObjectAttribute *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->len));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->root_dir));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->object_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->attributes));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sec_desc));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sec_qos));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->root_dir) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->root_dir));
		}
		if (r->object_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->object_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->object_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->object_name, ndr_charset_length(r->object_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->sec_desc) {
			NDR_CHECK(ndr_push_security_descriptor(ndr, NDR_SCALARS|NDR_BUFFERS, r->sec_desc));
		}
		if (r->sec_qos) {
			NDR_CHECK(ndr_push_lsa_QosInfo(ndr, NDR_SCALARS, r->sec_qos));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_ObjectAttribute(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_ObjectAttribute *r)
{
	uint32_t _ptr_root_dir;
	TALLOC_CTX *_mem_save_root_dir_0 = NULL;
	uint32_t _ptr_object_name;
	uint32_t size_object_name_1 = 0;
	uint32_t length_object_name_1 = 0;
	TALLOC_CTX *_mem_save_object_name_0 = NULL;
	uint32_t _ptr_sec_desc;
	TALLOC_CTX *_mem_save_sec_desc_0 = NULL;
	uint32_t _ptr_sec_qos;
	TALLOC_CTX *_mem_save_sec_qos_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &r->len));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_root_dir));
		if (_ptr_root_dir) {
			NDR_PULL_ALLOC(ndr, r->root_dir);
		} else {
			r->root_dir = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_object_name));
		if (_ptr_object_name) {
			NDR_PULL_ALLOC(ndr, r->object_name);
		} else {
			r->object_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->attributes));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sec_desc));
		if (_ptr_sec_desc) {
			NDR_PULL_ALLOC(ndr, r->sec_desc);
		} else {
			r->sec_desc = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sec_qos));
		if (_ptr_sec_qos) {
			NDR_PULL_ALLOC(ndr, r->sec_qos);
		} else {
			r->sec_qos = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->root_dir) {
			_mem_save_root_dir_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->root_dir, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->root_dir));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_root_dir_0, 0);
		}
		if (r->object_name) {
			_mem_save_object_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->object_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->object_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->object_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->object_name, &size_object_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->object_name, &length_object_name_1));
			if (length_object_name_1 > size_object_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_object_name_1, length_object_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_object_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->object_name, length_object_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_object_name_0, 0);
		}
		if (r->sec_desc) {
			_mem_save_sec_desc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sec_desc, 0);
			NDR_CHECK(ndr_pull_security_descriptor(ndr, NDR_SCALARS|NDR_BUFFERS, r->sec_desc));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sec_desc_0, 0);
		}
		if (r->sec_qos) {
			_mem_save_sec_qos_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sec_qos, 0);
			NDR_CHECK(ndr_pull_lsa_QosInfo(ndr, NDR_SCALARS, r->sec_qos));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sec_qos_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_ObjectAttribute(struct ndr_print *ndr, const char *name, const struct lsa_ObjectAttribute *r)
{
	ndr_print_struct(ndr, name, "lsa_ObjectAttribute");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint3264(ndr, "len", r->len);
	ndr_print_ptr(ndr, "root_dir", r->root_dir);
	ndr->depth++;
	if (r->root_dir) {
		ndr_print_uint8(ndr, "root_dir", *r->root_dir);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "object_name", r->object_name);
	ndr->depth++;
	if (r->object_name) {
		ndr_print_string(ndr, "object_name", r->object_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "attributes", r->attributes);
	ndr_print_ptr(ndr, "sec_desc", r->sec_desc);
	ndr->depth++;
	if (r->sec_desc) {
		ndr_print_security_descriptor(ndr, "sec_desc", r->sec_desc);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "sec_qos", r->sec_qos);
	ndr->depth++;
	if (r->sec_qos) {
		ndr_print_lsa_QosInfo(ndr, "sec_qos", r->sec_qos);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_PolicyAccessMask(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_PolicyAccessMask(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_PolicyAccessMask(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_POLICY_VIEW_LOCAL_INFORMATION", LSA_POLICY_VIEW_LOCAL_INFORMATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_POLICY_VIEW_AUDIT_INFORMATION", LSA_POLICY_VIEW_AUDIT_INFORMATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_POLICY_GET_PRIVATE_INFORMATION", LSA_POLICY_GET_PRIVATE_INFORMATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_POLICY_TRUST_ADMIN", LSA_POLICY_TRUST_ADMIN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_POLICY_CREATE_ACCOUNT", LSA_POLICY_CREATE_ACCOUNT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_POLICY_CREATE_SECRET", LSA_POLICY_CREATE_SECRET, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_POLICY_CREATE_PRIVILEGE", LSA_POLICY_CREATE_PRIVILEGE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_POLICY_SET_DEFAULT_QUOTA_LIMITS", LSA_POLICY_SET_DEFAULT_QUOTA_LIMITS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_POLICY_SET_AUDIT_REQUIREMENTS", LSA_POLICY_SET_AUDIT_REQUIREMENTS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_POLICY_AUDIT_LOG_ADMIN", LSA_POLICY_AUDIT_LOG_ADMIN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_POLICY_SERVER_ADMIN", LSA_POLICY_SERVER_ADMIN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_POLICY_LOOKUP_NAMES", LSA_POLICY_LOOKUP_NAMES, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_POLICY_NOTIFICATION", LSA_POLICY_NOTIFICATION, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_AccountAccessMask(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_AccountAccessMask(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_AccountAccessMask(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_ACCOUNT_VIEW", LSA_ACCOUNT_VIEW, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_ACCOUNT_ADJUST_PRIVILEGES", LSA_ACCOUNT_ADJUST_PRIVILEGES, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_ACCOUNT_ADJUST_QUOTAS", LSA_ACCOUNT_ADJUST_QUOTAS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_ACCOUNT_ADJUST_SYSTEM_ACCESS", LSA_ACCOUNT_ADJUST_SYSTEM_ACCESS, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_SecretAccessMask(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_SecretAccessMask(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_SecretAccessMask(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_SECRET_SET_VALUE", LSA_SECRET_SET_VALUE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_SECRET_QUERY_VALUE", LSA_SECRET_QUERY_VALUE, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_TrustedAccessMask(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_TrustedAccessMask(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustedAccessMask(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUSTED_QUERY_DOMAIN_NAME", LSA_TRUSTED_QUERY_DOMAIN_NAME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUSTED_QUERY_CONTROLLERS", LSA_TRUSTED_QUERY_CONTROLLERS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUSTED_SET_CONTROLLERS", LSA_TRUSTED_SET_CONTROLLERS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUSTED_QUERY_POSIX", LSA_TRUSTED_QUERY_POSIX, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUSTED_SET_POSIX", LSA_TRUSTED_SET_POSIX, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUSTED_SET_AUTH", LSA_TRUSTED_SET_AUTH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUSTED_QUERY_AUTH", LSA_TRUSTED_QUERY_AUTH, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_AuditLogInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_AuditLogInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->percent_full));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maximum_log_size));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->retention_time));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->shutdown_in_progress));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->time_to_shutdown));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->next_audit_record));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_AuditLogInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_AuditLogInfo *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->percent_full));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maximum_log_size));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->retention_time));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->shutdown_in_progress));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->time_to_shutdown));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->next_audit_record));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_AuditLogInfo(struct ndr_print *ndr, const char *name, const struct lsa_AuditLogInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_AuditLogInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "percent_full", r->percent_full);
	ndr_print_uint32(ndr, "maximum_log_size", r->maximum_log_size);
	ndr_print_hyper(ndr, "retention_time", r->retention_time);
	ndr_print_uint8(ndr, "shutdown_in_progress", r->shutdown_in_progress);
	ndr_print_hyper(ndr, "time_to_shutdown", r->time_to_shutdown);
	ndr_print_uint32(ndr, "next_audit_record", r->next_audit_record);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_PolicyAuditPolicy(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum lsa_PolicyAuditPolicy r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_PolicyAuditPolicy(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum lsa_PolicyAuditPolicy *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_PolicyAuditPolicy(struct ndr_print *ndr, const char *name, enum lsa_PolicyAuditPolicy r)
{
	const char *val = NULL;

	switch (r) {
		case LSA_AUDIT_POLICY_NONE: val = "LSA_AUDIT_POLICY_NONE"; break;
		case LSA_AUDIT_POLICY_SUCCESS: val = "LSA_AUDIT_POLICY_SUCCESS"; break;
		case LSA_AUDIT_POLICY_FAILURE: val = "LSA_AUDIT_POLICY_FAILURE"; break;
		case LSA_AUDIT_POLICY_ALL: val = "LSA_AUDIT_POLICY_ALL"; break;
		case LSA_AUDIT_POLICY_CLEAR: val = "LSA_AUDIT_POLICY_CLEAR"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_lsa_AuditEventsInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_AuditEventsInfo *r)
{
	uint32_t cntr_settings_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->auditing_mode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->settings));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->settings) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_settings_1 = 0; cntr_settings_1 < (r->count); cntr_settings_1++) {
				NDR_CHECK(ndr_push_lsa_PolicyAuditPolicy(ndr, NDR_SCALARS, r->settings[cntr_settings_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_AuditEventsInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_AuditEventsInfo *r)
{
	uint32_t _ptr_settings;
	uint32_t size_settings_1 = 0;
	uint32_t cntr_settings_1;
	TALLOC_CTX *_mem_save_settings_0 = NULL;
	TALLOC_CTX *_mem_save_settings_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->auditing_mode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_settings));
		if (_ptr_settings) {
			NDR_PULL_ALLOC(ndr, r->settings);
		} else {
			r->settings = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->settings) {
			_mem_save_settings_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->settings, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->settings));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->settings, &size_settings_1));
			NDR_PULL_ALLOC_N(ndr, r->settings, size_settings_1);
			_mem_save_settings_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->settings, 0);
			for (cntr_settings_1 = 0; cntr_settings_1 < (size_settings_1); cntr_settings_1++) {
				NDR_CHECK(ndr_pull_lsa_PolicyAuditPolicy(ndr, NDR_SCALARS, &r->settings[cntr_settings_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_settings_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_settings_0, 0);
		}
		if (r->settings) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->settings, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_AuditEventsInfo(struct ndr_print *ndr, const char *name, const struct lsa_AuditEventsInfo *r)
{
	uint32_t cntr_settings_1;
	ndr_print_struct(ndr, name, "lsa_AuditEventsInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "auditing_mode", r->auditing_mode);
	ndr_print_ptr(ndr, "settings", r->settings);
	ndr->depth++;
	if (r->settings) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "settings", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_settings_1 = 0; cntr_settings_1 < (r->count); cntr_settings_1++) {
			ndr_print_lsa_PolicyAuditPolicy(ndr, "settings", r->settings[cntr_settings_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "count", r->count);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_DomainInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_DomainInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->name));
		if (r->sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_DomainInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_DomainInfo *r)
{
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, r->sid);
		} else {
			r->sid = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->name));
		if (r->sid) {
			_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_DomainInfo(struct ndr_print *ndr, const char *name, const struct lsa_DomainInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_DomainInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_StringLarge(ndr, "name", &r->name);
	ndr_print_ptr(ndr, "sid", r->sid);
	ndr->depth++;
	if (r->sid) {
		ndr_print_dom_sid2(ndr, "sid", r->sid);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_PDAccountInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_PDAccountInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->name));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_PDAccountInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_PDAccountInfo *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->name));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_PDAccountInfo(struct ndr_print *ndr, const char *name, const struct lsa_PDAccountInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_PDAccountInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "name", &r->name);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Role(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum lsa_Role r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Role(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum lsa_Role *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Role(struct ndr_print *ndr, const char *name, enum lsa_Role r)
{
	const char *val = NULL;

	switch (r) {
		case LSA_ROLE_BACKUP: val = "LSA_ROLE_BACKUP"; break;
		case LSA_ROLE_PRIMARY: val = "LSA_ROLE_PRIMARY"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_lsa_ServerRole(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_ServerRole *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_Role(ndr, NDR_SCALARS, r->role));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_ServerRole(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_ServerRole *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_Role(ndr, NDR_SCALARS, &r->role));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_ServerRole(struct ndr_print *ndr, const char *name, const struct lsa_ServerRole *r)
{
	ndr_print_struct(ndr, name, "lsa_ServerRole");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_Role(ndr, "role", r->role);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_ReplicaSourceInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_ReplicaSourceInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->source));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->account));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->source));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->account));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_ReplicaSourceInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_ReplicaSourceInfo *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->source));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->account));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->source));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->account));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_ReplicaSourceInfo(struct ndr_print *ndr, const char *name, const struct lsa_ReplicaSourceInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_ReplicaSourceInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "source", &r->source);
	ndr_print_lsa_String(ndr, "account", &r->account);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_DefaultQuotaInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_DefaultQuotaInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->paged_pool));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->non_paged_pool));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->min_wss));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_wss));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pagefile));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->unknown));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_DefaultQuotaInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_DefaultQuotaInfo *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->paged_pool));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->non_paged_pool));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->min_wss));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_wss));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pagefile));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->unknown));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_DefaultQuotaInfo(struct ndr_print *ndr, const char *name, const struct lsa_DefaultQuotaInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_DefaultQuotaInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "paged_pool", r->paged_pool);
	ndr_print_uint32(ndr, "non_paged_pool", r->non_paged_pool);
	ndr_print_uint32(ndr, "min_wss", r->min_wss);
	ndr_print_uint32(ndr, "max_wss", r->max_wss);
	ndr_print_uint32(ndr, "pagefile", r->pagefile);
	ndr_print_hyper(ndr, "unknown", r->unknown);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_ModificationInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_ModificationInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->modified_id));
		NDR_CHECK(ndr_push_NTTIME_hyper(ndr, NDR_SCALARS, r->db_create_time));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_ModificationInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_ModificationInfo *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->modified_id));
		NDR_CHECK(ndr_pull_NTTIME_hyper(ndr, NDR_SCALARS, &r->db_create_time));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_ModificationInfo(struct ndr_print *ndr, const char *name, const struct lsa_ModificationInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_ModificationInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "modified_id", r->modified_id);
	ndr_print_NTTIME_hyper(ndr, "db_create_time", r->db_create_time);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_AuditFullSetInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_AuditFullSetInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->shutdown_on_full));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_AuditFullSetInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_AuditFullSetInfo *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->shutdown_on_full));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_AuditFullSetInfo(struct ndr_print *ndr, const char *name, const struct lsa_AuditFullSetInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_AuditFullSetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "shutdown_on_full", r->shutdown_on_full);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_AuditFullQueryInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_AuditFullQueryInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->shutdown_on_full));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->log_is_full));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_AuditFullQueryInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_AuditFullQueryInfo *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->shutdown_on_full));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->log_is_full));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_AuditFullQueryInfo(struct ndr_print *ndr, const char *name, const struct lsa_AuditFullQueryInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_AuditFullQueryInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "shutdown_on_full", r->shutdown_on_full);
	ndr_print_uint8(ndr, "log_is_full", r->log_is_full);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_DnsDomainInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_DnsDomainInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->dns_domain));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->dns_forest));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->domain_guid));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->name));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dns_domain));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dns_forest));
		if (r->sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_DnsDomainInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_DnsDomainInfo *r)
{
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->dns_domain));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->dns_forest));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->domain_guid));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, r->sid);
		} else {
			r->sid = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->name));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dns_domain));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dns_forest));
		if (r->sid) {
			_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_DnsDomainInfo(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_DnsDomainInfo *r)
{
	ndr_print_lsa_DnsDomainInfo(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_DnsDomainInfo(struct ndr_print *ndr, const char *name, const struct lsa_DnsDomainInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_DnsDomainInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_StringLarge(ndr, "name", &r->name);
	ndr_print_lsa_StringLarge(ndr, "dns_domain", &r->dns_domain);
	ndr_print_lsa_StringLarge(ndr, "dns_forest", &r->dns_forest);
	ndr_print_GUID(ndr, "domain_guid", &r->domain_guid);
	ndr_print_ptr(ndr, "sid", r->sid);
	ndr->depth++;
	if (r->sid) {
		ndr_print_dom_sid2(ndr, "sid", r->sid);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_PolicyInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum lsa_PolicyInfo r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_PolicyInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum lsa_PolicyInfo *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_PolicyInfo(struct ndr_print *ndr, const char *name, enum lsa_PolicyInfo r)
{
	const char *val = NULL;

	switch (r) {
		case LSA_POLICY_INFO_AUDIT_LOG: val = "LSA_POLICY_INFO_AUDIT_LOG"; break;
		case LSA_POLICY_INFO_AUDIT_EVENTS: val = "LSA_POLICY_INFO_AUDIT_EVENTS"; break;
		case LSA_POLICY_INFO_DOMAIN: val = "LSA_POLICY_INFO_DOMAIN"; break;
		case LSA_POLICY_INFO_PD: val = "LSA_POLICY_INFO_PD"; break;
		case LSA_POLICY_INFO_ACCOUNT_DOMAIN: val = "LSA_POLICY_INFO_ACCOUNT_DOMAIN"; break;
		case LSA_POLICY_INFO_ROLE: val = "LSA_POLICY_INFO_ROLE"; break;
		case LSA_POLICY_INFO_REPLICA: val = "LSA_POLICY_INFO_REPLICA"; break;
		case LSA_POLICY_INFO_QUOTA: val = "LSA_POLICY_INFO_QUOTA"; break;
		case LSA_POLICY_INFO_MOD: val = "LSA_POLICY_INFO_MOD"; break;
		case LSA_POLICY_INFO_AUDIT_FULL_SET: val = "LSA_POLICY_INFO_AUDIT_FULL_SET"; break;
		case LSA_POLICY_INFO_AUDIT_FULL_QUERY: val = "LSA_POLICY_INFO_AUDIT_FULL_QUERY"; break;
		case LSA_POLICY_INFO_DNS: val = "LSA_POLICY_INFO_DNS"; break;
		case LSA_POLICY_INFO_DNS_INT: val = "LSA_POLICY_INFO_DNS_INT"; break;
		case LSA_POLICY_INFO_L_ACCOUNT_DOMAIN: val = "LSA_POLICY_INFO_L_ACCOUNT_DOMAIN"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_lsa_PolicyInformation(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union lsa_PolicyInformation *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		switch (level) {
			case LSA_POLICY_INFO_AUDIT_LOG: {
				NDR_CHECK(ndr_push_lsa_AuditLogInfo(ndr, NDR_SCALARS, &r->audit_log));
			break; }

			case LSA_POLICY_INFO_AUDIT_EVENTS: {
				NDR_CHECK(ndr_push_lsa_AuditEventsInfo(ndr, NDR_SCALARS, &r->audit_events));
			break; }

			case LSA_POLICY_INFO_DOMAIN: {
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_SCALARS, &r->domain));
			break; }

			case LSA_POLICY_INFO_PD: {
				NDR_CHECK(ndr_push_lsa_PDAccountInfo(ndr, NDR_SCALARS, &r->pd));
			break; }

			case LSA_POLICY_INFO_ACCOUNT_DOMAIN: {
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_SCALARS, &r->account_domain));
			break; }

			case LSA_POLICY_INFO_ROLE: {
				NDR_CHECK(ndr_push_lsa_ServerRole(ndr, NDR_SCALARS, &r->role));
			break; }

			case LSA_POLICY_INFO_REPLICA: {
				NDR_CHECK(ndr_push_lsa_ReplicaSourceInfo(ndr, NDR_SCALARS, &r->replica));
			break; }

			case LSA_POLICY_INFO_QUOTA: {
				NDR_CHECK(ndr_push_lsa_DefaultQuotaInfo(ndr, NDR_SCALARS, &r->quota));
			break; }

			case LSA_POLICY_INFO_MOD: {
				NDR_CHECK(ndr_push_lsa_ModificationInfo(ndr, NDR_SCALARS, &r->mod));
			break; }

			case LSA_POLICY_INFO_AUDIT_FULL_SET: {
				NDR_CHECK(ndr_push_lsa_AuditFullSetInfo(ndr, NDR_SCALARS, &r->auditfullset));
			break; }

			case LSA_POLICY_INFO_AUDIT_FULL_QUERY: {
				NDR_CHECK(ndr_push_lsa_AuditFullQueryInfo(ndr, NDR_SCALARS, &r->auditfullquery));
			break; }

			case LSA_POLICY_INFO_DNS: {
				NDR_CHECK(ndr_push_lsa_DnsDomainInfo(ndr, NDR_SCALARS, &r->dns));
			break; }

			case LSA_POLICY_INFO_DNS_INT: {
				NDR_CHECK(ndr_push_lsa_DnsDomainInfo(ndr, NDR_SCALARS, &r->dns_int));
			break; }

			case LSA_POLICY_INFO_L_ACCOUNT_DOMAIN: {
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_SCALARS, &r->l_account_domain));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case LSA_POLICY_INFO_AUDIT_LOG:
			break;

			case LSA_POLICY_INFO_AUDIT_EVENTS:
				NDR_CHECK(ndr_push_lsa_AuditEventsInfo(ndr, NDR_BUFFERS, &r->audit_events));
			break;

			case LSA_POLICY_INFO_DOMAIN:
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->domain));
			break;

			case LSA_POLICY_INFO_PD:
				NDR_CHECK(ndr_push_lsa_PDAccountInfo(ndr, NDR_BUFFERS, &r->pd));
			break;

			case LSA_POLICY_INFO_ACCOUNT_DOMAIN:
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->account_domain));
			break;

			case LSA_POLICY_INFO_ROLE:
			break;

			case LSA_POLICY_INFO_REPLICA:
				NDR_CHECK(ndr_push_lsa_ReplicaSourceInfo(ndr, NDR_BUFFERS, &r->replica));
			break;

			case LSA_POLICY_INFO_QUOTA:
			break;

			case LSA_POLICY_INFO_MOD:
			break;

			case LSA_POLICY_INFO_AUDIT_FULL_SET:
			break;

			case LSA_POLICY_INFO_AUDIT_FULL_QUERY:
			break;

			case LSA_POLICY_INFO_DNS:
				NDR_CHECK(ndr_push_lsa_DnsDomainInfo(ndr, NDR_BUFFERS, &r->dns));
			break;

			case LSA_POLICY_INFO_DNS_INT:
				NDR_CHECK(ndr_push_lsa_DnsDomainInfo(ndr, NDR_BUFFERS, &r->dns_int));
			break;

			case LSA_POLICY_INFO_L_ACCOUNT_DOMAIN:
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->l_account_domain));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_PolicyInformation(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union lsa_PolicyInformation *r)
{
	uint32_t level;
	uint16_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu16" for r at %s", (uint16_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		switch (level) {
			case LSA_POLICY_INFO_AUDIT_LOG: {
				NDR_CHECK(ndr_pull_lsa_AuditLogInfo(ndr, NDR_SCALARS, &r->audit_log));
			break; }

			case LSA_POLICY_INFO_AUDIT_EVENTS: {
				NDR_CHECK(ndr_pull_lsa_AuditEventsInfo(ndr, NDR_SCALARS, &r->audit_events));
			break; }

			case LSA_POLICY_INFO_DOMAIN: {
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_SCALARS, &r->domain));
			break; }

			case LSA_POLICY_INFO_PD: {
				NDR_CHECK(ndr_pull_lsa_PDAccountInfo(ndr, NDR_SCALARS, &r->pd));
			break; }

			case LSA_POLICY_INFO_ACCOUNT_DOMAIN: {
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_SCALARS, &r->account_domain));
			break; }

			case LSA_POLICY_INFO_ROLE: {
				NDR_CHECK(ndr_pull_lsa_ServerRole(ndr, NDR_SCALARS, &r->role));
			break; }

			case LSA_POLICY_INFO_REPLICA: {
				NDR_CHECK(ndr_pull_lsa_ReplicaSourceInfo(ndr, NDR_SCALARS, &r->replica));
			break; }

			case LSA_POLICY_INFO_QUOTA: {
				NDR_CHECK(ndr_pull_lsa_DefaultQuotaInfo(ndr, NDR_SCALARS, &r->quota));
			break; }

			case LSA_POLICY_INFO_MOD: {
				NDR_CHECK(ndr_pull_lsa_ModificationInfo(ndr, NDR_SCALARS, &r->mod));
			break; }

			case LSA_POLICY_INFO_AUDIT_FULL_SET: {
				NDR_CHECK(ndr_pull_lsa_AuditFullSetInfo(ndr, NDR_SCALARS, &r->auditfullset));
			break; }

			case LSA_POLICY_INFO_AUDIT_FULL_QUERY: {
				NDR_CHECK(ndr_pull_lsa_AuditFullQueryInfo(ndr, NDR_SCALARS, &r->auditfullquery));
			break; }

			case LSA_POLICY_INFO_DNS: {
				NDR_CHECK(ndr_pull_lsa_DnsDomainInfo(ndr, NDR_SCALARS, &r->dns));
			break; }

			case LSA_POLICY_INFO_DNS_INT: {
				NDR_CHECK(ndr_pull_lsa_DnsDomainInfo(ndr, NDR_SCALARS, &r->dns_int));
			break; }

			case LSA_POLICY_INFO_L_ACCOUNT_DOMAIN: {
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_SCALARS, &r->l_account_domain));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case LSA_POLICY_INFO_AUDIT_LOG:
			break;

			case LSA_POLICY_INFO_AUDIT_EVENTS:
				NDR_CHECK(ndr_pull_lsa_AuditEventsInfo(ndr, NDR_BUFFERS, &r->audit_events));
			break;

			case LSA_POLICY_INFO_DOMAIN:
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->domain));
			break;

			case LSA_POLICY_INFO_PD:
				NDR_CHECK(ndr_pull_lsa_PDAccountInfo(ndr, NDR_BUFFERS, &r->pd));
			break;

			case LSA_POLICY_INFO_ACCOUNT_DOMAIN:
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->account_domain));
			break;

			case LSA_POLICY_INFO_ROLE:
			break;

			case LSA_POLICY_INFO_REPLICA:
				NDR_CHECK(ndr_pull_lsa_ReplicaSourceInfo(ndr, NDR_BUFFERS, &r->replica));
			break;

			case LSA_POLICY_INFO_QUOTA:
			break;

			case LSA_POLICY_INFO_MOD:
			break;

			case LSA_POLICY_INFO_AUDIT_FULL_SET:
			break;

			case LSA_POLICY_INFO_AUDIT_FULL_QUERY:
			break;

			case LSA_POLICY_INFO_DNS:
				NDR_CHECK(ndr_pull_lsa_DnsDomainInfo(ndr, NDR_BUFFERS, &r->dns));
			break;

			case LSA_POLICY_INFO_DNS_INT:
				NDR_CHECK(ndr_pull_lsa_DnsDomainInfo(ndr, NDR_BUFFERS, &r->dns_int));
			break;

			case LSA_POLICY_INFO_L_ACCOUNT_DOMAIN:
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->l_account_domain));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_PolicyInformation(struct ndr_print *ndr, const char *name, const union lsa_PolicyInformation *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "lsa_PolicyInformation");
	switch (level) {
		case LSA_POLICY_INFO_AUDIT_LOG:
			ndr_print_lsa_AuditLogInfo(ndr, "audit_log", &r->audit_log);
		break;

		case LSA_POLICY_INFO_AUDIT_EVENTS:
			ndr_print_lsa_AuditEventsInfo(ndr, "audit_events", &r->audit_events);
		break;

		case LSA_POLICY_INFO_DOMAIN:
			ndr_print_lsa_DomainInfo(ndr, "domain", &r->domain);
		break;

		case LSA_POLICY_INFO_PD:
			ndr_print_lsa_PDAccountInfo(ndr, "pd", &r->pd);
		break;

		case LSA_POLICY_INFO_ACCOUNT_DOMAIN:
			ndr_print_lsa_DomainInfo(ndr, "account_domain", &r->account_domain);
		break;

		case LSA_POLICY_INFO_ROLE:
			ndr_print_lsa_ServerRole(ndr, "role", &r->role);
		break;

		case LSA_POLICY_INFO_REPLICA:
			ndr_print_lsa_ReplicaSourceInfo(ndr, "replica", &r->replica);
		break;

		case LSA_POLICY_INFO_QUOTA:
			ndr_print_lsa_DefaultQuotaInfo(ndr, "quota", &r->quota);
		break;

		case LSA_POLICY_INFO_MOD:
			ndr_print_lsa_ModificationInfo(ndr, "mod", &r->mod);
		break;

		case LSA_POLICY_INFO_AUDIT_FULL_SET:
			ndr_print_lsa_AuditFullSetInfo(ndr, "auditfullset", &r->auditfullset);
		break;

		case LSA_POLICY_INFO_AUDIT_FULL_QUERY:
			ndr_print_lsa_AuditFullQueryInfo(ndr, "auditfullquery", &r->auditfullquery);
		break;

		case LSA_POLICY_INFO_DNS:
			ndr_print_lsa_DnsDomainInfo(ndr, "dns", &r->dns);
		break;

		case LSA_POLICY_INFO_DNS_INT:
			ndr_print_lsa_DnsDomainInfo(ndr, "dns_int", &r->dns_int);
		break;

		case LSA_POLICY_INFO_L_ACCOUNT_DOMAIN:
			ndr_print_lsa_DomainInfo(ndr, "l_account_domain", &r->l_account_domain);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_lsa_SidPtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_SidPtr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_SidPtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_SidPtr *r)
{
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, r->sid);
		} else {
			r->sid = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sid) {
			_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_SidPtr(struct ndr_print *ndr, const char *name, const struct lsa_SidPtr *r)
{
	ndr_print_struct(ndr, name, "lsa_SidPtr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "sid", r->sid);
	ndr->depth++;
	if (r->sid) {
		ndr_print_dom_sid2(ndr, "sid", r->sid);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_SidArray(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_SidArray *r)
{
	uint32_t cntr_sids_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_sids));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sids));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sids) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_sids));
			for (cntr_sids_1 = 0; cntr_sids_1 < (r->num_sids); cntr_sids_1++) {
				NDR_CHECK(ndr_push_lsa_SidPtr(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < (r->num_sids); cntr_sids_1++) {
				NDR_CHECK(ndr_push_lsa_SidPtr(ndr, NDR_BUFFERS, &r->sids[cntr_sids_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_SidArray(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_SidArray *r)
{
	uint32_t _ptr_sids;
	uint32_t size_sids_1 = 0;
	uint32_t cntr_sids_1;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	TALLOC_CTX *_mem_save_sids_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_sids));
		if (r->num_sids > 20480) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->num_sids), (uint32_t)(0), (uint32_t)(20480));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sids));
		if (_ptr_sids) {
			NDR_PULL_ALLOC(ndr, r->sids);
		} else {
			r->sids = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sids) {
			_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sids));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->sids, &size_sids_1));
			NDR_PULL_ALLOC_N(ndr, r->sids, size_sids_1);
			_mem_save_sids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			for (cntr_sids_1 = 0; cntr_sids_1 < (size_sids_1); cntr_sids_1++) {
				NDR_CHECK(ndr_pull_lsa_SidPtr(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < (size_sids_1); cntr_sids_1++) {
				NDR_CHECK(ndr_pull_lsa_SidPtr(ndr, NDR_BUFFERS, &r->sids[cntr_sids_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		}
		if (r->sids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->sids, r->num_sids));
		}
		for (cntr_sids_1 = 0; cntr_sids_1 < (size_sids_1); cntr_sids_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_SidArray(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_SidArray *r)
{
	ndr_print_lsa_SidArray(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_SidArray(struct ndr_print *ndr, const char *name, const struct lsa_SidArray *r)
{
	uint32_t cntr_sids_1;
	ndr_print_struct(ndr, name, "lsa_SidArray");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_sids", r->num_sids);
	ndr_print_ptr(ndr, "sids", r->sids);
	ndr->depth++;
	if (r->sids) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "sids", (uint32_t)(r->num_sids));
		ndr->depth++;
		for (cntr_sids_1 = 0; cntr_sids_1 < (r->num_sids); cntr_sids_1++) {
			ndr_print_lsa_SidPtr(ndr, "sids", &r->sids[cntr_sids_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_DomainList(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_DomainList *r)
{
	uint32_t cntr_domains_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domains));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domains) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_domains_1 = 0; cntr_domains_1 < (r->count); cntr_domains_1++) {
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_SCALARS, &r->domains[cntr_domains_1]));
			}
			for (cntr_domains_1 = 0; cntr_domains_1 < (r->count); cntr_domains_1++) {
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->domains[cntr_domains_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_DomainList(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_DomainList *r)
{
	uint32_t _ptr_domains;
	uint32_t size_domains_1 = 0;
	uint32_t cntr_domains_1;
	TALLOC_CTX *_mem_save_domains_0 = NULL;
	TALLOC_CTX *_mem_save_domains_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, r->domains);
		} else {
			r->domains = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domains) {
			_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domains, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domains));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->domains, &size_domains_1));
			NDR_PULL_ALLOC_N(ndr, r->domains, size_domains_1);
			_mem_save_domains_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domains, 0);
			for (cntr_domains_1 = 0; cntr_domains_1 < (size_domains_1); cntr_domains_1++) {
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_SCALARS, &r->domains[cntr_domains_1]));
			}
			for (cntr_domains_1 = 0; cntr_domains_1 < (size_domains_1); cntr_domains_1++) {
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->domains[cntr_domains_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, 0);
		}
		if (r->domains) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->domains, r->count));
		}
		for (cntr_domains_1 = 0; cntr_domains_1 < (size_domains_1); cntr_domains_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_DomainList(struct ndr_print *ndr, const char *name, const struct lsa_DomainList *r)
{
	uint32_t cntr_domains_1;
	ndr_print_struct(ndr, name, "lsa_DomainList");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "domains", r->domains);
	ndr->depth++;
	if (r->domains) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "domains", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_domains_1 = 0; cntr_domains_1 < (r->count); cntr_domains_1++) {
			ndr_print_lsa_DomainInfo(ndr, "domains", &r->domains[cntr_domains_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_SidType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum lsa_SidType r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_SidType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum lsa_SidType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_SidType(struct ndr_print *ndr, const char *name, enum lsa_SidType r)
{
	const char *val = NULL;

	switch (r) {
		case SID_NAME_USE_NONE: val = "SID_NAME_USE_NONE"; break;
		case SID_NAME_USER: val = "SID_NAME_USER"; break;
		case SID_NAME_DOM_GRP: val = "SID_NAME_DOM_GRP"; break;
		case SID_NAME_DOMAIN: val = "SID_NAME_DOMAIN"; break;
		case SID_NAME_ALIAS: val = "SID_NAME_ALIAS"; break;
		case SID_NAME_WKN_GRP: val = "SID_NAME_WKN_GRP"; break;
		case SID_NAME_DELETED: val = "SID_NAME_DELETED"; break;
		case SID_NAME_INVALID: val = "SID_NAME_INVALID"; break;
		case SID_NAME_UNKNOWN: val = "SID_NAME_UNKNOWN"; break;
		case SID_NAME_COMPUTER: val = "SID_NAME_COMPUTER"; break;
		case SID_NAME_LABEL: val = "SID_NAME_LABEL"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_lsa_TranslatedSid(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TranslatedSid *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, r->sid_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sid_index));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TranslatedSid(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TranslatedSid *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, &r->sid_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_index));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TranslatedSid(struct ndr_print *ndr, const char *name, const struct lsa_TranslatedSid *r)
{
	ndr_print_struct(ndr, name, "lsa_TranslatedSid");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_SidType(ndr, "sid_type", r->sid_type);
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_uint32(ndr, "sid_index", r->sid_index);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TransSidArray(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TransSidArray *r)
{
	uint32_t cntr_sids_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sids));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sids) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_sids_1 = 0; cntr_sids_1 < (r->count); cntr_sids_1++) {
				NDR_CHECK(ndr_push_lsa_TranslatedSid(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TransSidArray(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TransSidArray *r)
{
	uint32_t _ptr_sids;
	uint32_t size_sids_1 = 0;
	uint32_t cntr_sids_1;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	TALLOC_CTX *_mem_save_sids_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(1000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sids));
		if (_ptr_sids) {
			NDR_PULL_ALLOC(ndr, r->sids);
		} else {
			r->sids = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sids) {
			_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sids));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->sids, &size_sids_1));
			NDR_PULL_ALLOC_N(ndr, r->sids, size_sids_1);
			_mem_save_sids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			for (cntr_sids_1 = 0; cntr_sids_1 < (size_sids_1); cntr_sids_1++) {
				NDR_CHECK(ndr_pull_lsa_TranslatedSid(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		}
		if (r->sids) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->sids, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TransSidArray(struct ndr_print *ndr, const char *name, const struct lsa_TransSidArray *r)
{
	uint32_t cntr_sids_1;
	ndr_print_struct(ndr, name, "lsa_TransSidArray");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "sids", r->sids);
	ndr->depth++;
	if (r->sids) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "sids", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_sids_1 = 0; cntr_sids_1 < (r->count); cntr_sids_1++) {
			ndr_print_lsa_TranslatedSid(ndr, "sids", &r->sids[cntr_sids_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_RefDomainList(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_RefDomainList *r)
{
	uint32_t cntr_domains_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domains));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_size));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domains) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_domains_1 = 0; cntr_domains_1 < (r->count); cntr_domains_1++) {
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_SCALARS, &r->domains[cntr_domains_1]));
			}
			for (cntr_domains_1 = 0; cntr_domains_1 < (r->count); cntr_domains_1++) {
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->domains[cntr_domains_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_RefDomainList(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_RefDomainList *r)
{
	uint32_t _ptr_domains;
	uint32_t size_domains_1 = 0;
	uint32_t cntr_domains_1;
	TALLOC_CTX *_mem_save_domains_0 = NULL;
	TALLOC_CTX *_mem_save_domains_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(1000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, r->domains);
		} else {
			r->domains = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_size));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domains) {
			_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domains, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domains));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->domains, &size_domains_1));
			NDR_PULL_ALLOC_N(ndr, r->domains, size_domains_1);
			_mem_save_domains_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domains, 0);
			for (cntr_domains_1 = 0; cntr_domains_1 < (size_domains_1); cntr_domains_1++) {
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_SCALARS, &r->domains[cntr_domains_1]));
			}
			for (cntr_domains_1 = 0; cntr_domains_1 < (size_domains_1); cntr_domains_1++) {
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->domains[cntr_domains_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, 0);
		}
		if (r->domains) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->domains, r->count));
		}
		for (cntr_domains_1 = 0; cntr_domains_1 < (size_domains_1); cntr_domains_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_RefDomainList(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_RefDomainList *r)
{
	ndr_print_lsa_RefDomainList(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_RefDomainList(struct ndr_print *ndr, const char *name, const struct lsa_RefDomainList *r)
{
	uint32_t cntr_domains_1;
	ndr_print_struct(ndr, name, "lsa_RefDomainList");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "domains", r->domains);
	ndr->depth++;
	if (r->domains) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "domains", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_domains_1 = 0; cntr_domains_1 < (r->count); cntr_domains_1++) {
			ndr_print_lsa_DomainInfo(ndr, "domains", &r->domains[cntr_domains_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "max_size", r->max_size);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_LookupNamesLevel(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum lsa_LookupNamesLevel r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_LookupNamesLevel(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum lsa_LookupNamesLevel *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LookupNamesLevel(struct ndr_print *ndr, const char *name, enum lsa_LookupNamesLevel r)
{
	const char *val = NULL;

	switch (r) {
		case LSA_LOOKUP_NAMES_ALL: val = "LSA_LOOKUP_NAMES_ALL"; break;
		case LSA_LOOKUP_NAMES_DOMAINS_ONLY: val = "LSA_LOOKUP_NAMES_DOMAINS_ONLY"; break;
		case LSA_LOOKUP_NAMES_PRIMARY_DOMAIN_ONLY: val = "LSA_LOOKUP_NAMES_PRIMARY_DOMAIN_ONLY"; break;
		case LSA_LOOKUP_NAMES_UPLEVEL_TRUSTS_ONLY: val = "LSA_LOOKUP_NAMES_UPLEVEL_TRUSTS_ONLY"; break;
		case LSA_LOOKUP_NAMES_FOREST_TRUSTS_ONLY: val = "LSA_LOOKUP_NAMES_FOREST_TRUSTS_ONLY"; break;
		case LSA_LOOKUP_NAMES_UPLEVEL_TRUSTS_ONLY2: val = "LSA_LOOKUP_NAMES_UPLEVEL_TRUSTS_ONLY2"; break;
		case LSA_LOOKUP_NAMES_RODC_REFERRAL_TO_FULL_DC: val = "LSA_LOOKUP_NAMES_RODC_REFERRAL_TO_FULL_DC"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_lsa_TranslatedName(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TranslatedName *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, r->sid_type));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sid_index));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->name));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TranslatedName(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TranslatedName *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, &r->sid_type));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_index));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->name));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TranslatedName(struct ndr_print *ndr, const char *name, const struct lsa_TranslatedName *r)
{
	ndr_print_struct(ndr, name, "lsa_TranslatedName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_SidType(ndr, "sid_type", r->sid_type);
	ndr_print_lsa_String(ndr, "name", &r->name);
	ndr_print_uint32(ndr, "sid_index", r->sid_index);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_TransNameArray(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TransNameArray *r)
{
	uint32_t cntr_names_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->names));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_names_1 = 0; cntr_names_1 < (r->count); cntr_names_1++) {
				NDR_CHECK(ndr_push_lsa_TranslatedName(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < (r->count); cntr_names_1++) {
				NDR_CHECK(ndr_push_lsa_TranslatedName(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_TransNameArray(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TransNameArray *r)
{
	uint32_t _ptr_names;
	uint32_t size_names_1 = 0;
	uint32_t cntr_names_1;
	TALLOC_CTX *_mem_save_names_0 = NULL;
	TALLOC_CTX *_mem_save_names_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 20480) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(20480));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_names));
		if (_ptr_names) {
			NDR_PULL_ALLOC(ndr, r->names);
		} else {
			r->names = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->names));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->names, &size_names_1));
			NDR_PULL_ALLOC_N(ndr, r->names, size_names_1);
			_mem_save_names_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			for (cntr_names_1 = 0; cntr_names_1 < (size_names_1); cntr_names_1++) {
				NDR_CHECK(ndr_pull_lsa_TranslatedName(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < (size_names_1); cntr_names_1++) {
				NDR_CHECK(ndr_pull_lsa_TranslatedName(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		}
		if (r->names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->names, r->count));
		}
		for (cntr_names_1 = 0; cntr_names_1 < (size_names_1); cntr_names_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_TransNameArray(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_TransNameArray *r)
{
	ndr_print_lsa_TransNameArray(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_TransNameArray(struct ndr_print *ndr, const char *name, const struct lsa_TransNameArray *r)
{
	uint32_t cntr_names_1;
	ndr_print_struct(ndr, name, "lsa_TransNameArray");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "names", r->names);
	ndr->depth++;
	if (r->names) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "names", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_names_1 = 0; cntr_names_1 < (r->count); cntr_names_1++) {
			ndr_print_lsa_TranslatedName(ndr, "names", &r->names[cntr_names_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_LUIDAttribute(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_LUIDAttribute *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_LUID(ndr, NDR_SCALARS, &r->luid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->attribute));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_LUIDAttribute(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_LUIDAttribute *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_LUID(ndr, NDR_SCALARS, &r->luid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->attribute));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LUIDAttribute(struct ndr_print *ndr, const char *name, const struct lsa_LUIDAttribute *r)
{
	ndr_print_struct(ndr, name, "lsa_LUIDAttribute");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_LUID(ndr, "luid", &r->luid);
	ndr_print_uint32(ndr, "attribute", r->attribute);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_PrivilegeSet(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_PrivilegeSet *r)
{
	uint32_t cntr_set_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown));
		for (cntr_set_0 = 0; cntr_set_0 < (r->count); cntr_set_0++) {
			NDR_CHECK(ndr_push_lsa_LUIDAttribute(ndr, NDR_SCALARS, &r->set[cntr_set_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_PrivilegeSet(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_PrivilegeSet *r)
{
	uint32_t size_set_0 = 0;
	uint32_t cntr_set_0;
	TALLOC_CTX *_mem_save_set_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->set));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(1000));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->set, &size_set_0));
		NDR_PULL_ALLOC_N(ndr, r->set, size_set_0);
		_mem_save_set_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->set, 0);
		for (cntr_set_0 = 0; cntr_set_0 < (size_set_0); cntr_set_0++) {
			NDR_CHECK(ndr_pull_lsa_LUIDAttribute(ndr, NDR_SCALARS, &r->set[cntr_set_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_set_0, 0);
		if (r->set) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->set, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_PrivilegeSet(struct ndr_print *ndr, const char *name, const struct lsa_PrivilegeSet *r)
{
	uint32_t cntr_set_0;
	ndr_print_struct(ndr, name, "lsa_PrivilegeSet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "unknown", r->unknown);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "set", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_set_0 = 0; cntr_set_0 < (r->count); cntr_set_0++) {
		ndr_print_lsa_LUIDAttribute(ndr, "set", &r->set[cntr_set_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_DATA_BUF(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_DATA_BUF *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 5));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->length));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->size));
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->data));
			NDR_CHECK(ndr_push_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (r->data) {
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->size));
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->length));
				NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, r->length));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_DATA_BUF(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_DATA_BUF *r)
{
	uint32_t _ptr_data;
	uint32_t size_data_1 = 0;
	uint32_t length_data_1 = 0;
	TALLOC_CTX *_mem_save_data_0 = NULL;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 5));
			NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &r->length));
			NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &r->size));
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
			if (_ptr_data) {
				NDR_PULL_ALLOC(ndr, r->data);
			} else {
				r->data = NULL;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (r->data) {
				_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
				NDR_CHECK(ndr_pull_array_size(ndr, &r->data));
				NDR_CHECK(ndr_pull_array_length(ndr, &r->data));
				NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->data, &size_data_1));
				NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->data, &length_data_1));
				if (length_data_1 > size_data_1) {
					return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_data_1, length_data_1);
				}
				NDR_PULL_ALLOC_N(ndr, r->data, size_data_1);
				NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, length_data_1));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
			}
			if (r->data) {
				NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->data, r->size));
			}
			if (r->data) {
				NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->data, r->length));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_DATA_BUF(struct ndr_print *ndr, const char *name, const struct lsa_DATA_BUF *r)
{
	ndr_print_struct(ndr, name, "lsa_DATA_BUF");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint3264(ndr, "length", r->length);
		ndr_print_uint3264(ndr, "size", r->size);
		ndr_print_ptr(ndr, "data", r->data);
		ndr->depth++;
		if (r->data) {
			ndr_print_array_uint8(ndr, "data", r->data, r->length);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_lsa_DATA_BUF2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_DATA_BUF2 *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 5));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->data));
			NDR_CHECK(ndr_push_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (r->data) {
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->size));
				NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, r->size));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_DATA_BUF2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_DATA_BUF2 *r)
{
	uint32_t _ptr_data;
	uint32_t size_data_1 = 0;
	TALLOC_CTX *_mem_save_data_0 = NULL;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 5));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
			if (r->size > 65536) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->size), (uint32_t)(0), (uint32_t)(65536));
			}
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
			if (_ptr_data) {
				NDR_PULL_ALLOC(ndr, r->data);
			} else {
				r->data = NULL;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (r->data) {
				_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
				NDR_CHECK(ndr_pull_array_size(ndr, &r->data));
				NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->data, &size_data_1));
				NDR_PULL_ALLOC_N(ndr, r->data, size_data_1);
				NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, size_data_1));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
			}
			if (r->data) {
				NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->data, r->size));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_DATA_BUF2(struct ndr_print *ndr, const char *name, const struct lsa_DATA_BUF2 *r)
{
	ndr_print_struct(ndr, name, "lsa_DATA_BUF2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint32(ndr, "size", r->size);
		ndr_print_ptr(ndr, "data", r->data);
		ndr->depth++;
		if (r->data) {
			ndr_print_array_uint8(ndr, "data", r->data, r->size);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_lsa_TrustDomInfoEnum(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum lsa_TrustDomInfoEnum r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TrustDomInfoEnum(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum lsa_TrustDomInfoEnum *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustDomInfoEnum(struct ndr_print *ndr, const char *name, enum lsa_TrustDomInfoEnum r)
{
	const char *val = NULL;

	switch (r) {
		case LSA_TRUSTED_DOMAIN_INFO_NAME: val = "LSA_TRUSTED_DOMAIN_INFO_NAME"; break;
		case LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS: val = "LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS"; break;
		case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET: val = "LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET"; break;
		case LSA_TRUSTED_DOMAIN_INFO_PASSWORD: val = "LSA_TRUSTED_DOMAIN_INFO_PASSWORD"; break;
		case LSA_TRUSTED_DOMAIN_INFO_BASIC: val = "LSA_TRUSTED_DOMAIN_INFO_BASIC"; break;
		case LSA_TRUSTED_DOMAIN_INFO_INFO_EX: val = "LSA_TRUSTED_DOMAIN_INFO_INFO_EX"; break;
		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO: val = "LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO"; break;
		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO: val = "LSA_TRUSTED_DOMAIN_INFO_FULL_INFO"; break;
		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL: val = "LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL"; break;
		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL: val = "LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL"; break;
		case LSA_TRUSTED_DOMAIN_INFO_INFO_EX2_INTERNAL: val = "LSA_TRUSTED_DOMAIN_INFO_INFO_EX2_INTERNAL"; break;
		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_2_INTERNAL: val = "LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_2_INTERNAL"; break;
		case LSA_TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES: val = "LSA_TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES"; break;
		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL_AES: val = "LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL_AES"; break;
		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL_AES: val = "LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL_AES"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_TrustDirection(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_TrustDirection(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustDirection(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUST_DIRECTION_INBOUND", LSA_TRUST_DIRECTION_INBOUND, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUST_DIRECTION_OUTBOUND", LSA_TRUST_DIRECTION_OUTBOUND, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_TrustType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum lsa_TrustType r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_TrustType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum lsa_TrustType *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustType(struct ndr_print *ndr, const char *name, enum lsa_TrustType r)
{
	const char *val = NULL;

	switch (r) {
		case LSA_TRUST_TYPE_DOWNLEVEL: val = "LSA_TRUST_TYPE_DOWNLEVEL"; break;
		case LSA_TRUST_TYPE_UPLEVEL: val = "LSA_TRUST_TYPE_UPLEVEL"; break;
		case LSA_TRUST_TYPE_MIT: val = "LSA_TRUST_TYPE_MIT"; break;
		case LSA_TRUST_TYPE_DCE: val = "LSA_TRUST_TYPE_DCE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_TrustAttributes(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_TrustAttributes(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustAttributes(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUST_ATTRIBUTE_NON_TRANSITIVE", LSA_TRUST_ATTRIBUTE_NON_TRANSITIVE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUST_ATTRIBUTE_UPLEVEL_ONLY", LSA_TRUST_ATTRIBUTE_UPLEVEL_ONLY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUST_ATTRIBUTE_QUARANTINED_DOMAIN", LSA_TRUST_ATTRIBUTE_QUARANTINED_DOMAIN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUST_ATTRIBUTE_FOREST_TRANSITIVE", LSA_TRUST_ATTRIBUTE_FOREST_TRANSITIVE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUST_ATTRIBUTE_CROSS_ORGANIZATION", LSA_TRUST_ATTRIBUTE_CROSS_ORGANIZATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUST_ATTRIBUTE_WITHIN_FOREST", LSA_TRUST_ATTRIBUTE_WITHIN_FOREST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUST_ATTRIBUTE_TREAT_AS_EXTERNAL", LSA_TRUST_ATTRIBUTE_TREAT_AS_EXTERNAL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUST_ATTRIBUTE_USES_RC4_ENCRYPTION", LSA_TRUST_ATTRIBUTE_USES_RC4_ENCRYPTION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUST_ATTRIBUTE_CROSS_ORGANIZATION_NO_TGT_DELEGATION", LSA_TRUST_ATTRIBUTE_CROSS_ORGANIZATION_NO_TGT_DELEGATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUST_ATTRIBUTE_PIM_TRUST", LSA_TRUST_ATTRIBUTE_PIM_TRUST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TRUST_ATTRIBUTE_CROSS_ORGANIZATION_ENABLE_TGT_DELEGATION", LSA_TRUST_ATTRIBUTE_CROSS_ORGANIZATION_ENABLE_TGT_DELEGATION, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TrustDomainInfoName(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TrustDomainInfoName *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->netbios_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->netbios_name));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TrustDomainInfoName(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TrustDomainInfoName *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->netbios_name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->netbios_name));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoName(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoName *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_StringLarge(ndr, "netbios_name", &r->netbios_name);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TrustDomainInfoControllers(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TrustDomainInfoControllers *r)
{
	uint32_t cntr_netbios_names_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->entries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->netbios_names));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->netbios_names) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->entries));
			for (cntr_netbios_names_1 = 0; cntr_netbios_names_1 < (r->entries); cntr_netbios_names_1++) {
				NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->netbios_names[cntr_netbios_names_1]));
			}
			for (cntr_netbios_names_1 = 0; cntr_netbios_names_1 < (r->entries); cntr_netbios_names_1++) {
				NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->netbios_names[cntr_netbios_names_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TrustDomainInfoControllers(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TrustDomainInfoControllers *r)
{
	uint32_t _ptr_netbios_names;
	uint32_t size_netbios_names_1 = 0;
	uint32_t cntr_netbios_names_1;
	TALLOC_CTX *_mem_save_netbios_names_0 = NULL;
	TALLOC_CTX *_mem_save_netbios_names_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->entries));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_netbios_names));
		if (_ptr_netbios_names) {
			NDR_PULL_ALLOC(ndr, r->netbios_names);
		} else {
			r->netbios_names = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->netbios_names) {
			_mem_save_netbios_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->netbios_names, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->netbios_names));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->netbios_names, &size_netbios_names_1));
			NDR_PULL_ALLOC_N(ndr, r->netbios_names, size_netbios_names_1);
			_mem_save_netbios_names_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->netbios_names, 0);
			for (cntr_netbios_names_1 = 0; cntr_netbios_names_1 < (size_netbios_names_1); cntr_netbios_names_1++) {
				NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->netbios_names[cntr_netbios_names_1]));
			}
			for (cntr_netbios_names_1 = 0; cntr_netbios_names_1 < (size_netbios_names_1); cntr_netbios_names_1++) {
				NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->netbios_names[cntr_netbios_names_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_netbios_names_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_netbios_names_0, 0);
		}
		if (r->netbios_names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->netbios_names, r->entries));
		}
		for (cntr_netbios_names_1 = 0; cntr_netbios_names_1 < (size_netbios_names_1); cntr_netbios_names_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoControllers(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoControllers *r)
{
	uint32_t cntr_netbios_names_1;
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoControllers");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "entries", r->entries);
	ndr_print_ptr(ndr, "netbios_names", r->netbios_names);
	ndr->depth++;
	if (r->netbios_names) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "netbios_names", (uint32_t)(r->entries));
		ndr->depth++;
		for (cntr_netbios_names_1 = 0; cntr_netbios_names_1 < (r->entries); cntr_netbios_names_1++) {
			ndr_print_lsa_StringLarge(ndr, "netbios_names", &r->netbios_names[cntr_netbios_names_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TrustDomainInfoPosixOffset(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TrustDomainInfoPosixOffset *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->posix_offset));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TrustDomainInfoPosixOffset(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TrustDomainInfoPosixOffset *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->posix_offset));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoPosixOffset(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoPosixOffset *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoPosixOffset");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "posix_offset", r->posix_offset);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TrustDomainInfoPassword(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TrustDomainInfoPassword *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->password));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->old_password));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->password) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->password));
		}
		if (r->old_password) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->old_password));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TrustDomainInfoPassword(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TrustDomainInfoPassword *r)
{
	uint32_t _ptr_password;
	TALLOC_CTX *_mem_save_password_0 = NULL;
	uint32_t _ptr_old_password;
	TALLOC_CTX *_mem_save_old_password_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
		if (_ptr_password) {
			NDR_PULL_ALLOC(ndr, r->password);
		} else {
			r->password = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_old_password));
		if (_ptr_old_password) {
			NDR_PULL_ALLOC(ndr, r->old_password);
		} else {
			r->old_password = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->password) {
			_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->password, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->password));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
		}
		if (r->old_password) {
			_mem_save_old_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->old_password, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->old_password));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_old_password_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoPassword(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoPassword *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoPassword");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "password", r->password);
	ndr->depth++;
	if (r->password) {
		ndr_print_lsa_DATA_BUF(ndr, "password", r->password);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "old_password", r->old_password);
	ndr->depth++;
	if (r->old_password) {
		ndr_print_lsa_DATA_BUF(ndr, "old_password", r->old_password);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TrustDomainInfoBasic(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TrustDomainInfoBasic *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->netbios_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->netbios_name));
		if (r->sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TrustDomainInfoBasic(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TrustDomainInfoBasic *r)
{
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->netbios_name));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, r->sid);
		} else {
			r->sid = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->netbios_name));
		if (r->sid) {
			_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoBasic(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoBasic *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoBasic");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "netbios_name", &r->netbios_name);
	ndr_print_ptr(ndr, "sid", r->sid);
	ndr->depth++;
	if (r->sid) {
		ndr_print_dom_sid2(ndr, "sid", r->sid);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_TrustDomainInfoInfoEx(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TrustDomainInfoInfoEx *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->domain_name));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->netbios_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
		NDR_CHECK(ndr_push_lsa_TrustDirection(ndr, NDR_SCALARS, r->trust_direction));
		NDR_CHECK(ndr_push_lsa_TrustType(ndr, NDR_SCALARS, r->trust_type));
		NDR_CHECK(ndr_push_lsa_TrustAttributes(ndr, NDR_SCALARS, r->trust_attributes));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->domain_name));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->netbios_name));
		if (r->sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_TrustDomainInfoInfoEx(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TrustDomainInfoInfoEx *r)
{
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->domain_name));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->netbios_name));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, r->sid);
		} else {
			r->sid = NULL;
		}
		NDR_CHECK(ndr_pull_lsa_TrustDirection(ndr, NDR_SCALARS, &r->trust_direction));
		NDR_CHECK(ndr_pull_lsa_TrustType(ndr, NDR_SCALARS, &r->trust_type));
		NDR_CHECK(ndr_pull_lsa_TrustAttributes(ndr, NDR_SCALARS, &r->trust_attributes));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->domain_name));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->netbios_name));
		if (r->sid) {
			_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_TrustDomainInfoInfoEx(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_TrustDomainInfoInfoEx *r)
{
	ndr_print_lsa_TrustDomainInfoInfoEx(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoInfoEx(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoInfoEx *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoInfoEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_StringLarge(ndr, "domain_name", &r->domain_name);
	ndr_print_lsa_StringLarge(ndr, "netbios_name", &r->netbios_name);
	ndr_print_ptr(ndr, "sid", r->sid);
	ndr->depth++;
	if (r->sid) {
		ndr_print_dom_sid2(ndr, "sid", r->sid);
	}
	ndr->depth--;
	ndr_print_lsa_TrustDirection(ndr, "trust_direction", r->trust_direction);
	ndr_print_lsa_TrustType(ndr, "trust_type", r->trust_type);
	ndr_print_lsa_TrustAttributes(ndr, "trust_attributes", r->trust_attributes);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_TrustAuthType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum lsa_TrustAuthType r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_TrustAuthType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum lsa_TrustAuthType *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustAuthType(struct ndr_print *ndr, const char *name, enum lsa_TrustAuthType r)
{
	const char *val = NULL;

	switch (r) {
		case TRUST_AUTH_TYPE_NONE: val = "TRUST_AUTH_TYPE_NONE"; break;
		case TRUST_AUTH_TYPE_NT4OWF: val = "TRUST_AUTH_TYPE_NT4OWF"; break;
		case TRUST_AUTH_TYPE_CLEAR: val = "TRUST_AUTH_TYPE_CLEAR"; break;
		case TRUST_AUTH_TYPE_VERSION: val = "TRUST_AUTH_TYPE_VERSION"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_lsa_TrustDomainInfoBuffer(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TrustDomainInfoBuffer *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_NTTIME_hyper(ndr, NDR_SCALARS, r->last_update_time));
		NDR_CHECK(ndr_push_lsa_TrustAuthType(ndr, NDR_SCALARS, r->AuthType));
		NDR_CHECK(ndr_push_lsa_DATA_BUF2(ndr, NDR_SCALARS, &r->data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_DATA_BUF2(ndr, NDR_BUFFERS, &r->data));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TrustDomainInfoBuffer(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TrustDomainInfoBuffer *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_NTTIME_hyper(ndr, NDR_SCALARS, &r->last_update_time));
		NDR_CHECK(ndr_pull_lsa_TrustAuthType(ndr, NDR_SCALARS, &r->AuthType));
		NDR_CHECK(ndr_pull_lsa_DATA_BUF2(ndr, NDR_SCALARS, &r->data));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_DATA_BUF2(ndr, NDR_BUFFERS, &r->data));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoBuffer(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoBuffer *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoBuffer");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_NTTIME_hyper(ndr, "last_update_time", r->last_update_time);
	ndr_print_lsa_TrustAuthType(ndr, "AuthType", r->AuthType);
	ndr_print_lsa_DATA_BUF2(ndr, "data", &r->data);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_TrustDomainInfoAuthInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TrustDomainInfoAuthInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->incoming_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->incoming_current_auth_info));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->incoming_previous_auth_info));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->outgoing_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->outgoing_current_auth_info));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->outgoing_previous_auth_info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->incoming_current_auth_info) {
			NDR_CHECK(ndr_push_lsa_TrustDomainInfoBuffer(ndr, NDR_SCALARS|NDR_BUFFERS, r->incoming_current_auth_info));
		}
		if (r->incoming_previous_auth_info) {
			NDR_CHECK(ndr_push_lsa_TrustDomainInfoBuffer(ndr, NDR_SCALARS|NDR_BUFFERS, r->incoming_previous_auth_info));
		}
		if (r->outgoing_current_auth_info) {
			NDR_CHECK(ndr_push_lsa_TrustDomainInfoBuffer(ndr, NDR_SCALARS|NDR_BUFFERS, r->outgoing_current_auth_info));
		}
		if (r->outgoing_previous_auth_info) {
			NDR_CHECK(ndr_push_lsa_TrustDomainInfoBuffer(ndr, NDR_SCALARS|NDR_BUFFERS, r->outgoing_previous_auth_info));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_TrustDomainInfoAuthInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TrustDomainInfoAuthInfo *r)
{
	uint32_t _ptr_incoming_current_auth_info;
	TALLOC_CTX *_mem_save_incoming_current_auth_info_0 = NULL;
	uint32_t _ptr_incoming_previous_auth_info;
	TALLOC_CTX *_mem_save_incoming_previous_auth_info_0 = NULL;
	uint32_t _ptr_outgoing_current_auth_info;
	TALLOC_CTX *_mem_save_outgoing_current_auth_info_0 = NULL;
	uint32_t _ptr_outgoing_previous_auth_info;
	TALLOC_CTX *_mem_save_outgoing_previous_auth_info_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->incoming_count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_incoming_current_auth_info));
		if (_ptr_incoming_current_auth_info) {
			NDR_PULL_ALLOC(ndr, r->incoming_current_auth_info);
		} else {
			r->incoming_current_auth_info = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_incoming_previous_auth_info));
		if (_ptr_incoming_previous_auth_info) {
			NDR_PULL_ALLOC(ndr, r->incoming_previous_auth_info);
		} else {
			r->incoming_previous_auth_info = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->outgoing_count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_outgoing_current_auth_info));
		if (_ptr_outgoing_current_auth_info) {
			NDR_PULL_ALLOC(ndr, r->outgoing_current_auth_info);
		} else {
			r->outgoing_current_auth_info = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_outgoing_previous_auth_info));
		if (_ptr_outgoing_previous_auth_info) {
			NDR_PULL_ALLOC(ndr, r->outgoing_previous_auth_info);
		} else {
			r->outgoing_previous_auth_info = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->incoming_current_auth_info) {
			_mem_save_incoming_current_auth_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->incoming_current_auth_info, 0);
			NDR_CHECK(ndr_pull_lsa_TrustDomainInfoBuffer(ndr, NDR_SCALARS|NDR_BUFFERS, r->incoming_current_auth_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_incoming_current_auth_info_0, 0);
		}
		if (r->incoming_previous_auth_info) {
			_mem_save_incoming_previous_auth_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->incoming_previous_auth_info, 0);
			NDR_CHECK(ndr_pull_lsa_TrustDomainInfoBuffer(ndr, NDR_SCALARS|NDR_BUFFERS, r->incoming_previous_auth_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_incoming_previous_auth_info_0, 0);
		}
		if (r->outgoing_current_auth_info) {
			_mem_save_outgoing_current_auth_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->outgoing_current_auth_info, 0);
			NDR_CHECK(ndr_pull_lsa_TrustDomainInfoBuffer(ndr, NDR_SCALARS|NDR_BUFFERS, r->outgoing_current_auth_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_outgoing_current_auth_info_0, 0);
		}
		if (r->outgoing_previous_auth_info) {
			_mem_save_outgoing_previous_auth_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->outgoing_previous_auth_info, 0);
			NDR_CHECK(ndr_pull_lsa_TrustDomainInfoBuffer(ndr, NDR_SCALARS|NDR_BUFFERS, r->outgoing_previous_auth_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_outgoing_previous_auth_info_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_TrustDomainInfoAuthInfo(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_TrustDomainInfoAuthInfo *r)
{
	ndr_print_lsa_TrustDomainInfoAuthInfo(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoAuthInfo(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoAuthInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoAuthInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "incoming_count", r->incoming_count);
	ndr_print_ptr(ndr, "incoming_current_auth_info", r->incoming_current_auth_info);
	ndr->depth++;
	if (r->incoming_current_auth_info) {
		ndr_print_lsa_TrustDomainInfoBuffer(ndr, "incoming_current_auth_info", r->incoming_current_auth_info);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "incoming_previous_auth_info", r->incoming_previous_auth_info);
	ndr->depth++;
	if (r->incoming_previous_auth_info) {
		ndr_print_lsa_TrustDomainInfoBuffer(ndr, "incoming_previous_auth_info", r->incoming_previous_auth_info);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "outgoing_count", r->outgoing_count);
	ndr_print_ptr(ndr, "outgoing_current_auth_info", r->outgoing_current_auth_info);
	ndr->depth++;
	if (r->outgoing_current_auth_info) {
		ndr_print_lsa_TrustDomainInfoBuffer(ndr, "outgoing_current_auth_info", r->outgoing_current_auth_info);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "outgoing_previous_auth_info", r->outgoing_previous_auth_info);
	ndr->depth++;
	if (r->outgoing_previous_auth_info) {
		ndr_print_lsa_TrustDomainInfoBuffer(ndr, "outgoing_previous_auth_info", r->outgoing_previous_auth_info);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TrustDomainInfoFullInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TrustDomainInfoFullInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoPosixOffset(ndr, NDR_SCALARS, &r->posix_offset));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfo(ndr, NDR_SCALARS, &r->auth_info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfo(ndr, NDR_BUFFERS, &r->auth_info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TrustDomainInfoFullInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TrustDomainInfoFullInfo *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoPosixOffset(ndr, NDR_SCALARS, &r->posix_offset));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfo(ndr, NDR_SCALARS, &r->auth_info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfo(ndr, NDR_BUFFERS, &r->auth_info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoFullInfo(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoFullInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoFullInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_TrustDomainInfoInfoEx(ndr, "info_ex", &r->info_ex);
	ndr_print_lsa_TrustDomainInfoPosixOffset(ndr, "posix_offset", &r->posix_offset);
	ndr_print_lsa_TrustDomainInfoAuthInfo(ndr, "auth_info", &r->auth_info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TrustDomainInfoAuthInfoInternal(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TrustDomainInfoAuthInfoInternal *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_DATA_BUF2(ndr, NDR_SCALARS, &r->auth_blob));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_DATA_BUF2(ndr, NDR_BUFFERS, &r->auth_blob));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TrustDomainInfoAuthInfoInternal(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TrustDomainInfoAuthInfoInternal *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_DATA_BUF2(ndr, NDR_SCALARS, &r->auth_blob));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_DATA_BUF2(ndr, NDR_BUFFERS, &r->auth_blob));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoAuthInfoInternal(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoAuthInfoInternal *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoAuthInfoInternal");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_DATA_BUF2(ndr, "auth_blob", &r->auth_blob);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TrustDomainInfoFullInfoInternal(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TrustDomainInfoFullInfoInternal *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoPosixOffset(ndr, NDR_SCALARS, &r->posix_offset));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfoInternal(ndr, NDR_SCALARS, &r->auth_info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfoInternal(ndr, NDR_BUFFERS, &r->auth_info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TrustDomainInfoFullInfoInternal(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TrustDomainInfoFullInfoInternal *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoPosixOffset(ndr, NDR_SCALARS, &r->posix_offset));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfoInternal(ndr, NDR_SCALARS, &r->auth_info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfoInternal(ndr, NDR_BUFFERS, &r->auth_info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoFullInfoInternal(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoFullInfoInternal *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoFullInfoInternal");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_TrustDomainInfoInfoEx(ndr, "info_ex", &r->info_ex);
	ndr_print_lsa_TrustDomainInfoPosixOffset(ndr, "posix_offset", &r->posix_offset);
	ndr_print_lsa_TrustDomainInfoAuthInfoInternal(ndr, "auth_info", &r->auth_info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TrustDomainInfoAuthInfoInternalAES(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TrustDomainInfoAuthInfoInternalAES *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->auth_data, 64));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->salt, 16));
		NDR_CHECK(ndr_push_lsa_DATA_BUF2(ndr, NDR_SCALARS, &r->cipher));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_DATA_BUF2(ndr, NDR_BUFFERS, &r->cipher));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TrustDomainInfoAuthInfoInternalAES(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TrustDomainInfoAuthInfoInternalAES *r)
{
	uint32_t size_auth_data_0 = 0;
	uint32_t size_salt_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		size_auth_data_0 = 64;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->auth_data, size_auth_data_0));
		size_salt_0 = 16;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->salt, size_salt_0));
		NDR_CHECK(ndr_pull_lsa_DATA_BUF2(ndr, NDR_SCALARS, &r->cipher));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_DATA_BUF2(ndr, NDR_BUFFERS, &r->cipher));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoAuthInfoInternalAES(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoAuthInfoInternalAES *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoAuthInfoInternalAES");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_array_uint8(ndr, "auth_data", r->auth_data, 64);
	ndr_print_array_uint8(ndr, "salt", r->salt, 16);
	ndr_print_lsa_DATA_BUF2(ndr, "cipher", &r->cipher);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TrustDomainInfoFullInfoInternalAES(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TrustDomainInfoFullInfoInternalAES *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoPosixOffset(ndr, NDR_SCALARS, &r->posix_offset));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfoInternalAES(ndr, NDR_SCALARS, &r->auth_info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfoInternalAES(ndr, NDR_BUFFERS, &r->auth_info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TrustDomainInfoFullInfoInternalAES(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TrustDomainInfoFullInfoInternalAES *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoPosixOffset(ndr, NDR_SCALARS, &r->posix_offset));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfoInternalAES(ndr, NDR_SCALARS, &r->auth_info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfoInternalAES(ndr, NDR_BUFFERS, &r->auth_info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoFullInfoInternalAES(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoFullInfoInternalAES *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoFullInfoInternalAES");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_TrustDomainInfoInfoEx(ndr, "info_ex", &r->info_ex);
	ndr_print_lsa_TrustDomainInfoPosixOffset(ndr, "posix_offset", &r->posix_offset);
	ndr_print_lsa_TrustDomainInfoAuthInfoInternalAES(ndr, "auth_info", &r->auth_info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TrustDomainInfoInfoEx2Internal(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TrustDomainInfoInfoEx2Internal *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->forest_trust_length));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->forest_trust_data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
		if (r->forest_trust_data) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->forest_trust_length));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->forest_trust_data, r->forest_trust_length));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TrustDomainInfoInfoEx2Internal(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TrustDomainInfoInfoEx2Internal *r)
{
	uint32_t _ptr_forest_trust_data;
	uint32_t size_forest_trust_data_1 = 0;
	TALLOC_CTX *_mem_save_forest_trust_data_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->forest_trust_length));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_forest_trust_data));
		if (_ptr_forest_trust_data) {
			NDR_PULL_ALLOC(ndr, r->forest_trust_data);
		} else {
			r->forest_trust_data = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
		if (r->forest_trust_data) {
			_mem_save_forest_trust_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->forest_trust_data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->forest_trust_data));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->forest_trust_data, &size_forest_trust_data_1));
			NDR_PULL_ALLOC_N(ndr, r->forest_trust_data, size_forest_trust_data_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->forest_trust_data, size_forest_trust_data_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_forest_trust_data_0, 0);
		}
		if (r->forest_trust_data) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->forest_trust_data, r->forest_trust_length));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoInfoEx2Internal(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoInfoEx2Internal *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoInfoEx2Internal");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_TrustDomainInfoInfoEx(ndr, "info_ex", &r->info_ex);
	ndr_print_uint32(ndr, "forest_trust_length", r->forest_trust_length);
	ndr_print_ptr(ndr, "forest_trust_data", r->forest_trust_data);
	ndr->depth++;
	if (r->forest_trust_data) {
		ndr_print_array_uint8(ndr, "forest_trust_data", r->forest_trust_data, r->forest_trust_length);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TrustDomainInfoFullInfo2Internal(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TrustDomainInfoFullInfo2Internal *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx2Internal(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoPosixOffset(ndr, NDR_SCALARS, &r->posix_offset));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfo(ndr, NDR_SCALARS, &r->auth_info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx2Internal(ndr, NDR_BUFFERS, &r->info));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfo(ndr, NDR_BUFFERS, &r->auth_info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TrustDomainInfoFullInfo2Internal(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TrustDomainInfoFullInfo2Internal *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx2Internal(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoPosixOffset(ndr, NDR_SCALARS, &r->posix_offset));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfo(ndr, NDR_SCALARS, &r->auth_info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx2Internal(ndr, NDR_BUFFERS, &r->info));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfo(ndr, NDR_BUFFERS, &r->auth_info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoFullInfo2Internal(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoFullInfo2Internal *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoFullInfo2Internal");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_TrustDomainInfoInfoEx2Internal(ndr, "info", &r->info);
	ndr_print_lsa_TrustDomainInfoPosixOffset(ndr, "posix_offset", &r->posix_offset);
	ndr_print_lsa_TrustDomainInfoAuthInfo(ndr, "auth_info", &r->auth_info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TrustDomainInfoSupportedEncTypes(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TrustDomainInfoSupportedEncTypes *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_kerb_EncTypes(ndr, NDR_SCALARS, r->enc_types));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TrustDomainInfoSupportedEncTypes(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TrustDomainInfoSupportedEncTypes *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_kerb_EncTypes(ndr, NDR_SCALARS, &r->enc_types));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoSupportedEncTypes(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoSupportedEncTypes *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoSupportedEncTypes");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_kerb_EncTypes(ndr, "enc_types", r->enc_types);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TrustedDomainInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union lsa_TrustedDomainInfo *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case LSA_TRUSTED_DOMAIN_INFO_NAME: {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoName(ndr, NDR_SCALARS, &r->name));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS: {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoControllers(ndr, NDR_SCALARS, &r->controllers));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET: {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoPosixOffset(ndr, NDR_SCALARS, &r->posix_offset));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_PASSWORD: {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoPassword(ndr, NDR_SCALARS, &r->password));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_BASIC: {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoBasic(ndr, NDR_SCALARS, &r->info_basic));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_INFO_EX: {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO: {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfo(ndr, NDR_SCALARS, &r->auth_info));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO: {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoFullInfo(ndr, NDR_SCALARS, &r->full_info));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL: {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfoInternal(ndr, NDR_SCALARS, &r->auth_info_internal));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL: {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoFullInfoInternal(ndr, NDR_SCALARS, &r->full_info_internal));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_INFO_EX2_INTERNAL: {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx2Internal(ndr, NDR_SCALARS, &r->info_ex2_internal));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_2_INTERNAL: {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoFullInfo2Internal(ndr, NDR_SCALARS, &r->full_info2_internal));
			break; }

			case LSA_TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES: {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoSupportedEncTypes(ndr, NDR_SCALARS, &r->enc_types));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL_AES: {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfoInternalAES(ndr, NDR_SCALARS, &r->auth_info_internal_aes));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL_AES: {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoFullInfoInternalAES(ndr, NDR_SCALARS, &r->full_info_internal_aes));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case LSA_TRUSTED_DOMAIN_INFO_NAME:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoName(ndr, NDR_BUFFERS, &r->name));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoControllers(ndr, NDR_BUFFERS, &r->controllers));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET:
			break;

			case LSA_TRUSTED_DOMAIN_INFO_PASSWORD:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoPassword(ndr, NDR_BUFFERS, &r->password));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_BASIC:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoBasic(ndr, NDR_BUFFERS, &r->info_basic));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_INFO_EX:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfo(ndr, NDR_BUFFERS, &r->auth_info));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoFullInfo(ndr, NDR_BUFFERS, &r->full_info));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfoInternal(ndr, NDR_BUFFERS, &r->auth_info_internal));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoFullInfoInternal(ndr, NDR_BUFFERS, &r->full_info_internal));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_INFO_EX2_INTERNAL:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx2Internal(ndr, NDR_BUFFERS, &r->info_ex2_internal));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_2_INTERNAL:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoFullInfo2Internal(ndr, NDR_BUFFERS, &r->full_info2_internal));
			break;

			case LSA_TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES:
			break;

			case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL_AES:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfoInternalAES(ndr, NDR_BUFFERS, &r->auth_info_internal_aes));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL_AES:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoFullInfoInternalAES(ndr, NDR_BUFFERS, &r->full_info_internal_aes));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TrustedDomainInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union lsa_TrustedDomainInfo *r)
{
	uint32_t level;
	uint16_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint1632(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu16" for r at %s", (uint16_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case LSA_TRUSTED_DOMAIN_INFO_NAME: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoName(ndr, NDR_SCALARS, &r->name));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoControllers(ndr, NDR_SCALARS, &r->controllers));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoPosixOffset(ndr, NDR_SCALARS, &r->posix_offset));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_PASSWORD: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoPassword(ndr, NDR_SCALARS, &r->password));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_BASIC: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoBasic(ndr, NDR_SCALARS, &r->info_basic));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_INFO_EX: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfo(ndr, NDR_SCALARS, &r->auth_info));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoFullInfo(ndr, NDR_SCALARS, &r->full_info));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfoInternal(ndr, NDR_SCALARS, &r->auth_info_internal));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoFullInfoInternal(ndr, NDR_SCALARS, &r->full_info_internal));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_INFO_EX2_INTERNAL: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx2Internal(ndr, NDR_SCALARS, &r->info_ex2_internal));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_2_INTERNAL: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoFullInfo2Internal(ndr, NDR_SCALARS, &r->full_info2_internal));
			break; }

			case LSA_TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoSupportedEncTypes(ndr, NDR_SCALARS, &r->enc_types));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL_AES: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfoInternalAES(ndr, NDR_SCALARS, &r->auth_info_internal_aes));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL_AES: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoFullInfoInternalAES(ndr, NDR_SCALARS, &r->full_info_internal_aes));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case LSA_TRUSTED_DOMAIN_INFO_NAME:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoName(ndr, NDR_BUFFERS, &r->name));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoControllers(ndr, NDR_BUFFERS, &r->controllers));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET:
			break;

			case LSA_TRUSTED_DOMAIN_INFO_PASSWORD:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoPassword(ndr, NDR_BUFFERS, &r->password));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_BASIC:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoBasic(ndr, NDR_BUFFERS, &r->info_basic));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_INFO_EX:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfo(ndr, NDR_BUFFERS, &r->auth_info));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoFullInfo(ndr, NDR_BUFFERS, &r->full_info));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfoInternal(ndr, NDR_BUFFERS, &r->auth_info_internal));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoFullInfoInternal(ndr, NDR_BUFFERS, &r->full_info_internal));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_INFO_EX2_INTERNAL:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx2Internal(ndr, NDR_BUFFERS, &r->info_ex2_internal));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_2_INTERNAL:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoFullInfo2Internal(ndr, NDR_BUFFERS, &r->full_info2_internal));
			break;

			case LSA_TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES:
			break;

			case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL_AES:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfoInternalAES(ndr, NDR_BUFFERS, &r->auth_info_internal_aes));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL_AES:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoFullInfoInternalAES(ndr, NDR_BUFFERS, &r->full_info_internal_aes));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TrustedDomainInfo(struct ndr_print *ndr, const char *name, const union lsa_TrustedDomainInfo *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "lsa_TrustedDomainInfo");
	switch (level) {
		case LSA_TRUSTED_DOMAIN_INFO_NAME:
			ndr_print_lsa_TrustDomainInfoName(ndr, "name", &r->name);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS:
			ndr_print_lsa_TrustDomainInfoControllers(ndr, "controllers", &r->controllers);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET:
			ndr_print_lsa_TrustDomainInfoPosixOffset(ndr, "posix_offset", &r->posix_offset);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_PASSWORD:
			ndr_print_lsa_TrustDomainInfoPassword(ndr, "password", &r->password);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_BASIC:
			ndr_print_lsa_TrustDomainInfoBasic(ndr, "info_basic", &r->info_basic);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_INFO_EX:
			ndr_print_lsa_TrustDomainInfoInfoEx(ndr, "info_ex", &r->info_ex);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO:
			ndr_print_lsa_TrustDomainInfoAuthInfo(ndr, "auth_info", &r->auth_info);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO:
			ndr_print_lsa_TrustDomainInfoFullInfo(ndr, "full_info", &r->full_info);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL:
			ndr_print_lsa_TrustDomainInfoAuthInfoInternal(ndr, "auth_info_internal", &r->auth_info_internal);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL:
			ndr_print_lsa_TrustDomainInfoFullInfoInternal(ndr, "full_info_internal", &r->full_info_internal);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_INFO_EX2_INTERNAL:
			ndr_print_lsa_TrustDomainInfoInfoEx2Internal(ndr, "info_ex2_internal", &r->info_ex2_internal);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_2_INTERNAL:
			ndr_print_lsa_TrustDomainInfoFullInfo2Internal(ndr, "full_info2_internal", &r->full_info2_internal);
		break;

		case LSA_TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES:
			ndr_print_lsa_TrustDomainInfoSupportedEncTypes(ndr, "enc_types", &r->enc_types);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL_AES:
			ndr_print_lsa_TrustDomainInfoAuthInfoInternalAES(ndr, "auth_info_internal_aes", &r->auth_info_internal_aes);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL_AES:
			ndr_print_lsa_TrustDomainInfoFullInfoInternalAES(ndr, "full_info_internal_aes", &r->full_info_internal_aes);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_lsa_DATA_BUF_PTR(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_DATA_BUF_PTR *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->buf));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->buf) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->buf));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_DATA_BUF_PTR(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_DATA_BUF_PTR *r)
{
	uint32_t _ptr_buf;
	TALLOC_CTX *_mem_save_buf_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buf));
		if (_ptr_buf) {
			NDR_PULL_ALLOC(ndr, r->buf);
		} else {
			r->buf = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->buf) {
			_mem_save_buf_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->buf, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->buf));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buf_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_DATA_BUF_PTR(struct ndr_print *ndr, const char *name, const struct lsa_DATA_BUF_PTR *r)
{
	ndr_print_struct(ndr, name, "lsa_DATA_BUF_PTR");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "buf", r->buf);
	ndr->depth++;
	if (r->buf) {
		ndr_print_lsa_DATA_BUF(ndr, "buf", r->buf);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_RightSet(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_RightSet *r)
{
	uint32_t cntr_names_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->names));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_names_1 = 0; cntr_names_1 < (r->count); cntr_names_1++) {
				NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < (r->count); cntr_names_1++) {
				NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_RightSet(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_RightSet *r)
{
	uint32_t _ptr_names;
	uint32_t size_names_1 = 0;
	uint32_t cntr_names_1;
	TALLOC_CTX *_mem_save_names_0 = NULL;
	TALLOC_CTX *_mem_save_names_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 256) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(256));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_names));
		if (_ptr_names) {
			NDR_PULL_ALLOC(ndr, r->names);
		} else {
			r->names = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->names));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->names, &size_names_1));
			NDR_PULL_ALLOC_N(ndr, r->names, size_names_1);
			_mem_save_names_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			for (cntr_names_1 = 0; cntr_names_1 < (size_names_1); cntr_names_1++) {
				NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < (size_names_1); cntr_names_1++) {
				NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		}
		if (r->names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->names, r->count));
		}
		for (cntr_names_1 = 0; cntr_names_1 < (size_names_1); cntr_names_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_RightSet(struct ndr_print *ndr, const char *name, const struct lsa_RightSet *r)
{
	uint32_t cntr_names_1;
	ndr_print_struct(ndr, name, "lsa_RightSet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "names", r->names);
	ndr->depth++;
	if (r->names) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "names", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_names_1 = 0; cntr_names_1 < (r->count); cntr_names_1++) {
			ndr_print_lsa_StringLarge(ndr, "names", &r->names[cntr_names_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_DomainListEx(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_DomainListEx *r)
{
	uint32_t cntr_domains_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domains));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domains) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_domains_1 = 0; cntr_domains_1 < (r->count); cntr_domains_1++) {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->domains[cntr_domains_1]));
			}
			for (cntr_domains_1 = 0; cntr_domains_1 < (r->count); cntr_domains_1++) {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->domains[cntr_domains_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_DomainListEx(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_DomainListEx *r)
{
	uint32_t _ptr_domains;
	uint32_t size_domains_1 = 0;
	uint32_t cntr_domains_1;
	TALLOC_CTX *_mem_save_domains_0 = NULL;
	TALLOC_CTX *_mem_save_domains_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, r->domains);
		} else {
			r->domains = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domains) {
			_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domains, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domains));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->domains, &size_domains_1));
			NDR_PULL_ALLOC_N(ndr, r->domains, size_domains_1);
			_mem_save_domains_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domains, 0);
			for (cntr_domains_1 = 0; cntr_domains_1 < (size_domains_1); cntr_domains_1++) {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->domains[cntr_domains_1]));
			}
			for (cntr_domains_1 = 0; cntr_domains_1 < (size_domains_1); cntr_domains_1++) {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->domains[cntr_domains_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, 0);
		}
		if (r->domains) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->domains, r->count));
		}
		for (cntr_domains_1 = 0; cntr_domains_1 < (size_domains_1); cntr_domains_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_DomainListEx(struct ndr_print *ndr, const char *name, const struct lsa_DomainListEx *r)
{
	uint32_t cntr_domains_1;
	ndr_print_struct(ndr, name, "lsa_DomainListEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "domains", r->domains);
	ndr->depth++;
	if (r->domains) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "domains", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_domains_1 = 0; cntr_domains_1 < (r->count); cntr_domains_1++) {
			ndr_print_lsa_TrustDomainInfoInfoEx(ndr, "domains", &r->domains[cntr_domains_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_DomainInfoQoS(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_DomainInfoQoS *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->quality_of_service));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_DomainInfoQoS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_DomainInfoQoS *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->quality_of_service));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_DomainInfoQoS(struct ndr_print *ndr, const char *name, const struct lsa_DomainInfoQoS *r)
{
	ndr_print_struct(ndr, name, "lsa_DomainInfoQoS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "quality_of_service", r->quality_of_service);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_krbAuthenticationOptions(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_krbAuthenticationOptions(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_krbAuthenticationOptions(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_POLICY_KERBEROS_VALIDATE_CLIENT", LSA_POLICY_KERBEROS_VALIDATE_CLIENT, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_DomainInfoKerberos(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_DomainInfoKerberos *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_lsa_krbAuthenticationOptions(ndr, NDR_SCALARS, r->authentication_options));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->service_tkt_lifetime));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->user_tkt_lifetime));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->user_tkt_renewaltime));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->clock_skew));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->reserved));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_DomainInfoKerberos(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_DomainInfoKerberos *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_lsa_krbAuthenticationOptions(ndr, NDR_SCALARS, &r->authentication_options));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->service_tkt_lifetime));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->user_tkt_lifetime));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->user_tkt_renewaltime));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->clock_skew));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_DomainInfoKerberos(struct ndr_print *ndr, const char *name, const struct lsa_DomainInfoKerberos *r)
{
	ndr_print_struct(ndr, name, "lsa_DomainInfoKerberos");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_krbAuthenticationOptions(ndr, "authentication_options", r->authentication_options);
	ndr_print_hyper(ndr, "service_tkt_lifetime", r->service_tkt_lifetime);
	ndr_print_hyper(ndr, "user_tkt_lifetime", r->user_tkt_lifetime);
	ndr_print_hyper(ndr, "user_tkt_renewaltime", r->user_tkt_renewaltime);
	ndr_print_hyper(ndr, "clock_skew", r->clock_skew);
	ndr_print_hyper(ndr, "reserved", r->reserved);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_DomainInfoEfs(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_DomainInfoEfs *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->blob_size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->efs_blob));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->efs_blob) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->blob_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->efs_blob, r->blob_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_DomainInfoEfs(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_DomainInfoEfs *r)
{
	uint32_t _ptr_efs_blob;
	uint32_t size_efs_blob_1 = 0;
	TALLOC_CTX *_mem_save_efs_blob_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->blob_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_efs_blob));
		if (_ptr_efs_blob) {
			NDR_PULL_ALLOC(ndr, r->efs_blob);
		} else {
			r->efs_blob = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->efs_blob) {
			_mem_save_efs_blob_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->efs_blob, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->efs_blob));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->efs_blob, &size_efs_blob_1));
			NDR_PULL_ALLOC_N(ndr, r->efs_blob, size_efs_blob_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->efs_blob, size_efs_blob_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_efs_blob_0, 0);
		}
		if (r->efs_blob) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->efs_blob, r->blob_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_DomainInfoEfs(struct ndr_print *ndr, const char *name, const struct lsa_DomainInfoEfs *r)
{
	ndr_print_struct(ndr, name, "lsa_DomainInfoEfs");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "blob_size", r->blob_size);
	ndr_print_ptr(ndr, "efs_blob", r->efs_blob);
	ndr->depth++;
	if (r->efs_blob) {
		ndr_print_array_uint8(ndr, "efs_blob", r->efs_blob, r->blob_size);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_DomainInfoEnum(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum lsa_DomainInfoEnum r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_DomainInfoEnum(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum lsa_DomainInfoEnum *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_DomainInfoEnum(struct ndr_print *ndr, const char *name, enum lsa_DomainInfoEnum r)
{
	const char *val = NULL;

	switch (r) {
		case LSA_DOMAIN_INFO_POLICY_QOS: val = "LSA_DOMAIN_INFO_POLICY_QOS"; break;
		case LSA_DOMAIN_INFO_POLICY_EFS: val = "LSA_DOMAIN_INFO_POLICY_EFS"; break;
		case LSA_DOMAIN_INFO_POLICY_KERBEROS: val = "LSA_DOMAIN_INFO_POLICY_KERBEROS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_lsa_DomainInformationPolicy(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union lsa_DomainInformationPolicy *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		NDR_CHECK(ndr_push_lsa_DomainInfoEnum(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		switch (level) {
			case LSA_DOMAIN_INFO_POLICY_QOS: {
				NDR_CHECK(ndr_push_lsa_DomainInfoQoS(ndr, NDR_SCALARS, &r->qos_info));
			break; }

			case LSA_DOMAIN_INFO_POLICY_EFS: {
				NDR_CHECK(ndr_push_lsa_DomainInfoEfs(ndr, NDR_SCALARS, &r->efs_info));
			break; }

			case LSA_DOMAIN_INFO_POLICY_KERBEROS: {
				NDR_CHECK(ndr_push_lsa_DomainInfoKerberos(ndr, NDR_SCALARS, &r->kerberos_info));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case LSA_DOMAIN_INFO_POLICY_QOS:
			break;

			case LSA_DOMAIN_INFO_POLICY_EFS:
				NDR_CHECK(ndr_push_lsa_DomainInfoEfs(ndr, NDR_BUFFERS, &r->efs_info));
			break;

			case LSA_DOMAIN_INFO_POLICY_KERBEROS:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_DomainInformationPolicy(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union lsa_DomainInformationPolicy *r)
{
	uint32_t level;
	uint16_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint1632(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu16" for r at %s", (uint16_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		switch (level) {
			case LSA_DOMAIN_INFO_POLICY_QOS: {
				NDR_CHECK(ndr_pull_lsa_DomainInfoQoS(ndr, NDR_SCALARS, &r->qos_info));
			break; }

			case LSA_DOMAIN_INFO_POLICY_EFS: {
				NDR_CHECK(ndr_pull_lsa_DomainInfoEfs(ndr, NDR_SCALARS, &r->efs_info));
			break; }

			case LSA_DOMAIN_INFO_POLICY_KERBEROS: {
				NDR_CHECK(ndr_pull_lsa_DomainInfoKerberos(ndr, NDR_SCALARS, &r->kerberos_info));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case LSA_DOMAIN_INFO_POLICY_QOS:
			break;

			case LSA_DOMAIN_INFO_POLICY_EFS:
				NDR_CHECK(ndr_pull_lsa_DomainInfoEfs(ndr, NDR_BUFFERS, &r->efs_info));
			break;

			case LSA_DOMAIN_INFO_POLICY_KERBEROS:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_DomainInformationPolicy(struct ndr_print *ndr, const char *name, const union lsa_DomainInformationPolicy *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "lsa_DomainInformationPolicy");
	switch (level) {
		case LSA_DOMAIN_INFO_POLICY_QOS:
			ndr_print_lsa_DomainInfoQoS(ndr, "qos_info", &r->qos_info);
		break;

		case LSA_DOMAIN_INFO_POLICY_EFS:
			ndr_print_lsa_DomainInfoEfs(ndr, "efs_info", &r->efs_info);
		break;

		case LSA_DOMAIN_INFO_POLICY_KERBEROS:
			ndr_print_lsa_DomainInfoKerberos(ndr, "kerberos_info", &r->kerberos_info);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_lsa_TranslatedName2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TranslatedName2 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, r->sid_type));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sid_index));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->name));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TranslatedName2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TranslatedName2 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, &r->sid_type));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_index));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->name));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TranslatedName2(struct ndr_print *ndr, const char *name, const struct lsa_TranslatedName2 *r)
{
	ndr_print_struct(ndr, name, "lsa_TranslatedName2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_SidType(ndr, "sid_type", r->sid_type);
	ndr_print_lsa_String(ndr, "name", &r->name);
	ndr_print_uint32(ndr, "sid_index", r->sid_index);
	ndr_print_uint32(ndr, "unknown", r->unknown);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TransNameArray2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TransNameArray2 *r)
{
	uint32_t cntr_names_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->names));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_names_1 = 0; cntr_names_1 < (r->count); cntr_names_1++) {
				NDR_CHECK(ndr_push_lsa_TranslatedName2(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < (r->count); cntr_names_1++) {
				NDR_CHECK(ndr_push_lsa_TranslatedName2(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TransNameArray2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TransNameArray2 *r)
{
	uint32_t _ptr_names;
	uint32_t size_names_1 = 0;
	uint32_t cntr_names_1;
	TALLOC_CTX *_mem_save_names_0 = NULL;
	TALLOC_CTX *_mem_save_names_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(1000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_names));
		if (_ptr_names) {
			NDR_PULL_ALLOC(ndr, r->names);
		} else {
			r->names = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->names));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->names, &size_names_1));
			NDR_PULL_ALLOC_N(ndr, r->names, size_names_1);
			_mem_save_names_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			for (cntr_names_1 = 0; cntr_names_1 < (size_names_1); cntr_names_1++) {
				NDR_CHECK(ndr_pull_lsa_TranslatedName2(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < (size_names_1); cntr_names_1++) {
				NDR_CHECK(ndr_pull_lsa_TranslatedName2(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		}
		if (r->names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->names, r->count));
		}
		for (cntr_names_1 = 0; cntr_names_1 < (size_names_1); cntr_names_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TransNameArray2(struct ndr_print *ndr, const char *name, const struct lsa_TransNameArray2 *r)
{
	uint32_t cntr_names_1;
	ndr_print_struct(ndr, name, "lsa_TransNameArray2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "names", r->names);
	ndr->depth++;
	if (r->names) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "names", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_names_1 = 0; cntr_names_1 < (r->count); cntr_names_1++) {
			ndr_print_lsa_TranslatedName2(ndr, "names", &r->names[cntr_names_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_LookupOptions(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum lsa_LookupOptions r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_LookupOptions(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum lsa_LookupOptions *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LookupOptions(struct ndr_print *ndr, const char *name, enum lsa_LookupOptions r)
{
	const char *val = NULL;

	switch (r) {
		case LSA_LOOKUP_OPTION_SEARCH_ISOLATED_NAMES: val = "LSA_LOOKUP_OPTION_SEARCH_ISOLATED_NAMES"; break;
		case LSA_LOOKUP_OPTION_SEARCH_ISOLATED_NAMES_LOCAL: val = "LSA_LOOKUP_OPTION_SEARCH_ISOLATED_NAMES_LOCAL"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_lsa_ClientRevision(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum lsa_ClientRevision r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_ClientRevision(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum lsa_ClientRevision *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_ClientRevision(struct ndr_print *ndr, const char *name, enum lsa_ClientRevision r)
{
	const char *val = NULL;

	switch (r) {
		case LSA_CLIENT_REVISION_1: val = "LSA_CLIENT_REVISION_1"; break;
		case LSA_CLIENT_REVISION_2: val = "LSA_CLIENT_REVISION_2"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_lsa_TranslatedSid2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TranslatedSid2 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, r->sid_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sid_index));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TranslatedSid2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TranslatedSid2 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, &r->sid_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_index));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TranslatedSid2(struct ndr_print *ndr, const char *name, const struct lsa_TranslatedSid2 *r)
{
	ndr_print_struct(ndr, name, "lsa_TranslatedSid2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_SidType(ndr, "sid_type", r->sid_type);
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_uint32(ndr, "sid_index", r->sid_index);
	ndr_print_uint32(ndr, "unknown", r->unknown);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TransSidArray2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TransSidArray2 *r)
{
	uint32_t cntr_sids_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sids));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sids) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_sids_1 = 0; cntr_sids_1 < (r->count); cntr_sids_1++) {
				NDR_CHECK(ndr_push_lsa_TranslatedSid2(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TransSidArray2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TransSidArray2 *r)
{
	uint32_t _ptr_sids;
	uint32_t size_sids_1 = 0;
	uint32_t cntr_sids_1;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	TALLOC_CTX *_mem_save_sids_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(1000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sids));
		if (_ptr_sids) {
			NDR_PULL_ALLOC(ndr, r->sids);
		} else {
			r->sids = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sids) {
			_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sids));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->sids, &size_sids_1));
			NDR_PULL_ALLOC_N(ndr, r->sids, size_sids_1);
			_mem_save_sids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			for (cntr_sids_1 = 0; cntr_sids_1 < (size_sids_1); cntr_sids_1++) {
				NDR_CHECK(ndr_pull_lsa_TranslatedSid2(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		}
		if (r->sids) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->sids, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TransSidArray2(struct ndr_print *ndr, const char *name, const struct lsa_TransSidArray2 *r)
{
	uint32_t cntr_sids_1;
	ndr_print_struct(ndr, name, "lsa_TransSidArray2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "sids", r->sids);
	ndr->depth++;
	if (r->sids) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "sids", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_sids_1 = 0; cntr_sids_1 < (r->count); cntr_sids_1++) {
			ndr_print_lsa_TranslatedSid2(ndr, "sids", &r->sids[cntr_sids_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TranslatedSid3(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TranslatedSid3 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, r->sid_type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sid_index));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TranslatedSid3(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TranslatedSid3 *r)
{
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, &r->sid_type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, r->sid);
		} else {
			r->sid = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_index));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sid) {
			_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TranslatedSid3(struct ndr_print *ndr, const char *name, const struct lsa_TranslatedSid3 *r)
{
	ndr_print_struct(ndr, name, "lsa_TranslatedSid3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_SidType(ndr, "sid_type", r->sid_type);
	ndr_print_ptr(ndr, "sid", r->sid);
	ndr->depth++;
	if (r->sid) {
		ndr_print_dom_sid2(ndr, "sid", r->sid);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "sid_index", r->sid_index);
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TransSidArray3(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_TransSidArray3 *r)
{
	uint32_t cntr_sids_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sids));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sids) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_sids_1 = 0; cntr_sids_1 < (r->count); cntr_sids_1++) {
				NDR_CHECK(ndr_push_lsa_TranslatedSid3(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < (r->count); cntr_sids_1++) {
				NDR_CHECK(ndr_push_lsa_TranslatedSid3(ndr, NDR_BUFFERS, &r->sids[cntr_sids_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TransSidArray3(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_TransSidArray3 *r)
{
	uint32_t _ptr_sids;
	uint32_t size_sids_1 = 0;
	uint32_t cntr_sids_1;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	TALLOC_CTX *_mem_save_sids_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(1000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sids));
		if (_ptr_sids) {
			NDR_PULL_ALLOC(ndr, r->sids);
		} else {
			r->sids = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sids) {
			_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sids));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->sids, &size_sids_1));
			NDR_PULL_ALLOC_N(ndr, r->sids, size_sids_1);
			_mem_save_sids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			for (cntr_sids_1 = 0; cntr_sids_1 < (size_sids_1); cntr_sids_1++) {
				NDR_CHECK(ndr_pull_lsa_TranslatedSid3(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < (size_sids_1); cntr_sids_1++) {
				NDR_CHECK(ndr_pull_lsa_TranslatedSid3(ndr, NDR_BUFFERS, &r->sids[cntr_sids_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		}
		if (r->sids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->sids, r->count));
		}
		for (cntr_sids_1 = 0; cntr_sids_1 < (size_sids_1); cntr_sids_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TransSidArray3(struct ndr_print *ndr, const char *name, const struct lsa_TransSidArray3 *r)
{
	uint32_t cntr_sids_1;
	ndr_print_struct(ndr, name, "lsa_TransSidArray3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "sids", r->sids);
	ndr->depth++;
	if (r->sids) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "sids", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_sids_1 = 0; cntr_sids_1 < (r->count); cntr_sids_1++) {
			ndr_print_lsa_TranslatedSid3(ndr, "sids", &r->sids[cntr_sids_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_ForestTrustRecordFlags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_ForestTrustRecordFlags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_ForestTrustRecordFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TLN_DISABLED_NEW", LSA_TLN_DISABLED_NEW, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TLN_DISABLED_ADMIN", LSA_TLN_DISABLED_ADMIN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_TLN_DISABLED_CONFLICT", LSA_TLN_DISABLED_CONFLICT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_SID_DISABLED_ADMIN", LSA_SID_DISABLED_ADMIN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_SID_DISABLED_CONFLICT", LSA_SID_DISABLED_CONFLICT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_NB_DISABLED_ADMIN", LSA_NB_DISABLED_ADMIN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_NB_DISABLED_CONFLICT", LSA_NB_DISABLED_CONFLICT, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_ForestTrustRecordType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum lsa_ForestTrustRecordType r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_ForestTrustRecordType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum lsa_ForestTrustRecordType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_ForestTrustRecordType(struct ndr_print *ndr, const char *name, enum lsa_ForestTrustRecordType r)
{
	const char *val = NULL;

	switch (r) {
		case LSA_FOREST_TRUST_TOP_LEVEL_NAME: val = "LSA_FOREST_TRUST_TOP_LEVEL_NAME"; break;
		case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX: val = "LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX"; break;
		case LSA_FOREST_TRUST_DOMAIN_INFO: val = "LSA_FOREST_TRUST_DOMAIN_INFO"; break;
		case LSA_FOREST_TRUST_BINARY_DATA: val = "LSA_FOREST_TRUST_BINARY_DATA"; break;
		case LSA_FOREST_TRUST_SCANNER_INFO: val = "LSA_FOREST_TRUST_SCANNER_INFO"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_lsa_ForestTrustBinaryData(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_ForestTrustBinaryData *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->length));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, r->length));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_ForestTrustBinaryData(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_ForestTrustBinaryData *r)
{
	uint32_t _ptr_data;
	uint32_t size_data_1 = 0;
	TALLOC_CTX *_mem_save_data_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &r->length));
		if (r->length > 131072) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->length), (uint32_t)(0), (uint32_t)(131072));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
		if (_ptr_data) {
			NDR_PULL_ALLOC(ndr, r->data);
		} else {
			r->data = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data) {
			_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->data, &size_data_1));
			NDR_PULL_ALLOC_N(ndr, r->data, size_data_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, size_data_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
		}
		if (r->data) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->data, r->length));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_ForestTrustBinaryData(struct ndr_print *ndr, const char *name, const struct lsa_ForestTrustBinaryData *r)
{
	ndr_print_struct(ndr, name, "lsa_ForestTrustBinaryData");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint3264(ndr, "length", r->length);
	ndr_print_ptr(ndr, "data", r->data);
	ndr->depth++;
	if (r->data) {
		ndr_print_array_uint8(ndr, "data", r->data, r->length);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_ForestTrustDomainInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_ForestTrustDomainInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_sid));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->dns_domain_name));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->netbios_domain_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domain_sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain_sid));
		}
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dns_domain_name));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->netbios_domain_name));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_ForestTrustDomainInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_ForestTrustDomainInfo *r)
{
	uint32_t _ptr_domain_sid;
	TALLOC_CTX *_mem_save_domain_sid_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_sid));
		if (_ptr_domain_sid) {
			NDR_PULL_ALLOC(ndr, r->domain_sid);
		} else {
			r->domain_sid = NULL;
		}
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->dns_domain_name));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->netbios_domain_name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domain_sid) {
			_mem_save_domain_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain_sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_sid_0, 0);
		}
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dns_domain_name));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->netbios_domain_name));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_ForestTrustDomainInfo(struct ndr_print *ndr, const char *name, const struct lsa_ForestTrustDomainInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_ForestTrustDomainInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "domain_sid", r->domain_sid);
	ndr->depth++;
	if (r->domain_sid) {
		ndr_print_dom_sid2(ndr, "domain_sid", r->domain_sid);
	}
	ndr->depth--;
	ndr_print_lsa_StringLarge(ndr, "dns_domain_name", &r->dns_domain_name);
	ndr_print_lsa_StringLarge(ndr, "netbios_domain_name", &r->netbios_domain_name);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_ForestTrustData(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union lsa_ForestTrustData *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_ForestTrustRecordType(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case LSA_FOREST_TRUST_TOP_LEVEL_NAME: {
				NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->top_level_name));
			break; }

			case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX: {
				NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->top_level_name_ex));
			break; }

			case LSA_FOREST_TRUST_DOMAIN_INFO: {
				NDR_CHECK(ndr_push_lsa_ForestTrustDomainInfo(ndr, NDR_SCALARS, &r->domain_info));
			break; }

			default: {
				NDR_CHECK(ndr_push_lsa_ForestTrustBinaryData(ndr, NDR_SCALARS, &r->data));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case LSA_FOREST_TRUST_TOP_LEVEL_NAME:
				NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->top_level_name));
			break;

			case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX:
				NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->top_level_name_ex));
			break;

			case LSA_FOREST_TRUST_DOMAIN_INFO:
				NDR_CHECK(ndr_push_lsa_ForestTrustDomainInfo(ndr, NDR_BUFFERS, &r->domain_info));
			break;

			default:
				NDR_CHECK(ndr_push_lsa_ForestTrustBinaryData(ndr, NDR_BUFFERS, &r->data));
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_ForestTrustData(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union lsa_ForestTrustData *r)
{
	uint32_t level;
	uint16_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint1632(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu16" for r at %s", (uint16_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case LSA_FOREST_TRUST_TOP_LEVEL_NAME: {
				NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->top_level_name));
			break; }

			case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX: {
				NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->top_level_name_ex));
			break; }

			case LSA_FOREST_TRUST_DOMAIN_INFO: {
				NDR_CHECK(ndr_pull_lsa_ForestTrustDomainInfo(ndr, NDR_SCALARS, &r->domain_info));
			break; }

			default: {
				NDR_CHECK(ndr_pull_lsa_ForestTrustBinaryData(ndr, NDR_SCALARS, &r->data));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case LSA_FOREST_TRUST_TOP_LEVEL_NAME:
				NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->top_level_name));
			break;

			case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX:
				NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->top_level_name_ex));
			break;

			case LSA_FOREST_TRUST_DOMAIN_INFO:
				NDR_CHECK(ndr_pull_lsa_ForestTrustDomainInfo(ndr, NDR_BUFFERS, &r->domain_info));
			break;

			default:
				NDR_CHECK(ndr_pull_lsa_ForestTrustBinaryData(ndr, NDR_BUFFERS, &r->data));
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_ForestTrustData(struct ndr_print *ndr, const char *name, const union lsa_ForestTrustData *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "lsa_ForestTrustData");
	switch (level) {
		case LSA_FOREST_TRUST_TOP_LEVEL_NAME:
			ndr_print_lsa_StringLarge(ndr, "top_level_name", &r->top_level_name);
		break;

		case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX:
			ndr_print_lsa_StringLarge(ndr, "top_level_name_ex", &r->top_level_name_ex);
		break;

		case LSA_FOREST_TRUST_DOMAIN_INFO:
			ndr_print_lsa_ForestTrustDomainInfo(ndr, "domain_info", &r->domain_info);
		break;

		default:
			ndr_print_lsa_ForestTrustBinaryData(ndr, "data", &r->data);
		break;

	}
}

static enum ndr_err_code ndr_push_lsa_ForestTrustRecord(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_ForestTrustRecord *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_lsa_ForestTrustRecordFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_lsa_ForestTrustRecordType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_NTTIME_hyper(ndr, NDR_SCALARS, r->time));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->forest_trust_data, r->type));
		NDR_CHECK(ndr_push_lsa_ForestTrustData(ndr, NDR_SCALARS, &r->forest_trust_data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->forest_trust_data, r->type));
		NDR_CHECK(ndr_push_lsa_ForestTrustData(ndr, NDR_BUFFERS, &r->forest_trust_data));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_ForestTrustRecord(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_ForestTrustRecord *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_lsa_ForestTrustRecordFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_lsa_ForestTrustRecordType(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_NTTIME_hyper(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->forest_trust_data, r->type));
		NDR_CHECK(ndr_pull_lsa_ForestTrustData(ndr, NDR_SCALARS, &r->forest_trust_data));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->forest_trust_data, r->type));
		NDR_CHECK(ndr_pull_lsa_ForestTrustData(ndr, NDR_BUFFERS, &r->forest_trust_data));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_ForestTrustRecord(struct ndr_print *ndr, const char *name, const struct lsa_ForestTrustRecord *r)
{
	ndr_print_struct(ndr, name, "lsa_ForestTrustRecord");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_ForestTrustRecordFlags(ndr, "flags", r->flags);
	ndr_print_lsa_ForestTrustRecordType(ndr, "type", r->type);
	ndr_print_NTTIME_hyper(ndr, "time", r->time);
	ndr_print_set_switch_value(ndr, &r->forest_trust_data, r->type);
	ndr_print_lsa_ForestTrustData(ndr, "forest_trust_data", &r->forest_trust_data);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_ForestTrustInformation(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_ForestTrustInformation *r)
{
	uint32_t cntr_entries_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->entries));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_entries_1 = 0; cntr_entries_1 < (r->count); cntr_entries_1++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < (r->count); cntr_entries_1++) {
				if (r->entries[cntr_entries_1]) {
					NDR_CHECK(ndr_push_lsa_ForestTrustRecord(ndr, NDR_SCALARS|NDR_BUFFERS, r->entries[cntr_entries_1]));
				}
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_ForestTrustInformation(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_ForestTrustInformation *r)
{
	uint32_t _ptr_entries;
	uint32_t size_entries_1 = 0;
	uint32_t cntr_entries_1;
	TALLOC_CTX *_mem_save_entries_0 = NULL;
	TALLOC_CTX *_mem_save_entries_1 = NULL;
	TALLOC_CTX *_mem_save_entries_2 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 4000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(4000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_entries));
		if (_ptr_entries) {
			NDR_PULL_ALLOC(ndr, r->entries);
		} else {
			r->entries = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			_mem_save_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->entries));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->entries, &size_entries_1));
			NDR_PULL_ALLOC_N(ndr, r->entries, size_entries_1);
			_mem_save_entries_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			for (cntr_entries_1 = 0; cntr_entries_1 < (size_entries_1); cntr_entries_1++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_entries));
				if (_ptr_entries) {
					NDR_PULL_ALLOC(ndr, r->entries[cntr_entries_1]);
				} else {
					r->entries[cntr_entries_1] = NULL;
				}
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < (size_entries_1); cntr_entries_1++) {
				if (r->entries[cntr_entries_1]) {
					_mem_save_entries_2 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->entries[cntr_entries_1], 0);
					NDR_CHECK(ndr_pull_lsa_ForestTrustRecord(ndr, NDR_SCALARS|NDR_BUFFERS, r->entries[cntr_entries_1]));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_2, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_0, 0);
		}
		if (r->entries) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->entries, r->count));
		}
		for (cntr_entries_1 = 0; cntr_entries_1 < (size_entries_1); cntr_entries_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_ForestTrustInformation(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_ForestTrustInformation *r)
{
	ndr_print_lsa_ForestTrustInformation(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_ForestTrustInformation(struct ndr_print *ndr, const char *name, const struct lsa_ForestTrustInformation *r)
{
	uint32_t cntr_entries_1;
	ndr_print_struct(ndr, name, "lsa_ForestTrustInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "entries", r->entries);
	ndr->depth++;
	if (r->entries) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "entries", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_entries_1 = 0; cntr_entries_1 < (r->count); cntr_entries_1++) {
			ndr_print_ptr(ndr, "entries", r->entries[cntr_entries_1]);
			ndr->depth++;
			if (r->entries[cntr_entries_1]) {
				ndr_print_lsa_ForestTrustRecord(ndr, "entries", r->entries[cntr_entries_1]);
			}
			ndr->depth--;
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_ForestTrustCollisionRecordType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum lsa_ForestTrustCollisionRecordType r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_ForestTrustCollisionRecordType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum lsa_ForestTrustCollisionRecordType *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_ForestTrustCollisionRecordType(struct ndr_print *ndr, const char *name, enum lsa_ForestTrustCollisionRecordType r)
{
	const char *val = NULL;

	switch (r) {
		case LSA_FOREST_TRUST_COLLISION_TDO: val = "LSA_FOREST_TRUST_COLLISION_TDO"; break;
		case LSA_FOREST_TRUST_COLLISION_XREF: val = "LSA_FOREST_TRUST_COLLISION_XREF"; break;
		case LSA_FOREST_TRUST_COLLISION_OTHER: val = "LSA_FOREST_TRUST_COLLISION_OTHER"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_ForestTrustCollisionRecord(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_ForestTrustCollisionRecord *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->index));
		NDR_CHECK(ndr_push_lsa_ForestTrustCollisionRecordType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_lsa_ForestTrustRecordFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->name));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_ForestTrustCollisionRecord(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_ForestTrustCollisionRecord *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->index));
		NDR_CHECK(ndr_pull_lsa_ForestTrustCollisionRecordType(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_lsa_ForestTrustRecordFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->name));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_ForestTrustCollisionRecord(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_ForestTrustCollisionRecord *r)
{
	ndr_print_lsa_ForestTrustCollisionRecord(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_ForestTrustCollisionRecord(struct ndr_print *ndr, const char *name, const struct lsa_ForestTrustCollisionRecord *r)
{
	ndr_print_struct(ndr, name, "lsa_ForestTrustCollisionRecord");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "index", r->index);
	ndr_print_lsa_ForestTrustCollisionRecordType(ndr, "type", r->type);
	ndr_print_lsa_ForestTrustRecordFlags(ndr, "flags", r->flags);
	ndr_print_lsa_String(ndr, "name", &r->name);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_ForestTrustCollisionInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_ForestTrustCollisionInfo *r)
{
	uint32_t cntr_entries_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->entries));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_entries_1 = 0; cntr_entries_1 < (r->count); cntr_entries_1++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < (r->count); cntr_entries_1++) {
				if (r->entries[cntr_entries_1]) {
					NDR_CHECK(ndr_push_lsa_ForestTrustCollisionRecord(ndr, NDR_SCALARS|NDR_BUFFERS, r->entries[cntr_entries_1]));
				}
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_ForestTrustCollisionInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_ForestTrustCollisionInfo *r)
{
	uint32_t _ptr_entries;
	uint32_t size_entries_1 = 0;
	uint32_t cntr_entries_1;
	TALLOC_CTX *_mem_save_entries_0 = NULL;
	TALLOC_CTX *_mem_save_entries_1 = NULL;
	TALLOC_CTX *_mem_save_entries_2 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_entries));
		if (_ptr_entries) {
			NDR_PULL_ALLOC(ndr, r->entries);
		} else {
			r->entries = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			_mem_save_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->entries));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->entries, &size_entries_1));
			NDR_PULL_ALLOC_N(ndr, r->entries, size_entries_1);
			_mem_save_entries_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			for (cntr_entries_1 = 0; cntr_entries_1 < (size_entries_1); cntr_entries_1++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_entries));
				if (_ptr_entries) {
					NDR_PULL_ALLOC(ndr, r->entries[cntr_entries_1]);
				} else {
					r->entries[cntr_entries_1] = NULL;
				}
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < (size_entries_1); cntr_entries_1++) {
				if (r->entries[cntr_entries_1]) {
					_mem_save_entries_2 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->entries[cntr_entries_1], 0);
					NDR_CHECK(ndr_pull_lsa_ForestTrustCollisionRecord(ndr, NDR_SCALARS|NDR_BUFFERS, r->entries[cntr_entries_1]));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_2, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_0, 0);
		}
		if (r->entries) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->entries, r->count));
		}
		for (cntr_entries_1 = 0; cntr_entries_1 < (size_entries_1); cntr_entries_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_ForestTrustCollisionInfo(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_ForestTrustCollisionInfo *r)
{
	ndr_print_lsa_ForestTrustCollisionInfo(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_ForestTrustCollisionInfo(struct ndr_print *ndr, const char *name, const struct lsa_ForestTrustCollisionInfo *r)
{
	uint32_t cntr_entries_1;
	ndr_print_struct(ndr, name, "lsa_ForestTrustCollisionInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "entries", r->entries);
	ndr->depth++;
	if (r->entries) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "entries", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_entries_1 = 0; cntr_entries_1 < (r->count); cntr_entries_1++) {
			ndr_print_ptr(ndr, "entries", r->entries[cntr_entries_1]);
			ndr->depth++;
			if (r->entries[cntr_entries_1]) {
				ndr_print_lsa_ForestTrustCollisionRecord(ndr, "entries", r->entries[cntr_entries_1]);
			}
			ndr->depth--;
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_RevisionSupportedFeature(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_RevisionSupportedFeature(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_RevisionSupportedFeature(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "LSA_FEATURE_TDO_AUTH_INFO_AES_CIPHER", LSA_FEATURE_TDO_AUTH_INFO_AES_CIPHER, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_revision_info1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_revision_info1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->revision));
		NDR_CHECK(ndr_push_lsa_RevisionSupportedFeature(ndr, NDR_SCALARS, r->supported_features));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_revision_info1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_revision_info1 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->revision));
		NDR_CHECK(ndr_pull_lsa_RevisionSupportedFeature(ndr, NDR_SCALARS, &r->supported_features));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_revision_info1(struct ndr_print *ndr, const char *name, const struct lsa_revision_info1 *r)
{
	ndr_print_struct(ndr, name, "lsa_revision_info1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "revision", r->revision);
	ndr_print_lsa_RevisionSupportedFeature(ndr, "supported_features", r->supported_features);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_revision_info(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union lsa_revision_info *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_lsa_revision_info1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_revision_info(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union lsa_revision_info *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_lsa_revision_info1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_revision_info(struct ndr_print *ndr, const char *name, const union lsa_revision_info *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "lsa_revision_info");
	switch (level) {
		case 1:
			ndr_print_lsa_revision_info1(ndr, "info1", &r->info1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_lsa_ForestTrustData2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union lsa_ForestTrustData2 *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_ForestTrustRecordType(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case LSA_FOREST_TRUST_TOP_LEVEL_NAME: {
				NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->top_level_name));
			break; }

			case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX: {
				NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->top_level_name_ex));
			break; }

			case LSA_FOREST_TRUST_DOMAIN_INFO: {
				NDR_CHECK(ndr_push_lsa_ForestTrustDomainInfo(ndr, NDR_SCALARS, &r->domain_info));
			break; }

			case LSA_FOREST_TRUST_BINARY_DATA: {
				NDR_CHECK(ndr_push_lsa_ForestTrustBinaryData(ndr, NDR_SCALARS, &r->data));
			break; }

			case LSA_FOREST_TRUST_SCANNER_INFO: {
				NDR_CHECK(ndr_push_lsa_ForestTrustDomainInfo(ndr, NDR_SCALARS, &r->scanner_info));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case LSA_FOREST_TRUST_TOP_LEVEL_NAME:
				NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->top_level_name));
			break;

			case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX:
				NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->top_level_name_ex));
			break;

			case LSA_FOREST_TRUST_DOMAIN_INFO:
				NDR_CHECK(ndr_push_lsa_ForestTrustDomainInfo(ndr, NDR_BUFFERS, &r->domain_info));
			break;

			case LSA_FOREST_TRUST_BINARY_DATA:
				NDR_CHECK(ndr_push_lsa_ForestTrustBinaryData(ndr, NDR_BUFFERS, &r->data));
			break;

			case LSA_FOREST_TRUST_SCANNER_INFO:
				NDR_CHECK(ndr_push_lsa_ForestTrustDomainInfo(ndr, NDR_BUFFERS, &r->scanner_info));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_ForestTrustData2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union lsa_ForestTrustData2 *r)
{
	uint32_t level;
	uint16_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint1632(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu16" for r at %s", (uint16_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case LSA_FOREST_TRUST_TOP_LEVEL_NAME: {
				NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->top_level_name));
			break; }

			case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX: {
				NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->top_level_name_ex));
			break; }

			case LSA_FOREST_TRUST_DOMAIN_INFO: {
				NDR_CHECK(ndr_pull_lsa_ForestTrustDomainInfo(ndr, NDR_SCALARS, &r->domain_info));
			break; }

			case LSA_FOREST_TRUST_BINARY_DATA: {
				NDR_CHECK(ndr_pull_lsa_ForestTrustBinaryData(ndr, NDR_SCALARS, &r->data));
			break; }

			case LSA_FOREST_TRUST_SCANNER_INFO: {
				NDR_CHECK(ndr_pull_lsa_ForestTrustDomainInfo(ndr, NDR_SCALARS, &r->scanner_info));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case LSA_FOREST_TRUST_TOP_LEVEL_NAME:
				NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->top_level_name));
			break;

			case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX:
				NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->top_level_name_ex));
			break;

			case LSA_FOREST_TRUST_DOMAIN_INFO:
				NDR_CHECK(ndr_pull_lsa_ForestTrustDomainInfo(ndr, NDR_BUFFERS, &r->domain_info));
			break;

			case LSA_FOREST_TRUST_BINARY_DATA:
				NDR_CHECK(ndr_pull_lsa_ForestTrustBinaryData(ndr, NDR_BUFFERS, &r->data));
			break;

			case LSA_FOREST_TRUST_SCANNER_INFO:
				NDR_CHECK(ndr_pull_lsa_ForestTrustDomainInfo(ndr, NDR_BUFFERS, &r->scanner_info));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_ForestTrustData2(struct ndr_print *ndr, const char *name, const union lsa_ForestTrustData2 *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "lsa_ForestTrustData2");
	switch (level) {
		case LSA_FOREST_TRUST_TOP_LEVEL_NAME:
			ndr_print_lsa_StringLarge(ndr, "top_level_name", &r->top_level_name);
		break;

		case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX:
			ndr_print_lsa_StringLarge(ndr, "top_level_name_ex", &r->top_level_name_ex);
		break;

		case LSA_FOREST_TRUST_DOMAIN_INFO:
			ndr_print_lsa_ForestTrustDomainInfo(ndr, "domain_info", &r->domain_info);
		break;

		case LSA_FOREST_TRUST_BINARY_DATA:
			ndr_print_lsa_ForestTrustBinaryData(ndr, "data", &r->data);
		break;

		case LSA_FOREST_TRUST_SCANNER_INFO:
			ndr_print_lsa_ForestTrustDomainInfo(ndr, "scanner_info", &r->scanner_info);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_lsa_ForestTrustRecord2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_ForestTrustRecord2 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_lsa_ForestTrustRecordFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_lsa_ForestTrustRecordType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_NTTIME_hyper(ndr, NDR_SCALARS, r->time));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->forest_trust_data, r->type));
		NDR_CHECK(ndr_push_lsa_ForestTrustData2(ndr, NDR_SCALARS, &r->forest_trust_data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->forest_trust_data, r->type));
		NDR_CHECK(ndr_push_lsa_ForestTrustData2(ndr, NDR_BUFFERS, &r->forest_trust_data));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_ForestTrustRecord2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_ForestTrustRecord2 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_lsa_ForestTrustRecordFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_lsa_ForestTrustRecordType(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_NTTIME_hyper(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->forest_trust_data, r->type));
		NDR_CHECK(ndr_pull_lsa_ForestTrustData2(ndr, NDR_SCALARS, &r->forest_trust_data));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->forest_trust_data, r->type));
		NDR_CHECK(ndr_pull_lsa_ForestTrustData2(ndr, NDR_BUFFERS, &r->forest_trust_data));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_ForestTrustRecord2(struct ndr_print *ndr, const char *name, const struct lsa_ForestTrustRecord2 *r)
{
	ndr_print_struct(ndr, name, "lsa_ForestTrustRecord2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_ForestTrustRecordFlags(ndr, "flags", r->flags);
	ndr_print_lsa_ForestTrustRecordType(ndr, "type", r->type);
	ndr_print_NTTIME_hyper(ndr, "time", r->time);
	ndr_print_set_switch_value(ndr, &r->forest_trust_data, r->type);
	ndr_print_lsa_ForestTrustData2(ndr, "forest_trust_data", &r->forest_trust_data);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_ForestTrustInformation2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_ForestTrustInformation2 *r)
{
	uint32_t cntr_entries_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->entries));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_entries_1 = 0; cntr_entries_1 < (r->count); cntr_entries_1++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < (r->count); cntr_entries_1++) {
				if (r->entries[cntr_entries_1]) {
					NDR_CHECK(ndr_push_lsa_ForestTrustRecord2(ndr, NDR_SCALARS|NDR_BUFFERS, r->entries[cntr_entries_1]));
				}
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_ForestTrustInformation2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_ForestTrustInformation2 *r)
{
	uint32_t _ptr_entries;
	uint32_t size_entries_1 = 0;
	uint32_t cntr_entries_1;
	TALLOC_CTX *_mem_save_entries_0 = NULL;
	TALLOC_CTX *_mem_save_entries_1 = NULL;
	TALLOC_CTX *_mem_save_entries_2 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 4000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(4000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_entries));
		if (_ptr_entries) {
			NDR_PULL_ALLOC(ndr, r->entries);
		} else {
			r->entries = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			_mem_save_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->entries));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->entries, &size_entries_1));
			NDR_PULL_ALLOC_N(ndr, r->entries, size_entries_1);
			_mem_save_entries_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			for (cntr_entries_1 = 0; cntr_entries_1 < (size_entries_1); cntr_entries_1++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_entries));
				if (_ptr_entries) {
					NDR_PULL_ALLOC(ndr, r->entries[cntr_entries_1]);
				} else {
					r->entries[cntr_entries_1] = NULL;
				}
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < (size_entries_1); cntr_entries_1++) {
				if (r->entries[cntr_entries_1]) {
					_mem_save_entries_2 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->entries[cntr_entries_1], 0);
					NDR_CHECK(ndr_pull_lsa_ForestTrustRecord2(ndr, NDR_SCALARS|NDR_BUFFERS, r->entries[cntr_entries_1]));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_2, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_0, 0);
		}
		if (r->entries) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->entries, r->count));
		}
		for (cntr_entries_1 = 0; cntr_entries_1 < (size_entries_1); cntr_entries_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_ForestTrustInformation2(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_ForestTrustInformation2 *r)
{
	ndr_print_lsa_ForestTrustInformation2(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_ForestTrustInformation2(struct ndr_print *ndr, const char *name, const struct lsa_ForestTrustInformation2 *r)
{
	uint32_t cntr_entries_1;
	ndr_print_struct(ndr, name, "lsa_ForestTrustInformation2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "entries", r->entries);
	ndr->depth++;
	if (r->entries) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "entries", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_entries_1 = 0; cntr_entries_1 < (r->count); cntr_entries_1++) {
			ndr_print_ptr(ndr, "entries", r->entries[cntr_entries_1]);
			ndr->depth++;
			if (r->entries[cntr_entries_1]) {
				ndr_print_lsa_ForestTrustRecord2(ndr, "entries", r->entries[cntr_entries_1]);
			}
			ndr->depth--;
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Close(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Close *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Close(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Close *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		*r->out.handle = *r->in.handle;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Close(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Close *r)
{
	ndr_print_struct(ndr, name, "lsa_Close");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Close");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Close");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_Delete(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Delete *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_Delete(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Delete *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Delete(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Delete *r)
{
	ndr_print_struct(ndr, name, "lsa_Delete");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Delete");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Delete");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_EnumPrivs(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_EnumPrivs *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.resume_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_count));
	}
	if (flags & NDR_OUT) {
		if (r->out.resume_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.privs == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		NDR_CHECK(ndr_push_lsa_PrivArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.privs));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_EnumPrivs(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_EnumPrivs *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_resume_handle_0 = NULL;
	TALLOC_CTX *_mem_save_privs_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_count));
		NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		*r->out.resume_handle = *r->in.resume_handle;
		NDR_PULL_ALLOC(ndr, r->out.privs);
		NDR_ZERO_STRUCTP(r->out.privs);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.resume_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
			NDR_ZERO_STRUCTP(r->in.resume_handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.privs);
		}
		_mem_save_privs_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.privs, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_PrivArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.privs));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privs_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_EnumPrivs(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_EnumPrivs *r)
{
	ndr_print_struct(ndr, name, "lsa_EnumPrivs");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_EnumPrivs");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_count", r->in.max_count);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_EnumPrivs");
		ndr->depth++;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "privs", r->out.privs);
		ndr->depth++;
		ndr_print_lsa_PrivArray(ndr, "privs", r->out.privs);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_QuerySecurity(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_QuerySecurity *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_security_secinfo(ndr, NDR_SCALARS, r->in.sec_info));
	}
	if (flags & NDR_OUT) {
		if (r->out.sdbuf == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.sdbuf));
		if (*r->out.sdbuf) {
			NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sdbuf));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_QuerySecurity(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_QuerySecurity *r)
{
	uint32_t _ptr_sdbuf;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_sdbuf_0 = NULL;
	TALLOC_CTX *_mem_save_sdbuf_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_security_secinfo(ndr, NDR_SCALARS, &r->in.sec_info));
		NDR_PULL_ALLOC(ndr, r->out.sdbuf);
		NDR_ZERO_STRUCTP(r->out.sdbuf);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sdbuf);
		}
		_mem_save_sdbuf_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sdbuf, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sdbuf));
		if (_ptr_sdbuf) {
			NDR_PULL_ALLOC(ndr, *r->out.sdbuf);
		} else {
			*r->out.sdbuf = NULL;
		}
		if (*r->out.sdbuf) {
			_mem_save_sdbuf_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.sdbuf, 0);
			NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sdbuf));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sdbuf_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sdbuf_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_QuerySecurity(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_QuerySecurity *r)
{
	ndr_print_struct(ndr, name, "lsa_QuerySecurity");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_QuerySecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_security_secinfo(ndr, "sec_info", r->in.sec_info);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_QuerySecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "sdbuf", r->out.sdbuf);
		ndr->depth++;
		ndr_print_ptr(ndr, "sdbuf", *r->out.sdbuf);
		ndr->depth++;
		if (*r->out.sdbuf) {
			ndr_print_sec_desc_buf(ndr, "sdbuf", *r->out.sdbuf);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_SetSecObj(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_SetSecObj *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.sdbuf == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_security_secinfo(ndr, NDR_SCALARS, r->in.sec_info));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sdbuf));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_SetSecObj(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_SetSecObj *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_sdbuf_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_security_secinfo(ndr, NDR_SCALARS, &r->in.sec_info));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sdbuf);
		}
		_mem_save_sdbuf_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sdbuf, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sdbuf));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sdbuf_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.sdbuf == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sdbuf);
			NDR_ZERO_STRUCTP(r->in.sdbuf);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_SetSecObj(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_SetSecObj *r)
{
	ndr_print_struct(ndr, name, "lsa_SetSecObj");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetSecObj");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_security_secinfo(ndr, "sec_info", r->in.sec_info);
		ndr_print_ptr(ndr, "sdbuf", r->in.sdbuf);
		ndr->depth++;
		ndr_print_sec_desc_buf(ndr, "sdbuf", r->in.sdbuf);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetSecObj");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_ChangePassword(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_ChangePassword *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_ChangePassword(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_ChangePassword *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_ChangePassword(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_ChangePassword *r)
{
	ndr_print_struct(ndr, name, "lsa_ChangePassword");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_ChangePassword");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_ChangePassword");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_OpenPolicy(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_OpenPolicy *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.attr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.system_name));
		}
		NDR_CHECK(ndr_push_lsa_ObjectAttribute(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.attr));
		NDR_CHECK(ndr_push_lsa_PolicyAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_OpenPolicy(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_OpenPolicy *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0 = NULL;
	TALLOC_CTX *_mem_save_attr_0 = NULL;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.system_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.attr);
		}
		_mem_save_attr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.attr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_ObjectAttribute(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.attr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_PolicyAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		NDR_ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.attr == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.attr);
			NDR_ZERO_STRUCTP(r->in.attr);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_OpenPolicy(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_OpenPolicy *r)
{
	ndr_print_struct(ndr, name, "lsa_OpenPolicy");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_OpenPolicy");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_uint16(ndr, "system_name", *r->in.system_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "attr", r->in.attr);
		ndr->depth++;
		ndr_print_lsa_ObjectAttribute(ndr, "attr", r->in.attr);
		ndr->depth--;
		ndr_print_lsa_PolicyAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_OpenPolicy");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_QueryInfoPolicy(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_QueryInfoPolicy *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_PolicyInfo(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_push_lsa_PolicyInformation(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_QueryInfoPolicy(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_QueryInfoPolicy *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	TALLOC_CTX *_mem_save_info_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_PolicyInfo(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		NDR_ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_lsa_PolicyInformation(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_QueryInfoPolicy(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_QueryInfoPolicy *r)
{
	ndr_print_struct(ndr, name, "lsa_QueryInfoPolicy");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_QueryInfoPolicy");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_lsa_PolicyInfo(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_QueryInfoPolicy");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_set_switch_value(ndr, *r->out.info, r->in.level);
			ndr_print_lsa_PolicyInformation(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_SetInfoPolicy(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_SetInfoPolicy *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_PolicyInfo(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_push_lsa_PolicyInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_SetInfoPolicy(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_SetInfoPolicy *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_PolicyInfo(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_lsa_PolicyInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.info == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.info);
			NDR_ZERO_STRUCTP(r->in.info);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_SetInfoPolicy(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_SetInfoPolicy *r)
{
	ndr_print_struct(ndr, name, "lsa_SetInfoPolicy");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetInfoPolicy");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_lsa_PolicyInfo(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
		ndr_print_lsa_PolicyInformation(ndr, "info", r->in.info);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetInfoPolicy");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_ClearAuditLog(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_ClearAuditLog *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_ClearAuditLog(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_ClearAuditLog *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_ClearAuditLog(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_ClearAuditLog *r)
{
	ndr_print_struct(ndr, name, "lsa_ClearAuditLog");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_ClearAuditLog");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_ClearAuditLog");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_CreateAccount(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CreateAccount *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_CHECK(ndr_push_lsa_AccountAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.acct_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.acct_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_CreateAccount(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CreateAccount *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	TALLOC_CTX *_mem_save_acct_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_AccountAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.acct_handle);
		NDR_ZERO_STRUCTP(r->out.acct_handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
			NDR_ZERO_STRUCTP(r->in.sid);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.acct_handle);
		}
		_mem_save_acct_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.acct_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.acct_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_acct_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CreateAccount(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CreateAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_CreateAccount");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CreateAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr_print_lsa_AccountAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CreateAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "acct_handle", r->out.acct_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "acct_handle", r->out.acct_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_EnumAccounts(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_EnumAccounts *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.resume_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_entries));
	}
	if (flags & NDR_OUT) {
		if (r->out.resume_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_EnumAccounts(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_EnumAccounts *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_resume_handle_0 = NULL;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_entries));
		if (r->in.num_entries > 8192) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.num_entries), (uint32_t)(0), (uint32_t)(8192));
		}
		NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		*r->out.resume_handle = *r->in.resume_handle;
		NDR_PULL_ALLOC(ndr, r->out.sids);
		NDR_ZERO_STRUCTP(r->out.sids);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.resume_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
			NDR_ZERO_STRUCTP(r->in.resume_handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_EnumAccounts(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_EnumAccounts *r)
{
	ndr_print_struct(ndr, name, "lsa_EnumAccounts");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_EnumAccounts");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "num_entries", r->in.num_entries);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_EnumAccounts");
		ndr->depth++;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->out.sids);
		ndr->depth++;
		ndr_print_lsa_SidArray(ndr, "sids", r->out.sids);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_CreateTrustedDomain(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CreateTrustedDomain *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.policy_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.policy_handle));
		NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_CHECK(ndr_push_lsa_TrustedAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.trustdom_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.trustdom_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_CreateTrustedDomain(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CreateTrustedDomain *r)
{
	TALLOC_CTX *_mem_save_policy_handle_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	TALLOC_CTX *_mem_save_trustdom_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.policy_handle);
		}
		_mem_save_policy_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.policy_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.policy_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_policy_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustedAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		NDR_ZERO_STRUCTP(r->out.trustdom_handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.policy_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.policy_handle);
			NDR_ZERO_STRUCTP(r->in.policy_handle);
		}
		if (r->in.info == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.info);
			NDR_ZERO_STRUCTP(r->in.info);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		}
		_mem_save_trustdom_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.trustdom_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.trustdom_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trustdom_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CreateTrustedDomain(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CreateTrustedDomain *r)
{
	ndr_print_struct(ndr, name, "lsa_CreateTrustedDomain");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CreateTrustedDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "policy_handle", r->in.policy_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "policy_handle", r->in.policy_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_lsa_DomainInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr_print_lsa_TrustedAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CreateTrustedDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_EnumTrustDom(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_EnumTrustDom *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.resume_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.resume_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.domains == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		NDR_CHECK(ndr_push_lsa_DomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_EnumTrustDom(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_EnumTrustDom *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_resume_handle_0 = NULL;
	TALLOC_CTX *_mem_save_domains_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_size));
		NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		*r->out.resume_handle = *r->in.resume_handle;
		NDR_PULL_ALLOC(ndr, r->out.domains);
		NDR_ZERO_STRUCTP(r->out.domains);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.resume_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
			NDR_ZERO_STRUCTP(r->in.resume_handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		}
		_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_DomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_EnumTrustDom(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_EnumTrustDom *r)
{
	ndr_print_struct(ndr, name, "lsa_EnumTrustDom");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_EnumTrustDom");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_size", r->in.max_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_EnumTrustDom");
		ndr->depth++;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		ndr_print_lsa_DomainList(ndr, "domains", r->out.domains);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_LookupNames(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LookupNames *r)
{
	uint32_t cntr_names_0;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_names));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.num_names));
		for (cntr_names_0 = 0; cntr_names_0 < (r->in.num_names); cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < (r->in.num_names); cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		NDR_CHECK(ndr_push_lsa_TransSidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_CHECK(ndr_push_lsa_LookupNamesLevel(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.count));
	}
	if (flags & NDR_OUT) {
		if (r->out.domains == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.domains));
		if (*r->out.domains) {
			NDR_CHECK(ndr_push_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.domains));
		}
		NDR_CHECK(ndr_push_lsa_TransSidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_LookupNames(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LookupNames *r)
{
	uint32_t size_names_0 = 0;
	uint32_t cntr_names_0;
	uint32_t _ptr_domains;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_names_0 = NULL;
	TALLOC_CTX *_mem_save_domains_0 = NULL;
	TALLOC_CTX *_mem_save_domains_1 = NULL;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	TALLOC_CTX *_mem_save_count_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_names));
		if (r->in.num_names > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.num_names), (uint32_t)(0), (uint32_t)(1000));
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.names));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.names, &size_names_0));
		NDR_PULL_ALLOC_N(ndr, r->in.names, size_names_0);
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.names, 0);
		for (cntr_names_0 = 0; cntr_names_0 < (size_names_0); cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < (size_names_0); cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransSidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_LookupNamesLevel(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.domains);
		NDR_ZERO_STRUCTP(r->out.domains);
		NDR_PULL_ALLOC(ndr, r->out.sids);
		*r->out.sids = *r->in.sids;
		NDR_PULL_ALLOC(ndr, r->out.count);
		*r->out.count = *r->in.count;
		if (r->in.names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.names, r->in.num_names));
		}
		for (cntr_names_0 = 0; cntr_names_0 < (size_names_0); cntr_names_0++) {
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.sids == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
			NDR_ZERO_STRUCTP(r->in.sids);
		}
		if (r->in.count == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.count);
			NDR_ZERO_STRUCTP(r->in.count);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		}
		_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, *r->out.domains);
		} else {
			*r->out.domains = NULL;
		}
		if (*r->out.domains) {
			_mem_save_domains_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.domains, 0);
			NDR_CHECK(ndr_pull_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.domains));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransSidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LookupNames(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LookupNames *r)
{
	uint32_t cntr_names_0;
	ndr_print_struct(ndr, name, "lsa_LookupNames");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupNames");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "num_names", r->in.num_names);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "names", (uint32_t)(r->in.num_names));
		ndr->depth++;
		for (cntr_names_0 = 0; cntr_names_0 < (r->in.num_names); cntr_names_0++) {
			ndr_print_lsa_String(ndr, "names", &r->in.names[cntr_names_0]);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_TransSidArray(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr_print_lsa_LookupNamesLevel(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "count", r->in.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->in.count);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupNames");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", *r->out.domains);
		ndr->depth++;
		if (*r->out.domains) {
			ndr_print_lsa_RefDomainList(ndr, "domains", *r->out.domains);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->out.sids);
		ndr->depth++;
		ndr_print_lsa_TransSidArray(ndr, "sids", r->out.sids);
		ndr->depth--;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_LookupSids(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LookupSids *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_CHECK(ndr_push_lsa_TransNameArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.names));
		NDR_CHECK(ndr_push_lsa_LookupNamesLevel(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.count));
	}
	if (flags & NDR_OUT) {
		if (r->out.domains == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.domains));
		if (*r->out.domains) {
			NDR_CHECK(ndr_push_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.domains));
		}
		NDR_CHECK(ndr_push_lsa_TransNameArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_LookupSids(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LookupSids *r)
{
	uint32_t _ptr_domains;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	TALLOC_CTX *_mem_save_domains_0 = NULL;
	TALLOC_CTX *_mem_save_domains_1 = NULL;
	TALLOC_CTX *_mem_save_names_0 = NULL;
	TALLOC_CTX *_mem_save_count_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransNameArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_LookupNamesLevel(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.domains);
		NDR_ZERO_STRUCTP(r->out.domains);
		NDR_PULL_ALLOC(ndr, r->out.names);
		*r->out.names = *r->in.names;
		NDR_PULL_ALLOC(ndr, r->out.count);
		*r->out.count = *r->in.count;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.sids == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
			NDR_ZERO_STRUCTP(r->in.sids);
		}
		if (r->in.names == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.names);
			NDR_ZERO_STRUCTP(r->in.names);
		}
		if (r->in.count == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.count);
			NDR_ZERO_STRUCTP(r->in.count);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		}
		_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, *r->out.domains);
		} else {
			*r->out.domains = NULL;
		}
		if (*r->out.domains) {
			_mem_save_domains_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.domains, 0);
			NDR_CHECK(ndr_pull_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.domains));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransNameArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LookupSids(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LookupSids *r)
{
	ndr_print_struct(ndr, name, "lsa_LookupSids");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupSids");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_SidArray(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr_print_ptr(ndr, "names", r->in.names);
		ndr->depth++;
		ndr_print_lsa_TransNameArray(ndr, "names", r->in.names);
		ndr->depth--;
		ndr_print_lsa_LookupNamesLevel(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "count", r->in.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->in.count);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupSids");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", *r->out.domains);
		ndr->depth++;
		if (*r->out.domains) {
			ndr_print_lsa_RefDomainList(ndr, "domains", *r->out.domains);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "names", r->out.names);
		ndr->depth++;
		ndr_print_lsa_TransNameArray(ndr, "names", r->out.names);
		ndr->depth--;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_CreateSecret(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CreateSecret *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_push_lsa_SecretAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.sec_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.sec_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_CreateSecret(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CreateSecret *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_sec_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_pull_lsa_SecretAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.sec_handle);
		NDR_ZERO_STRUCTP(r->out.sec_handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sec_handle);
		}
		_mem_save_sec_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sec_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.sec_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sec_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CreateSecret(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CreateSecret *r)
{
	ndr_print_struct(ndr, name, "lsa_CreateSecret");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CreateSecret");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_lsa_String(ndr, "name", &r->in.name);
		ndr_print_lsa_SecretAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CreateSecret");
		ndr->depth++;
		ndr_print_ptr(ndr, "sec_handle", r->out.sec_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "sec_handle", r->out.sec_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_OpenAccount(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_OpenAccount *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_CHECK(ndr_push_lsa_AccountAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.acct_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.acct_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_OpenAccount(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_OpenAccount *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	TALLOC_CTX *_mem_save_acct_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_AccountAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.acct_handle);
		NDR_ZERO_STRUCTP(r->out.acct_handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
			NDR_ZERO_STRUCTP(r->in.sid);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.acct_handle);
		}
		_mem_save_acct_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.acct_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.acct_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_acct_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_OpenAccount(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_OpenAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_OpenAccount");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_OpenAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr_print_lsa_AccountAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_OpenAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "acct_handle", r->out.acct_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "acct_handle", r->out.acct_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_EnumPrivsAccount(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_EnumPrivsAccount *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.privs == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.privs));
		if (*r->out.privs) {
			NDR_CHECK(ndr_push_lsa_PrivilegeSet(ndr, NDR_SCALARS, *r->out.privs));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_EnumPrivsAccount(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_EnumPrivsAccount *r)
{
	uint32_t _ptr_privs;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_privs_0 = NULL;
	TALLOC_CTX *_mem_save_privs_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.privs);
		NDR_ZERO_STRUCTP(r->out.privs);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.privs);
		}
		_mem_save_privs_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.privs, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_privs));
		if (_ptr_privs) {
			NDR_PULL_ALLOC(ndr, *r->out.privs);
		} else {
			*r->out.privs = NULL;
		}
		if (*r->out.privs) {
			_mem_save_privs_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.privs, 0);
			NDR_CHECK(ndr_pull_lsa_PrivilegeSet(ndr, NDR_SCALARS, *r->out.privs));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privs_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privs_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_EnumPrivsAccount(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_EnumPrivsAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_EnumPrivsAccount");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_EnumPrivsAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_EnumPrivsAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "privs", r->out.privs);
		ndr->depth++;
		ndr_print_ptr(ndr, "privs", *r->out.privs);
		ndr->depth++;
		if (*r->out.privs) {
			ndr_print_lsa_PrivilegeSet(ndr, "privs", *r->out.privs);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_AddPrivilegesToAccount(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_AddPrivilegesToAccount *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.privs == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_PrivilegeSet(ndr, NDR_SCALARS, r->in.privs));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_AddPrivilegesToAccount(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_AddPrivilegesToAccount *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_privs_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.privs);
		}
		_mem_save_privs_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.privs, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_PrivilegeSet(ndr, NDR_SCALARS, r->in.privs));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privs_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.privs == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.privs);
			NDR_ZERO_STRUCTP(r->in.privs);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_AddPrivilegesToAccount(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_AddPrivilegesToAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_AddPrivilegesToAccount");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_AddPrivilegesToAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "privs", r->in.privs);
		ndr->depth++;
		ndr_print_lsa_PrivilegeSet(ndr, "privs", r->in.privs);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_AddPrivilegesToAccount");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_RemovePrivilegesFromAccount(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_RemovePrivilegesFromAccount *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.remove_all));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.privs));
		if (r->in.privs) {
			NDR_CHECK(ndr_push_lsa_PrivilegeSet(ndr, NDR_SCALARS, r->in.privs));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_RemovePrivilegesFromAccount(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_RemovePrivilegesFromAccount *r)
{
	uint32_t _ptr_privs;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_privs_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.remove_all));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_privs));
		if (_ptr_privs) {
			NDR_PULL_ALLOC(ndr, r->in.privs);
		} else {
			r->in.privs = NULL;
		}
		if (r->in.privs) {
			_mem_save_privs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.privs, 0);
			NDR_CHECK(ndr_pull_lsa_PrivilegeSet(ndr, NDR_SCALARS, r->in.privs));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privs_0, 0);
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_RemovePrivilegesFromAccount(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_RemovePrivilegesFromAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_RemovePrivilegesFromAccount");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_RemovePrivilegesFromAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint8(ndr, "remove_all", r->in.remove_all);
		ndr_print_ptr(ndr, "privs", r->in.privs);
		ndr->depth++;
		if (r->in.privs) {
			ndr_print_lsa_PrivilegeSet(ndr, "privs", r->in.privs);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_RemovePrivilegesFromAccount");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_GetQuotasForAccount(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_GetQuotasForAccount *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_GetQuotasForAccount(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_GetQuotasForAccount *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_GetQuotasForAccount(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_GetQuotasForAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_GetQuotasForAccount");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_GetQuotasForAccount");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_GetQuotasForAccount");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_SetQuotasForAccount(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_SetQuotasForAccount *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_SetQuotasForAccount(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_SetQuotasForAccount *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_SetQuotasForAccount(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_SetQuotasForAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_SetQuotasForAccount");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetQuotasForAccount");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetQuotasForAccount");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_GetSystemAccessAccount(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_GetSystemAccessAccount *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.access_mask == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_AccountAccessMask(ndr, NDR_SCALARS, *r->out.access_mask));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_GetSystemAccessAccount(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_GetSystemAccessAccount *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_access_mask_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.access_mask);
		NDR_ZERO_STRUCTP(r->out.access_mask);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.access_mask);
		}
		_mem_save_access_mask_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.access_mask, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_AccountAccessMask(ndr, NDR_SCALARS, r->out.access_mask));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_access_mask_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_GetSystemAccessAccount(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_GetSystemAccessAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_GetSystemAccessAccount");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_GetSystemAccessAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_GetSystemAccessAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "access_mask", r->out.access_mask);
		ndr->depth++;
		ndr_print_lsa_AccountAccessMask(ndr, "access_mask", *r->out.access_mask);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_SetSystemAccessAccount(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_SetSystemAccessAccount *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_AccountAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_SetSystemAccessAccount(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_SetSystemAccessAccount *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_AccountAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_SetSystemAccessAccount(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_SetSystemAccessAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_SetSystemAccessAccount");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetSystemAccessAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_lsa_AccountAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetSystemAccessAccount");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_OpenTrustedDomain(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_OpenTrustedDomain *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_CHECK(ndr_push_lsa_TrustedAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.trustdom_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.trustdom_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_OpenTrustedDomain(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_OpenTrustedDomain *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	TALLOC_CTX *_mem_save_trustdom_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustedAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		NDR_ZERO_STRUCTP(r->out.trustdom_handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
			NDR_ZERO_STRUCTP(r->in.sid);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		}
		_mem_save_trustdom_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.trustdom_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.trustdom_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trustdom_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_OpenTrustedDomain(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_OpenTrustedDomain *r)
{
	ndr_print_struct(ndr, name, "lsa_OpenTrustedDomain");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_OpenTrustedDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr_print_lsa_TrustedAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_OpenTrustedDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_QueryTrustedDomainInfo(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_QueryTrustedDomainInfo *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.trustdom_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.trustdom_handle));
		NDR_CHECK(ndr_push_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_push_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_QueryTrustedDomainInfo(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_QueryTrustedDomainInfo *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_trustdom_handle_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	TALLOC_CTX *_mem_save_info_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.trustdom_handle);
		}
		_mem_save_trustdom_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.trustdom_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.trustdom_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trustdom_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		NDR_ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.trustdom_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.trustdom_handle);
			NDR_ZERO_STRUCTP(r->in.trustdom_handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_QueryTrustedDomainInfo(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_QueryTrustedDomainInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_QueryTrustedDomainInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_QueryTrustedDomainInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "trustdom_handle", r->in.trustdom_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "trustdom_handle", r->in.trustdom_handle);
		ndr->depth--;
		ndr_print_lsa_TrustDomInfoEnum(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_QueryTrustedDomainInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_set_switch_value(ndr, *r->out.info, r->in.level);
			ndr_print_lsa_TrustedDomainInfo(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_SetInformationTrustedDomain(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_SetInformationTrustedDomain *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.trustdom_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.trustdom_handle));
		NDR_CHECK(ndr_push_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_push_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_SetInformationTrustedDomain(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_SetInformationTrustedDomain *r)
{
	TALLOC_CTX *_mem_save_trustdom_handle_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.trustdom_handle);
		}
		_mem_save_trustdom_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.trustdom_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.trustdom_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trustdom_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.trustdom_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.trustdom_handle);
			NDR_ZERO_STRUCTP(r->in.trustdom_handle);
		}
		if (r->in.info == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.info);
			NDR_ZERO_STRUCTP(r->in.info);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_SetInformationTrustedDomain(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_SetInformationTrustedDomain *r)
{
	ndr_print_struct(ndr, name, "lsa_SetInformationTrustedDomain");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetInformationTrustedDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "trustdom_handle", r->in.trustdom_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "trustdom_handle", r->in.trustdom_handle);
		ndr->depth--;
		ndr_print_lsa_TrustDomInfoEnum(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
		ndr_print_lsa_TrustedDomainInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetInformationTrustedDomain");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_OpenSecret(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_OpenSecret *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_push_lsa_SecretAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.sec_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.sec_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_OpenSecret(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_OpenSecret *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_sec_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_pull_lsa_SecretAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.sec_handle);
		NDR_ZERO_STRUCTP(r->out.sec_handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sec_handle);
		}
		_mem_save_sec_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sec_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.sec_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sec_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_OpenSecret(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_OpenSecret *r)
{
	ndr_print_struct(ndr, name, "lsa_OpenSecret");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_OpenSecret");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_lsa_String(ndr, "name", &r->in.name);
		ndr_print_lsa_SecretAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_OpenSecret");
		ndr->depth++;
		ndr_print_ptr(ndr, "sec_handle", r->out.sec_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "sec_handle", r->out.sec_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_SetSecret(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_SetSecret *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.sec_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.sec_handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.new_val));
		if (r->in.new_val) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.new_val));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.old_val));
		if (r->in.old_val) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.old_val));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_SetSecret(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_SetSecret *r)
{
	uint32_t _ptr_new_val;
	uint32_t _ptr_old_val;
	TALLOC_CTX *_mem_save_sec_handle_0 = NULL;
	TALLOC_CTX *_mem_save_new_val_0 = NULL;
	TALLOC_CTX *_mem_save_old_val_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sec_handle);
		}
		_mem_save_sec_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sec_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.sec_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sec_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_new_val));
		if (_ptr_new_val) {
			NDR_PULL_ALLOC(ndr, r->in.new_val);
		} else {
			r->in.new_val = NULL;
		}
		if (r->in.new_val) {
			_mem_save_new_val_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.new_val, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.new_val));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_new_val_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_old_val));
		if (_ptr_old_val) {
			NDR_PULL_ALLOC(ndr, r->in.old_val);
		} else {
			r->in.old_val = NULL;
		}
		if (r->in.old_val) {
			_mem_save_old_val_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.old_val, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.old_val));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_old_val_0, 0);
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.sec_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sec_handle);
			NDR_ZERO_STRUCTP(r->in.sec_handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_SetSecret(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_SetSecret *r)
{
	ndr_print_struct(ndr, name, "lsa_SetSecret");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetSecret");
		ndr->depth++;
		ndr_print_ptr(ndr, "sec_handle", r->in.sec_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "sec_handle", r->in.sec_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "new_val", r->in.new_val);
		ndr->depth++;
		if (r->in.new_val) {
			ndr_print_lsa_DATA_BUF(ndr, "new_val", r->in.new_val);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "old_val", r->in.old_val);
		ndr->depth++;
		if (r->in.old_val) {
			ndr_print_lsa_DATA_BUF(ndr, "old_val", r->in.old_val);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetSecret");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_QuerySecret(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_QuerySecret *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.sec_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.sec_handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.new_val));
		if (r->in.new_val) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF_PTR(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.new_val));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.new_mtime));
		if (r->in.new_mtime) {
			NDR_CHECK(ndr_push_NTTIME_hyper(ndr, NDR_SCALARS, *r->in.new_mtime));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.old_val));
		if (r->in.old_val) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF_PTR(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.old_val));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.old_mtime));
		if (r->in.old_mtime) {
			NDR_CHECK(ndr_push_NTTIME_hyper(ndr, NDR_SCALARS, *r->in.old_mtime));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.new_val));
		if (r->out.new_val) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF_PTR(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.new_val));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.new_mtime));
		if (r->out.new_mtime) {
			NDR_CHECK(ndr_push_NTTIME_hyper(ndr, NDR_SCALARS, *r->out.new_mtime));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.old_val));
		if (r->out.old_val) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF_PTR(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.old_val));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.old_mtime));
		if (r->out.old_mtime) {
			NDR_CHECK(ndr_push_NTTIME_hyper(ndr, NDR_SCALARS, *r->out.old_mtime));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_QuerySecret(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_QuerySecret *r)
{
	uint32_t _ptr_new_val;
	uint32_t _ptr_new_mtime;
	uint32_t _ptr_old_val;
	uint32_t _ptr_old_mtime;
	TALLOC_CTX *_mem_save_sec_handle_0 = NULL;
	TALLOC_CTX *_mem_save_new_val_0 = NULL;
	TALLOC_CTX *_mem_save_new_mtime_0 = NULL;
	TALLOC_CTX *_mem_save_old_val_0 = NULL;
	TALLOC_CTX *_mem_save_old_mtime_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sec_handle);
		}
		_mem_save_sec_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sec_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.sec_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sec_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_new_val));
		if (_ptr_new_val) {
			NDR_PULL_ALLOC(ndr, r->in.new_val);
		} else {
			r->in.new_val = NULL;
		}
		if (r->in.new_val) {
			_mem_save_new_val_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.new_val, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF_PTR(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.new_val));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_new_val_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_new_mtime));
		if (_ptr_new_mtime) {
			NDR_PULL_ALLOC(ndr, r->in.new_mtime);
		} else {
			r->in.new_mtime = NULL;
		}
		if (r->in.new_mtime) {
			_mem_save_new_mtime_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.new_mtime, 0);
			NDR_CHECK(ndr_pull_NTTIME_hyper(ndr, NDR_SCALARS, r->in.new_mtime));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_new_mtime_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_old_val));
		if (_ptr_old_val) {
			NDR_PULL_ALLOC(ndr, r->in.old_val);
		} else {
			r->in.old_val = NULL;
		}
		if (r->in.old_val) {
			_mem_save_old_val_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.old_val, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF_PTR(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.old_val));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_old_val_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_old_mtime));
		if (_ptr_old_mtime) {
			NDR_PULL_ALLOC(ndr, r->in.old_mtime);
		} else {
			r->in.old_mtime = NULL;
		}
		if (r->in.old_mtime) {
			_mem_save_old_mtime_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.old_mtime, 0);
			NDR_CHECK(ndr_pull_NTTIME_hyper(ndr, NDR_SCALARS, r->in.old_mtime));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_old_mtime_0, 0);
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.sec_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sec_handle);
			NDR_ZERO_STRUCTP(r->in.sec_handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_new_val));
		if (_ptr_new_val) {
			NDR_PULL_ALLOC(ndr, r->out.new_val);
		} else {
			r->out.new_val = NULL;
		}
		if (r->out.new_val) {
			_mem_save_new_val_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.new_val, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF_PTR(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.new_val));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_new_val_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_new_mtime));
		if (_ptr_new_mtime) {
			NDR_PULL_ALLOC(ndr, r->out.new_mtime);
		} else {
			r->out.new_mtime = NULL;
		}
		if (r->out.new_mtime) {
			_mem_save_new_mtime_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.new_mtime, 0);
			NDR_CHECK(ndr_pull_NTTIME_hyper(ndr, NDR_SCALARS, r->out.new_mtime));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_new_mtime_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_old_val));
		if (_ptr_old_val) {
			NDR_PULL_ALLOC(ndr, r->out.old_val);
		} else {
			r->out.old_val = NULL;
		}
		if (r->out.old_val) {
			_mem_save_old_val_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.old_val, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF_PTR(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.old_val));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_old_val_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_old_mtime));
		if (_ptr_old_mtime) {
			NDR_PULL_ALLOC(ndr, r->out.old_mtime);
		} else {
			r->out.old_mtime = NULL;
		}
		if (r->out.old_mtime) {
			_mem_save_old_mtime_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.old_mtime, 0);
			NDR_CHECK(ndr_pull_NTTIME_hyper(ndr, NDR_SCALARS, r->out.old_mtime));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_old_mtime_0, 0);
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_QuerySecret(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_QuerySecret *r)
{
	ndr_print_struct(ndr, name, "lsa_QuerySecret");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_QuerySecret");
		ndr->depth++;
		ndr_print_ptr(ndr, "sec_handle", r->in.sec_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "sec_handle", r->in.sec_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "new_val", r->in.new_val);
		ndr->depth++;
		if (r->in.new_val) {
			ndr_print_lsa_DATA_BUF_PTR(ndr, "new_val", r->in.new_val);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "new_mtime", r->in.new_mtime);
		ndr->depth++;
		if (r->in.new_mtime) {
			ndr_print_NTTIME_hyper(ndr, "new_mtime", *r->in.new_mtime);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "old_val", r->in.old_val);
		ndr->depth++;
		if (r->in.old_val) {
			ndr_print_lsa_DATA_BUF_PTR(ndr, "old_val", r->in.old_val);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "old_mtime", r->in.old_mtime);
		ndr->depth++;
		if (r->in.old_mtime) {
			ndr_print_NTTIME_hyper(ndr, "old_mtime", *r->in.old_mtime);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_QuerySecret");
		ndr->depth++;
		ndr_print_ptr(ndr, "new_val", r->out.new_val);
		ndr->depth++;
		if (r->out.new_val) {
			ndr_print_lsa_DATA_BUF_PTR(ndr, "new_val", r->out.new_val);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "new_mtime", r->out.new_mtime);
		ndr->depth++;
		if (r->out.new_mtime) {
			ndr_print_NTTIME_hyper(ndr, "new_mtime", *r->out.new_mtime);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "old_val", r->out.old_val);
		ndr->depth++;
		if (r->out.old_val) {
			ndr_print_lsa_DATA_BUF_PTR(ndr, "old_val", r->out.old_val);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "old_mtime", r->out.old_mtime);
		ndr->depth++;
		if (r->out.old_mtime) {
			ndr_print_NTTIME_hyper(ndr, "old_mtime", *r->out.old_mtime);
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_LookupPrivValue(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LookupPrivValue *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
	}
	if (flags & NDR_OUT) {
		if (r->out.luid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_LUID(ndr, NDR_SCALARS, r->out.luid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_LookupPrivValue(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LookupPrivValue *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_name_0 = NULL;
	TALLOC_CTX *_mem_save_luid_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.luid);
		NDR_ZERO_STRUCTP(r->out.luid);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.name == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.name);
			NDR_ZERO_STRUCTP(r->in.name);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.luid);
		}
		_mem_save_luid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.luid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_LUID(ndr, NDR_SCALARS, r->out.luid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_luid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LookupPrivValue(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LookupPrivValue *r)
{
	ndr_print_struct(ndr, name, "lsa_LookupPrivValue");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupPrivValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "name", r->in.name);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupPrivValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "luid", r->out.luid);
		ndr->depth++;
		ndr_print_lsa_LUID(ndr, "luid", r->out.luid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_LookupPrivName(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LookupPrivName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.luid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_LUID(ndr, NDR_SCALARS, r->in.luid));
	}
	if (flags & NDR_OUT) {
		if (r->out.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.name));
		if (*r->out.name) {
			NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.name));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_LookupPrivName(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LookupPrivName *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_luid_0 = NULL;
	TALLOC_CTX *_mem_save_name_0 = NULL;
	TALLOC_CTX *_mem_save_name_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.luid);
		}
		_mem_save_luid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.luid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_LUID(ndr, NDR_SCALARS, r->in.luid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_luid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.name);
		NDR_ZERO_STRUCTP(r->out.name);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.luid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.luid);
			NDR_ZERO_STRUCTP(r->in.luid);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, *r->out.name);
		} else {
			*r->out.name = NULL;
		}
		if (*r->out.name) {
			_mem_save_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.name, 0);
			NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LookupPrivName(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LookupPrivName *r)
{
	ndr_print_struct(ndr, name, "lsa_LookupPrivName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupPrivName");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "luid", r->in.luid);
		ndr->depth++;
		ndr_print_lsa_LUID(ndr, "luid", r->in.luid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupPrivName");
		ndr->depth++;
		ndr_print_ptr(ndr, "name", r->out.name);
		ndr->depth++;
		ndr_print_ptr(ndr, "name", *r->out.name);
		ndr->depth++;
		if (*r->out.name) {
			ndr_print_lsa_StringLarge(ndr, "name", *r->out.name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_LookupPrivDisplayName(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LookupPrivDisplayName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.language_id));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.language_id_sys));
	}
	if (flags & NDR_OUT) {
		if (r->out.disp_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.returned_language_id == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.disp_name));
		if (*r->out.disp_name) {
			NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.disp_name));
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->out.returned_language_id));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_LookupPrivDisplayName(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LookupPrivDisplayName *r)
{
	uint32_t _ptr_disp_name;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_name_0 = NULL;
	TALLOC_CTX *_mem_save_disp_name_0 = NULL;
	TALLOC_CTX *_mem_save_disp_name_1 = NULL;
	TALLOC_CTX *_mem_save_returned_language_id_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.language_id));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.language_id_sys));
		NDR_PULL_ALLOC(ndr, r->out.disp_name);
		NDR_ZERO_STRUCTP(r->out.disp_name);
		NDR_PULL_ALLOC(ndr, r->out.returned_language_id);
		NDR_ZERO_STRUCTP(r->out.returned_language_id);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.name == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.name);
			NDR_ZERO_STRUCTP(r->in.name);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.disp_name);
		}
		_mem_save_disp_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.disp_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_disp_name));
		if (_ptr_disp_name) {
			NDR_PULL_ALLOC(ndr, *r->out.disp_name);
		} else {
			*r->out.disp_name = NULL;
		}
		if (*r->out.disp_name) {
			_mem_save_disp_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.disp_name, 0);
			NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.disp_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_disp_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_disp_name_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.returned_language_id);
		}
		_mem_save_returned_language_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.returned_language_id, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->out.returned_language_id));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_returned_language_id_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LookupPrivDisplayName(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LookupPrivDisplayName *r)
{
	ndr_print_struct(ndr, name, "lsa_LookupPrivDisplayName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupPrivDisplayName");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "name", r->in.name);
		ndr->depth--;
		ndr_print_uint16(ndr, "language_id", r->in.language_id);
		ndr_print_uint16(ndr, "language_id_sys", r->in.language_id_sys);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupPrivDisplayName");
		ndr->depth++;
		ndr_print_ptr(ndr, "disp_name", r->out.disp_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "disp_name", *r->out.disp_name);
		ndr->depth++;
		if (*r->out.disp_name) {
			ndr_print_lsa_StringLarge(ndr, "disp_name", *r->out.disp_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "returned_language_id", r->out.returned_language_id);
		ndr->depth++;
		ndr_print_uint16(ndr, "returned_language_id", *r->out.returned_language_id);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_DeleteObject(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_DeleteObject *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_DeleteObject(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_DeleteObject *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		*r->out.handle = *r->in.handle;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_DeleteObject(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_DeleteObject *r)
{
	ndr_print_struct(ndr, name, "lsa_DeleteObject");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_DeleteObject");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_DeleteObject");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_EnumAccountsWithUserRight(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_EnumAccountsWithUserRight *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.name));
		if (r->in.name) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_EnumAccountsWithUserRight(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_EnumAccountsWithUserRight *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_name_0 = NULL;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->in.name);
		} else {
			r->in.name = NULL;
		}
		if (r->in.name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.name, 0);
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.sids);
		NDR_ZERO_STRUCTP(r->out.sids);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_EnumAccountsWithUserRight(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_EnumAccountsWithUserRight *r)
{
	ndr_print_struct(ndr, name, "lsa_EnumAccountsWithUserRight");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_EnumAccountsWithUserRight");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		if (r->in.name) {
			ndr_print_lsa_String(ndr, "name", r->in.name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_EnumAccountsWithUserRight");
		ndr->depth++;
		ndr_print_ptr(ndr, "sids", r->out.sids);
		ndr->depth++;
		ndr_print_lsa_SidArray(ndr, "sids", r->out.sids);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_EnumAccountRights(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_EnumAccountRights *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
	}
	if (flags & NDR_OUT) {
		if (r->out.rights == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_RightSet(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.rights));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_EnumAccountRights(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_EnumAccountRights *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	TALLOC_CTX *_mem_save_rights_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.rights);
		NDR_ZERO_STRUCTP(r->out.rights);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
			NDR_ZERO_STRUCTP(r->in.sid);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rights);
		}
		_mem_save_rights_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rights, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_RightSet(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.rights));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rights_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_EnumAccountRights(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_EnumAccountRights *r)
{
	ndr_print_struct(ndr, name, "lsa_EnumAccountRights");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_EnumAccountRights");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_EnumAccountRights");
		ndr->depth++;
		ndr_print_ptr(ndr, "rights", r->out.rights);
		ndr->depth++;
		ndr_print_lsa_RightSet(ndr, "rights", r->out.rights);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_AddAccountRights(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_AddAccountRights *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.rights == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_CHECK(ndr_push_lsa_RightSet(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.rights));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_AddAccountRights(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_AddAccountRights *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	TALLOC_CTX *_mem_save_rights_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.rights);
		}
		_mem_save_rights_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.rights, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_RightSet(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.rights));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rights_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
			NDR_ZERO_STRUCTP(r->in.sid);
		}
		if (r->in.rights == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.rights);
			NDR_ZERO_STRUCTP(r->in.rights);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_AddAccountRights(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_AddAccountRights *r)
{
	ndr_print_struct(ndr, name, "lsa_AddAccountRights");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_AddAccountRights");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr_print_ptr(ndr, "rights", r->in.rights);
		ndr->depth++;
		ndr_print_lsa_RightSet(ndr, "rights", r->in.rights);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_AddAccountRights");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_RemoveAccountRights(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_RemoveAccountRights *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.rights == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.remove_all));
		NDR_CHECK(ndr_push_lsa_RightSet(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.rights));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_RemoveAccountRights(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_RemoveAccountRights *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	TALLOC_CTX *_mem_save_rights_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.remove_all));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.rights);
		}
		_mem_save_rights_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.rights, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_RightSet(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.rights));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rights_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
			NDR_ZERO_STRUCTP(r->in.sid);
		}
		if (r->in.rights == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.rights);
			NDR_ZERO_STRUCTP(r->in.rights);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_RemoveAccountRights(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_RemoveAccountRights *r)
{
	ndr_print_struct(ndr, name, "lsa_RemoveAccountRights");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_RemoveAccountRights");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr_print_uint8(ndr, "remove_all", r->in.remove_all);
		ndr_print_ptr(ndr, "rights", r->in.rights);
		ndr->depth++;
		ndr_print_lsa_RightSet(ndr, "rights", r->in.rights);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_RemoveAccountRights");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_QueryTrustedDomainInfoBySid(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_QueryTrustedDomainInfoBySid *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.dom_sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.dom_sid));
		NDR_CHECK(ndr_push_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_push_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_QueryTrustedDomainInfoBySid(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_QueryTrustedDomainInfoBySid *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_dom_sid_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	TALLOC_CTX *_mem_save_info_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.dom_sid);
		}
		_mem_save_dom_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.dom_sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.dom_sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dom_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		NDR_ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.dom_sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.dom_sid);
			NDR_ZERO_STRUCTP(r->in.dom_sid);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_QueryTrustedDomainInfoBySid(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_QueryTrustedDomainInfoBySid *r)
{
	ndr_print_struct(ndr, name, "lsa_QueryTrustedDomainInfoBySid");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_QueryTrustedDomainInfoBySid");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "dom_sid", r->in.dom_sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "dom_sid", r->in.dom_sid);
		ndr->depth--;
		ndr_print_lsa_TrustDomInfoEnum(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_QueryTrustedDomainInfoBySid");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_set_switch_value(ndr, *r->out.info, r->in.level);
			ndr_print_lsa_TrustedDomainInfo(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_SetTrustedDomainInfo(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_SetTrustedDomainInfo *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.dom_sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.dom_sid));
		NDR_CHECK(ndr_push_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_push_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_SetTrustedDomainInfo(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_SetTrustedDomainInfo *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_dom_sid_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.dom_sid);
		}
		_mem_save_dom_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.dom_sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.dom_sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dom_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.dom_sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.dom_sid);
			NDR_ZERO_STRUCTP(r->in.dom_sid);
		}
		if (r->in.info == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.info);
			NDR_ZERO_STRUCTP(r->in.info);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_SetTrustedDomainInfo(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_SetTrustedDomainInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_SetTrustedDomainInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetTrustedDomainInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "dom_sid", r->in.dom_sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "dom_sid", r->in.dom_sid);
		ndr->depth--;
		ndr_print_lsa_TrustDomInfoEnum(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
		ndr_print_lsa_TrustedDomainInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetTrustedDomainInfo");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_DeleteTrustedDomain(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_DeleteTrustedDomain *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.dom_sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.dom_sid));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_DeleteTrustedDomain(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_DeleteTrustedDomain *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_dom_sid_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.dom_sid);
		}
		_mem_save_dom_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.dom_sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.dom_sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dom_sid_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.dom_sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.dom_sid);
			NDR_ZERO_STRUCTP(r->in.dom_sid);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_DeleteTrustedDomain(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_DeleteTrustedDomain *r)
{
	ndr_print_struct(ndr, name, "lsa_DeleteTrustedDomain");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_DeleteTrustedDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "dom_sid", r->in.dom_sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "dom_sid", r->in.dom_sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_DeleteTrustedDomain");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_StorePrivateData(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_StorePrivateData *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.val));
		if (r->in.val) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.val));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_StorePrivateData(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_StorePrivateData *r)
{
	uint32_t _ptr_val;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_name_0 = NULL;
	TALLOC_CTX *_mem_save_val_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_val));
		if (_ptr_val) {
			NDR_PULL_ALLOC(ndr, r->in.val);
		} else {
			r->in.val = NULL;
		}
		if (r->in.val) {
			_mem_save_val_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.val, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.val));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_val_0, 0);
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.name == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.name);
			NDR_ZERO_STRUCTP(r->in.name);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_StorePrivateData(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_StorePrivateData *r)
{
	ndr_print_struct(ndr, name, "lsa_StorePrivateData");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_StorePrivateData");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "name", r->in.name);
		ndr->depth--;
		ndr_print_ptr(ndr, "val", r->in.val);
		ndr->depth++;
		if (r->in.val) {
			ndr_print_lsa_DATA_BUF(ndr, "val", r->in.val);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_StorePrivateData");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_RetrievePrivateData(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_RetrievePrivateData *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.val == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.val));
		if (*r->in.val) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.val));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.val == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.val));
		if (*r->out.val) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.val));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_RetrievePrivateData(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_RetrievePrivateData *r)
{
	uint32_t _ptr_val;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_name_0 = NULL;
	TALLOC_CTX *_mem_save_val_0 = NULL;
	TALLOC_CTX *_mem_save_val_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.val);
		}
		_mem_save_val_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.val, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_val));
		if (_ptr_val) {
			NDR_PULL_ALLOC(ndr, *r->in.val);
		} else {
			*r->in.val = NULL;
		}
		if (*r->in.val) {
			_mem_save_val_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->in.val, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.val));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_val_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_val_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.val);
		*r->out.val = *r->in.val;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.name == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.name);
			NDR_ZERO_STRUCTP(r->in.name);
		}
		if (r->in.val == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.val);
			NDR_ZERO_STRUCTP(r->in.val);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.val);
		}
		_mem_save_val_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.val, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_val));
		if (_ptr_val) {
			NDR_PULL_ALLOC(ndr, *r->out.val);
		} else {
			*r->out.val = NULL;
		}
		if (*r->out.val) {
			_mem_save_val_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.val, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.val));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_val_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_val_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_RetrievePrivateData(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_RetrievePrivateData *r)
{
	ndr_print_struct(ndr, name, "lsa_RetrievePrivateData");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_RetrievePrivateData");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "name", r->in.name);
		ndr->depth--;
		ndr_print_ptr(ndr, "val", r->in.val);
		ndr->depth++;
		ndr_print_ptr(ndr, "val", *r->in.val);
		ndr->depth++;
		if (*r->in.val) {
			ndr_print_lsa_DATA_BUF(ndr, "val", *r->in.val);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_RetrievePrivateData");
		ndr->depth++;
		ndr_print_ptr(ndr, "val", r->out.val);
		ndr->depth++;
		ndr_print_ptr(ndr, "val", *r->out.val);
		ndr->depth++;
		if (*r->out.val) {
			ndr_print_lsa_DATA_BUF(ndr, "val", *r->out.val);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_OpenPolicy2(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_OpenPolicy2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.attr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.system_name, ndr_charset_length(r->in.system_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_lsa_ObjectAttribute(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.attr));
		NDR_CHECK(ndr_push_lsa_PolicyAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_OpenPolicy2(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_OpenPolicy2 *r)
{
	uint32_t _ptr_system_name;
	uint32_t size_system_name_1 = 0;
	uint32_t length_system_name_1 = 0;
	TALLOC_CTX *_mem_save_system_name_0 = NULL;
	TALLOC_CTX *_mem_save_attr_0 = NULL;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.system_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.system_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.system_name, &size_system_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.system_name, &length_system_name_1));
			if (length_system_name_1 > size_system_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_system_name_1, length_system_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_system_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.system_name, length_system_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.attr);
		}
		_mem_save_attr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.attr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_ObjectAttribute(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.attr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_PolicyAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		NDR_ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.attr == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.attr);
			NDR_ZERO_STRUCTP(r->in.attr);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_OpenPolicy2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_OpenPolicy2 *r)
{
	ndr_print_struct(ndr, name, "lsa_OpenPolicy2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_OpenPolicy2");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_string(ndr, "system_name", r->in.system_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "attr", r->in.attr);
		ndr->depth++;
		ndr_print_lsa_ObjectAttribute(ndr, "attr", r->in.attr);
		ndr->depth--;
		ndr_print_lsa_PolicyAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_OpenPolicy2");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_GetUserName(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_GetUserName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.account_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.system_name, ndr_charset_length(r->in.system_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.account_name));
		if (*r->in.account_name) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.account_name));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.authority_name));
		if (r->in.authority_name) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.authority_name));
			if (*r->in.authority_name) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.authority_name));
			}
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.account_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.account_name));
		if (*r->out.account_name) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.account_name));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.authority_name));
		if (r->out.authority_name) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.authority_name));
			if (*r->out.authority_name) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.authority_name));
			}
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_GetUserName(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_GetUserName *r)
{
	uint32_t _ptr_system_name;
	uint32_t size_system_name_1 = 0;
	uint32_t length_system_name_1 = 0;
	uint32_t _ptr_account_name;
	uint32_t _ptr_authority_name;
	TALLOC_CTX *_mem_save_system_name_0 = NULL;
	TALLOC_CTX *_mem_save_account_name_0 = NULL;
	TALLOC_CTX *_mem_save_account_name_1 = NULL;
	TALLOC_CTX *_mem_save_authority_name_0 = NULL;
	TALLOC_CTX *_mem_save_authority_name_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.system_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.system_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.system_name, &size_system_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.system_name, &length_system_name_1));
			if (length_system_name_1 > size_system_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_system_name_1, length_system_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_system_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.system_name, length_system_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.account_name);
		}
		_mem_save_account_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.account_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_account_name));
		if (_ptr_account_name) {
			NDR_PULL_ALLOC(ndr, *r->in.account_name);
		} else {
			*r->in.account_name = NULL;
		}
		if (*r->in.account_name) {
			_mem_save_account_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->in.account_name, 0);
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.account_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_authority_name));
		if (_ptr_authority_name) {
			NDR_PULL_ALLOC(ndr, r->in.authority_name);
		} else {
			r->in.authority_name = NULL;
		}
		if (r->in.authority_name) {
			_mem_save_authority_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.authority_name, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_authority_name));
			if (_ptr_authority_name) {
				NDR_PULL_ALLOC(ndr, *r->in.authority_name);
			} else {
				*r->in.authority_name = NULL;
			}
			if (*r->in.authority_name) {
				_mem_save_authority_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->in.authority_name, 0);
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.authority_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_authority_name_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_authority_name_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.account_name);
		*r->out.account_name = *r->in.account_name;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.account_name == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.account_name);
			NDR_ZERO_STRUCTP(r->in.account_name);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.account_name);
		}
		_mem_save_account_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.account_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_account_name));
		if (_ptr_account_name) {
			NDR_PULL_ALLOC(ndr, *r->out.account_name);
		} else {
			*r->out.account_name = NULL;
		}
		if (*r->out.account_name) {
			_mem_save_account_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.account_name, 0);
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.account_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_authority_name));
		if (_ptr_authority_name) {
			NDR_PULL_ALLOC(ndr, r->out.authority_name);
		} else {
			r->out.authority_name = NULL;
		}
		if (r->out.authority_name) {
			_mem_save_authority_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.authority_name, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_authority_name));
			if (_ptr_authority_name) {
				NDR_PULL_ALLOC(ndr, *r->out.authority_name);
			} else {
				*r->out.authority_name = NULL;
			}
			if (*r->out.authority_name) {
				_mem_save_authority_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->out.authority_name, 0);
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.authority_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_authority_name_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_authority_name_0, 0);
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_GetUserName(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_GetUserName *r)
{
	ndr_print_struct(ndr, name, "lsa_GetUserName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_GetUserName");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_string(ndr, "system_name", r->in.system_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account_name", r->in.account_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "account_name", *r->in.account_name);
		ndr->depth++;
		if (*r->in.account_name) {
			ndr_print_lsa_String(ndr, "account_name", *r->in.account_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "authority_name", r->in.authority_name);
		ndr->depth++;
		if (r->in.authority_name) {
			ndr_print_ptr(ndr, "authority_name", *r->in.authority_name);
			ndr->depth++;
			if (*r->in.authority_name) {
				ndr_print_lsa_String(ndr, "authority_name", *r->in.authority_name);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_GetUserName");
		ndr->depth++;
		ndr_print_ptr(ndr, "account_name", r->out.account_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "account_name", *r->out.account_name);
		ndr->depth++;
		if (*r->out.account_name) {
			ndr_print_lsa_String(ndr, "account_name", *r->out.account_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "authority_name", r->out.authority_name);
		ndr->depth++;
		if (r->out.authority_name) {
			ndr_print_ptr(ndr, "authority_name", *r->out.authority_name);
			ndr->depth++;
			if (*r->out.authority_name) {
				ndr_print_lsa_String(ndr, "authority_name", *r->out.authority_name);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_QueryInfoPolicy2(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_QueryInfoPolicy2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_PolicyInfo(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_push_lsa_PolicyInformation(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_QueryInfoPolicy2(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_QueryInfoPolicy2 *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	TALLOC_CTX *_mem_save_info_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_PolicyInfo(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		NDR_ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_lsa_PolicyInformation(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_QueryInfoPolicy2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_QueryInfoPolicy2 *r)
{
	ndr_print_struct(ndr, name, "lsa_QueryInfoPolicy2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_QueryInfoPolicy2");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_lsa_PolicyInfo(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_QueryInfoPolicy2");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_set_switch_value(ndr, *r->out.info, r->in.level);
			ndr_print_lsa_PolicyInformation(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_SetInfoPolicy2(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_SetInfoPolicy2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_PolicyInfo(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_push_lsa_PolicyInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_SetInfoPolicy2(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_SetInfoPolicy2 *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_PolicyInfo(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_lsa_PolicyInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.info == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.info);
			NDR_ZERO_STRUCTP(r->in.info);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_SetInfoPolicy2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_SetInfoPolicy2 *r)
{
	ndr_print_struct(ndr, name, "lsa_SetInfoPolicy2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetInfoPolicy2");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_lsa_PolicyInfo(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
		ndr_print_lsa_PolicyInformation(ndr, "info", r->in.info);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetInfoPolicy2");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_QueryTrustedDomainInfoByName(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_QueryTrustedDomainInfoByName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.trusted_domain == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.trusted_domain));
		NDR_CHECK(ndr_push_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_push_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_QueryTrustedDomainInfoByName(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_QueryTrustedDomainInfoByName *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_trusted_domain_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	TALLOC_CTX *_mem_save_info_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.trusted_domain);
		}
		_mem_save_trusted_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.trusted_domain, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.trusted_domain));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trusted_domain_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		NDR_ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.trusted_domain == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.trusted_domain);
			NDR_ZERO_STRUCTP(r->in.trusted_domain);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_QueryTrustedDomainInfoByName(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_QueryTrustedDomainInfoByName *r)
{
	ndr_print_struct(ndr, name, "lsa_QueryTrustedDomainInfoByName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_QueryTrustedDomainInfoByName");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "trusted_domain", r->in.trusted_domain);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "trusted_domain", r->in.trusted_domain);
		ndr->depth--;
		ndr_print_lsa_TrustDomInfoEnum(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_QueryTrustedDomainInfoByName");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_set_switch_value(ndr, *r->out.info, r->in.level);
			ndr_print_lsa_TrustedDomainInfo(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_SetTrustedDomainInfoByName(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_SetTrustedDomainInfoByName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.trusted_domain == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.trusted_domain));
		NDR_CHECK(ndr_push_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_push_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_SetTrustedDomainInfoByName(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_SetTrustedDomainInfoByName *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_trusted_domain_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.trusted_domain);
		}
		_mem_save_trusted_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.trusted_domain, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.trusted_domain));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trusted_domain_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.trusted_domain == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.trusted_domain);
			NDR_ZERO_STRUCTP(r->in.trusted_domain);
		}
		if (r->in.info == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.info);
			NDR_ZERO_STRUCTP(r->in.info);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_SetTrustedDomainInfoByName(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_SetTrustedDomainInfoByName *r)
{
	ndr_print_struct(ndr, name, "lsa_SetTrustedDomainInfoByName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetTrustedDomainInfoByName");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "trusted_domain", r->in.trusted_domain);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "trusted_domain", r->in.trusted_domain);
		ndr->depth--;
		ndr_print_lsa_TrustDomInfoEnum(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
		ndr_print_lsa_TrustedDomainInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetTrustedDomainInfoByName");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_EnumTrustedDomainsEx(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_EnumTrustedDomainsEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.resume_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.resume_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.domains == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		NDR_CHECK(ndr_push_lsa_DomainListEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_EnumTrustedDomainsEx(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_EnumTrustedDomainsEx *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_resume_handle_0 = NULL;
	TALLOC_CTX *_mem_save_domains_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_size));
		NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		*r->out.resume_handle = *r->in.resume_handle;
		NDR_PULL_ALLOC(ndr, r->out.domains);
		NDR_ZERO_STRUCTP(r->out.domains);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.resume_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
			NDR_ZERO_STRUCTP(r->in.resume_handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		}
		_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_DomainListEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_EnumTrustedDomainsEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_EnumTrustedDomainsEx *r)
{
	ndr_print_struct(ndr, name, "lsa_EnumTrustedDomainsEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_EnumTrustedDomainsEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_size", r->in.max_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_EnumTrustedDomainsEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		ndr_print_lsa_DomainListEx(ndr, "domains", r->out.domains);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_CreateTrustedDomainEx(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CreateTrustedDomainEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.policy_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.auth_info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.policy_handle));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.auth_info));
		NDR_CHECK(ndr_push_lsa_TrustedAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.trustdom_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.trustdom_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_CreateTrustedDomainEx(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CreateTrustedDomainEx *r)
{
	TALLOC_CTX *_mem_save_policy_handle_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	TALLOC_CTX *_mem_save_auth_info_0 = NULL;
	TALLOC_CTX *_mem_save_trustdom_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.policy_handle);
		}
		_mem_save_policy_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.policy_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.policy_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_policy_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.auth_info);
		}
		_mem_save_auth_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.auth_info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.auth_info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_auth_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustedAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		NDR_ZERO_STRUCTP(r->out.trustdom_handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.policy_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.policy_handle);
			NDR_ZERO_STRUCTP(r->in.policy_handle);
		}
		if (r->in.info == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.info);
			NDR_ZERO_STRUCTP(r->in.info);
		}
		if (r->in.auth_info == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.auth_info);
			NDR_ZERO_STRUCTP(r->in.auth_info);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		}
		_mem_save_trustdom_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.trustdom_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.trustdom_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trustdom_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CreateTrustedDomainEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CreateTrustedDomainEx *r)
{
	ndr_print_struct(ndr, name, "lsa_CreateTrustedDomainEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CreateTrustedDomainEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "policy_handle", r->in.policy_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "policy_handle", r->in.policy_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_lsa_TrustDomainInfoInfoEx(ndr, "info", r->in.info);
		ndr->depth--;
		ndr_print_ptr(ndr, "auth_info", r->in.auth_info);
		ndr->depth++;
		ndr_print_lsa_TrustDomainInfoAuthInfo(ndr, "auth_info", r->in.auth_info);
		ndr->depth--;
		ndr_print_lsa_TrustedAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CreateTrustedDomainEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_CloseTrustedDomainEx(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CloseTrustedDomainEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_CloseTrustedDomainEx(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CloseTrustedDomainEx *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		*r->out.handle = *r->in.handle;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CloseTrustedDomainEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CloseTrustedDomainEx *r)
{
	ndr_print_struct(ndr, name, "lsa_CloseTrustedDomainEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CloseTrustedDomainEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CloseTrustedDomainEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_QueryDomainInformationPolicy(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_QueryDomainInformationPolicy *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_DomainInfoEnum(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_push_lsa_DomainInformationPolicy(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_QueryDomainInformationPolicy(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_QueryDomainInformationPolicy *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	TALLOC_CTX *_mem_save_info_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_DomainInfoEnum(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		NDR_ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_lsa_DomainInformationPolicy(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_QueryDomainInformationPolicy(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_QueryDomainInformationPolicy *r)
{
	ndr_print_struct(ndr, name, "lsa_QueryDomainInformationPolicy");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_QueryDomainInformationPolicy");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_lsa_DomainInfoEnum(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_QueryDomainInformationPolicy");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_set_switch_value(ndr, *r->out.info, r->in.level);
			ndr_print_lsa_DomainInformationPolicy(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_SetDomainInformationPolicy(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_SetDomainInformationPolicy *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_DomainInfoEnum(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.info));
		if (r->in.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
			NDR_CHECK(ndr_push_lsa_DomainInformationPolicy(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_SetDomainInformationPolicy(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_SetDomainInformationPolicy *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_DomainInfoEnum(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		} else {
			r->in.info = NULL;
		}
		if (r->in.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
			NDR_CHECK(ndr_pull_lsa_DomainInformationPolicy(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_SetDomainInformationPolicy(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_SetDomainInformationPolicy *r)
{
	ndr_print_struct(ndr, name, "lsa_SetDomainInformationPolicy");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetDomainInformationPolicy");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_lsa_DomainInfoEnum(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		if (r->in.info) {
			ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
			ndr_print_lsa_DomainInformationPolicy(ndr, "info", r->in.info);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetDomainInformationPolicy");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_OpenTrustedDomainByName(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_OpenTrustedDomainByName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_push_lsa_TrustedAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.trustdom_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.trustdom_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_OpenTrustedDomainByName(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_OpenTrustedDomainByName *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_trustdom_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_pull_lsa_TrustedAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		NDR_ZERO_STRUCTP(r->out.trustdom_handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		}
		_mem_save_trustdom_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.trustdom_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.trustdom_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trustdom_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_OpenTrustedDomainByName(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_OpenTrustedDomainByName *r)
{
	ndr_print_struct(ndr, name, "lsa_OpenTrustedDomainByName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_OpenTrustedDomainByName");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_lsa_String(ndr, "name", &r->in.name);
		ndr_print_lsa_TrustedAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_OpenTrustedDomainByName");
		ndr->depth++;
		ndr_print_ptr(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_TestCall(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_TestCall *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_TestCall(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_TestCall *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_TestCall(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_TestCall *r)
{
	ndr_print_struct(ndr, name, "lsa_TestCall");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_TestCall");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_TestCall");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_LookupSids2(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LookupSids2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_CHECK(ndr_push_lsa_TransNameArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.names));
		NDR_CHECK(ndr_push_lsa_LookupNamesLevel(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.count));
		NDR_CHECK(ndr_push_lsa_LookupOptions(ndr, NDR_SCALARS, r->in.lookup_options));
		NDR_CHECK(ndr_push_lsa_ClientRevision(ndr, NDR_SCALARS, r->in.client_revision));
	}
	if (flags & NDR_OUT) {
		if (r->out.domains == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.domains));
		if (*r->out.domains) {
			NDR_CHECK(ndr_push_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.domains));
		}
		NDR_CHECK(ndr_push_lsa_TransNameArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_LookupSids2(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LookupSids2 *r)
{
	uint32_t _ptr_domains;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	TALLOC_CTX *_mem_save_domains_0 = NULL;
	TALLOC_CTX *_mem_save_domains_1 = NULL;
	TALLOC_CTX *_mem_save_names_0 = NULL;
	TALLOC_CTX *_mem_save_count_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransNameArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_LookupNamesLevel(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_LookupOptions(ndr, NDR_SCALARS, &r->in.lookup_options));
		NDR_CHECK(ndr_pull_lsa_ClientRevision(ndr, NDR_SCALARS, &r->in.client_revision));
		NDR_PULL_ALLOC(ndr, r->out.domains);
		NDR_ZERO_STRUCTP(r->out.domains);
		NDR_PULL_ALLOC(ndr, r->out.names);
		*r->out.names = *r->in.names;
		NDR_PULL_ALLOC(ndr, r->out.count);
		*r->out.count = *r->in.count;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.sids == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
			NDR_ZERO_STRUCTP(r->in.sids);
		}
		if (r->in.names == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.names);
			NDR_ZERO_STRUCTP(r->in.names);
		}
		if (r->in.count == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.count);
			NDR_ZERO_STRUCTP(r->in.count);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		}
		_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, *r->out.domains);
		} else {
			*r->out.domains = NULL;
		}
		if (*r->out.domains) {
			_mem_save_domains_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.domains, 0);
			NDR_CHECK(ndr_pull_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.domains));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransNameArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LookupSids2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LookupSids2 *r)
{
	ndr_print_struct(ndr, name, "lsa_LookupSids2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupSids2");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_SidArray(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr_print_ptr(ndr, "names", r->in.names);
		ndr->depth++;
		ndr_print_lsa_TransNameArray2(ndr, "names", r->in.names);
		ndr->depth--;
		ndr_print_lsa_LookupNamesLevel(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "count", r->in.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->in.count);
		ndr->depth--;
		ndr_print_lsa_LookupOptions(ndr, "lookup_options", r->in.lookup_options);
		ndr_print_lsa_ClientRevision(ndr, "client_revision", r->in.client_revision);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupSids2");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", *r->out.domains);
		ndr->depth++;
		if (*r->out.domains) {
			ndr_print_lsa_RefDomainList(ndr, "domains", *r->out.domains);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "names", r->out.names);
		ndr->depth++;
		ndr_print_lsa_TransNameArray2(ndr, "names", r->out.names);
		ndr->depth--;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_LookupNames2(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LookupNames2 *r)
{
	uint32_t cntr_names_0;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_names));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.num_names));
		for (cntr_names_0 = 0; cntr_names_0 < (r->in.num_names); cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < (r->in.num_names); cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		NDR_CHECK(ndr_push_lsa_TransSidArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_CHECK(ndr_push_lsa_LookupNamesLevel(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.count));
		NDR_CHECK(ndr_push_lsa_LookupOptions(ndr, NDR_SCALARS, r->in.lookup_options));
		NDR_CHECK(ndr_push_lsa_ClientRevision(ndr, NDR_SCALARS, r->in.client_revision));
	}
	if (flags & NDR_OUT) {
		if (r->out.domains == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.domains));
		if (*r->out.domains) {
			NDR_CHECK(ndr_push_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.domains));
		}
		NDR_CHECK(ndr_push_lsa_TransSidArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_LookupNames2(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LookupNames2 *r)
{
	uint32_t size_names_0 = 0;
	uint32_t cntr_names_0;
	uint32_t _ptr_domains;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_names_0 = NULL;
	TALLOC_CTX *_mem_save_domains_0 = NULL;
	TALLOC_CTX *_mem_save_domains_1 = NULL;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	TALLOC_CTX *_mem_save_count_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_names));
		if (r->in.num_names > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.num_names), (uint32_t)(0), (uint32_t)(1000));
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.names));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.names, &size_names_0));
		NDR_PULL_ALLOC_N(ndr, r->in.names, size_names_0);
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.names, 0);
		for (cntr_names_0 = 0; cntr_names_0 < (size_names_0); cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < (size_names_0); cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransSidArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_LookupNamesLevel(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_LookupOptions(ndr, NDR_SCALARS, &r->in.lookup_options));
		NDR_CHECK(ndr_pull_lsa_ClientRevision(ndr, NDR_SCALARS, &r->in.client_revision));
		NDR_PULL_ALLOC(ndr, r->out.domains);
		NDR_ZERO_STRUCTP(r->out.domains);
		NDR_PULL_ALLOC(ndr, r->out.sids);
		*r->out.sids = *r->in.sids;
		NDR_PULL_ALLOC(ndr, r->out.count);
		*r->out.count = *r->in.count;
		if (r->in.names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.names, r->in.num_names));
		}
		for (cntr_names_0 = 0; cntr_names_0 < (size_names_0); cntr_names_0++) {
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.sids == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
			NDR_ZERO_STRUCTP(r->in.sids);
		}
		if (r->in.count == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.count);
			NDR_ZERO_STRUCTP(r->in.count);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		}
		_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, *r->out.domains);
		} else {
			*r->out.domains = NULL;
		}
		if (*r->out.domains) {
			_mem_save_domains_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.domains, 0);
			NDR_CHECK(ndr_pull_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.domains));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransSidArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LookupNames2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LookupNames2 *r)
{
	uint32_t cntr_names_0;
	ndr_print_struct(ndr, name, "lsa_LookupNames2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupNames2");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "num_names", r->in.num_names);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "names", (uint32_t)(r->in.num_names));
		ndr->depth++;
		for (cntr_names_0 = 0; cntr_names_0 < (r->in.num_names); cntr_names_0++) {
			ndr_print_lsa_String(ndr, "names", &r->in.names[cntr_names_0]);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_TransSidArray2(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr_print_lsa_LookupNamesLevel(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "count", r->in.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->in.count);
		ndr->depth--;
		ndr_print_lsa_LookupOptions(ndr, "lookup_options", r->in.lookup_options);
		ndr_print_lsa_ClientRevision(ndr, "client_revision", r->in.client_revision);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupNames2");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", *r->out.domains);
		ndr->depth++;
		if (*r->out.domains) {
			ndr_print_lsa_RefDomainList(ndr, "domains", *r->out.domains);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->out.sids);
		ndr->depth++;
		ndr_print_lsa_TransSidArray2(ndr, "sids", r->out.sids);
		ndr->depth--;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_CreateTrustedDomainEx2(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CreateTrustedDomainEx2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.policy_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.auth_info_internal == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.policy_handle));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfoInternal(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.auth_info_internal));
		NDR_CHECK(ndr_push_lsa_TrustedAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.trustdom_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.trustdom_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_CreateTrustedDomainEx2(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CreateTrustedDomainEx2 *r)
{
	TALLOC_CTX *_mem_save_policy_handle_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	TALLOC_CTX *_mem_save_auth_info_internal_0 = NULL;
	TALLOC_CTX *_mem_save_trustdom_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.policy_handle);
		}
		_mem_save_policy_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.policy_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.policy_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_policy_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.auth_info_internal);
		}
		_mem_save_auth_info_internal_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.auth_info_internal, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfoInternal(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.auth_info_internal));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_auth_info_internal_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustedAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		NDR_ZERO_STRUCTP(r->out.trustdom_handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.policy_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.policy_handle);
			NDR_ZERO_STRUCTP(r->in.policy_handle);
		}
		if (r->in.info == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.info);
			NDR_ZERO_STRUCTP(r->in.info);
		}
		if (r->in.auth_info_internal == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.auth_info_internal);
			NDR_ZERO_STRUCTP(r->in.auth_info_internal);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		}
		_mem_save_trustdom_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.trustdom_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.trustdom_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trustdom_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CreateTrustedDomainEx2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CreateTrustedDomainEx2 *r)
{
	ndr_print_struct(ndr, name, "lsa_CreateTrustedDomainEx2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CreateTrustedDomainEx2");
		ndr->depth++;
		ndr_print_ptr(ndr, "policy_handle", r->in.policy_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "policy_handle", r->in.policy_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_lsa_TrustDomainInfoInfoEx(ndr, "info", r->in.info);
		ndr->depth--;
		ndr_print_ptr(ndr, "auth_info_internal", r->in.auth_info_internal);
		ndr->depth++;
		ndr_print_lsa_TrustDomainInfoAuthInfoInternal(ndr, "auth_info_internal", r->in.auth_info_internal);
		ndr->depth--;
		ndr_print_lsa_TrustedAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CreateTrustedDomainEx2");
		ndr->depth++;
		ndr_print_ptr(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_CREDRWRITE(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CREDRWRITE *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_CREDRWRITE(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CREDRWRITE *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CREDRWRITE(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CREDRWRITE *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRWRITE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRWRITE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRWRITE");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_CREDRREAD(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CREDRREAD *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_CREDRREAD(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CREDRREAD *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CREDRREAD(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CREDRREAD *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRREAD");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRREAD");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRREAD");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_CREDRENUMERATE(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CREDRENUMERATE *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_CREDRENUMERATE(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CREDRENUMERATE *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CREDRENUMERATE(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CREDRENUMERATE *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRENUMERATE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRENUMERATE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRENUMERATE");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_CREDRWRITEDOMAINCREDENTIALS(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CREDRWRITEDOMAINCREDENTIALS *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_CREDRWRITEDOMAINCREDENTIALS(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CREDRWRITEDOMAINCREDENTIALS *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CREDRWRITEDOMAINCREDENTIALS(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CREDRWRITEDOMAINCREDENTIALS *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRWRITEDOMAINCREDENTIALS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRWRITEDOMAINCREDENTIALS");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRWRITEDOMAINCREDENTIALS");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_CREDRREADDOMAINCREDENTIALS(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CREDRREADDOMAINCREDENTIALS *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_CREDRREADDOMAINCREDENTIALS(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CREDRREADDOMAINCREDENTIALS *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CREDRREADDOMAINCREDENTIALS(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CREDRREADDOMAINCREDENTIALS *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRREADDOMAINCREDENTIALS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRREADDOMAINCREDENTIALS");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRREADDOMAINCREDENTIALS");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_CREDRDELETE(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CREDRDELETE *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_CREDRDELETE(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CREDRDELETE *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CREDRDELETE(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CREDRDELETE *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRDELETE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRDELETE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRDELETE");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_CREDRGETTARGETINFO(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CREDRGETTARGETINFO *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_CREDRGETTARGETINFO(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CREDRGETTARGETINFO *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CREDRGETTARGETINFO(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CREDRGETTARGETINFO *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRGETTARGETINFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRGETTARGETINFO");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRGETTARGETINFO");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_CREDRPROFILELOADED(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CREDRPROFILELOADED *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_CREDRPROFILELOADED(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CREDRPROFILELOADED *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CREDRPROFILELOADED(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CREDRPROFILELOADED *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRPROFILELOADED");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRPROFILELOADED");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRPROFILELOADED");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_LookupNames3(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LookupNames3 *r)
{
	uint32_t cntr_names_0;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_names));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.num_names));
		for (cntr_names_0 = 0; cntr_names_0 < (r->in.num_names); cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < (r->in.num_names); cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		NDR_CHECK(ndr_push_lsa_TransSidArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_CHECK(ndr_push_lsa_LookupNamesLevel(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.count));
		NDR_CHECK(ndr_push_lsa_LookupOptions(ndr, NDR_SCALARS, r->in.lookup_options));
		NDR_CHECK(ndr_push_lsa_ClientRevision(ndr, NDR_SCALARS, r->in.client_revision));
	}
	if (flags & NDR_OUT) {
		if (r->out.domains == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.domains));
		if (*r->out.domains) {
			NDR_CHECK(ndr_push_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.domains));
		}
		NDR_CHECK(ndr_push_lsa_TransSidArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_LookupNames3(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LookupNames3 *r)
{
	uint32_t size_names_0 = 0;
	uint32_t cntr_names_0;
	uint32_t _ptr_domains;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_names_0 = NULL;
	TALLOC_CTX *_mem_save_domains_0 = NULL;
	TALLOC_CTX *_mem_save_domains_1 = NULL;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	TALLOC_CTX *_mem_save_count_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_names));
		if (r->in.num_names > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.num_names), (uint32_t)(0), (uint32_t)(1000));
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.names));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.names, &size_names_0));
		NDR_PULL_ALLOC_N(ndr, r->in.names, size_names_0);
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.names, 0);
		for (cntr_names_0 = 0; cntr_names_0 < (size_names_0); cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < (size_names_0); cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransSidArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_LookupNamesLevel(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_LookupOptions(ndr, NDR_SCALARS, &r->in.lookup_options));
		NDR_CHECK(ndr_pull_lsa_ClientRevision(ndr, NDR_SCALARS, &r->in.client_revision));
		NDR_PULL_ALLOC(ndr, r->out.domains);
		NDR_ZERO_STRUCTP(r->out.domains);
		NDR_PULL_ALLOC(ndr, r->out.sids);
		*r->out.sids = *r->in.sids;
		NDR_PULL_ALLOC(ndr, r->out.count);
		*r->out.count = *r->in.count;
		if (r->in.names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.names, r->in.num_names));
		}
		for (cntr_names_0 = 0; cntr_names_0 < (size_names_0); cntr_names_0++) {
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.sids == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
			NDR_ZERO_STRUCTP(r->in.sids);
		}
		if (r->in.count == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.count);
			NDR_ZERO_STRUCTP(r->in.count);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		}
		_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, *r->out.domains);
		} else {
			*r->out.domains = NULL;
		}
		if (*r->out.domains) {
			_mem_save_domains_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.domains, 0);
			NDR_CHECK(ndr_pull_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.domains));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransSidArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LookupNames3(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LookupNames3 *r)
{
	uint32_t cntr_names_0;
	ndr_print_struct(ndr, name, "lsa_LookupNames3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupNames3");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "num_names", r->in.num_names);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "names", (uint32_t)(r->in.num_names));
		ndr->depth++;
		for (cntr_names_0 = 0; cntr_names_0 < (r->in.num_names); cntr_names_0++) {
			ndr_print_lsa_String(ndr, "names", &r->in.names[cntr_names_0]);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_TransSidArray3(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr_print_lsa_LookupNamesLevel(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "count", r->in.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->in.count);
		ndr->depth--;
		ndr_print_lsa_LookupOptions(ndr, "lookup_options", r->in.lookup_options);
		ndr_print_lsa_ClientRevision(ndr, "client_revision", r->in.client_revision);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupNames3");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", *r->out.domains);
		ndr->depth++;
		if (*r->out.domains) {
			ndr_print_lsa_RefDomainList(ndr, "domains", *r->out.domains);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->out.sids);
		ndr->depth++;
		ndr_print_lsa_TransSidArray3(ndr, "sids", r->out.sids);
		ndr->depth--;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_CREDRGETSESSIONTYPES(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CREDRGETSESSIONTYPES *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_CREDRGETSESSIONTYPES(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CREDRGETSESSIONTYPES *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CREDRGETSESSIONTYPES(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CREDRGETSESSIONTYPES *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRGETSESSIONTYPES");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRGETSESSIONTYPES");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRGETSESSIONTYPES");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_LSARREGISTERAUDITEVENT(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LSARREGISTERAUDITEVENT *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_LSARREGISTERAUDITEVENT(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LSARREGISTERAUDITEVENT *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LSARREGISTERAUDITEVENT(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LSARREGISTERAUDITEVENT *r)
{
	ndr_print_struct(ndr, name, "lsa_LSARREGISTERAUDITEVENT");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LSARREGISTERAUDITEVENT");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LSARREGISTERAUDITEVENT");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_LSARGENAUDITEVENT(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LSARGENAUDITEVENT *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_LSARGENAUDITEVENT(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LSARGENAUDITEVENT *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LSARGENAUDITEVENT(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LSARGENAUDITEVENT *r)
{
	ndr_print_struct(ndr, name, "lsa_LSARGENAUDITEVENT");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LSARGENAUDITEVENT");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LSARGENAUDITEVENT");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_LSARUNREGISTERAUDITEVENT(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LSARUNREGISTERAUDITEVENT *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_LSARUNREGISTERAUDITEVENT(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LSARUNREGISTERAUDITEVENT *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LSARUNREGISTERAUDITEVENT(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LSARUNREGISTERAUDITEVENT *r)
{
	ndr_print_struct(ndr, name, "lsa_LSARUNREGISTERAUDITEVENT");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LSARUNREGISTERAUDITEVENT");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LSARUNREGISTERAUDITEVENT");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_lsaRQueryForestTrustInformation(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_lsaRQueryForestTrustInformation *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.trusted_domain_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.trusted_domain_name));
		NDR_CHECK(ndr_push_lsa_ForestTrustRecordType(ndr, NDR_SCALARS, r->in.highest_record_type));
	}
	if (flags & NDR_OUT) {
		if (r->out.forest_trust_info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.forest_trust_info));
		if (*r->out.forest_trust_info) {
			NDR_CHECK(ndr_push_lsa_ForestTrustInformation(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.forest_trust_info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_lsaRQueryForestTrustInformation(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_lsaRQueryForestTrustInformation *r)
{
	uint32_t _ptr_forest_trust_info;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_trusted_domain_name_0 = NULL;
	TALLOC_CTX *_mem_save_forest_trust_info_0 = NULL;
	TALLOC_CTX *_mem_save_forest_trust_info_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.trusted_domain_name);
		}
		_mem_save_trusted_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.trusted_domain_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.trusted_domain_name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trusted_domain_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_ForestTrustRecordType(ndr, NDR_SCALARS, &r->in.highest_record_type));
		NDR_PULL_ALLOC(ndr, r->out.forest_trust_info);
		NDR_ZERO_STRUCTP(r->out.forest_trust_info);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.trusted_domain_name == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.trusted_domain_name);
			NDR_ZERO_STRUCTP(r->in.trusted_domain_name);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.forest_trust_info);
		}
		_mem_save_forest_trust_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.forest_trust_info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_forest_trust_info));
		if (_ptr_forest_trust_info) {
			NDR_PULL_ALLOC(ndr, *r->out.forest_trust_info);
		} else {
			*r->out.forest_trust_info = NULL;
		}
		if (*r->out.forest_trust_info) {
			_mem_save_forest_trust_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.forest_trust_info, 0);
			NDR_CHECK(ndr_pull_lsa_ForestTrustInformation(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.forest_trust_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_forest_trust_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_forest_trust_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_lsaRQueryForestTrustInformation(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_lsaRQueryForestTrustInformation *r)
{
	ndr_print_struct(ndr, name, "lsa_lsaRQueryForestTrustInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_lsaRQueryForestTrustInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "trusted_domain_name", r->in.trusted_domain_name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "trusted_domain_name", r->in.trusted_domain_name);
		ndr->depth--;
		ndr_print_lsa_ForestTrustRecordType(ndr, "highest_record_type", r->in.highest_record_type);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_lsaRQueryForestTrustInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "forest_trust_info", r->out.forest_trust_info);
		ndr->depth++;
		ndr_print_ptr(ndr, "forest_trust_info", *r->out.forest_trust_info);
		ndr->depth++;
		if (*r->out.forest_trust_info) {
			ndr_print_lsa_ForestTrustInformation(ndr, "forest_trust_info", *r->out.forest_trust_info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_lsaRSetForestTrustInformation(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_lsaRSetForestTrustInformation *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.trusted_domain_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.forest_trust_info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.trusted_domain_name));
		NDR_CHECK(ndr_push_lsa_ForestTrustRecordType(ndr, NDR_SCALARS, r->in.highest_record_type));
		NDR_CHECK(ndr_push_lsa_ForestTrustInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.forest_trust_info));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.check_only));
	}
	if (flags & NDR_OUT) {
		if (r->out.collision_info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.collision_info));
		if (*r->out.collision_info) {
			NDR_CHECK(ndr_push_lsa_ForestTrustCollisionInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.collision_info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_lsaRSetForestTrustInformation(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_lsaRSetForestTrustInformation *r)
{
	uint32_t _ptr_collision_info;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_trusted_domain_name_0 = NULL;
	TALLOC_CTX *_mem_save_forest_trust_info_0 = NULL;
	TALLOC_CTX *_mem_save_collision_info_0 = NULL;
	TALLOC_CTX *_mem_save_collision_info_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.trusted_domain_name);
		}
		_mem_save_trusted_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.trusted_domain_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.trusted_domain_name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trusted_domain_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_ForestTrustRecordType(ndr, NDR_SCALARS, &r->in.highest_record_type));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.forest_trust_info);
		}
		_mem_save_forest_trust_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.forest_trust_info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_ForestTrustInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.forest_trust_info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_forest_trust_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.check_only));
		NDR_PULL_ALLOC(ndr, r->out.collision_info);
		NDR_ZERO_STRUCTP(r->out.collision_info);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.trusted_domain_name == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.trusted_domain_name);
			NDR_ZERO_STRUCTP(r->in.trusted_domain_name);
		}
		if (r->in.forest_trust_info == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.forest_trust_info);
			NDR_ZERO_STRUCTP(r->in.forest_trust_info);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.collision_info);
		}
		_mem_save_collision_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.collision_info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_collision_info));
		if (_ptr_collision_info) {
			NDR_PULL_ALLOC(ndr, *r->out.collision_info);
		} else {
			*r->out.collision_info = NULL;
		}
		if (*r->out.collision_info) {
			_mem_save_collision_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.collision_info, 0);
			NDR_CHECK(ndr_pull_lsa_ForestTrustCollisionInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.collision_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_collision_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_collision_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_lsaRSetForestTrustInformation(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_lsaRSetForestTrustInformation *r)
{
	ndr_print_struct(ndr, name, "lsa_lsaRSetForestTrustInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_lsaRSetForestTrustInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "trusted_domain_name", r->in.trusted_domain_name);
		ndr->depth++;
		ndr_print_lsa_StringLarge(ndr, "trusted_domain_name", r->in.trusted_domain_name);
		ndr->depth--;
		ndr_print_lsa_ForestTrustRecordType(ndr, "highest_record_type", r->in.highest_record_type);
		ndr_print_ptr(ndr, "forest_trust_info", r->in.forest_trust_info);
		ndr->depth++;
		ndr_print_lsa_ForestTrustInformation(ndr, "forest_trust_info", r->in.forest_trust_info);
		ndr->depth--;
		ndr_print_uint8(ndr, "check_only", r->in.check_only);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_lsaRSetForestTrustInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "collision_info", r->out.collision_info);
		ndr->depth++;
		ndr_print_ptr(ndr, "collision_info", *r->out.collision_info);
		ndr->depth++;
		if (*r->out.collision_info) {
			ndr_print_lsa_ForestTrustCollisionInfo(ndr, "collision_info", *r->out.collision_info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_CREDRRENAME(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CREDRRENAME *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_CREDRRENAME(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CREDRRENAME *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CREDRRENAME(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CREDRRENAME *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRRENAME");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRRENAME");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRRENAME");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_LookupSids3(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LookupSids3 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_CHECK(ndr_push_lsa_TransNameArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.names));
		NDR_CHECK(ndr_push_lsa_LookupNamesLevel(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.count));
		NDR_CHECK(ndr_push_lsa_LookupOptions(ndr, NDR_SCALARS, r->in.lookup_options));
		NDR_CHECK(ndr_push_lsa_ClientRevision(ndr, NDR_SCALARS, r->in.client_revision));
	}
	if (flags & NDR_OUT) {
		if (r->out.domains == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.domains));
		if (*r->out.domains) {
			NDR_CHECK(ndr_push_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.domains));
		}
		NDR_CHECK(ndr_push_lsa_TransNameArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_LookupSids3(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LookupSids3 *r)
{
	uint32_t _ptr_domains;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	TALLOC_CTX *_mem_save_domains_0 = NULL;
	TALLOC_CTX *_mem_save_domains_1 = NULL;
	TALLOC_CTX *_mem_save_names_0 = NULL;
	TALLOC_CTX *_mem_save_count_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransNameArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_LookupNamesLevel(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_LookupOptions(ndr, NDR_SCALARS, &r->in.lookup_options));
		NDR_CHECK(ndr_pull_lsa_ClientRevision(ndr, NDR_SCALARS, &r->in.client_revision));
		NDR_PULL_ALLOC(ndr, r->out.domains);
		NDR_ZERO_STRUCTP(r->out.domains);
		NDR_PULL_ALLOC(ndr, r->out.names);
		*r->out.names = *r->in.names;
		NDR_PULL_ALLOC(ndr, r->out.count);
		*r->out.count = *r->in.count;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.sids == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
			NDR_ZERO_STRUCTP(r->in.sids);
		}
		if (r->in.names == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.names);
			NDR_ZERO_STRUCTP(r->in.names);
		}
		if (r->in.count == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.count);
			NDR_ZERO_STRUCTP(r->in.count);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		}
		_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, *r->out.domains);
		} else {
			*r->out.domains = NULL;
		}
		if (*r->out.domains) {
			_mem_save_domains_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.domains, 0);
			NDR_CHECK(ndr_pull_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.domains));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransNameArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LookupSids3(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LookupSids3 *r)
{
	ndr_print_struct(ndr, name, "lsa_LookupSids3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupSids3");
		ndr->depth++;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_SidArray(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr_print_ptr(ndr, "names", r->in.names);
		ndr->depth++;
		ndr_print_lsa_TransNameArray2(ndr, "names", r->in.names);
		ndr->depth--;
		ndr_print_lsa_LookupNamesLevel(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "count", r->in.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->in.count);
		ndr->depth--;
		ndr_print_lsa_LookupOptions(ndr, "lookup_options", r->in.lookup_options);
		ndr_print_lsa_ClientRevision(ndr, "client_revision", r->in.client_revision);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupSids3");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", *r->out.domains);
		ndr->depth++;
		if (*r->out.domains) {
			ndr_print_lsa_RefDomainList(ndr, "domains", *r->out.domains);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "names", r->out.names);
		ndr->depth++;
		ndr_print_lsa_TransNameArray2(ndr, "names", r->out.names);
		ndr->depth--;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_LookupNames4(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LookupNames4 *r)
{
	uint32_t cntr_names_0;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_names));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.num_names));
		for (cntr_names_0 = 0; cntr_names_0 < (r->in.num_names); cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < (r->in.num_names); cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		NDR_CHECK(ndr_push_lsa_TransSidArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_CHECK(ndr_push_lsa_LookupNamesLevel(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.count));
		NDR_CHECK(ndr_push_lsa_LookupOptions(ndr, NDR_SCALARS, r->in.lookup_options));
		NDR_CHECK(ndr_push_lsa_ClientRevision(ndr, NDR_SCALARS, r->in.client_revision));
	}
	if (flags & NDR_OUT) {
		if (r->out.domains == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.domains));
		if (*r->out.domains) {
			NDR_CHECK(ndr_push_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.domains));
		}
		NDR_CHECK(ndr_push_lsa_TransSidArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_LookupNames4(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LookupNames4 *r)
{
	uint32_t size_names_0 = 0;
	uint32_t cntr_names_0;
	uint32_t _ptr_domains;
	TALLOC_CTX *_mem_save_names_0 = NULL;
	TALLOC_CTX *_mem_save_domains_0 = NULL;
	TALLOC_CTX *_mem_save_domains_1 = NULL;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	TALLOC_CTX *_mem_save_count_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_names));
		if (r->in.num_names > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.num_names), (uint32_t)(0), (uint32_t)(1000));
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.names));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.names, &size_names_0));
		NDR_PULL_ALLOC_N(ndr, r->in.names, size_names_0);
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.names, 0);
		for (cntr_names_0 = 0; cntr_names_0 < (size_names_0); cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < (size_names_0); cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransSidArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_LookupNamesLevel(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_LookupOptions(ndr, NDR_SCALARS, &r->in.lookup_options));
		NDR_CHECK(ndr_pull_lsa_ClientRevision(ndr, NDR_SCALARS, &r->in.client_revision));
		NDR_PULL_ALLOC(ndr, r->out.domains);
		NDR_ZERO_STRUCTP(r->out.domains);
		NDR_PULL_ALLOC(ndr, r->out.sids);
		*r->out.sids = *r->in.sids;
		NDR_PULL_ALLOC(ndr, r->out.count);
		*r->out.count = *r->in.count;
		if (r->in.names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.names, r->in.num_names));
		}
		for (cntr_names_0 = 0; cntr_names_0 < (size_names_0); cntr_names_0++) {
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.sids == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
			NDR_ZERO_STRUCTP(r->in.sids);
		}
		if (r->in.count == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.count);
			NDR_ZERO_STRUCTP(r->in.count);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		}
		_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, *r->out.domains);
		} else {
			*r->out.domains = NULL;
		}
		if (*r->out.domains) {
			_mem_save_domains_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.domains, 0);
			NDR_CHECK(ndr_pull_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.domains));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransSidArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LookupNames4(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LookupNames4 *r)
{
	uint32_t cntr_names_0;
	ndr_print_struct(ndr, name, "lsa_LookupNames4");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupNames4");
		ndr->depth++;
		ndr_print_uint32(ndr, "num_names", r->in.num_names);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "names", (uint32_t)(r->in.num_names));
		ndr->depth++;
		for (cntr_names_0 = 0; cntr_names_0 < (r->in.num_names); cntr_names_0++) {
			ndr_print_lsa_String(ndr, "names", &r->in.names[cntr_names_0]);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_TransSidArray3(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr_print_lsa_LookupNamesLevel(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "count", r->in.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->in.count);
		ndr->depth--;
		ndr_print_lsa_LookupOptions(ndr, "lookup_options", r->in.lookup_options);
		ndr_print_lsa_ClientRevision(ndr, "client_revision", r->in.client_revision);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupNames4");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", *r->out.domains);
		ndr->depth++;
		if (*r->out.domains) {
			ndr_print_lsa_RefDomainList(ndr, "domains", *r->out.domains);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->out.sids);
		ndr->depth++;
		ndr_print_lsa_TransSidArray3(ndr, "sids", r->out.sids);
		ndr->depth--;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_LSAROPENPOLICYSCE(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LSAROPENPOLICYSCE *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_LSAROPENPOLICYSCE(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LSAROPENPOLICYSCE *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LSAROPENPOLICYSCE(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LSAROPENPOLICYSCE *r)
{
	ndr_print_struct(ndr, name, "lsa_LSAROPENPOLICYSCE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LSAROPENPOLICYSCE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LSAROPENPOLICYSCE");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_LSARADTREGISTERSECURITYEVENTSOURCE(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_LSARADTREGISTERSECURITYEVENTSOURCE(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LSARADTREGISTERSECURITYEVENTSOURCE(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE *r)
{
	ndr_print_struct(ndr, name, "lsa_LSARADTREGISTERSECURITYEVENTSOURCE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LSARADTREGISTERSECURITYEVENTSOURCE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LSARADTREGISTERSECURITYEVENTSOURCE");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE *r)
{
	ndr_print_struct(ndr, name, "lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_LSARADTREPORTSECURITYEVENT(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_LSARADTREPORTSECURITYEVENT *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_LSARADTREPORTSECURITYEVENT(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_LSARADTREPORTSECURITYEVENT *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_LSARADTREPORTSECURITYEVENT(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_LSARADTREPORTSECURITYEVENT *r)
{
	ndr_print_struct(ndr, name, "lsa_LSARADTREPORTSECURITYEVENT");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LSARADTREPORTSECURITYEVENT");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LSARADTREPORTSECURITYEVENT");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum82NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum82NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum82NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum82NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum82NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum82NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum82NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum82NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum82NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum83NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum83NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum83NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum83NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum83NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum83NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum83NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum83NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum83NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum84NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum84NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum84NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum84NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum84NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum84NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum84NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum84NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum84NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum85NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum85NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum85NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum85NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum85NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum85NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum85NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum85NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum85NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum86NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum86NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum86NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum86NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum86NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum86NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum86NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum86NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum86NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum87NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum87NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum87NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum87NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum87NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum87NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum87NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum87NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum87NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum88NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum88NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum88NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum88NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum88NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum88NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum88NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum88NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum88NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum89NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum89NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum89NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum89NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum89NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum89NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum89NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum89NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum89NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum90NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum90NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum90NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum90NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum90NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum90NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum90NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum90NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum90NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum91NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum91NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum91NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum91NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum91NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum91NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum91NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum91NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum91NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum92NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum92NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum92NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum92NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum92NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum92NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum92NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum92NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum92NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum93NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum93NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum93NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum93NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum93NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum93NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum93NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum93NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum93NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum94NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum94NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum94NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum94NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum94NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum94NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum94NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum94NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum94NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum95NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum95NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum95NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum95NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum95NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum95NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum95NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum95NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum95NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum96NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum96NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum96NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum96NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum96NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum96NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum96NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum96NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum96NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum97NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum97NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum97NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum97NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum97NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum97NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum97NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum97NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum97NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum98NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum98NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum98NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum98NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum98NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum98NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum98NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum98NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum98NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum99NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum99NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum99NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum99NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum99NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum99NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum99NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum99NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum99NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum100NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum100NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum100NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum100NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum100NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum100NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum100NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum100NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum100NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum101NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum101NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum101NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum101NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum101NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum101NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum101NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum101NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum101NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum102NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum102NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum102NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum102NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum102NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum102NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum102NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum102NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum102NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum103NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum103NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum103NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum103NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum103NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum103NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum103NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum103NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum103NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum104NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum104NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum104NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum104NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum104NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum104NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum104NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum104NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum104NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum105NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum105NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum105NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum105NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum105NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum105NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum105NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum105NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum105NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum106NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum106NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum106NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum106NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum106NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum106NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum106NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum106NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum106NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum107NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum107NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum107NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum107NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum107NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum107NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum107NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum107NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum107NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum108NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum108NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum108NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum108NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum108NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum108NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum108NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum108NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum108NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum109NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum109NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum109NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum109NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum109NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum109NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum109NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum109NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum109NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum110NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum110NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum110NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum110NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum110NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum110NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum110NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum110NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum110NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum111NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum111NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum111NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum111NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum111NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum111NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum111NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum111NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum111NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum112NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum112NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum112NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum112NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum112NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum112NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum112NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum112NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum112NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum113NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum113NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum113NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum113NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum113NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum113NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum113NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum113NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum113NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum114NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum114NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum114NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum114NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum114NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum114NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum114NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum114NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum114NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum115NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum115NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum115NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum115NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum115NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum115NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum115NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum115NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum115NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum116NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum116NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum116NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum116NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum116NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum116NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum116NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum116NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum116NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum117NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum117NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum117NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum117NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum117NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum117NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum117NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum117NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum117NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum118NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum118NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum118NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum118NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum118NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum118NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum118NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum118NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum118NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum119NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum119NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum119NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum119NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum119NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum119NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum119NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum119NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum119NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum120NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum120NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum120NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum120NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum120NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum120NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum120NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum120NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum120NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum121NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum121NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum121NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum121NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum121NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum121NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum121NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum121NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum121NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum122NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum122NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum122NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum122NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum122NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum122NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum122NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum122NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum122NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum123NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum123NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum123NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum123NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum123NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum123NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum123NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum123NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum123NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum124NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum124NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum124NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum124NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum124NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum124NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum124NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum124NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum124NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum125NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum125NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum125NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum125NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum125NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum125NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum125NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum125NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum125NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum126NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum126NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum126NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum126NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum126NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum126NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum126NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum126NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum126NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum127NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum127NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum127NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum127NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum127NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum127NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum127NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum127NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum127NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum128NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum128NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum128NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum128NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum128NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum128NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum128NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum128NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum128NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_CreateTrustedDomainEx3(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_CreateTrustedDomainEx3 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.policy_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.auth_info_internal == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.policy_handle));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfoInternalAES(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.auth_info_internal));
		NDR_CHECK(ndr_push_lsa_TrustedAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.trustdom_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.trustdom_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_CreateTrustedDomainEx3(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_CreateTrustedDomainEx3 *r)
{
	TALLOC_CTX *_mem_save_policy_handle_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	TALLOC_CTX *_mem_save_auth_info_internal_0 = NULL;
	TALLOC_CTX *_mem_save_trustdom_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.policy_handle);
		}
		_mem_save_policy_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.policy_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.policy_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_policy_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.auth_info_internal);
		}
		_mem_save_auth_info_internal_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.auth_info_internal, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfoInternalAES(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.auth_info_internal));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_auth_info_internal_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustedAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		NDR_ZERO_STRUCTP(r->out.trustdom_handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.policy_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.policy_handle);
			NDR_ZERO_STRUCTP(r->in.policy_handle);
		}
		if (r->in.info == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.info);
			NDR_ZERO_STRUCTP(r->in.info);
		}
		if (r->in.auth_info_internal == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.auth_info_internal);
			NDR_ZERO_STRUCTP(r->in.auth_info_internal);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		}
		_mem_save_trustdom_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.trustdom_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.trustdom_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trustdom_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_CreateTrustedDomainEx3(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_CreateTrustedDomainEx3 *r)
{
	ndr_print_struct(ndr, name, "lsa_CreateTrustedDomainEx3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CreateTrustedDomainEx3");
		ndr->depth++;
		ndr_print_ptr(ndr, "policy_handle", r->in.policy_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "policy_handle", r->in.policy_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_lsa_TrustDomainInfoInfoEx(ndr, "info", r->in.info);
		ndr->depth--;
		ndr_print_ptr(ndr, "auth_info_internal", r->in.auth_info_internal);
		ndr->depth++;
		ndr_print_lsa_TrustDomainInfoAuthInfoInternalAES(ndr, "auth_info_internal", r->in.auth_info_internal);
		ndr->depth--;
		ndr_print_lsa_TrustedAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CreateTrustedDomainEx3");
		ndr->depth++;
		ndr_print_ptr(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_OpenPolicy3(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_OpenPolicy3 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.attr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.in_revision_info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.system_name, ndr_charset_length(r->in.system_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_lsa_ObjectAttribute(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.attr));
		NDR_CHECK(ndr_push_lsa_PolicyAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.in_version));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.in_revision_info, r->in.in_version));
		NDR_CHECK(ndr_push_lsa_revision_info(ndr, NDR_SCALARS, r->in.in_revision_info));
	}
	if (flags & NDR_OUT) {
		if (r->out.out_version == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.out_revision_info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.out_version));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.out_revision_info, *r->out.out_version));
		NDR_CHECK(ndr_push_lsa_revision_info(ndr, NDR_SCALARS, r->out.out_revision_info));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_OpenPolicy3(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_OpenPolicy3 *r)
{
	uint32_t _ptr_system_name;
	uint32_t size_system_name_1 = 0;
	uint32_t length_system_name_1 = 0;
	TALLOC_CTX *_mem_save_system_name_0 = NULL;
	TALLOC_CTX *_mem_save_attr_0 = NULL;
	TALLOC_CTX *_mem_save_in_revision_info_0 = NULL;
	TALLOC_CTX *_mem_save_out_version_0 = NULL;
	TALLOC_CTX *_mem_save_out_revision_info_0 = NULL;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.system_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.system_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.system_name, &size_system_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.system_name, &length_system_name_1));
			if (length_system_name_1 > size_system_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_system_name_1, length_system_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_system_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.system_name, length_system_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.attr);
		}
		_mem_save_attr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.attr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_ObjectAttribute(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.attr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_PolicyAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.in_version));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.in_revision_info);
		}
		_mem_save_in_revision_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.in_revision_info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.in_revision_info, r->in.in_version));
		NDR_CHECK(ndr_pull_lsa_revision_info(ndr, NDR_SCALARS, r->in.in_revision_info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_in_revision_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.out_version);
		NDR_ZERO_STRUCTP(r->out.out_version);
		NDR_PULL_ALLOC(ndr, r->out.out_revision_info);
		NDR_ZERO_STRUCTP(r->out.out_revision_info);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		NDR_ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.attr == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.attr);
			NDR_ZERO_STRUCTP(r->in.attr);
		}
		if (r->in.in_revision_info == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.in_revision_info);
			NDR_ZERO_STRUCTP(r->in.in_revision_info);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.out_version);
		}
		_mem_save_out_version_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.out_version, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.out_version));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_out_version_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.out_revision_info);
		}
		_mem_save_out_revision_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.out_revision_info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.out_revision_info, *r->out.out_version));
		NDR_CHECK(ndr_pull_lsa_revision_info(ndr, NDR_SCALARS, r->out.out_revision_info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_out_revision_info_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_OpenPolicy3(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_OpenPolicy3 *r)
{
	ndr_print_struct(ndr, name, "lsa_OpenPolicy3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_OpenPolicy3");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_string(ndr, "system_name", r->in.system_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "attr", r->in.attr);
		ndr->depth++;
		ndr_print_lsa_ObjectAttribute(ndr, "attr", r->in.attr);
		ndr->depth--;
		ndr_print_lsa_PolicyAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr_print_uint32(ndr, "in_version", r->in.in_version);
		ndr_print_ptr(ndr, "in_revision_info", r->in.in_revision_info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.in_revision_info, r->in.in_version);
		ndr_print_lsa_revision_info(ndr, "in_revision_info", r->in.in_revision_info);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_OpenPolicy3");
		ndr->depth++;
		ndr_print_ptr(ndr, "out_version", r->out.out_version);
		ndr->depth++;
		ndr_print_uint32(ndr, "out_version", *r->out.out_version);
		ndr->depth--;
		ndr_print_ptr(ndr, "out_revision_info", r->out.out_revision_info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.out_revision_info, *r->out.out_version);
		ndr_print_lsa_revision_info(ndr, "out_revision_info", r->out.out_revision_info);
		ndr->depth--;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_lsa_Opnum131NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_Opnum131NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_lsa_Opnum131NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_Opnum131NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_Opnum131NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_Opnum131NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "lsa_Opnum131NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Opnum131NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Opnum131NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_lsaRQueryForestTrustInformation2(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_lsaRQueryForestTrustInformation2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.trusted_domain_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.trusted_domain_name));
		NDR_CHECK(ndr_push_lsa_ForestTrustRecordType(ndr, NDR_SCALARS, r->in.highest_record_type));
	}
	if (flags & NDR_OUT) {
		if (r->out.forest_trust_info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.forest_trust_info));
		if (*r->out.forest_trust_info) {
			NDR_CHECK(ndr_push_lsa_ForestTrustInformation2(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.forest_trust_info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_lsaRQueryForestTrustInformation2(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_lsaRQueryForestTrustInformation2 *r)
{
	uint32_t _ptr_forest_trust_info;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_trusted_domain_name_0 = NULL;
	TALLOC_CTX *_mem_save_forest_trust_info_0 = NULL;
	TALLOC_CTX *_mem_save_forest_trust_info_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.trusted_domain_name);
		}
		_mem_save_trusted_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.trusted_domain_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.trusted_domain_name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trusted_domain_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_ForestTrustRecordType(ndr, NDR_SCALARS, &r->in.highest_record_type));
		NDR_PULL_ALLOC(ndr, r->out.forest_trust_info);
		NDR_ZERO_STRUCTP(r->out.forest_trust_info);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.trusted_domain_name == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.trusted_domain_name);
			NDR_ZERO_STRUCTP(r->in.trusted_domain_name);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.forest_trust_info);
		}
		_mem_save_forest_trust_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.forest_trust_info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_forest_trust_info));
		if (_ptr_forest_trust_info) {
			NDR_PULL_ALLOC(ndr, *r->out.forest_trust_info);
		} else {
			*r->out.forest_trust_info = NULL;
		}
		if (*r->out.forest_trust_info) {
			_mem_save_forest_trust_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.forest_trust_info, 0);
			NDR_CHECK(ndr_pull_lsa_ForestTrustInformation2(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.forest_trust_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_forest_trust_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_forest_trust_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_lsaRQueryForestTrustInformation2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_lsaRQueryForestTrustInformation2 *r)
{
	ndr_print_struct(ndr, name, "lsa_lsaRQueryForestTrustInformation2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_lsaRQueryForestTrustInformation2");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "trusted_domain_name", r->in.trusted_domain_name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "trusted_domain_name", r->in.trusted_domain_name);
		ndr->depth--;
		ndr_print_lsa_ForestTrustRecordType(ndr, "highest_record_type", r->in.highest_record_type);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_lsaRQueryForestTrustInformation2");
		ndr->depth++;
		ndr_print_ptr(ndr, "forest_trust_info", r->out.forest_trust_info);
		ndr->depth++;
		ndr_print_ptr(ndr, "forest_trust_info", *r->out.forest_trust_info);
		ndr->depth++;
		if (*r->out.forest_trust_info) {
			ndr_print_lsa_ForestTrustInformation2(ndr, "forest_trust_info", *r->out.forest_trust_info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_lsaRSetForestTrustInformation2(struct ndr_push *ndr, ndr_flags_type flags, const struct lsa_lsaRSetForestTrustInformation2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.trusted_domain_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.forest_trust_info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.trusted_domain_name));
		NDR_CHECK(ndr_push_lsa_ForestTrustRecordType(ndr, NDR_SCALARS, r->in.highest_record_type));
		NDR_CHECK(ndr_push_lsa_ForestTrustInformation2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.forest_trust_info));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.check_only));
	}
	if (flags & NDR_OUT) {
		if (r->out.collision_info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.collision_info));
		if (*r->out.collision_info) {
			NDR_CHECK(ndr_push_lsa_ForestTrustCollisionInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.collision_info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_lsaRSetForestTrustInformation2(struct ndr_pull *ndr, ndr_flags_type flags, struct lsa_lsaRSetForestTrustInformation2 *r)
{
	uint32_t _ptr_collision_info;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_trusted_domain_name_0 = NULL;
	TALLOC_CTX *_mem_save_forest_trust_info_0 = NULL;
	TALLOC_CTX *_mem_save_collision_info_0 = NULL;
	TALLOC_CTX *_mem_save_collision_info_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.trusted_domain_name);
		}
		_mem_save_trusted_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.trusted_domain_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.trusted_domain_name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trusted_domain_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_ForestTrustRecordType(ndr, NDR_SCALARS, &r->in.highest_record_type));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.forest_trust_info);
		}
		_mem_save_forest_trust_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.forest_trust_info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_ForestTrustInformation2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.forest_trust_info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_forest_trust_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.check_only));
		NDR_PULL_ALLOC(ndr, r->out.collision_info);
		NDR_ZERO_STRUCTP(r->out.collision_info);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
		if (r->in.trusted_domain_name == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.trusted_domain_name);
			NDR_ZERO_STRUCTP(r->in.trusted_domain_name);
		}
		if (r->in.forest_trust_info == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.forest_trust_info);
			NDR_ZERO_STRUCTP(r->in.forest_trust_info);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.collision_info);
		}
		_mem_save_collision_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.collision_info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_collision_info));
		if (_ptr_collision_info) {
			NDR_PULL_ALLOC(ndr, *r->out.collision_info);
		} else {
			*r->out.collision_info = NULL;
		}
		if (*r->out.collision_info) {
			_mem_save_collision_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.collision_info, 0);
			NDR_CHECK(ndr_pull_lsa_ForestTrustCollisionInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.collision_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_collision_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_collision_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_lsaRSetForestTrustInformation2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct lsa_lsaRSetForestTrustInformation2 *r)
{
	ndr_print_struct(ndr, name, "lsa_lsaRSetForestTrustInformation2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_lsaRSetForestTrustInformation2");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "trusted_domain_name", r->in.trusted_domain_name);
		ndr->depth++;
		ndr_print_lsa_StringLarge(ndr, "trusted_domain_name", r->in.trusted_domain_name);
		ndr->depth--;
		ndr_print_lsa_ForestTrustRecordType(ndr, "highest_record_type", r->in.highest_record_type);
		ndr_print_ptr(ndr, "forest_trust_info", r->in.forest_trust_info);
		ndr->depth++;
		ndr_print_lsa_ForestTrustInformation2(ndr, "forest_trust_info", r->in.forest_trust_info);
		ndr->depth--;
		ndr_print_uint8(ndr, "check_only", r->in.check_only);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_lsaRSetForestTrustInformation2");
		ndr->depth++;
		ndr_print_ptr(ndr, "collision_info", r->out.collision_info);
		ndr->depth++;
		ndr_print_ptr(ndr, "collision_info", *r->out.collision_info);
		ndr->depth++;
		if (*r->out.collision_info) {
			ndr_print_lsa_ForestTrustCollisionInfo(ndr, "collision_info", *r->out.collision_info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_lsarpc
static const struct ndr_interface_public_struct lsarpc_public_structs[] = {
	{
		.name = "lsa_String",
		.struct_size = sizeof(struct lsa_String ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_String,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_String,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_String,
	},
	{
		.name = "lsa_StringLarge",
		.struct_size = sizeof(struct lsa_StringLarge ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_StringLarge,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_StringLarge,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_StringLarge,
	},
	{
		.name = "lsa_Strings",
		.struct_size = sizeof(struct lsa_Strings ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_Strings,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_Strings,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_Strings,
	},
	{
		.name = "lsa_AsciiString",
		.struct_size = sizeof(struct lsa_AsciiString ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_AsciiString,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_AsciiString,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_AsciiString,
	},
	{
		.name = "lsa_AsciiStringLarge",
		.struct_size = sizeof(struct lsa_AsciiStringLarge ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_AsciiStringLarge,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_AsciiStringLarge,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_AsciiStringLarge,
	},
	{
		.name = "lsa_BinaryString",
		.struct_size = sizeof(struct lsa_BinaryString ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_BinaryString,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_BinaryString,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_BinaryString,
	},
	{
		.name = "lsa_DnsDomainInfo",
		.struct_size = sizeof(struct lsa_DnsDomainInfo ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_DnsDomainInfo,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_DnsDomainInfo,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_DnsDomainInfo,
	},
	{
		.name = "lsa_SidArray",
		.struct_size = sizeof(struct lsa_SidArray ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_SidArray,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_SidArray,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_SidArray,
	},
	{
		.name = "lsa_RefDomainList",
		.struct_size = sizeof(struct lsa_RefDomainList ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_RefDomainList,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_RefDomainList,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_RefDomainList,
	},
	{
		.name = "lsa_TransNameArray",
		.struct_size = sizeof(struct lsa_TransNameArray ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_TransNameArray,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_TransNameArray,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_TransNameArray,
	},
	{
		.name = "lsa_TrustDomainInfoInfoEx",
		.struct_size = sizeof(struct lsa_TrustDomainInfoInfoEx ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_TrustDomainInfoInfoEx,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_TrustDomainInfoInfoEx,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_TrustDomainInfoInfoEx,
	},
	{
		.name = "lsa_TrustDomainInfoAuthInfo",
		.struct_size = sizeof(struct lsa_TrustDomainInfoAuthInfo ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_TrustDomainInfoAuthInfo,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_TrustDomainInfoAuthInfo,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_TrustDomainInfoAuthInfo,
	},
	{
		.name = "lsa_ForestTrustInformation",
		.struct_size = sizeof(struct lsa_ForestTrustInformation ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_ForestTrustInformation,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_ForestTrustInformation,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_ForestTrustInformation,
	},
	{
		.name = "lsa_ForestTrustCollisionRecord",
		.struct_size = sizeof(struct lsa_ForestTrustCollisionRecord ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_ForestTrustCollisionRecord,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_ForestTrustCollisionRecord,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_ForestTrustCollisionRecord,
	},
	{
		.name = "lsa_ForestTrustCollisionInfo",
		.struct_size = sizeof(struct lsa_ForestTrustCollisionInfo ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_ForestTrustCollisionInfo,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_ForestTrustCollisionInfo,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_ForestTrustCollisionInfo,
	},
	{
		.name = "lsa_ForestTrustInformation2",
		.struct_size = sizeof(struct lsa_ForestTrustInformation2 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_ForestTrustInformation2,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_ForestTrustInformation2,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_ForestTrustInformation2,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call lsarpc_calls[] = {
	{
		"lsa_Close",
		sizeof(struct lsa_Close),
		(ndr_push_flags_fn_t) ndr_push_lsa_Close,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Close,
		(ndr_print_function_t) ndr_print_lsa_Close,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Delete",
		sizeof(struct lsa_Delete),
		(ndr_push_flags_fn_t) ndr_push_lsa_Delete,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Delete,
		(ndr_print_function_t) ndr_print_lsa_Delete,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_EnumPrivs",
		sizeof(struct lsa_EnumPrivs),
		(ndr_push_flags_fn_t) ndr_push_lsa_EnumPrivs,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_EnumPrivs,
		(ndr_print_function_t) ndr_print_lsa_EnumPrivs,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_QuerySecurity",
		sizeof(struct lsa_QuerySecurity),
		(ndr_push_flags_fn_t) ndr_push_lsa_QuerySecurity,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_QuerySecurity,
		(ndr_print_function_t) ndr_print_lsa_QuerySecurity,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_SetSecObj",
		sizeof(struct lsa_SetSecObj),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetSecObj,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetSecObj,
		(ndr_print_function_t) ndr_print_lsa_SetSecObj,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_ChangePassword",
		sizeof(struct lsa_ChangePassword),
		(ndr_push_flags_fn_t) ndr_push_lsa_ChangePassword,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_ChangePassword,
		(ndr_print_function_t) ndr_print_lsa_ChangePassword,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_OpenPolicy",
		sizeof(struct lsa_OpenPolicy),
		(ndr_push_flags_fn_t) ndr_push_lsa_OpenPolicy,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_OpenPolicy,
		(ndr_print_function_t) ndr_print_lsa_OpenPolicy,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_QueryInfoPolicy",
		sizeof(struct lsa_QueryInfoPolicy),
		(ndr_push_flags_fn_t) ndr_push_lsa_QueryInfoPolicy,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_QueryInfoPolicy,
		(ndr_print_function_t) ndr_print_lsa_QueryInfoPolicy,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_SetInfoPolicy",
		sizeof(struct lsa_SetInfoPolicy),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetInfoPolicy,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetInfoPolicy,
		(ndr_print_function_t) ndr_print_lsa_SetInfoPolicy,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_ClearAuditLog",
		sizeof(struct lsa_ClearAuditLog),
		(ndr_push_flags_fn_t) ndr_push_lsa_ClearAuditLog,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_ClearAuditLog,
		(ndr_print_function_t) ndr_print_lsa_ClearAuditLog,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CreateAccount",
		sizeof(struct lsa_CreateAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_CreateAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CreateAccount,
		(ndr_print_function_t) ndr_print_lsa_CreateAccount,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_EnumAccounts",
		sizeof(struct lsa_EnumAccounts),
		(ndr_push_flags_fn_t) ndr_push_lsa_EnumAccounts,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_EnumAccounts,
		(ndr_print_function_t) ndr_print_lsa_EnumAccounts,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CreateTrustedDomain",
		sizeof(struct lsa_CreateTrustedDomain),
		(ndr_push_flags_fn_t) ndr_push_lsa_CreateTrustedDomain,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CreateTrustedDomain,
		(ndr_print_function_t) ndr_print_lsa_CreateTrustedDomain,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_EnumTrustDom",
		sizeof(struct lsa_EnumTrustDom),
		(ndr_push_flags_fn_t) ndr_push_lsa_EnumTrustDom,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_EnumTrustDom,
		(ndr_print_function_t) ndr_print_lsa_EnumTrustDom,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LookupNames",
		sizeof(struct lsa_LookupNames),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupNames,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupNames,
		(ndr_print_function_t) ndr_print_lsa_LookupNames,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LookupSids",
		sizeof(struct lsa_LookupSids),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupSids,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupSids,
		(ndr_print_function_t) ndr_print_lsa_LookupSids,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CreateSecret",
		sizeof(struct lsa_CreateSecret),
		(ndr_push_flags_fn_t) ndr_push_lsa_CreateSecret,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CreateSecret,
		(ndr_print_function_t) ndr_print_lsa_CreateSecret,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_OpenAccount",
		sizeof(struct lsa_OpenAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_OpenAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_OpenAccount,
		(ndr_print_function_t) ndr_print_lsa_OpenAccount,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_EnumPrivsAccount",
		sizeof(struct lsa_EnumPrivsAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_EnumPrivsAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_EnumPrivsAccount,
		(ndr_print_function_t) ndr_print_lsa_EnumPrivsAccount,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_AddPrivilegesToAccount",
		sizeof(struct lsa_AddPrivilegesToAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_AddPrivilegesToAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_AddPrivilegesToAccount,
		(ndr_print_function_t) ndr_print_lsa_AddPrivilegesToAccount,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_RemovePrivilegesFromAccount",
		sizeof(struct lsa_RemovePrivilegesFromAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_RemovePrivilegesFromAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_RemovePrivilegesFromAccount,
		(ndr_print_function_t) ndr_print_lsa_RemovePrivilegesFromAccount,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_GetQuotasForAccount",
		sizeof(struct lsa_GetQuotasForAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_GetQuotasForAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_GetQuotasForAccount,
		(ndr_print_function_t) ndr_print_lsa_GetQuotasForAccount,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_SetQuotasForAccount",
		sizeof(struct lsa_SetQuotasForAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetQuotasForAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetQuotasForAccount,
		(ndr_print_function_t) ndr_print_lsa_SetQuotasForAccount,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_GetSystemAccessAccount",
		sizeof(struct lsa_GetSystemAccessAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_GetSystemAccessAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_GetSystemAccessAccount,
		(ndr_print_function_t) ndr_print_lsa_GetSystemAccessAccount,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_SetSystemAccessAccount",
		sizeof(struct lsa_SetSystemAccessAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetSystemAccessAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetSystemAccessAccount,
		(ndr_print_function_t) ndr_print_lsa_SetSystemAccessAccount,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_OpenTrustedDomain",
		sizeof(struct lsa_OpenTrustedDomain),
		(ndr_push_flags_fn_t) ndr_push_lsa_OpenTrustedDomain,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_OpenTrustedDomain,
		(ndr_print_function_t) ndr_print_lsa_OpenTrustedDomain,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_QueryTrustedDomainInfo",
		sizeof(struct lsa_QueryTrustedDomainInfo),
		(ndr_push_flags_fn_t) ndr_push_lsa_QueryTrustedDomainInfo,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_QueryTrustedDomainInfo,
		(ndr_print_function_t) ndr_print_lsa_QueryTrustedDomainInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_SetInformationTrustedDomain",
		sizeof(struct lsa_SetInformationTrustedDomain),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetInformationTrustedDomain,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetInformationTrustedDomain,
		(ndr_print_function_t) ndr_print_lsa_SetInformationTrustedDomain,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_OpenSecret",
		sizeof(struct lsa_OpenSecret),
		(ndr_push_flags_fn_t) ndr_push_lsa_OpenSecret,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_OpenSecret,
		(ndr_print_function_t) ndr_print_lsa_OpenSecret,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_SetSecret",
		sizeof(struct lsa_SetSecret),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetSecret,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetSecret,
		(ndr_print_function_t) ndr_print_lsa_SetSecret,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_QuerySecret",
		sizeof(struct lsa_QuerySecret),
		(ndr_push_flags_fn_t) ndr_push_lsa_QuerySecret,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_QuerySecret,
		(ndr_print_function_t) ndr_print_lsa_QuerySecret,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LookupPrivValue",
		sizeof(struct lsa_LookupPrivValue),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupPrivValue,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupPrivValue,
		(ndr_print_function_t) ndr_print_lsa_LookupPrivValue,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LookupPrivName",
		sizeof(struct lsa_LookupPrivName),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupPrivName,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupPrivName,
		(ndr_print_function_t) ndr_print_lsa_LookupPrivName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LookupPrivDisplayName",
		sizeof(struct lsa_LookupPrivDisplayName),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupPrivDisplayName,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupPrivDisplayName,
		(ndr_print_function_t) ndr_print_lsa_LookupPrivDisplayName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_DeleteObject",
		sizeof(struct lsa_DeleteObject),
		(ndr_push_flags_fn_t) ndr_push_lsa_DeleteObject,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_DeleteObject,
		(ndr_print_function_t) ndr_print_lsa_DeleteObject,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_EnumAccountsWithUserRight",
		sizeof(struct lsa_EnumAccountsWithUserRight),
		(ndr_push_flags_fn_t) ndr_push_lsa_EnumAccountsWithUserRight,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_EnumAccountsWithUserRight,
		(ndr_print_function_t) ndr_print_lsa_EnumAccountsWithUserRight,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_EnumAccountRights",
		sizeof(struct lsa_EnumAccountRights),
		(ndr_push_flags_fn_t) ndr_push_lsa_EnumAccountRights,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_EnumAccountRights,
		(ndr_print_function_t) ndr_print_lsa_EnumAccountRights,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_AddAccountRights",
		sizeof(struct lsa_AddAccountRights),
		(ndr_push_flags_fn_t) ndr_push_lsa_AddAccountRights,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_AddAccountRights,
		(ndr_print_function_t) ndr_print_lsa_AddAccountRights,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_RemoveAccountRights",
		sizeof(struct lsa_RemoveAccountRights),
		(ndr_push_flags_fn_t) ndr_push_lsa_RemoveAccountRights,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_RemoveAccountRights,
		(ndr_print_function_t) ndr_print_lsa_RemoveAccountRights,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_QueryTrustedDomainInfoBySid",
		sizeof(struct lsa_QueryTrustedDomainInfoBySid),
		(ndr_push_flags_fn_t) ndr_push_lsa_QueryTrustedDomainInfoBySid,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_QueryTrustedDomainInfoBySid,
		(ndr_print_function_t) ndr_print_lsa_QueryTrustedDomainInfoBySid,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_SetTrustedDomainInfo",
		sizeof(struct lsa_SetTrustedDomainInfo),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetTrustedDomainInfo,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetTrustedDomainInfo,
		(ndr_print_function_t) ndr_print_lsa_SetTrustedDomainInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_DeleteTrustedDomain",
		sizeof(struct lsa_DeleteTrustedDomain),
		(ndr_push_flags_fn_t) ndr_push_lsa_DeleteTrustedDomain,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_DeleteTrustedDomain,
		(ndr_print_function_t) ndr_print_lsa_DeleteTrustedDomain,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_StorePrivateData",
		sizeof(struct lsa_StorePrivateData),
		(ndr_push_flags_fn_t) ndr_push_lsa_StorePrivateData,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_StorePrivateData,
		(ndr_print_function_t) ndr_print_lsa_StorePrivateData,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_RetrievePrivateData",
		sizeof(struct lsa_RetrievePrivateData),
		(ndr_push_flags_fn_t) ndr_push_lsa_RetrievePrivateData,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_RetrievePrivateData,
		(ndr_print_function_t) ndr_print_lsa_RetrievePrivateData,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_OpenPolicy2",
		sizeof(struct lsa_OpenPolicy2),
		(ndr_push_flags_fn_t) ndr_push_lsa_OpenPolicy2,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_OpenPolicy2,
		(ndr_print_function_t) ndr_print_lsa_OpenPolicy2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_GetUserName",
		sizeof(struct lsa_GetUserName),
		(ndr_push_flags_fn_t) ndr_push_lsa_GetUserName,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_GetUserName,
		(ndr_print_function_t) ndr_print_lsa_GetUserName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_QueryInfoPolicy2",
		sizeof(struct lsa_QueryInfoPolicy2),
		(ndr_push_flags_fn_t) ndr_push_lsa_QueryInfoPolicy2,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_QueryInfoPolicy2,
		(ndr_print_function_t) ndr_print_lsa_QueryInfoPolicy2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_SetInfoPolicy2",
		sizeof(struct lsa_SetInfoPolicy2),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetInfoPolicy2,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetInfoPolicy2,
		(ndr_print_function_t) ndr_print_lsa_SetInfoPolicy2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_QueryTrustedDomainInfoByName",
		sizeof(struct lsa_QueryTrustedDomainInfoByName),
		(ndr_push_flags_fn_t) ndr_push_lsa_QueryTrustedDomainInfoByName,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_QueryTrustedDomainInfoByName,
		(ndr_print_function_t) ndr_print_lsa_QueryTrustedDomainInfoByName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_SetTrustedDomainInfoByName",
		sizeof(struct lsa_SetTrustedDomainInfoByName),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetTrustedDomainInfoByName,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetTrustedDomainInfoByName,
		(ndr_print_function_t) ndr_print_lsa_SetTrustedDomainInfoByName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_EnumTrustedDomainsEx",
		sizeof(struct lsa_EnumTrustedDomainsEx),
		(ndr_push_flags_fn_t) ndr_push_lsa_EnumTrustedDomainsEx,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_EnumTrustedDomainsEx,
		(ndr_print_function_t) ndr_print_lsa_EnumTrustedDomainsEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CreateTrustedDomainEx",
		sizeof(struct lsa_CreateTrustedDomainEx),
		(ndr_push_flags_fn_t) ndr_push_lsa_CreateTrustedDomainEx,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CreateTrustedDomainEx,
		(ndr_print_function_t) ndr_print_lsa_CreateTrustedDomainEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CloseTrustedDomainEx",
		sizeof(struct lsa_CloseTrustedDomainEx),
		(ndr_push_flags_fn_t) ndr_push_lsa_CloseTrustedDomainEx,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CloseTrustedDomainEx,
		(ndr_print_function_t) ndr_print_lsa_CloseTrustedDomainEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_QueryDomainInformationPolicy",
		sizeof(struct lsa_QueryDomainInformationPolicy),
		(ndr_push_flags_fn_t) ndr_push_lsa_QueryDomainInformationPolicy,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_QueryDomainInformationPolicy,
		(ndr_print_function_t) ndr_print_lsa_QueryDomainInformationPolicy,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_SetDomainInformationPolicy",
		sizeof(struct lsa_SetDomainInformationPolicy),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetDomainInformationPolicy,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetDomainInformationPolicy,
		(ndr_print_function_t) ndr_print_lsa_SetDomainInformationPolicy,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_OpenTrustedDomainByName",
		sizeof(struct lsa_OpenTrustedDomainByName),
		(ndr_push_flags_fn_t) ndr_push_lsa_OpenTrustedDomainByName,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_OpenTrustedDomainByName,
		(ndr_print_function_t) ndr_print_lsa_OpenTrustedDomainByName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_TestCall",
		sizeof(struct lsa_TestCall),
		(ndr_push_flags_fn_t) ndr_push_lsa_TestCall,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_TestCall,
		(ndr_print_function_t) ndr_print_lsa_TestCall,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LookupSids2",
		sizeof(struct lsa_LookupSids2),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupSids2,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupSids2,
		(ndr_print_function_t) ndr_print_lsa_LookupSids2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LookupNames2",
		sizeof(struct lsa_LookupNames2),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupNames2,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupNames2,
		(ndr_print_function_t) ndr_print_lsa_LookupNames2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CreateTrustedDomainEx2",
		sizeof(struct lsa_CreateTrustedDomainEx2),
		(ndr_push_flags_fn_t) ndr_push_lsa_CreateTrustedDomainEx2,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CreateTrustedDomainEx2,
		(ndr_print_function_t) ndr_print_lsa_CreateTrustedDomainEx2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CREDRWRITE",
		sizeof(struct lsa_CREDRWRITE),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRWRITE,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRWRITE,
		(ndr_print_function_t) ndr_print_lsa_CREDRWRITE,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CREDRREAD",
		sizeof(struct lsa_CREDRREAD),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRREAD,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRREAD,
		(ndr_print_function_t) ndr_print_lsa_CREDRREAD,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CREDRENUMERATE",
		sizeof(struct lsa_CREDRENUMERATE),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRENUMERATE,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRENUMERATE,
		(ndr_print_function_t) ndr_print_lsa_CREDRENUMERATE,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CREDRWRITEDOMAINCREDENTIALS",
		sizeof(struct lsa_CREDRWRITEDOMAINCREDENTIALS),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRWRITEDOMAINCREDENTIALS,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRWRITEDOMAINCREDENTIALS,
		(ndr_print_function_t) ndr_print_lsa_CREDRWRITEDOMAINCREDENTIALS,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CREDRREADDOMAINCREDENTIALS",
		sizeof(struct lsa_CREDRREADDOMAINCREDENTIALS),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRREADDOMAINCREDENTIALS,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRREADDOMAINCREDENTIALS,
		(ndr_print_function_t) ndr_print_lsa_CREDRREADDOMAINCREDENTIALS,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CREDRDELETE",
		sizeof(struct lsa_CREDRDELETE),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRDELETE,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRDELETE,
		(ndr_print_function_t) ndr_print_lsa_CREDRDELETE,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CREDRGETTARGETINFO",
		sizeof(struct lsa_CREDRGETTARGETINFO),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRGETTARGETINFO,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRGETTARGETINFO,
		(ndr_print_function_t) ndr_print_lsa_CREDRGETTARGETINFO,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CREDRPROFILELOADED",
		sizeof(struct lsa_CREDRPROFILELOADED),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRPROFILELOADED,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRPROFILELOADED,
		(ndr_print_function_t) ndr_print_lsa_CREDRPROFILELOADED,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LookupNames3",
		sizeof(struct lsa_LookupNames3),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupNames3,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupNames3,
		(ndr_print_function_t) ndr_print_lsa_LookupNames3,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CREDRGETSESSIONTYPES",
		sizeof(struct lsa_CREDRGETSESSIONTYPES),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRGETSESSIONTYPES,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRGETSESSIONTYPES,
		(ndr_print_function_t) ndr_print_lsa_CREDRGETSESSIONTYPES,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LSARREGISTERAUDITEVENT",
		sizeof(struct lsa_LSARREGISTERAUDITEVENT),
		(ndr_push_flags_fn_t) ndr_push_lsa_LSARREGISTERAUDITEVENT,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LSARREGISTERAUDITEVENT,
		(ndr_print_function_t) ndr_print_lsa_LSARREGISTERAUDITEVENT,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LSARGENAUDITEVENT",
		sizeof(struct lsa_LSARGENAUDITEVENT),
		(ndr_push_flags_fn_t) ndr_push_lsa_LSARGENAUDITEVENT,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LSARGENAUDITEVENT,
		(ndr_print_function_t) ndr_print_lsa_LSARGENAUDITEVENT,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LSARUNREGISTERAUDITEVENT",
		sizeof(struct lsa_LSARUNREGISTERAUDITEVENT),
		(ndr_push_flags_fn_t) ndr_push_lsa_LSARUNREGISTERAUDITEVENT,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LSARUNREGISTERAUDITEVENT,
		(ndr_print_function_t) ndr_print_lsa_LSARUNREGISTERAUDITEVENT,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_lsaRQueryForestTrustInformation",
		sizeof(struct lsa_lsaRQueryForestTrustInformation),
		(ndr_push_flags_fn_t) ndr_push_lsa_lsaRQueryForestTrustInformation,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_lsaRQueryForestTrustInformation,
		(ndr_print_function_t) ndr_print_lsa_lsaRQueryForestTrustInformation,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_lsaRSetForestTrustInformation",
		sizeof(struct lsa_lsaRSetForestTrustInformation),
		(ndr_push_flags_fn_t) ndr_push_lsa_lsaRSetForestTrustInformation,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_lsaRSetForestTrustInformation,
		(ndr_print_function_t) ndr_print_lsa_lsaRSetForestTrustInformation,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CREDRRENAME",
		sizeof(struct lsa_CREDRRENAME),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRRENAME,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRRENAME,
		(ndr_print_function_t) ndr_print_lsa_CREDRRENAME,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LookupSids3",
		sizeof(struct lsa_LookupSids3),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupSids3,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupSids3,
		(ndr_print_function_t) ndr_print_lsa_LookupSids3,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LookupNames4",
		sizeof(struct lsa_LookupNames4),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupNames4,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupNames4,
		(ndr_print_function_t) ndr_print_lsa_LookupNames4,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LSAROPENPOLICYSCE",
		sizeof(struct lsa_LSAROPENPOLICYSCE),
		(ndr_push_flags_fn_t) ndr_push_lsa_LSAROPENPOLICYSCE,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LSAROPENPOLICYSCE,
		(ndr_print_function_t) ndr_print_lsa_LSAROPENPOLICYSCE,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LSARADTREGISTERSECURITYEVENTSOURCE",
		sizeof(struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE),
		(ndr_push_flags_fn_t) ndr_push_lsa_LSARADTREGISTERSECURITYEVENTSOURCE,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LSARADTREGISTERSECURITYEVENTSOURCE,
		(ndr_print_function_t) ndr_print_lsa_LSARADTREGISTERSECURITYEVENTSOURCE,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE",
		sizeof(struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE),
		(ndr_push_flags_fn_t) ndr_push_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE,
		(ndr_print_function_t) ndr_print_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_LSARADTREPORTSECURITYEVENT",
		sizeof(struct lsa_LSARADTREPORTSECURITYEVENT),
		(ndr_push_flags_fn_t) ndr_push_lsa_LSARADTREPORTSECURITYEVENT,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LSARADTREPORTSECURITYEVENT,
		(ndr_print_function_t) ndr_print_lsa_LSARADTREPORTSECURITYEVENT,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum82NotUsedOnWire",
		sizeof(struct lsa_Opnum82NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum82NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum82NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum82NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum83NotUsedOnWire",
		sizeof(struct lsa_Opnum83NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum83NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum83NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum83NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum84NotUsedOnWire",
		sizeof(struct lsa_Opnum84NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum84NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum84NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum84NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum85NotUsedOnWire",
		sizeof(struct lsa_Opnum85NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum85NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum85NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum85NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum86NotUsedOnWire",
		sizeof(struct lsa_Opnum86NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum86NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum86NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum86NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum87NotUsedOnWire",
		sizeof(struct lsa_Opnum87NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum87NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum87NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum87NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum88NotUsedOnWire",
		sizeof(struct lsa_Opnum88NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum88NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum88NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum88NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum89NotUsedOnWire",
		sizeof(struct lsa_Opnum89NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum89NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum89NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum89NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum90NotUsedOnWire",
		sizeof(struct lsa_Opnum90NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum90NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum90NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum90NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum91NotUsedOnWire",
		sizeof(struct lsa_Opnum91NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum91NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum91NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum91NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum92NotUsedOnWire",
		sizeof(struct lsa_Opnum92NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum92NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum92NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum92NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum93NotUsedOnWire",
		sizeof(struct lsa_Opnum93NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum93NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum93NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum93NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum94NotUsedOnWire",
		sizeof(struct lsa_Opnum94NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum94NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum94NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum94NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum95NotUsedOnWire",
		sizeof(struct lsa_Opnum95NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum95NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum95NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum95NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum96NotUsedOnWire",
		sizeof(struct lsa_Opnum96NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum96NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum96NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum96NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum97NotUsedOnWire",
		sizeof(struct lsa_Opnum97NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum97NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum97NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum97NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum98NotUsedOnWire",
		sizeof(struct lsa_Opnum98NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum98NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum98NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum98NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum99NotUsedOnWire",
		sizeof(struct lsa_Opnum99NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum99NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum99NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum99NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum100NotUsedOnWire",
		sizeof(struct lsa_Opnum100NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum100NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum100NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum100NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum101NotUsedOnWire",
		sizeof(struct lsa_Opnum101NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum101NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum101NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum101NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum102NotUsedOnWire",
		sizeof(struct lsa_Opnum102NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum102NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum102NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum102NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum103NotUsedOnWire",
		sizeof(struct lsa_Opnum103NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum103NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum103NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum103NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum104NotUsedOnWire",
		sizeof(struct lsa_Opnum104NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum104NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum104NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum104NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum105NotUsedOnWire",
		sizeof(struct lsa_Opnum105NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum105NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum105NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum105NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum106NotUsedOnWire",
		sizeof(struct lsa_Opnum106NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum106NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum106NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum106NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum107NotUsedOnWire",
		sizeof(struct lsa_Opnum107NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum107NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum107NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum107NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum108NotUsedOnWire",
		sizeof(struct lsa_Opnum108NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum108NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum108NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum108NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum109NotUsedOnWire",
		sizeof(struct lsa_Opnum109NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum109NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum109NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum109NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum110NotUsedOnWire",
		sizeof(struct lsa_Opnum110NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum110NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum110NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum110NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum111NotUsedOnWire",
		sizeof(struct lsa_Opnum111NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum111NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum111NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum111NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum112NotUsedOnWire",
		sizeof(struct lsa_Opnum112NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum112NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum112NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum112NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum113NotUsedOnWire",
		sizeof(struct lsa_Opnum113NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum113NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum113NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum113NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum114NotUsedOnWire",
		sizeof(struct lsa_Opnum114NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum114NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum114NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum114NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum115NotUsedOnWire",
		sizeof(struct lsa_Opnum115NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum115NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum115NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum115NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum116NotUsedOnWire",
		sizeof(struct lsa_Opnum116NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum116NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum116NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum116NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum117NotUsedOnWire",
		sizeof(struct lsa_Opnum117NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum117NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum117NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum117NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum118NotUsedOnWire",
		sizeof(struct lsa_Opnum118NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum118NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum118NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum118NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum119NotUsedOnWire",
		sizeof(struct lsa_Opnum119NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum119NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum119NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum119NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum120NotUsedOnWire",
		sizeof(struct lsa_Opnum120NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum120NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum120NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum120NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum121NotUsedOnWire",
		sizeof(struct lsa_Opnum121NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum121NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum121NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum121NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum122NotUsedOnWire",
		sizeof(struct lsa_Opnum122NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum122NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum122NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum122NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum123NotUsedOnWire",
		sizeof(struct lsa_Opnum123NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum123NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum123NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum123NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum124NotUsedOnWire",
		sizeof(struct lsa_Opnum124NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum124NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum124NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum124NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum125NotUsedOnWire",
		sizeof(struct lsa_Opnum125NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum125NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum125NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum125NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum126NotUsedOnWire",
		sizeof(struct lsa_Opnum126NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum126NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum126NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum126NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum127NotUsedOnWire",
		sizeof(struct lsa_Opnum127NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum127NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum127NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum127NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum128NotUsedOnWire",
		sizeof(struct lsa_Opnum128NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum128NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum128NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum128NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_CreateTrustedDomainEx3",
		sizeof(struct lsa_CreateTrustedDomainEx3),
		(ndr_push_flags_fn_t) ndr_push_lsa_CreateTrustedDomainEx3,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CreateTrustedDomainEx3,
		(ndr_print_function_t) ndr_print_lsa_CreateTrustedDomainEx3,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_OpenPolicy3",
		sizeof(struct lsa_OpenPolicy3),
		(ndr_push_flags_fn_t) ndr_push_lsa_OpenPolicy3,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_OpenPolicy3,
		(ndr_print_function_t) ndr_print_lsa_OpenPolicy3,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_Opnum131NotUsedOnWire",
		sizeof(struct lsa_Opnum131NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_lsa_Opnum131NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Opnum131NotUsedOnWire,
		(ndr_print_function_t) ndr_print_lsa_Opnum131NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_lsaRQueryForestTrustInformation2",
		sizeof(struct lsa_lsaRQueryForestTrustInformation2),
		(ndr_push_flags_fn_t) ndr_push_lsa_lsaRQueryForestTrustInformation2,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_lsaRQueryForestTrustInformation2,
		(ndr_print_function_t) ndr_print_lsa_lsaRQueryForestTrustInformation2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"lsa_lsaRSetForestTrustInformation2",
		sizeof(struct lsa_lsaRSetForestTrustInformation2),
		(ndr_push_flags_fn_t) ndr_push_lsa_lsaRSetForestTrustInformation2,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_lsaRSetForestTrustInformation2,
		(ndr_print_function_t) ndr_print_lsa_lsaRSetForestTrustInformation2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ .name = NULL }
};

static const char * const lsarpc_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\lsarpc]", 
	"ncacn_np:[\\pipe\\lsass]", 
	"ncacn_ip_tcp:", 
	"ncalrpc:", 
};

static const struct ndr_interface_string_array lsarpc_endpoints = {
	.count	= 4,
	.names	= lsarpc_endpoint_strings
};

static const char * const lsarpc_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array lsarpc_authservices = {
	.count	= 1,
	.names	= lsarpc_authservice_strings
};


const struct ndr_interface_table ndr_table_lsarpc = {
	.name		= "lsarpc",
	.syntax_id	= {
		{0x12345778,0x1234,0xabcd,{0xef,0x00},{0x01,0x23,0x45,0x67,0x89,0xab}},
		NDR_LSARPC_VERSION
	},
	.helpstring	= NDR_LSARPC_HELPSTRING,
	.num_calls	= 134,
	.calls		= lsarpc_calls,
	.num_public_structs	= 16,
	.public_structs		= lsarpc_public_structs,
	.endpoints	= &lsarpc_endpoints,
	.authservices	= &lsarpc_authservices
};

#endif /* SKIP_NDR_TABLE_lsarpc */
