/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/source4/librpc/gen_ndr/ndr_irpc.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_nbt.h"
#include "librpc/gen_ndr/ndr_netlogon.h"
#include "librpc/gen_ndr/ndr_server_id.h"
static enum ndr_err_code ndr_push_irpc_flags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_irpc_flags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_irpc_flags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "IRPC_FLAG_REPLY", IRPC_FLAG_REPLY, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_irpc_creds(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct irpc_creds *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->token));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->token) {
			NDR_CHECK(ndr_push_security_token(ndr, NDR_SCALARS|NDR_BUFFERS, r->token));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_irpc_creds(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct irpc_creds *r)
{
	uint32_t _ptr_token;
	TALLOC_CTX *_mem_save_token_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_token));
		if (_ptr_token) {
			NDR_PULL_ALLOC(ndr, r->token);
		} else {
			r->token = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->token) {
			_mem_save_token_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->token, 0);
			NDR_CHECK(ndr_pull_security_token(ndr, NDR_SCALARS|NDR_BUFFERS, r->token));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_token_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_irpc_creds(struct ndr_print *ndr, const char *name, const struct irpc_creds *r)
{
	ndr_print_struct(ndr, name, "irpc_creds");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "token", r->token);
	ndr->depth++;
	if (r->token) {
		ndr_print_security_token(ndr, "token", r->token);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_irpc_header(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct irpc_header *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->uuid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->if_version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->callnum));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->callid));
		NDR_CHECK(ndr_push_irpc_flags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->status));
		{
			struct ndr_push *_ndr_creds;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_creds, 4, -1));
			NDR_CHECK(ndr_push_irpc_creds(_ndr_creds, NDR_SCALARS|NDR_BUFFERS, &r->creds));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_creds, 4, -1));
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_irpc_header(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct irpc_header *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->uuid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->if_version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->callnum));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->callid));
		NDR_CHECK(ndr_pull_irpc_flags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->status));
		{
			struct ndr_pull *_ndr_creds;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_creds, 4, sub_size));
			NDR_CHECK(ndr_pull_irpc_creds(_ndr_creds, NDR_SCALARS|NDR_BUFFERS, &r->creds));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_creds, 4, sub_size));
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_irpc_header(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct irpc_header *r)
{
	ndr_print_irpc_header(ndr, name, r);
}

_PUBLIC_ void ndr_print_irpc_header(struct ndr_print *ndr, const char *name, const struct irpc_header *r)
{
	ndr_print_struct(ndr, name, "irpc_header");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "uuid", &r->uuid);
	ndr_print_uint32(ndr, "if_version", r->if_version);
	ndr_print_uint32(ndr, "callnum", r->callnum);
	ndr_print_uint32(ndr, "callid", r->callid);
	ndr_print_irpc_flags(ndr, "flags", r->flags);
	ndr_print_NTSTATUS(ndr, "status", r->status);
	ndr_print_irpc_creds(ndr, "creds", &r->creds);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
		ndr_print_DATA_BLOB(ndr, "_pad", r->_pad);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_irpc_name_record(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct irpc_name_record *r)
{
	uint32_t cntr_ids_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 8));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_UTF8|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		for (cntr_ids_0 = 0; cntr_ids_0 < (r->count); cntr_ids_0++) {
			NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->ids[cntr_ids_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_irpc_name_record(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct irpc_name_record *r)
{
	uint32_t size_ids_0 = 0;
	uint32_t cntr_ids_0;
	TALLOC_CTX *_mem_save_ids_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->ids));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_UTF8|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->ids, &size_ids_0));
		NDR_PULL_ALLOC_N(ndr, r->ids, size_ids_0);
		_mem_save_ids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->ids, 0);
		for (cntr_ids_0 = 0; cntr_ids_0 < (size_ids_0); cntr_ids_0++) {
			NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->ids[cntr_ids_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ids_0, 0);
		if (r->ids) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->ids, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_irpc_name_record(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct irpc_name_record *r)
{
	ndr_print_irpc_name_record(ndr, name, r);
}

_PUBLIC_ void ndr_print_irpc_name_record(struct ndr_print *ndr, const char *name, const struct irpc_name_record *r)
{
	uint32_t cntr_ids_0;
	ndr_print_struct(ndr, name, "irpc_name_record");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_UTF8|LIBNDR_FLAG_STR_NULLTERM);
		ndr_print_string(ndr, "name", r->name);
		ndr->flags = _flags_save_string;
	}
	ndr_print_uint32(ndr, "count", r->count);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "ids", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_ids_0 = 0; cntr_ids_0 < (r->count); cntr_ids_0++) {
		ndr_print_server_id(ndr, "ids", &r->ids[cntr_ids_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_irpc_name_records(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct irpc_name_records *r)
{
	uint32_t cntr_names_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_records));
		for (cntr_names_0 = 0; cntr_names_0 < (r->num_records); cntr_names_0++) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->names[cntr_names_0]));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_records));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_names_0 = 0; cntr_names_0 < (r->num_records); cntr_names_0++) {
			if (r->names[cntr_names_0]) {
				NDR_CHECK(ndr_push_irpc_name_record(ndr, NDR_SCALARS, r->names[cntr_names_0]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_irpc_name_records(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct irpc_name_records *r)
{
	uint32_t _ptr_names;
	uint32_t size_names_0 = 0;
	uint32_t cntr_names_0;
	TALLOC_CTX *_mem_save_names_0 = NULL;
	TALLOC_CTX *_mem_save_names_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->names));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->names, &size_names_0));
		NDR_PULL_ALLOC_N(ndr, r->names, size_names_0);
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
		for (cntr_names_0 = 0; cntr_names_0 < (size_names_0); cntr_names_0++) {
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_names));
			if (_ptr_names) {
				NDR_PULL_ALLOC(ndr, r->names[cntr_names_0]);
			} else {
				r->names[cntr_names_0] = NULL;
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_records));
		if (r->names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->names, r->num_records));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->names, &size_names_0));
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
		for (cntr_names_0 = 0; cntr_names_0 < (size_names_0); cntr_names_0++) {
			if (r->names[cntr_names_0]) {
				_mem_save_names_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->names[cntr_names_0], 0);
				NDR_CHECK(ndr_pull_irpc_name_record(ndr, NDR_SCALARS, r->names[cntr_names_0]));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_1, 0);
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		for (cntr_names_0 = 0; cntr_names_0 < (size_names_0); cntr_names_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_irpc_name_records(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct irpc_name_records *r)
{
	ndr_print_irpc_name_records(ndr, name, r);
}

_PUBLIC_ void ndr_print_irpc_name_records(struct ndr_print *ndr, const char *name, const struct irpc_name_records *r)
{
	uint32_t cntr_names_0;
	ndr_print_struct(ndr, name, "irpc_name_records");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "names", (uint32_t)(r->num_records));
	ndr->depth++;
	for (cntr_names_0 = 0; cntr_names_0 < (r->num_records); cntr_names_0++) {
		ndr_print_ptr(ndr, "names", r->names[cntr_names_0]);
		ndr->depth++;
		if (r->names[cntr_names_0]) {
			ndr_print_irpc_name_record(ndr, "names", r->names[cntr_names_0]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "num_records", r->num_records);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbtd_info_level(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum nbtd_info_level r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbtd_info_level(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum nbtd_info_level *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbtd_info_level(struct ndr_print *ndr, const char *name, enum nbtd_info_level r)
{
	const char *val = NULL;

	switch (r) {
		case NBTD_INFO_STATISTICS: val = "NBTD_INFO_STATISTICS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_nbtd_statistics(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct nbtd_statistics *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->total_received));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->total_sent));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->query_count));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->register_count));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->release_count));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbtd_statistics(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct nbtd_statistics *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->total_received));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->total_sent));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->query_count));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->register_count));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->release_count));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbtd_statistics(struct ndr_print *ndr, const char *name, const struct nbtd_statistics *r)
{
	ndr_print_struct(ndr, name, "nbtd_statistics");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "total_received", r->total_received);
	ndr_print_hyper(ndr, "total_sent", r->total_sent);
	ndr_print_hyper(ndr, "query_count", r->query_count);
	ndr_print_hyper(ndr, "register_count", r->register_count);
	ndr_print_hyper(ndr, "release_count", r->release_count);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbtd_info(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union nbtd_info *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_nbtd_info_level(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case NBTD_INFO_STATISTICS: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->stats));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case NBTD_INFO_STATISTICS:
				if (r->stats) {
					NDR_CHECK(ndr_push_nbtd_statistics(ndr, NDR_SCALARS, r->stats));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbtd_info(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union nbtd_info *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_stats_0 = NULL;
	uint32_t _ptr_stats;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case NBTD_INFO_STATISTICS: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_stats));
				if (_ptr_stats) {
					NDR_PULL_ALLOC(ndr, r->stats);
				} else {
					r->stats = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case NBTD_INFO_STATISTICS:
				if (r->stats) {
					_mem_save_stats_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->stats, 0);
					NDR_CHECK(ndr_pull_nbtd_statistics(ndr, NDR_SCALARS, r->stats));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_stats_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbtd_info(struct ndr_print *ndr, const char *name, const union nbtd_info *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "nbtd_info");
	switch (level) {
		case NBTD_INFO_STATISTICS:
			ndr_print_ptr(ndr, "stats", r->stats);
			ndr->depth++;
			if (r->stats) {
				ndr_print_nbtd_statistics(ndr, "stats", r->stats);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_nbtd_proxy_wins_addr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct nbtd_proxy_wins_addr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->addr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbtd_proxy_wins_addr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct nbtd_proxy_wins_addr *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->addr));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbtd_proxy_wins_addr(struct ndr_print *ndr, const char *name, const struct nbtd_proxy_wins_addr *r)
{
	ndr_print_struct(ndr, name, "nbtd_proxy_wins_addr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ipv4address(ndr, "addr", r->addr);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbsrv_info_level(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum smbsrv_info_level r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbsrv_info_level(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum smbsrv_info_level *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbsrv_info_level(struct ndr_print *ndr, const char *name, enum smbsrv_info_level r)
{
	const char *val = NULL;

	switch (r) {
		case SMBSRV_INFO_SESSIONS: val = "SMBSRV_INFO_SESSIONS"; break;
		case SMBSRV_INFO_TCONS: val = "SMBSRV_INFO_TCONS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_smbsrv_session_info(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbsrv_session_info *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->vuid));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->account_name));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->domain_name));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->client_ip));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->connect_time));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->auth_time));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_use_time));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbsrv_session_info(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbsrv_session_info *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->vuid));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->account_name));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->domain_name));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->client_ip));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->connect_time));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->auth_time));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_use_time));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbsrv_session_info(struct ndr_print *ndr, const char *name, const struct smbsrv_session_info *r)
{
	ndr_print_struct(ndr, name, "smbsrv_session_info");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "vuid", r->vuid);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
		ndr_print_string(ndr, "account_name", r->account_name);
		ndr->flags = _flags_save_string;
	}
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
		ndr_print_string(ndr, "domain_name", r->domain_name);
		ndr->flags = _flags_save_string;
	}
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
		ndr_print_string(ndr, "client_ip", r->client_ip);
		ndr->flags = _flags_save_string;
	}
	ndr_print_NTTIME(ndr, "connect_time", r->connect_time);
	ndr_print_NTTIME(ndr, "auth_time", r->auth_time);
	ndr_print_NTTIME(ndr, "last_use_time", r->last_use_time);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbsrv_sessions(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbsrv_sessions *r)
{
	uint32_t cntr_sessions_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_sessions));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sessions));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sessions) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_sessions));
			for (cntr_sessions_1 = 0; cntr_sessions_1 < (r->num_sessions); cntr_sessions_1++) {
				NDR_CHECK(ndr_push_smbsrv_session_info(ndr, NDR_SCALARS, &r->sessions[cntr_sessions_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbsrv_sessions(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbsrv_sessions *r)
{
	uint32_t _ptr_sessions;
	uint32_t size_sessions_1 = 0;
	uint32_t cntr_sessions_1;
	TALLOC_CTX *_mem_save_sessions_0 = NULL;
	TALLOC_CTX *_mem_save_sessions_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_sessions));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sessions));
		if (_ptr_sessions) {
			NDR_PULL_ALLOC(ndr, r->sessions);
		} else {
			r->sessions = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sessions) {
			_mem_save_sessions_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sessions, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sessions));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->sessions, &size_sessions_1));
			NDR_PULL_ALLOC_N(ndr, r->sessions, size_sessions_1);
			_mem_save_sessions_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sessions, 0);
			for (cntr_sessions_1 = 0; cntr_sessions_1 < (size_sessions_1); cntr_sessions_1++) {
				NDR_CHECK(ndr_pull_smbsrv_session_info(ndr, NDR_SCALARS, &r->sessions[cntr_sessions_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sessions_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sessions_0, 0);
		}
		if (r->sessions) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->sessions, r->num_sessions));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbsrv_sessions(struct ndr_print *ndr, const char *name, const struct smbsrv_sessions *r)
{
	uint32_t cntr_sessions_1;
	ndr_print_struct(ndr, name, "smbsrv_sessions");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_sessions", r->num_sessions);
	ndr_print_ptr(ndr, "sessions", r->sessions);
	ndr->depth++;
	if (r->sessions) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "sessions", (uint32_t)(r->num_sessions));
		ndr->depth++;
		for (cntr_sessions_1 = 0; cntr_sessions_1 < (r->num_sessions); cntr_sessions_1++) {
			ndr_print_smbsrv_session_info(ndr, "sessions", &r->sessions[cntr_sessions_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbsrv_tcon_info(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbsrv_tcon_info *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->tid));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->share_name));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->client_ip));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->connect_time));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_use_time));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbsrv_tcon_info(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbsrv_tcon_info *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tid));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->share_name));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->client_ip));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->connect_time));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_use_time));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbsrv_tcon_info(struct ndr_print *ndr, const char *name, const struct smbsrv_tcon_info *r)
{
	ndr_print_struct(ndr, name, "smbsrv_tcon_info");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "tid", r->tid);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
		ndr_print_string(ndr, "share_name", r->share_name);
		ndr->flags = _flags_save_string;
	}
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
		ndr_print_string(ndr, "client_ip", r->client_ip);
		ndr->flags = _flags_save_string;
	}
	ndr_print_NTTIME(ndr, "connect_time", r->connect_time);
	ndr_print_NTTIME(ndr, "last_use_time", r->last_use_time);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbsrv_tcons(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbsrv_tcons *r)
{
	uint32_t cntr_tcons_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_tcons));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->tcons));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->tcons) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_tcons));
			for (cntr_tcons_1 = 0; cntr_tcons_1 < (r->num_tcons); cntr_tcons_1++) {
				NDR_CHECK(ndr_push_smbsrv_tcon_info(ndr, NDR_SCALARS, &r->tcons[cntr_tcons_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbsrv_tcons(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbsrv_tcons *r)
{
	uint32_t _ptr_tcons;
	uint32_t size_tcons_1 = 0;
	uint32_t cntr_tcons_1;
	TALLOC_CTX *_mem_save_tcons_0 = NULL;
	TALLOC_CTX *_mem_save_tcons_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_tcons));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_tcons));
		if (_ptr_tcons) {
			NDR_PULL_ALLOC(ndr, r->tcons);
		} else {
			r->tcons = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->tcons) {
			_mem_save_tcons_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->tcons, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->tcons));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->tcons, &size_tcons_1));
			NDR_PULL_ALLOC_N(ndr, r->tcons, size_tcons_1);
			_mem_save_tcons_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->tcons, 0);
			for (cntr_tcons_1 = 0; cntr_tcons_1 < (size_tcons_1); cntr_tcons_1++) {
				NDR_CHECK(ndr_pull_smbsrv_tcon_info(ndr, NDR_SCALARS, &r->tcons[cntr_tcons_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_tcons_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_tcons_0, 0);
		}
		if (r->tcons) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->tcons, r->num_tcons));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbsrv_tcons(struct ndr_print *ndr, const char *name, const struct smbsrv_tcons *r)
{
	uint32_t cntr_tcons_1;
	ndr_print_struct(ndr, name, "smbsrv_tcons");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_tcons", r->num_tcons);
	ndr_print_ptr(ndr, "tcons", r->tcons);
	ndr->depth++;
	if (r->tcons) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "tcons", (uint32_t)(r->num_tcons));
		ndr->depth++;
		for (cntr_tcons_1 = 0; cntr_tcons_1 < (r->num_tcons); cntr_tcons_1++) {
			ndr_print_smbsrv_tcon_info(ndr, "tcons", &r->tcons[cntr_tcons_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbsrv_info(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union smbsrv_info *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_smbsrv_info_level(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case SMBSRV_INFO_SESSIONS: {
				NDR_CHECK(ndr_push_smbsrv_sessions(ndr, NDR_SCALARS, &r->sessions));
			break; }

			case SMBSRV_INFO_TCONS: {
				NDR_CHECK(ndr_push_smbsrv_tcons(ndr, NDR_SCALARS, &r->tcons));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case SMBSRV_INFO_SESSIONS:
				NDR_CHECK(ndr_push_smbsrv_sessions(ndr, NDR_BUFFERS, &r->sessions));
			break;

			case SMBSRV_INFO_TCONS:
				NDR_CHECK(ndr_push_smbsrv_tcons(ndr, NDR_BUFFERS, &r->tcons));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbsrv_info(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union smbsrv_info *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case SMBSRV_INFO_SESSIONS: {
				NDR_CHECK(ndr_pull_smbsrv_sessions(ndr, NDR_SCALARS, &r->sessions));
			break; }

			case SMBSRV_INFO_TCONS: {
				NDR_CHECK(ndr_pull_smbsrv_tcons(ndr, NDR_SCALARS, &r->tcons));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case SMBSRV_INFO_SESSIONS:
				NDR_CHECK(ndr_pull_smbsrv_sessions(ndr, NDR_BUFFERS, &r->sessions));
			break;

			case SMBSRV_INFO_TCONS:
				NDR_CHECK(ndr_pull_smbsrv_tcons(ndr, NDR_BUFFERS, &r->tcons));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbsrv_info(struct ndr_print *ndr, const char *name, const union smbsrv_info *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbsrv_info");
	switch (level) {
		case SMBSRV_INFO_SESSIONS:
			ndr_print_smbsrv_sessions(ndr, "sessions", &r->sessions);
		break;

		case SMBSRV_INFO_TCONS:
			ndr_print_smbsrv_tcons(ndr, "tcons", &r->tcons);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drepl_role_master(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drepl_role_master r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drepl_role_master(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drepl_role_master *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drepl_role_master(struct ndr_print *ndr, const char *name, enum drepl_role_master r)
{
	const char *val = NULL;

	switch (r) {
		case DREPL_SCHEMA_MASTER: val = "DREPL_SCHEMA_MASTER"; break;
		case DREPL_RID_MASTER: val = "DREPL_RID_MASTER"; break;
		case DREPL_INFRASTRUCTURE_MASTER: val = "DREPL_INFRASTRUCTURE_MASTER"; break;
		case DREPL_NAMING_MASTER: val = "DREPL_NAMING_MASTER"; break;
		case DREPL_PDC_MASTER: val = "DREPL_PDC_MASTER"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_irpc_uptime(struct ndr_push *ndr, ndr_flags_type flags, const struct irpc_uptime *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.start_time == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, *r->out.start_time));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_irpc_uptime(struct ndr_pull *ndr, ndr_flags_type flags, struct irpc_uptime *r)
{
	TALLOC_CTX *_mem_save_start_time_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.start_time);
		NDR_ZERO_STRUCTP(r->out.start_time);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.start_time);
		}
		_mem_save_start_time_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.start_time, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, r->out.start_time));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_start_time_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_irpc_uptime(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct irpc_uptime *r)
{
	ndr_print_struct(ndr, name, "irpc_uptime");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "irpc_uptime");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "irpc_uptime");
		ndr->depth++;
		ndr_print_ptr(ndr, "start_time", r->out.start_time);
		ndr->depth++;
		ndr_print_NTTIME(ndr, "start_time", *r->out.start_time);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbtd_information(struct ndr_push *ndr, ndr_flags_type flags, const struct nbtd_information *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_nbtd_info_level(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_push_nbtd_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbtd_information(struct ndr_pull *ndr, ndr_flags_type flags, struct nbtd_information *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_nbtd_info_level(ndr, NDR_SCALARS, &r->in.level));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_nbtd_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbtd_information(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct nbtd_information *r)
{
	ndr_print_struct(ndr, name, "nbtd_information");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "nbtd_information");
		ndr->depth++;
		ndr_print_nbtd_info_level(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "nbtd_information");
		ndr->depth++;
		ndr_print_set_switch_value(ndr, &r->out.info, r->in.level);
		ndr_print_nbtd_info(ndr, "info", &r->out.info);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbtd_getdcname(struct ndr_push *ndr, ndr_flags_type flags, const struct nbtd_getdcname *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.domain_sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.domainname));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.ip_address));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.my_computername));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.my_accountname));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.account_control));
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.domain_sid));
	}
	if (flags & NDR_OUT) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.dcname));
			if (r->out.dcname) {
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->out.dcname));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbtd_getdcname(struct ndr_pull *ndr, ndr_flags_type flags, struct nbtd_getdcname *r)
{
	uint32_t _ptr_dcname;
	TALLOC_CTX *_mem_save_domain_sid_0 = NULL;
	TALLOC_CTX *_mem_save_dcname_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.domainname));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.ip_address));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.my_computername));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.my_accountname));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.account_control));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_sid);
		}
		_mem_save_domain_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.domain_sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_sid_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.domain_sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.domain_sid);
			NDR_ZERO_STRUCTP(r->in.domain_sid);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dcname));
			if (_ptr_dcname) {
				NDR_PULL_ALLOC(ndr, r->out.dcname);
			} else {
				r->out.dcname = NULL;
			}
			if (r->out.dcname) {
				_mem_save_dcname_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->out.dcname, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->out.dcname));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dcname_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbtd_getdcname(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct nbtd_getdcname *r)
{
	ndr_print_struct(ndr, name, "nbtd_getdcname");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "nbtd_getdcname");
		ndr->depth++;
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			ndr_print_string(ndr, "domainname", r->in.domainname);
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			ndr_print_string(ndr, "ip_address", r->in.ip_address);
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			ndr_print_string(ndr, "my_computername", r->in.my_computername);
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			ndr_print_string(ndr, "my_accountname", r->in.my_accountname);
			ndr->flags = _flags_save_string;
		}
		ndr_print_uint32(ndr, "account_control", r->in.account_control);
		ndr_print_ptr(ndr, "domain_sid", r->in.domain_sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "domain_sid", r->in.domain_sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "nbtd_getdcname");
		ndr->depth++;
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			ndr_print_ptr(ndr, "dcname", r->out.dcname);
			ndr->depth++;
			if (r->out.dcname) {
				ndr_print_string(ndr, "dcname", r->out.dcname);
			}
			ndr->depth--;
			ndr->flags = _flags_save_string;
		}
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbtd_proxy_wins_challenge(struct ndr_push *ndr, ndr_flags_type flags, const struct nbtd_proxy_wins_challenge *r)
{
	uint32_t cntr_addrs_0;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_nbt_name(ndr, NDR_SCALARS, &r->in.name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_addrs));
		for (cntr_addrs_0 = 0; cntr_addrs_0 < (r->in.num_addrs); cntr_addrs_0++) {
			NDR_CHECK(ndr_push_nbtd_proxy_wins_addr(ndr, NDR_SCALARS, &r->in.addrs[cntr_addrs_0]));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.num_addrs));
		for (cntr_addrs_0 = 0; cntr_addrs_0 < (r->out.num_addrs); cntr_addrs_0++) {
			NDR_CHECK(ndr_push_nbtd_proxy_wins_addr(ndr, NDR_SCALARS, &r->out.addrs[cntr_addrs_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbtd_proxy_wins_challenge(struct ndr_pull *ndr, ndr_flags_type flags, struct nbtd_proxy_wins_challenge *r)
{
	uint32_t size_addrs_0 = 0;
	uint32_t cntr_addrs_0;
	TALLOC_CTX *_mem_save_addrs_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_nbt_name(ndr, NDR_SCALARS, &r->in.name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_addrs));
		size_addrs_0 = r->in.num_addrs;
		NDR_PULL_ALLOC_N(ndr, r->in.addrs, size_addrs_0);
		_mem_save_addrs_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.addrs, 0);
		for (cntr_addrs_0 = 0; cntr_addrs_0 < (size_addrs_0); cntr_addrs_0++) {
			NDR_CHECK(ndr_pull_nbtd_proxy_wins_addr(ndr, NDR_SCALARS, &r->in.addrs[cntr_addrs_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addrs_0, 0);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.num_addrs));
		size_addrs_0 = r->out.num_addrs;
		NDR_PULL_ALLOC_N(ndr, r->out.addrs, size_addrs_0);
		_mem_save_addrs_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.addrs, 0);
		for (cntr_addrs_0 = 0; cntr_addrs_0 < (size_addrs_0); cntr_addrs_0++) {
			NDR_CHECK(ndr_pull_nbtd_proxy_wins_addr(ndr, NDR_SCALARS, &r->out.addrs[cntr_addrs_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addrs_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbtd_proxy_wins_challenge(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct nbtd_proxy_wins_challenge *r)
{
	uint32_t cntr_addrs_0;
	ndr_print_struct(ndr, name, "nbtd_proxy_wins_challenge");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "nbtd_proxy_wins_challenge");
		ndr->depth++;
		ndr_print_nbt_name(ndr, "name", &r->in.name);
		ndr_print_uint32(ndr, "num_addrs", r->in.num_addrs);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "addrs", (uint32_t)(r->in.num_addrs));
		ndr->depth++;
		for (cntr_addrs_0 = 0; cntr_addrs_0 < (r->in.num_addrs); cntr_addrs_0++) {
			ndr_print_nbtd_proxy_wins_addr(ndr, "addrs", &r->in.addrs[cntr_addrs_0]);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "nbtd_proxy_wins_challenge");
		ndr->depth++;
		ndr_print_uint32(ndr, "num_addrs", r->out.num_addrs);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "addrs", (uint32_t)(r->out.num_addrs));
		ndr->depth++;
		for (cntr_addrs_0 = 0; cntr_addrs_0 < (r->out.num_addrs); cntr_addrs_0++) {
			ndr_print_nbtd_proxy_wins_addr(ndr, "addrs", &r->out.addrs[cntr_addrs_0]);
		}
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbtd_proxy_wins_release_demand(struct ndr_push *ndr, ndr_flags_type flags, const struct nbtd_proxy_wins_release_demand *r)
{
	uint32_t cntr_addrs_0;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_nbt_name(ndr, NDR_SCALARS, &r->in.name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_addrs));
		for (cntr_addrs_0 = 0; cntr_addrs_0 < (r->in.num_addrs); cntr_addrs_0++) {
			NDR_CHECK(ndr_push_nbtd_proxy_wins_addr(ndr, NDR_SCALARS, &r->in.addrs[cntr_addrs_0]));
		}
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbtd_proxy_wins_release_demand(struct ndr_pull *ndr, ndr_flags_type flags, struct nbtd_proxy_wins_release_demand *r)
{
	uint32_t size_addrs_0 = 0;
	uint32_t cntr_addrs_0;
	TALLOC_CTX *_mem_save_addrs_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_nbt_name(ndr, NDR_SCALARS, &r->in.name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_addrs));
		size_addrs_0 = r->in.num_addrs;
		NDR_PULL_ALLOC_N(ndr, r->in.addrs, size_addrs_0);
		_mem_save_addrs_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.addrs, 0);
		for (cntr_addrs_0 = 0; cntr_addrs_0 < (size_addrs_0); cntr_addrs_0++) {
			NDR_CHECK(ndr_pull_nbtd_proxy_wins_addr(ndr, NDR_SCALARS, &r->in.addrs[cntr_addrs_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addrs_0, 0);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbtd_proxy_wins_release_demand(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct nbtd_proxy_wins_release_demand *r)
{
	uint32_t cntr_addrs_0;
	ndr_print_struct(ndr, name, "nbtd_proxy_wins_release_demand");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "nbtd_proxy_wins_release_demand");
		ndr->depth++;
		ndr_print_nbt_name(ndr, "name", &r->in.name);
		ndr_print_uint32(ndr, "num_addrs", r->in.num_addrs);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "addrs", (uint32_t)(r->in.num_addrs));
		ndr->depth++;
		for (cntr_addrs_0 = 0; cntr_addrs_0 < (r->in.num_addrs); cntr_addrs_0++) {
			ndr_print_nbtd_proxy_wins_addr(ndr, "addrs", &r->in.addrs[cntr_addrs_0]);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "nbtd_proxy_wins_release_demand");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_kdc_check_generic_kerberos(struct ndr_push *ndr, ndr_flags_type flags, const struct kdc_check_generic_kerberos *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->in.generic_request));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->out.generic_reply));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_kdc_check_generic_kerberos(struct ndr_pull *ndr, ndr_flags_type flags, struct kdc_check_generic_kerberos *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->in.generic_request));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->out.generic_reply));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_kdc_check_generic_kerberos(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct kdc_check_generic_kerberos *r)
{
	ndr_print_struct(ndr, name, "kdc_check_generic_kerberos");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "kdc_check_generic_kerberos");
		ndr->depth++;
		ndr_print_DATA_BLOB(ndr, "generic_request", r->in.generic_request);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "kdc_check_generic_kerberos");
		ndr->depth++;
		ndr_print_DATA_BLOB(ndr, "generic_reply", r->out.generic_reply);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbsrv_information(struct ndr_push *ndr, ndr_flags_type flags, const struct smbsrv_information *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_smbsrv_info_level(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_push_smbsrv_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbsrv_information(struct ndr_pull *ndr, ndr_flags_type flags, struct smbsrv_information *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_smbsrv_info_level(ndr, NDR_SCALARS, &r->in.level));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_smbsrv_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbsrv_information(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct smbsrv_information *r)
{
	ndr_print_struct(ndr, name, "smbsrv_information");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "smbsrv_information");
		ndr->depth++;
		ndr_print_smbsrv_info_level(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "smbsrv_information");
		ndr->depth++;
		ndr_print_set_switch_value(ndr, &r->out.info, r->in.level);
		ndr_print_smbsrv_info(ndr, "info", &r->out.info);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samba_terminate(struct ndr_push *ndr, ndr_flags_type flags, const struct samba_terminate *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.reason));
			ndr->flags = _flags_save_string;
		}
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samba_terminate(struct ndr_pull *ndr, ndr_flags_type flags, struct samba_terminate *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.reason));
			ndr->flags = _flags_save_string;
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samba_terminate(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct samba_terminate *r)
{
	ndr_print_struct(ndr, name, "samba_terminate");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samba_terminate");
		ndr->depth++;
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			ndr_print_string(ndr, "reason", r->in.reason);
			ndr->flags = _flags_save_string;
		}
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samba_terminate");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dreplsrv_refresh(struct ndr_push *ndr, ndr_flags_type flags, const struct dreplsrv_refresh *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dreplsrv_refresh(struct ndr_pull *ndr, ndr_flags_type flags, struct dreplsrv_refresh *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dreplsrv_refresh(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct dreplsrv_refresh *r)
{
	ndr_print_struct(ndr, name, "dreplsrv_refresh");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dreplsrv_refresh");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dreplsrv_refresh");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drepl_takeFSMORole(struct ndr_push *ndr, ndr_flags_type flags, const struct drepl_takeFSMORole *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_drepl_role_master(ndr, NDR_SCALARS, r->in.role));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drepl_takeFSMORole(struct ndr_pull *ndr, ndr_flags_type flags, struct drepl_takeFSMORole *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_drepl_role_master(ndr, NDR_SCALARS, &r->in.role));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drepl_takeFSMORole(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drepl_takeFSMORole *r)
{
	ndr_print_struct(ndr, name, "drepl_takeFSMORole");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drepl_takeFSMORole");
		ndr->depth++;
		ndr_print_drepl_role_master(ndr, "role", r->in.role);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drepl_takeFSMORole");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drepl_trigger_repl_secret(struct ndr_push *ndr, ndr_flags_type flags, const struct drepl_trigger_repl_secret *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.user_dn));
			ndr->flags = _flags_save_string;
		}
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drepl_trigger_repl_secret(struct ndr_pull *ndr, ndr_flags_type flags, struct drepl_trigger_repl_secret *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.user_dn));
			ndr->flags = _flags_save_string;
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drepl_trigger_repl_secret(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drepl_trigger_repl_secret *r)
{
	ndr_print_struct(ndr, name, "drepl_trigger_repl_secret");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drepl_trigger_repl_secret");
		ndr->depth++;
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			ndr_print_string(ndr, "user_dn", r->in.user_dn);
			ndr->flags = _flags_save_string;
		}
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drepl_trigger_repl_secret");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dnsupdate_RODC(struct ndr_push *ndr, ndr_flags_type flags, const struct dnsupdate_RODC *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.dns_names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.dom_sid));
		if (r->in.dom_sid) {
			NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.dom_sid));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.site_name));
		if (r->in.site_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.site_name, ndr_charset_length(r->in.site_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dns_ttl));
		NDR_CHECK(ndr_push_NL_DNS_NAME_INFO_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.dns_names));
	}
	if (flags & NDR_OUT) {
		if (r->out.dns_names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_NL_DNS_NAME_INFO_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.dns_names));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dnsupdate_RODC(struct ndr_pull *ndr, ndr_flags_type flags, struct dnsupdate_RODC *r)
{
	uint32_t _ptr_dom_sid;
	uint32_t _ptr_site_name;
	uint32_t size_site_name_1 = 0;
	uint32_t length_site_name_1 = 0;
	TALLOC_CTX *_mem_save_dom_sid_0 = NULL;
	TALLOC_CTX *_mem_save_site_name_0 = NULL;
	TALLOC_CTX *_mem_save_dns_names_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dom_sid));
		if (_ptr_dom_sid) {
			NDR_PULL_ALLOC(ndr, r->in.dom_sid);
		} else {
			r->in.dom_sid = NULL;
		}
		if (r->in.dom_sid) {
			_mem_save_dom_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.dom_sid, 0);
			NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.dom_sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dom_sid_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_name));
		if (_ptr_site_name) {
			NDR_PULL_ALLOC(ndr, r->in.site_name);
		} else {
			r->in.site_name = NULL;
		}
		if (r->in.site_name) {
			_mem_save_site_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.site_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.site_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.site_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.site_name, &size_site_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.site_name, &length_site_name_1));
			if (length_site_name_1 > size_site_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_site_name_1, length_site_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_site_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.site_name, length_site_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dns_ttl));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.dns_names);
		}
		_mem_save_dns_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.dns_names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NL_DNS_NAME_INFO_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.dns_names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.dns_names);
		*r->out.dns_names = *r->in.dns_names;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.dns_names == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.dns_names);
			NDR_ZERO_STRUCTP(r->in.dns_names);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dns_names);
		}
		_mem_save_dns_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dns_names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NL_DNS_NAME_INFO_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.dns_names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dnsupdate_RODC(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct dnsupdate_RODC *r)
{
	ndr_print_struct(ndr, name, "dnsupdate_RODC");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dnsupdate_RODC");
		ndr->depth++;
		ndr_print_ptr(ndr, "dom_sid", r->in.dom_sid);
		ndr->depth++;
		if (r->in.dom_sid) {
			ndr_print_dom_sid(ndr, "dom_sid", r->in.dom_sid);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "site_name", r->in.site_name);
		ndr->depth++;
		if (r->in.site_name) {
			ndr_print_string(ndr, "site_name", r->in.site_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dns_ttl", r->in.dns_ttl);
		ndr_print_ptr(ndr, "dns_names", r->in.dns_names);
		ndr->depth++;
		ndr_print_NL_DNS_NAME_INFO_ARRAY(ndr, "dns_names", r->in.dns_names);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dnsupdate_RODC");
		ndr->depth++;
		ndr_print_ptr(ndr, "dns_names", r->out.dns_names);
		ndr->depth++;
		ndr_print_NL_DNS_NAME_INFO_ARRAY(ndr, "dns_names", r->out.dns_names);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dnssrv_reload_dns_zones(struct ndr_push *ndr, ndr_flags_type flags, const struct dnssrv_reload_dns_zones *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dnssrv_reload_dns_zones(struct ndr_pull *ndr, ndr_flags_type flags, struct dnssrv_reload_dns_zones *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dnssrv_reload_dns_zones(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct dnssrv_reload_dns_zones *r)
{
	ndr_print_struct(ndr, name, "dnssrv_reload_dns_zones");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dnssrv_reload_dns_zones");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dnssrv_reload_dns_zones");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_irpc
static const struct ndr_interface_public_struct irpc_public_structs[] = {
	{
		.name = "irpc_header",
		.struct_size = sizeof(struct irpc_header ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_irpc_header,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_irpc_header,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_irpc_header,
	},
	{
		.name = "irpc_name_record",
		.struct_size = sizeof(struct irpc_name_record ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_irpc_name_record,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_irpc_name_record,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_irpc_name_record,
	},
	{
		.name = "irpc_name_records",
		.struct_size = sizeof(struct irpc_name_records ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_irpc_name_records,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_irpc_name_records,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_irpc_name_records,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call irpc_calls[] = {
	{
		"irpc_uptime",
		sizeof(struct irpc_uptime),
		(ndr_push_flags_fn_t) ndr_push_irpc_uptime,
		(ndr_pull_flags_fn_t) ndr_pull_irpc_uptime,
		(ndr_print_function_t) ndr_print_irpc_uptime,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"nbtd_information",
		sizeof(struct nbtd_information),
		(ndr_push_flags_fn_t) ndr_push_nbtd_information,
		(ndr_pull_flags_fn_t) ndr_pull_nbtd_information,
		(ndr_print_function_t) ndr_print_nbtd_information,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"nbtd_getdcname",
		sizeof(struct nbtd_getdcname),
		(ndr_push_flags_fn_t) ndr_push_nbtd_getdcname,
		(ndr_pull_flags_fn_t) ndr_pull_nbtd_getdcname,
		(ndr_print_function_t) ndr_print_nbtd_getdcname,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"nbtd_proxy_wins_challenge",
		sizeof(struct nbtd_proxy_wins_challenge),
		(ndr_push_flags_fn_t) ndr_push_nbtd_proxy_wins_challenge,
		(ndr_pull_flags_fn_t) ndr_pull_nbtd_proxy_wins_challenge,
		(ndr_print_function_t) ndr_print_nbtd_proxy_wins_challenge,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"nbtd_proxy_wins_release_demand",
		sizeof(struct nbtd_proxy_wins_release_demand),
		(ndr_push_flags_fn_t) ndr_push_nbtd_proxy_wins_release_demand,
		(ndr_pull_flags_fn_t) ndr_pull_nbtd_proxy_wins_release_demand,
		(ndr_print_function_t) ndr_print_nbtd_proxy_wins_release_demand,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"kdc_check_generic_kerberos",
		sizeof(struct kdc_check_generic_kerberos),
		(ndr_push_flags_fn_t) ndr_push_kdc_check_generic_kerberos,
		(ndr_pull_flags_fn_t) ndr_pull_kdc_check_generic_kerberos,
		(ndr_print_function_t) ndr_print_kdc_check_generic_kerberos,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"smbsrv_information",
		sizeof(struct smbsrv_information),
		(ndr_push_flags_fn_t) ndr_push_smbsrv_information,
		(ndr_pull_flags_fn_t) ndr_pull_smbsrv_information,
		(ndr_print_function_t) ndr_print_smbsrv_information,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samba_terminate",
		sizeof(struct samba_terminate),
		(ndr_push_flags_fn_t) ndr_push_samba_terminate,
		(ndr_pull_flags_fn_t) ndr_pull_samba_terminate,
		(ndr_print_function_t) ndr_print_samba_terminate,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"dreplsrv_refresh",
		sizeof(struct dreplsrv_refresh),
		(ndr_push_flags_fn_t) ndr_push_dreplsrv_refresh,
		(ndr_pull_flags_fn_t) ndr_pull_dreplsrv_refresh,
		(ndr_print_function_t) ndr_print_dreplsrv_refresh,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drepl_takeFSMORole",
		sizeof(struct drepl_takeFSMORole),
		(ndr_push_flags_fn_t) ndr_push_drepl_takeFSMORole,
		(ndr_pull_flags_fn_t) ndr_pull_drepl_takeFSMORole,
		(ndr_print_function_t) ndr_print_drepl_takeFSMORole,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drepl_trigger_repl_secret",
		sizeof(struct drepl_trigger_repl_secret),
		(ndr_push_flags_fn_t) ndr_push_drepl_trigger_repl_secret,
		(ndr_pull_flags_fn_t) ndr_pull_drepl_trigger_repl_secret,
		(ndr_print_function_t) ndr_print_drepl_trigger_repl_secret,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"dnsupdate_RODC",
		sizeof(struct dnsupdate_RODC),
		(ndr_push_flags_fn_t) ndr_push_dnsupdate_RODC,
		(ndr_pull_flags_fn_t) ndr_pull_dnsupdate_RODC,
		(ndr_print_function_t) ndr_print_dnsupdate_RODC,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"dnssrv_reload_dns_zones",
		sizeof(struct dnssrv_reload_dns_zones),
		(ndr_push_flags_fn_t) ndr_push_dnssrv_reload_dns_zones,
		(ndr_pull_flags_fn_t) ndr_pull_dnssrv_reload_dns_zones,
		(ndr_print_function_t) ndr_print_dnssrv_reload_dns_zones,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ .name = NULL }
};

static const char * const irpc_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\irpc]", 
};

static const struct ndr_interface_string_array irpc_endpoints = {
	.count	= 1,
	.names	= irpc_endpoint_strings
};

static const char * const irpc_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array irpc_authservices = {
	.count	= 1,
	.names	= irpc_authservice_strings
};


const struct ndr_interface_table ndr_table_irpc = {
	.name		= "irpc",
	.syntax_id	= {
		{0xe770c620,0x0b06,0x4b5e,{0x8d,0x87},{0xa2,0x6e,0x20,0xf2,0x83,0x40}},
		NDR_IRPC_VERSION
	},
	.helpstring	= NDR_IRPC_HELPSTRING,
	.num_calls	= 13,
	.calls		= irpc_calls,
	.num_public_structs	= 3,
	.public_structs		= irpc_public_structs,
	.endpoints	= &irpc_endpoints,
	.authservices	= &irpc_authservices
};

#endif /* SKIP_NDR_TABLE_irpc */
