/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkTransformGeometryImageFilter.h"
#include "itkTransformGeometryImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
TransformGeometryImageFilter::TransformGeometryImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
TransformGeometryImageFilter::~TransformGeometryImageFilter() = default;



//
// ToString
//
std::string TransformGeometryImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::TransformGeometryImageFilter\n";

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image TransformGeometryImageFilter::Execute ( const Image & image, const Transform & transform )
{
  const PixelIDValueEnum type = image.GetPixelID();
  const unsigned int dimension = image.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( &image, &transform );
}
Image TransformGeometryImageFilter::Execute ( Image && image, const Transform & transform )
{
  Image &temp = image;
  auto autoResetInPlace = make_scope_exit([this, &temp]{this->m_InPlace=false; Image moved(std::move(temp));});
  if (temp.IsUnique())
    {
    m_InPlace = true;
    }
  return this->Execute( image, transform );
}


//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image TransformGeometryImageFilter::ExecuteInternal ( const Image * inImage, const Transform * inTransform )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  using OutputImageType = InputImageType;



  using FilterType = itk::TransformGeometryImageFilter<InputImageType, OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inImage != nullptr );
  typename FilterType::InputImageType::ConstPointer image1 = this->CastImageToITK<typename FilterType::InputImageType>( *inImage );
  filter->SetInput( image1 );
  assert( inTransform != nullptr );
  const typename FilterType::TransformType *itkTx = dynamic_cast<const typename FilterType::TransformType *>(inTransform->GetITKBase() );
  if ( !itkTx )
    {
    sitkExceptionMacro( "Unexpected error converting transform! Possible miss matching dimensions!" );
    }
  else { filter->SetTransform( itkTx ); }


  filter->SetInPlace( m_InPlace );
         



  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image TransformGeometry ( const Image & image, const Transform & transform )
{
  TransformGeometryImageFilter filter;

  return filter.Execute ( image, transform );
}
//
// Function to run the Execute method of this filter
//
Image TransformGeometry ( Image && image, const Transform & transform )
{
  TransformGeometryImageFilter filter;

  return filter.Execute ( std::move(image), transform );
}

}
