/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta2

// DeviceClaimApplyConfiguration represents a declarative configuration of the DeviceClaim type for use
// with apply.
//
// DeviceClaim defines how to request devices with a ResourceClaim.
type DeviceClaimApplyConfiguration struct {
	// Requests represent individual requests for distinct devices which
	// must all be satisfied. If empty, nothing needs to be allocated.
	Requests []DeviceRequestApplyConfiguration `json:"requests,omitempty"`
	// These constraints must be satisfied by the set of devices that get
	// allocated for the claim.
	Constraints []DeviceConstraintApplyConfiguration `json:"constraints,omitempty"`
	// This field holds configuration for multiple potential drivers which
	// could satisfy requests in this claim. It is ignored while allocating
	// the claim.
	Config []DeviceClaimConfigurationApplyConfiguration `json:"config,omitempty"`
}

// DeviceClaimApplyConfiguration constructs a declarative configuration of the DeviceClaim type for use with
// apply.
func DeviceClaim() *DeviceClaimApplyConfiguration {
	return &DeviceClaimApplyConfiguration{}
}

// WithRequests adds the given value to the Requests field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Requests field.
func (b *DeviceClaimApplyConfiguration) WithRequests(values ...*DeviceRequestApplyConfiguration) *DeviceClaimApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithRequests")
		}
		b.Requests = append(b.Requests, *values[i])
	}
	return b
}

// WithConstraints adds the given value to the Constraints field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Constraints field.
func (b *DeviceClaimApplyConfiguration) WithConstraints(values ...*DeviceConstraintApplyConfiguration) *DeviceClaimApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConstraints")
		}
		b.Constraints = append(b.Constraints, *values[i])
	}
	return b
}

// WithConfig adds the given value to the Config field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Config field.
func (b *DeviceClaimApplyConfiguration) WithConfig(values ...*DeviceClaimConfigurationApplyConfiguration) *DeviceClaimApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConfig")
		}
		b.Config = append(b.Config, *values[i])
	}
	return b
}
