const char feedback_daemon_lua[] =
"-- feedback_daemon.lua (internal file)\n"
"--\n"
"local log   = require('log')\n"
"local json  = require('json')\n"
"local fiber = require('fiber')\n"
"local http  = require('http.client')\n"
"local fio = require('fio')\n"
"local ffi = require('ffi')\n"
"\n"
"local PREFIX = \"feedback_daemon\"\n"
"local METRICS_PREFIX = \"metrics_collector\"\n"
"\n"
"local daemon = {\n"
"    enabled  = false,\n"
"    interval = 0,\n"
"    host     = nil,\n"
"    send_metrics = false,\n"
"    metrics_collect_interval = 0,\n"
"    metrics_limit = 0,\n"
"    fiber    = nil,\n"
"    control  = nil,\n"
"    guard    = nil,\n"
"    shutdown = nil,\n"
"    metrics  = {},\n"
"    metrics_size = 0,\n"
"}\n"
"\n"
"local function get_fiber_id(f)\n"
"    local fid = 0\n"
"    if f ~= nil and f:status() ~= \"dead\" then\n"
"        fid = f:id()\n"
"    end\n"
"    return fid\n"
"end\n"
"\n"
"local function determine_cgroup_env_impl()\n"
"    local fh = fio.open('/proc/1/cgroup', {'O_RDONLY'})\n"
"    if not fh then\n"
"        return ''\n"
"    end\n"
"\n"
"    -- fh:read() doesn't read empty \"proc\" files\n"
"    local big_enough_chunk = 4096\n"
"    local s = fh:read(big_enough_chunk)\n"
"    fh:close()\n"
"\n"
"    if s:find('docker') then\n"
"        return 'docker'\n"
"    elseif s:find('lxc') then\n"
"        return 'lxc'\n"
"    end\n"
"\n"
"    return ''\n"
"end\n"
"\n"
"local cached_determine_cgroup_env\n"
"\n"
"local function determine_cgroup_env()\n"
"    if cached_determine_cgroup_env == nil then\n"
"        cached_determine_cgroup_env = determine_cgroup_env_impl()\n"
"    end\n"
"\n"
"    return cached_determine_cgroup_env\n"
"end\n"
"\n"
"local function is_system_space(space)\n"
"    return box.schema.SYSTEM_ID_MIN <= space.id and\n"
"           space.id <= box.schema.SYSTEM_ID_MAX\n"
"end\n"
"\n"
"local function jsonpaths_from_idx_parts(idx)\n"
"    local paths = {}\n"
"\n"
"    for _, part in pairs(idx.parts) do\n"
"        if type(part.path) == 'string' then\n"
"            table.insert(paths, part.path)\n"
"        end\n"
"    end\n"
"\n"
"    return paths\n"
"end\n"
"\n"
"local function is_jsonpath_index(idx)\n"
"    return #jsonpaths_from_idx_parts(idx) > 0\n"
"end\n"
"\n"
"local function is_jp_multikey_index(idx)\n"
"    for _, path in pairs(jsonpaths_from_idx_parts(idx)) do\n"
"        if path:find('[*]', 1, true) then\n"
"            return true\n"
"        end\n"
"    end\n"
"\n"
"    return false\n"
"end\n"
"\n"
"local function is_functional_index(idx)\n"
"    return idx.func ~= nil\n"
"end\n"
"\n"
"local function is_func_multikey_index(idx)\n"
"    if is_functional_index(idx) then\n"
"        local fid = idx.func.fid\n"
"        local func = fid and box.func[fid]\n"
"        return func and func.is_multikey or false\n"
"    end\n"
"\n"
"    return false\n"
"end\n"
"\n"
"local function fill_in_base_info(feedback)\n"
"    if box.info.status ~= \"running\" then\n"
"        return nil, \"not running\"\n"
"    end\n"
"    feedback.tarantool_version = box.info.version\n"
"    feedback.server_id         = box.info.uuid\n"
"    feedback.cluster_id        = box.info.cluster.uuid\n"
"    feedback.uptime            = box.info.uptime\n"
"end\n"
"\n"
"local function fill_in_platform_info(feedback)\n"
"    feedback.os     = jit.os\n"
"    feedback.arch   = jit.arch\n"
"    feedback.cgroup = determine_cgroup_env()\n"
"end\n"
"\n"
"local function fill_in_indices_stats(space, stats)\n"
"    for name, idx in pairs(space.index) do\n"
"        if type(name) == 'number' then\n"
"            local idx_type = idx.type\n"
"            if idx_type == 'TREE' then\n"
"                if is_functional_index(idx) then\n"
"                    stats.functional = stats.functional + 1\n"
"                    if is_func_multikey_index(idx) then\n"
"                        stats.functional_multikey = stats.functional_multikey + 1\n"
"                    end\n"
"                elseif is_jsonpath_index(idx) then\n"
"                    stats.jsonpath = stats.jsonpath + 1\n"
"                    if is_jp_multikey_index(idx) then\n"
"                        stats.jsonpath_multikey = stats.jsonpath_multikey + 1\n"
"                    end\n"
"                end\n"
"                stats.tree = stats.tree + 1\n"
"            elseif idx_type == 'HASH' then\n"
"                stats.hash = stats.hash + 1\n"
"            elseif idx_type == 'RTREE' then\n"
"                stats.rtree = stats.rtree + 1\n"
"            elseif idx_type == 'BITSET' then\n"
"                stats.bitset = stats.bitset + 1\n"
"            end\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function fill_in_schema_stats_impl(schema)\n"
"    local spaces = {\n"
"        memtx     = 0,\n"
"        vinyl     = 0,\n"
"        temporary = 0,\n"
"        ['local'] = 0,\n"
"        sync      = 0,\n"
"    }\n"
"\n"
"    local indices = {\n"
"        hash                = 0,\n"
"        tree                = 0,\n"
"        rtree               = 0,\n"
"        bitset              = 0,\n"
"        jsonpath            = 0,\n"
"        jsonpath_multikey   = 0,\n"
"        functional          = 0,\n"
"        functional_multikey = 0,\n"
"    }\n"
"\n"
"    local space_ids = {}\n"
"    for name, space in pairs(box.space) do\n"
"        local is_system = is_system_space(space)\n"
"        if not is_system and type(name) == 'number' then\n"
"            table.insert(space_ids, name)\n"
"        end\n"
"    end\n"
"\n"
"    for _, id in pairs(space_ids) do\n"
"        local space = box.space[id]\n"
"        if space == nil then\n"
"            goto continue;\n"
"        end\n"
"\n"
"        if space.engine == 'vinyl' then\n"
"            spaces.vinyl = spaces.vinyl + 1\n"
"        elseif space.engine == 'memtx' then\n"
"            if space.temporary then\n"
"                spaces.temporary = spaces.temporary + 1\n"
"            end\n"
"            spaces.memtx = spaces.memtx + 1\n"
"        end\n"
"        if space.is_local then\n"
"            spaces['local'] = spaces['local'] + 1\n"
"        end\n"
"        if space.is_sync then\n"
"            spaces.sync = spaces.sync + 1\n"
"        end\n"
"        fill_in_indices_stats(space, indices)\n"
"\n"
"        fiber.yield()\n"
"        ::continue::\n"
"    end\n"
"\n"
"    for k, v in pairs(spaces) do\n"
"        schema[k..'_spaces'] = v\n"
"    end\n"
"\n"
"    for k, v in pairs(indices) do\n"
"        schema[k..'_indices'] = v\n"
"    end\n"
"end\n"
"\n"
"local cached_schema_version = 0\n"
"local cached_schema_features = {}\n"
"\n"
"local function fill_in_schema_stats(features)\n"
"    local schema_version = box.info.schema_version\n"
"    if cached_schema_version < schema_version then\n"
"        local schema = {}\n"
"        fill_in_schema_stats_impl(schema)\n"
"        cached_schema_version = schema_version\n"
"        cached_schema_features = schema\n"
"    end\n"
"    features.schema = cached_schema_features\n"
"end\n"
"\n"
"local function read_first_file(pattern)\n"
"    local path = fio.glob(pattern)[1]\n"
"    if not path then\n"
"        local err = string.format(\n"
"            'Tarantool repo not installed: nothing matches \"%s\"',\n"
"            pattern\n"
"        )\n"
"        return nil, err\n"
"    end\n"
"\n"
"    local fh, err = fio.open(path, {'O_RDONLY'})\n"
"    if not fh then\n"
"        return nil, err\n"
"    end\n"
"\n"
"    local s, err = fh:read()\n"
"    fh:close()\n"
"    if type(s) ~= 'string' then\n"
"        return nil, err\n"
"    end\n"
"\n"
"    return s\n"
"end\n"
"\n"
"local function extract_repo_url_apt()\n"
"    local content, err = read_first_file('/etc/apt/sources.list.d/tarantool*.list')\n"
"    if not content then\n"
"        return nil, err\n"
"    end\n"
"\n"
"    return content:match('deb ([^ ]*)')\n"
"end\n"
"\n"
"local function extract_repo_url_yum()\n"
"    local content, err = read_first_file('/etc/yum.repos.d/tarantool*.repo')\n"
"    if not content then\n"
"        return nil, err\n"
"    end\n"
"\n"
"    return content:match('baseurl=([^\\n]*)')\n"
"end\n"
"\n"
"local function fill_in_repo_url(feedback)\n"
"    if jit.os == 'Linux' then\n"
"        feedback.repo_url = extract_repo_url_yum() or extract_repo_url_apt()\n"
"    end\n"
"end\n"
"\n"
"local function fill_in_features(feedback)\n"
"    feedback.features = {}\n"
"    fill_in_schema_stats(feedback.features)\n"
"    feedback.features.on_reload_configuration_used =\n"
"        type(box.on_reload_configuration) == 'function'\n"
"end\n"
"\n"
"local function fill_in_options(feedback)\n"
"    local options = {}\n"
"    options.election_mode = box.cfg.election_mode\n"
"    options.replication_synchro_quorum = box.cfg.replication_synchro_quorum\n"
"    options.memtx_use_mvcc_engine = box.cfg.memtx_use_mvcc_engine\n"
"    feedback.options = options\n"
"end\n"
"\n"
"local function fill_in_stats(feedback)\n"
"    local stats = {box = {}, net = {}}\n"
"    local box_stat = box.stat()\n"
"    local net_stat = box.stat.net()\n"
"\n"
"    stats.time = fiber.time64()\n"
"    -- Send box.stat().*.total.\n"
"    for op, tbl in pairs(box_stat) do\n"
"        if type(tbl) == 'table' and tbl.total ~= nil then\n"
"            stats.box[op] = {\n"
"                total = tbl.total\n"
"            }\n"
"        end\n"
"    end\n"
"    -- Send box.stat.net().*.total and box.stat.net().*.current.\n"
"    for val, tbl in pairs(net_stat) do\n"
"        if type(tbl) == 'table' and\n"
"           (tbl.total ~= nil or tbl.current ~= nil) then\n"
"            stats.net[val] = {\n"
"                total = tbl.total,\n"
"                current = tbl.current\n"
"            }\n"
"        end\n"
"    end\n"
"    feedback.stats = stats\n"
"end\n"
"\n"
"local function fill_in_events(self, feedback)\n"
"    feedback.events = self.cached_events\n"
"end\n"
"\n"
"local function fill_in_metrics(self, feedback)\n"
"    if self.send_metrics and #self.metrics > 0 then\n"
"        feedback.metrics = self.metrics\n"
"        self.metrics = {}\n"
"    end\n"
"end\n"
"\n"
"local function fill_in_feedback(self, feedback)\n"
"    fill_in_base_info(feedback)\n"
"    fill_in_platform_info(feedback)\n"
"    fill_in_repo_url(feedback)\n"
"    fill_in_features(feedback)\n"
"    fill_in_options(feedback)\n"
"    fill_in_stats(feedback)\n"
"    fill_in_events(self, feedback)\n"
"    fill_in_metrics(self, feedback)\n"
"\n"
"    return feedback\n"
"end\n"
"\n"
"local function feedback_loop(self)\n"
"    fiber.name(PREFIX, { truncate = true })\n"
"    -- Speed up the first send.\n"
"    local send_timeout = math.min(120, self.interval)\n"
"\n"
"    while true do\n"
"        local msg = self.control:get(send_timeout)\n"
"        send_timeout = self.interval\n"
"        -- if msg == \"send\" then we simply send feedback\n"
"        if msg == \"stop\" then\n"
"            break\n"
"        end\n"
"        local feedback = self:generate_feedback()\n"
"        if feedback ~= nil then\n"
"            pcall(http.post, self.host, json.encode(feedback), {timeout=1})\n"
"        end\n"
"    end\n"
"    self.shutdown:put(\"stopped\")\n"
"end\n"
"\n"
"-- Returns nil if there is no appropriate metrics module.\n"
"-- Otherwise, returns metrics.collect result.\n"
"local function collect_default_metrics()\n"
"    -- Do all the job in pcall for better reliability.\n"
"    local has_metrics, metrics = pcall(function()\n"
"        local metrics = require(\"metrics\")\n"
"        -- Required version of metrics module is 0.16.0 or newer.\n"
"        -- A little cheat here - _VERSION field was introduced in 0.16.0,\n"
"        -- let's just check if it is not nil.\n"
"        if metrics._VERSION == nil then\n"
"            return nil\n"
"        end\n"
"        return metrics.collect({invoke_callbacks = true, default_only = true})\n"
"    end)\n"
"    if has_metrics then\n"
"        return metrics\n"
"    else\n"
"        return nil\n"
"    end\n"
"end\n"
"\n"
"-- Trivial objects are stored right in table slot or stack with gc64\n"
"local trivial_obj_size = ffi.abi('gc64') and 0 or 8\n"
"\n"
"-- Calculate approximate amount of occupied memory\n"
"local function obj_approx_size(obj)\n"
"    if type(obj) == 'table' then\n"
"        local size = 40\n"
"        for k, v in pairs(obj) do\n"
"            size = size + 16\n"
"            size = size + obj_approx_size(k)\n"
"            size = size + obj_approx_size(v)\n"
"        end\n"
"        return size\n"
"    elseif type(obj) == 'string' then\n"
"        return 17 + #obj\n"
"    else -- Number, boolean and nil\n"
"        return trivial_obj_size\n"
"    end\n"
"end\n"
"\n"
"local function insert_metric(self, new_metric)\n"
"    local new_metric_size = obj_approx_size(new_metric)\n"
"    if self.metrics_size + new_metric_size <= self.metrics_limit then\n"
"        self.metrics_size = self.metrics_size + new_metric_size\n"
"        table.insert(self.metrics, new_metric)\n"
"    end\n"
"end\n"
"\n"
"local function metrics_collect_loop(self)\n"
"    fiber.name(METRICS_PREFIX, { truncate = true })\n"
"\n"
"    while true do\n"
"        local collect_timeout = self.metrics_collect_interval\n"
"        local st = pcall(fiber.sleep, collect_timeout)\n"
"        if not st then\n"
"            -- fiber was cancelled\n"
"            break\n"
"        end\n"
"        local new_metric = collect_default_metrics()\n"
"        if new_metric ~= nil then\n"
"            insert_metric(self, new_metric)\n"
"        end\n"
"    end\n"
"    self.shutdown:put(\"stopped\")\n"
"end\n"
"\n"
"local function guard_loop(self)\n"
"    fiber.name(string.format(\"guard of %s\", PREFIX), {truncate=true})\n"
"\n"
"    while true do\n"
"\n"
"        if get_fiber_id(self.fiber) == 0 then\n"
"            self.fiber = fiber.create(feedback_loop, self)\n"
"            log.verbose(\"%s restarted\", PREFIX)\n"
"        end\n"
"        if self.send_metrics and\n"
"           get_fiber_id(self.metrics_collect_fiber) == 0 then\n"
"            self.metrics_collect_fiber =\n"
"                fiber.create(metrics_collect_loop, self)\n"
"            log.verbose(\"%s restarted\", METRICS_PREFIX)\n"
"        end\n"
"        local interval = self.interval\n"
"        if self.send_metrics then\n"
"            interval = math.min(interval, self.metrics_collect_interval)\n"
"        end\n"
"        local st = pcall(fiber.sleep, interval)\n"
"        if not st then\n"
"            -- fiber was cancelled\n"
"            break\n"
"        end\n"
"    end\n"
"    self.shutdown:put(\"stopped\")\n"
"end\n"
"\n"
"local function save_event(self, event)\n"
"    if type(event) ~= 'string' then\n"
"        error(\"Usage: box.internal.feedback_daemon.save_event(string)\")\n"
"    end\n"
"    if type(self.cached_events) ~= 'table' then\n"
"        return\n"
"    end\n"
"\n"
"    self.cached_events[event] = (self.cached_events[event] or 0) + 1\n"
"end\n"
"\n"
"-- these functions are used for test purposes only\n"
"local function start(self)\n"
"    self:stop()\n"
"    if self.enabled then\n"
"        -- There may be up to 5 fibers triggering a send during bootstrap or\n"
"        -- shortly after it. And maybe more to come. Do not make anyone wait for\n"
"        -- feedback daemon to process the incoming events, and set channel size\n"
"        -- to 10 just in case.\n"
"        self.control = fiber.channel(10)\n"
"        self.shutdown = fiber.channel()\n"
"        self.cached_events = {}\n"
"        self.metrics = {}\n"
"        self.metrics_size = 0\n"
"        self.metrics_sizes = {}\n"
"        self.guard = fiber.create(guard_loop, self)\n"
"    end\n"
"    log.verbose(\"%s started\", PREFIX)\n"
"end\n"
"\n"
"local function stop(self)\n"
"    if (get_fiber_id(self.guard) ~= 0) then\n"
"        self.guard:cancel()\n"
"        self.shutdown:get()\n"
"    end\n"
"    if (get_fiber_id(self.fiber) ~= 0) then\n"
"        self.control:put(\"stop\")\n"
"        self.shutdown:get()\n"
"    end\n"
"    if get_fiber_id(self.metrics_collect_fiber) ~= 0 then\n"
"        self.metrics_collect_fiber:cancel()\n"
"        self.shutdown:get()\n"
"    end\n"
"    self.guard = nil\n"
"    self.fiber = nil\n"
"    self.metrics_collect_fiber = nil\n"
"    self.control = nil\n"
"    self.shutdown = nil\n"
"    self.metrics = {}\n"
"    log.verbose(\"%s stopped\", PREFIX)\n"
"end\n"
"\n"
"local function reload(self)\n"
"    self:stop()\n"
"    self:start()\n"
"end\n"
"\n"
"setmetatable(daemon, {\n"
"    __index = {\n"
"        set_feedback_params = function()\n"
"            box.internal.cfg_set_feedback()\n"
"            daemon.enabled  = box.cfg.feedback_enabled\n"
"            daemon.host     = box.cfg.feedback_host\n"
"            daemon.interval = box.cfg.feedback_interval\n"
"            daemon.send_metrics = box.cfg.feedback_send_metrics\n"
"            daemon.metrics_collect_interval =\n"
"                box.cfg.feedback_metrics_collect_interval\n"
"            daemon.metrics_limit = box.cfg.feedback_metrics_limit\n"
"            reload(daemon)\n"
"            return\n"
"        end,\n"
"        -- this function is used in saving feedback in file\n"
"        generate_feedback = function()\n"
"            return fill_in_feedback(daemon, { feedback_version = 8 })\n"
"        end,\n"
"        start = function()\n"
"            start(daemon)\n"
"        end,\n"
"        stop = function()\n"
"            stop(daemon)\n"
"        end,\n"
"        reload = function()\n"
"            reload(daemon)\n"
"        end,\n"
"        save_event = function(event)\n"
"            save_event(daemon, event)\n"
"        end,\n"
"        send = function()\n"
"            if daemon.control ~= nil then\n"
"                daemon.control:put(\"send\")\n"
"            end\n"
"        end\n"
"    }\n"
"})\n"
"\n"
"box.feedback = {}\n"
"box.feedback.save = function(file_name)\n"
"    if type(file_name) ~= \"string\" then\n"
"        error(\"Usage: box.feedback.save(path)\")\n"
"    end\n"
"    local feedback = json.encode(daemon.generate_feedback())\n"
"    local fh, err = fio.open(file_name, {'O_CREAT', 'O_RDWR', 'O_TRUNC'},\n"
"                             tonumber('0777', 8))\n"
"    if not fh then\n"
"        error(err)\n"
"    end\n"
"    fh:write(feedback)\n"
"    fh:close()\n"
"end\n"
"\n"
"if box.internal == nil then\n"
"    box.internal = { [PREFIX] = daemon }\n"
"else\n"
"    box.internal[PREFIX] = daemon\n"
"end\n"
""
;
