const char trigger_lua[] =
"local fun = require('fun')\n"
"\n"
"--\n"
"-- Checks that argument is a callable, i.e. a function or a table\n"
"-- with __call metamethod.\n"
"--\n"
"local function is_callable(arg)\n"
"    if type(arg) == 'function' then\n"
"        return true\n"
"    elseif type(arg) == 'table' then\n"
"        local mt = getmetatable(arg)\n"
"        if mt ~= nil and type(mt.__call) == 'function' then\n"
"            return true\n"
"        end\n"
"    end\n"
"    return false\n"
"end\n"
"\n"
"local trigger_list_mt = {\n"
"    __call = function(self, new_trigger, old_trigger)\n"
"        -- prepare, check arguments\n"
"        if new_trigger ~= nil and not is_callable(new_trigger) then\n"
"            error(string.format(\"Usage: %s(callable)\", self.name))\n"
"        end\n"
"        if old_trigger ~= nil and not is_callable(old_trigger) then\n"
"            error(string.format(\"Usage: trigger(new_callable, old_callable)\",\n"
"                  self.name))\n"
"        end\n"
"        -- do something\n"
"        if new_trigger == nil and old_trigger == nil then\n"
"            -- list all the triggers\n"
"            return fun.iter(ipairs(self)):totable()\n"
"        elseif new_trigger ~= nil and old_trigger == nil then\n"
"            -- append new trigger\n"
"            return table.insert(self, new_trigger)\n"
"        elseif new_trigger == nil and old_trigger ~= nil then\n"
"            -- delete old trigger\n"
"            for pos, func in ipairs(self) do\n"
"                if old_trigger == func then\n"
"                    table.remove(self, pos)\n"
"                    return old_trigger\n"
"                end\n"
"            end\n"
"            error(string.format(\"%s: trigger is not found\", self.name))\n"
"        else\n"
"            -- if both of the arguments are functions, then\n"
"            -- we'll replace triggers and return the old one\n"
"            for pos, func in ipairs(self) do\n"
"                if old_trigger == func then\n"
"                    self[pos] = new_trigger\n"
"                    return old_trigger\n"
"                end\n"
"            end\n"
"            error(string.format(\"%s: trigger is not found\", self.name))\n"
"        end\n"
"    end,\n"
"    __index = {\n"
"        run = function(self, ...)\n"
"            -- ipairs ignores .name\n"
"            for _, func in ipairs(self) do\n"
"                func(...)\n"
"            end\n"
"        end,\n"
"    }\n"
"}\n"
"\n"
"local function trigger_list_new(name)\n"
"    return setmetatable({\n"
"        name = name\n"
"    }, trigger_list_mt)\n"
"end\n"
"\n"
"return {\n"
"    new = trigger_list_new\n"
"}\n"
""
;
