const char metrics_cartridge_issues_lua[] =
"local utils = require('metrics.utils')\n"
"local fun = require('fun')\n"
"\n"
"local collectors_list = {}\n"
"\n"
"local function update()\n"
"    local list_on_instance = rawget(_G, '__cartridge_issues_list_on_instance')\n"
"\n"
"    if not list_on_instance then\n"
"        return\n"
"    end\n"
"\n"
"    local ok, issues = pcall(list_on_instance)\n"
"\n"
"    if not ok then\n"
"        return\n"
"    end\n"
"\n"
"    local levels = { 'warning', 'critical' }\n"
"\n"
"    for _, level in ipairs(levels) do\n"
"        local len = fun.iter(issues):filter(function(x) return x.level == level end):length()\n"
"        collectors_list.cartridge_issues =\n"
"            utils.set_gauge('cartridge_issues', 'Tarantool Cartridge issues',\n"
"                len, {level = level}, nil, {default = true})\n"
"    end\n"
"\n"
"    local global_issues_cnt = rawget(_G, '__cartridge_issues_cnt')\n"
"    if global_issues_cnt ~= nil then\n"
"        collectors_list.global_issues =\n"
"            utils.set_gauge('cartridge_cluster_issues', 'Tarantool Cartridge cluster issues',\n"
"                global_issues_cnt, nil, nil, {default = true})\n"
"    end\n"
"end\n"
"\n"
"return {\n"
"    update = update,\n"
"    list = collectors_list,\n"
"}\n"
""
;
