const char metrics_tarantool_luajit_lua[] =
"local has_mics_module, misc = pcall(require, 'misc')\n"
"\n"
"local LJ_PREFIX = 'lj_'\n"
"\n"
"local utils = require('metrics.utils')\n"
"\n"
"local collectors_list = {}\n"
"\n"
"local function update()\n"
"    if not (has_mics_module and misc.getmetrics ~= nil) then\n"
"        return\n"
"    end\n"
"    -- Details: https://github.com/tarantool/doc/issues/1597\n"
"    local lj_metrics = misc.getmetrics()\n"
"    collectors_list.gc_freed_total =\n"
"        utils.set_counter('gc_freed_total', 'Total amount of freed memory',\n"
"            lj_metrics.gc_freed, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.strhash_hit_total =\n"
"        utils.set_counter('strhash_hit_total', 'Total number of strings being interned',\n"
"            lj_metrics.strhash_hit, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.gc_steps_atomic_total =\n"
"        utils.set_counter('gc_steps_atomic_total', 'Total count of incremental GC steps (atomic state)',\n"
"            lj_metrics.gc_steps_atomic, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.strhash_miss_total =\n"
"        utils.set_counter('strhash_miss_total', 'Total number of strings allocations during the platform lifetime',\n"
"            lj_metrics.strhash_miss, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.gc_steps_sweepstring_total =\n"
"        utils.set_counter('gc_steps_sweepstring_total', 'Total count of incremental GC steps (sweepstring state)',\n"
"            lj_metrics.gc_steps_sweepstring, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.gc_strnum =\n"
"        utils.set_gauge('gc_strnum', 'Amount of allocated string objects',\n"
"            lj_metrics.gc_strnum, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.gc_tabnum =\n"
"        utils.set_gauge('gc_tabnum', 'Amount of allocated table objects',\n"
"            lj_metrics.gc_tabnum, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.gc_cdatanum =\n"
"        utils.set_gauge('gc_cdatanum', 'Amount of allocated cdata objects',\n"
"            lj_metrics.gc_cdatanum, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.jit_snap_restore_total =\n"
"        utils.set_counter('jit_snap_restore_total', 'Overall number of snap restores',\n"
"            lj_metrics.jit_snap_restore, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.gc_memory =\n"
"        utils.set_gauge('gc_memory', 'Memory currently allocated',\n"
"            lj_metrics.gc_total, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.gc_udatanum =\n"
"        utils.set_gauge('gc_udatanum', 'Amount of allocated udata objects',\n"
"            lj_metrics.gc_udatanum, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.gc_steps_finalize_total =\n"
"        utils.set_counter('gc_steps_finalize_total', 'Total count of incremental GC steps (finalize state)',\n"
"            lj_metrics.gc_steps_finalize, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.gc_allocated_total =\n"
"        utils.set_counter('gc_allocated_total', 'Total amount of allocated memory',\n"
"            lj_metrics.gc_allocated, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.jit_trace_num =\n"
"        utils.set_gauge('jit_trace_num', 'Amount of JIT traces',\n"
"            lj_metrics.jit_trace_num, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.gc_steps_sweep_total =\n"
"        utils.set_counter('gc_steps_sweep_total', 'Total count of incremental GC steps (sweep state)',\n"
"            lj_metrics.gc_steps_sweep, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.jit_trace_abort_total =\n"
"        utils.set_counter('jit_trace_abort_total', 'Overall number of abort traces',\n"
"            lj_metrics.jit_trace_abort, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.jit_mcode_size =\n"
"        utils.set_gauge('jit_mcode_size', 'Total size of all allocated machine code areas',\n"
"            lj_metrics.jit_mcode_size, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.gc_steps_propagate_total =\n"
"        utils.set_counter('gc_steps_propagate_total', 'Total count of incremental GC steps (propagate state)',\n"
"            lj_metrics.gc_steps_propagate, nil, LJ_PREFIX, {default = true})\n"
"    collectors_list.gc_steps_pause_total =\n"
"        utils.set_counter('gc_steps_pause_total', 'Total count of incremental GC steps (pause state)',\n"
"            lj_metrics.gc_steps_pause, nil, LJ_PREFIX, {default = true})\n"
"end\n"
"\n"
"return {\n"
"    update = update,\n"
"    list = collectors_list,\n"
"}\n"
""
;
