// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanGleanTestsTestMetrics_h
#define mozilla_GleanGleanTestsTestMetrics_h

#include "mozilla/JSONStringWriteFuncs.h"
#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace test_only {
  /**
   * generated from test_only.an_event
   */
  /**
   * This is a test-only metric.
   * Just recording some events.
   */
  constexpr impl::EventMetric<NoExtraKeys> an_event(4940);

  /**
   * generated from test_only.bad_code
   * Number of times we encountered bad code.
   * This is a test-only metric.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> bad_code(4941);

  /**
   * generated from test_only.balloons
   */

  struct BalloonsObjectItem {
    Maybe<nsCString> colour;
    Maybe<int64_t> diameter;
    Maybe<int64_t> CamelCasedParameter;
  };

  using BalloonsObject = nsTArray<BalloonsObjectItem>;
  /**
   * A collection of balloons
   */
  constexpr impl::ObjectMetric<BalloonsObject, struct BalloonsObjectTag> balloons(4942);

  /**
   * generated from test_only.button_jars
   * The number of buttons in each button jar.
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::QuantityMetric, DynamicLabel> button_jars(4943);

  /**
   * generated from test_only.can_we_flag_it
   * Test metric for a boolean.
   * This is a test-only metric.
   */
  constexpr impl::BooleanMetric can_we_flag_it(4944);

  /**
   * generated from test_only.can_we_time_it
   * Test metric for a timespan.
   * This is a test-only metric.
   */
  constexpr impl::TimespanMetric can_we_time_it(4945);

  /**
   * generated from test_only.cheesy_string
   * Only the cheesiest of strings.
   * This is a test-only metric.
   */
  constexpr impl::StringMetric cheesy_string(4946);

  /**
   * generated from test_only.cheesy_string_list
   * Only the cheesiest of strings. In list form!
   * This is a test-only metric.
   */
  constexpr impl::StringListMetric cheesy_string_list(4947);

  /**
   * generated from test_only.collection_disabled_counter
   * Number of times we count.
   * This is a test-only metric.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> collection_disabled_counter(4948);

  /**
   * generated from test_only.crash_stack
   */

  struct CrashStackObjectCrashInfo {
    Maybe<nsCString> typ;
    Maybe<nsCString> address;
    Maybe<int64_t> crashing_thread;
  };


  struct CrashStackObjectModulesItem {
    Maybe<nsCString> base_addr;
    Maybe<nsCString> end_addr;
  };

  using CrashStackObjectModules = nsTArray<CrashStackObjectModulesItem>;


  struct CrashStackObject {
    Maybe<nsCString> status;
    Maybe<int64_t> main_module;
    Maybe<CrashStackObjectCrashInfo> crash_info;
    Maybe<CrashStackObjectModules> modules;
  };
  /**
   * A not-real crash stack
   */
  constexpr impl::ObjectMetric<CrashStackObject, struct CrashStackObjectTag> crash_stack(4949);

  /**
   * generated from test_only.default_products
   * A testing uint scalar; not meant to be touched This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.default_products.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> default_products(4950);

  /**
   * generated from test_only.desktop_only
   * A testing uint scalar; not meant to be touched This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.desktop_only.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> desktop_only(4951);

  /**
   * generated from test_only.disabled_counter
   * Number of times we count.
   * This is a test-only metric.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> disabled_counter(4952);

  /**
   * generated from test_only.do_you_remember
   * They say it's the second thing to go.
   * This is a test-only metric.
   */
  constexpr impl::MemoryDistributionMetric do_you_remember(4953);

  /**
   * generated from test_only.expired
   * This mirrors to an expired testing scalar. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.expired.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> expired(4954);

  /**
   * generated from test_only.expired_hist
   * a testing histogram; not meant to be touched
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_TEST_EXPIRED.
   */
  constexpr impl::CustomDistributionMetric expired_hist(4955);

  /**
   * generated from test_only.impression_id_only
   * This is a test uint type with only the deletion-request store. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.impression_id_only.
   */
  constexpr impl::StringMetric impression_id_only(4956);

  /**
   * generated from test_only.keyed_categories
   * How many categories of each key do we have?
   */
  constexpr impl::DualLabeledCounterMetric keyed_categories(4957);

  /**
   * generated from test_only.keyed_expired
   * This mirrors to an expired testing scalar. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.keyed_expired.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> keyed_expired(4958);

  /**
   * generated from test_only.keyed_mobile_only
   * A keyed testing uint scalar; not meant to be touched This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.keyed_mobile_only.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> keyed_mobile_only(4959);

  /**
   * generated from test_only.keyed_release_optin
   * A testing scalar; not meant to be touched. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.keyed_release_optin.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> keyed_release_optin(4960);

  /**
   * generated from test_only.keyed_release_optout
   * A testing scalar; not meant to be touched. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.keyed_release_optout.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> keyed_release_optout(4961);

  /**
   * generated from test_only.mabels_balloon_labels
   */
  enum class MabelsBalloonLabelsLabel: uint16_t {
    eCelebratory = 0,
    eCelebratoryAndSnarky = 1,
    e__Other__,
  };
  /**
   * How does Mabel label her balloons?
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::StringMetric, MabelsBalloonLabelsLabel> mabels_balloon_labels(4962);

  /**
   * generated from test_only.mabels_balloon_strings
   * What do the labeled Mabel's liked balloons' strings say?
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::StringMetric, DynamicLabel> mabels_balloon_strings(4963);

  /**
   * generated from test_only.mabels_bathroom_counters
   * Counts Mabels labeled by their bathroom counters.
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> mabels_bathroom_counters(4964);

  /**
   * generated from test_only.mabels_custom_label_lengths
   * Mabel wants to track the length of their new label maker's labels.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> mabels_custom_label_lengths(4965);

  /**
   * generated from test_only.mabels_kitchen_counters
   * Counts Mabels labeled by their kitchen counters.
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> mabels_kitchen_counters(4966);

  /**
   * generated from test_only.mabels_label_maker
   * Mabel just got a label maker and wants to party like it's
   * 1999.
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::StringMetric, DynamicLabel> mabels_label_maker(4967);

  /**
   * generated from test_only.mabels_labeled_counters
   */
  enum class MabelsLabeledCountersLabel: uint16_t {
    eNextToTheFridge = 0,
    eClean = 1,
    e1stCounter = 2,
    e__Other__,
  };
  /**
   * Counts Mabels labeled by their kitchen counters.
   * Now with static labels.
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, MabelsLabeledCountersLabel> mabels_labeled_counters(4968);

  /**
   * generated from test_only.mabels_like_balloons
   * Does the labeled Mabel like balloons?
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> mabels_like_balloons(4969);

  /**
   * generated from test_only.mabels_like_labeled_balloons
   */
  enum class MabelsLikeLabeledBalloonsLabel: uint16_t {
    eWater = 0,
    eBirthdayParty = 1,
    e__Other__,
  };
  /**
   * Does the labeled Mabel like balloons?
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::BooleanMetric, MabelsLikeLabeledBalloonsLabel> mabels_like_labeled_balloons(4970);

  /**
   * generated from test_only.main_only
   * This is a test uint type with only the main store. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.main_only.
   */
  constexpr impl::QuantityMetric main_only(4971);

  /**
   * generated from test_only.meaning_of_life
   * Measures the one true answer to the Ultimate Question of Life,
   * the Universe, and Everything.
   * Approximately.
   * This is a test-only metric.
   */
  constexpr impl::QuantityMetric meaning_of_life(4972);

  /**
   * generated from test_only.mirror_time
   * Mirrored metric for a timespan.
   * This is a test-only metric.
   */
  constexpr impl::TimespanMetric mirror_time(4973);

  /**
   * generated from test_only.mirror_time_nanos
   * Mirrored metric for a timespan.
   * This is a test-only metric.
   */
  constexpr impl::TimespanMetric mirror_time_nanos(4974);

  /**
   * generated from test_only.mirrors_for_labeled_bools
   * Mirrored metric.
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> mirrors_for_labeled_bools(4975);

  /**
   * generated from test_only.mobile_only
   * A testing uint scalar; not meant to be touched This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.mobile_only.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mobile_only(4976);

  /**
   * generated from test_only.multiproduct
   * A testing uint scalar; not meant to be touched This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.multiproduct.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> multiproduct(4977);

  /**
   * generated from test_only.one_ping_one_bool
   * One bool for one ping only.
   * This is a test-only metric.
   */
  constexpr impl::BooleanMetric one_ping_one_bool(4978);

  /**
   * generated from test_only.release_optin
   * A testing scalar; not meant to be touched. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.release_optin.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> release_optin(4979);

  /**
   * generated from test_only.release_optout
   * A testing scalar; not meant to be touched. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.release_optout.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> release_optout(4980);

  /**
   * generated from test_only.unexpired
   * This is an unexpired testing scalar; not meant to be touched. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.unexpired.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> unexpired(4981);

  /**
   * generated from test_only.what_a_date
   * ...To be writing FOG code. This is a test-only metric.
   */
  constexpr impl::DatetimeMetric what_a_date(4982);

  /**
   * generated from test_only.what_do_you_remember
   * What do they say is the second thing to go?
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::MemoryDistributionMetric, DynamicLabel> what_do_you_remember(4983);

  /**
   * generated from test_only.what_id_it
   * Just a UUID.
   * This is a test-only metric.
   */
  constexpr impl::UuidMetric what_id_it(4984);

  /**
   * generated from test_only.what_time_is_it
   * Adheres to at least two of the top ten fallacies programmers believe
   * about time.
   * This is a test-only metric.
   */
  constexpr impl::TimingDistributionMetric what_time_is_it(4985);

  /**
   * generated from test_only.where_has_the_time_gone
   * Time is different in different places.
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> where_has_the_time_gone(4986);
}

template <>
inline void impl::ObjectMetric<test_only::BalloonsObject, test_only::BalloonsObjectTag>::Set(const test_only::BalloonsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.colour.isSome()) {
          writer.StringProperty("colour", *(aobjItem.colour));
        }
        if (aobjItem.diameter.isSome()) {
          writer.IntProperty("diameter", *(aobjItem.diameter));
        }
        if (aobjItem.CamelCasedParameter.isSome()) {
          writer.IntProperty("CamelCasedParameter", *(aobjItem.CamelCasedParameter));
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<test_only::CrashStackObject, test_only::CrashStackObjectTag>::Set(const test_only::CrashStackObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.status.isSome()) {
      writer.StringProperty("status", *(aObj.status));
    }
    if (aObj.main_module.isSome()) {
      writer.IntProperty("main_module", *(aObj.main_module));
    }
    if (aObj.crash_info.isSome()) {
      writer.StartObjectProperty("crash_info");
      if (aObj.crash_info->typ.isSome()) {
        writer.StringProperty("typ", *(aObj.crash_info->typ));
      }
      if (aObj.crash_info->address.isSome()) {
        writer.StringProperty("address", *(aObj.crash_info->address));
      }
      if (aObj.crash_info->crashing_thread.isSome()) {
        writer.IntProperty("crashing_thread", *(aObj.crash_info->crashing_thread));
      }
      writer.EndObject();
    }
    if (aObj.modules.isSome()) {
      writer.StartArrayProperty("modules");
      for (const auto& aobjModulesItem: *aObj.modules) {
        writer.StartObjectElement();
        {
          if (aobjModulesItem.base_addr.isSome()) {
            writer.StringProperty("base_addr", *(aobjModulesItem.base_addr));
          }
          if (aobjModulesItem.end_addr.isSome()) {
            writer.StringProperty("end_addr", *(aobjModulesItem.end_addr));
          }
        }
        writer.EndObject();

      }
      writer.EndArray();
    }
  }
  writer.EndObject();


  SetStr(json);
}

namespace test_only_ipc {
  /**
   * generated from test_only.ipc.a_bool
   * This is a test-only metric.
   * Just flagging things.
   */
  constexpr impl::BooleanMetric a_bool(4987);

  /**
   * generated from test_only.ipc.a_counter
   * This is a test-only metric.
   * Just counting things.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> a_counter(4988);

  /**
   * generated from test_only.ipc.a_counter_for_hgram
   * This is a test-only metric.
   * Just counting things.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> a_counter_for_hgram(4989);

  /**
   * generated from test_only.ipc.a_custom_dist
   * This is a test-only metric.
   * Just measuring samples.
   */
  constexpr impl::CustomDistributionMetric a_custom_dist(4990);

  /**
   * generated from test_only.ipc.a_date
   * This is a test-only metric.
   * Just putting things on the calendar.
   */
  constexpr impl::DatetimeMetric a_date(4991);

  /**
   * generated from test_only.ipc.a_dual_labeled_counter
   * This is a test-only metric.
   * Just counting keyed categorical things.
   */
  constexpr impl::DualLabeledCounterMetric a_dual_labeled_counter(4992);

  /**
   * generated from test_only.ipc.a_labeled_counter
   * This is a test-only metric.
   * Just counting labeled things.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> a_labeled_counter(4993);

  /**
   * generated from test_only.ipc.a_labeled_counter_for_categorical
   */
  enum class ALabeledCounterForCategoricalLabel: uint16_t {
    eCommonlabel = 0,
    eLabel4 = 1,
    eLabel5 = 2,
    eLabel6 = 3,
    e__Other__,
  };
  /**
   * This is a test-only metric.
   * Just counting things.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ALabeledCounterForCategoricalLabel> a_labeled_counter_for_categorical(4994);

  /**
   * generated from test_only.ipc.a_labeled_counter_for_hgram
   */
  enum class ALabeledCounterForHgramLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * This is a test-only metric.
   * Just counting things.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ALabeledCounterForHgramLabel> a_labeled_counter_for_hgram(4995);

  /**
   * generated from test_only.ipc.a_labeled_counter_for_keyed_count_hgram
   * This is a test-only metric.
   * Just counting things.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> a_labeled_counter_for_keyed_count_hgram(4996);

  /**
   * generated from test_only.ipc.a_memory_dist
   * This is a test-only metric.
   * Just measuring memory.
   */
  constexpr impl::MemoryDistributionMetric a_memory_dist(4997);

  /**
   * generated from test_only.ipc.a_quantity
   * This is a test-only metric.
   * Just quantifying things.
   */
  constexpr impl::QuantityMetric a_quantity(4998);

  /**
   * generated from test_only.ipc.a_string
   * This is a test-only metric.
   * Just setting some strings.
   */
  constexpr impl::StringMetric a_string(4999);

  /**
   * generated from test_only.ipc.a_string_list
   * This is a test-only metric.
   * Just appending some strings.
   */
  constexpr impl::StringListMetric a_string_list(5000);

  /**
   * generated from test_only.ipc.a_text
   * This is a test-only metric.
   * For holding Text data.
   */
  constexpr impl::TextMetric a_text(5001);

  /**
   * generated from test_only.ipc.a_timing_dist
   * This is a test-only metric.
   * Just measuring time.
   */
  constexpr impl::TimingDistributionMetric a_timing_dist(5002);

  /**
   * generated from test_only.ipc.a_url
   * This is a test-only metric.
   * Just setting some Urls.
   */
  constexpr impl::UrlMetric a_url(5003);

  /**
   * generated from test_only.ipc.a_uuid
   * This is a test-only metric.
   * Just recording some unique identifiers.
   */
  constexpr impl::UuidMetric a_uuid(5004);

  /**
   * generated from test_only.ipc.an_event
   */
  struct AnEventExtra {
    mozilla::Maybe<nsCString> extra1;
    mozilla::Maybe<nsCString> extra2;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (extra1) {
        extraKeys.AppendElement()->AssignASCII("extra1");
        extraValues.EmplaceBack(extra1.value());
      }
      if (extra2) {
        extraKeys.AppendElement()->AssignASCII("extra2");
        extraValues.EmplaceBack(extra2.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is a test-only metric.
   * Just recording some events.
   */
  constexpr impl::EventMetric<AnEventExtra> an_event(5005);

  /**
   * generated from test_only.ipc.an_external_denominator
   * This is a test-only metric.
   * A denominator not from around here.
   */
  constexpr impl::DenominatorMetric an_external_denominator(5006);

  /**
   * generated from test_only.ipc.an_unordered_bool
   * This is a test-only metric.
   * Just flagging things unorderedly in child processes.
   */
  constexpr impl::BooleanMetric an_unordered_bool(5007);

  /**
   * generated from test_only.ipc.an_unordered_labeled_boolean
   * This is a test-only metric.
   * Just flagging labeled things unorderedly in child processes.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> an_unordered_labeled_boolean(5008);

  /**
   * generated from test_only.ipc.another_dual_labeled_counter
   * This is a test-only metric.
   * Just counting other keyed categorical things.
   */
  constexpr impl::DualLabeledCounterMetric another_dual_labeled_counter(5009);

  /**
   * generated from test_only.ipc.another_labeled_counter
   * This is a test-only metric.
   * Just another metric counting labeled things.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> another_labeled_counter(5010);

  /**
   * generated from test_only.ipc.event_with_extra
   */
  struct EventWithExtraExtra {
    mozilla::Maybe<nsCString> extra1;
    mozilla::Maybe<uint32_t> extra2;
    mozilla::Maybe<bool> extra3LongerName;
    mozilla::Maybe<bool> extra4camelcase;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (extra1) {
        extraKeys.AppendElement()->AssignASCII("extra1");
        extraValues.EmplaceBack(extra1.value());
      }
      if (extra2) {
        extraKeys.AppendElement()->AssignASCII("extra2");
        extraValues.AppendElement()->AppendInt(extra2.value());
      }
      if (extra3LongerName) {
        extraKeys.AppendElement()->AssignASCII("extra3_longer_name");
        extraValues.AppendElement()->AssignASCII(extra3LongerName.value() ? "true" : "false");
      }
      if (extra4camelcase) {
        extraKeys.AppendElement()->AssignASCII("extra4CamelCase");
        extraValues.AppendElement()->AssignASCII(extra4camelcase.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is a test-only metric.
   * Just recording some events.
   */
  constexpr impl::EventMetric<EventWithExtraExtra> event_with_extra(5011);

  /**
   * generated from test_only.ipc.irate
   * This is a test-only metric.
   * A rate that isn't happy about it.
   */
  constexpr impl::RateMetric irate(5012);

  /**
   * generated from test_only.ipc.no_extra_event
   */
  /**
   * This is a test-only metric.
   * Just recording some events without the extra fuss.
   */
  constexpr impl::EventMetric<NoExtraKeys> no_extra_event(5013);

  /**
   * generated from test_only.ipc.rate_with_external_denominator
   * This is a test-only metric.
   * A rate with a denominator that is Out There.
   */
  constexpr impl::NumeratorMetric rate_with_external_denominator(5014);
}

namespace test_only_jog {
  /**
   * generated from test_only.jog.a_counter
   * This is a test-only metric.
   * Just counting things.
   * Tied closely to test_jog_name_collision.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> a_counter(5015);

  /**
   * generated from test_only.jog.an_event
   */
  struct AnEventExtra {
    mozilla::Maybe<nsCString> extra1;
    mozilla::Maybe<nsCString> extra2;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (extra1) {
        extraKeys.AppendElement()->AssignASCII("extra1");
        extraValues.EmplaceBack(extra1.value());
      }
      if (extra2) {
        extraKeys.AppendElement()->AssignASCII("extra2");
        extraValues.EmplaceBack(extra2.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is a test-only metric.
   * Just recording some events.
   * Tied closely to test_jog_name_collision.
   */
  constexpr impl::EventMetric<AnEventExtra> an_event(5016);
}

} // namespace mozilla::glean

#endif // mozilla_GleanGleanTestsTestMetrics_h
