/* THIS FILE IS AUTOGENERATED FROM CSSNumericValue.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "CSSNumericValueBinding.h"
#include "CSSStyleValueBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_layout.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CSSMathSum.h"
#include "mozilla/dom/CSSNumericValue.h"
#include "mozilla/dom/CSSUnitValue.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/WebIDLPrefs.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<CSSNumericBaseType>::Values[7];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, CSSNumericBaseType aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<CSSNumericBaseType>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<CSSNumericBaseType>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<CSSNumericBaseType>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningDoubleOrCSSNumericValue& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsCSSNumericValue()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsCSSNumericValue(), "mCSSNumericValue", aFlags);
  }
}


void
ImplCycleCollectionUnlink(OwningDoubleOrCSSNumericValue& aUnion)
{
  aUnion.Uninit();
}



CSSNumericType::CSSNumericType()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
CSSNumericType::InitIds(JSContext* cx, CSSNumericTypeAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->time_id.init(cx, "time") ||
      !atomsCache->resolution_id.init(cx, "resolution") ||
      !atomsCache->percentHint_id.init(cx, "percentHint") ||
      !atomsCache->percent_id.init(cx, "percent") ||
      !atomsCache->length_id.init(cx, "length") ||
      !atomsCache->frequency_id.init(cx, "frequency") ||
      !atomsCache->flex_id.init(cx, "flex") ||
      !atomsCache->angle_id.init(cx, "angle")) {
    return false;
  }
  return true;
}

bool
CSSNumericType::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
CSSNumericType::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  CSSNumericTypeAtoms* atomsCache = GetAtomCache<CSSNumericTypeAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mAngle.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mAngle.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->angle_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFlex.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mFlex.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->flex_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFrequency.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mFrequency.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->frequency_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mLength.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mLength.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->length_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPercent.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mPercent.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->percent_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPercentHint.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      CSSNumericBaseType const & currentValue = mPercentHint.InternalValue();
      if (!ToJSValue(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->percentHint_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mResolution.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mResolution.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->resolution_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTime.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mTime.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->time_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
CSSNumericType::TraceDictionary(JSTracer* trc)
{
}

CSSNumericType&
CSSNumericType::operator=(const CSSNumericType& aOther)
{
  DictionaryBase::operator=(aOther);
  mAngle.Reset();
  if (aOther.mAngle.WasPassed()) {
    mAngle.Construct(aOther.mAngle.Value());
  }
  mFlex.Reset();
  if (aOther.mFlex.WasPassed()) {
    mFlex.Construct(aOther.mFlex.Value());
  }
  mFrequency.Reset();
  if (aOther.mFrequency.WasPassed()) {
    mFrequency.Construct(aOther.mFrequency.Value());
  }
  mLength.Reset();
  if (aOther.mLength.WasPassed()) {
    mLength.Construct(aOther.mLength.Value());
  }
  mPercent.Reset();
  if (aOther.mPercent.WasPassed()) {
    mPercent.Construct(aOther.mPercent.Value());
  }
  mPercentHint.Reset();
  if (aOther.mPercentHint.WasPassed()) {
    mPercentHint.Construct(aOther.mPercentHint.Value());
  }
  mResolution.Reset();
  if (aOther.mResolution.WasPassed()) {
    mResolution.Construct(aOther.mResolution.Value());
  }
  mTime.Reset();
  if (aOther.mTime.WasPassed()) {
    mTime.Construct(aOther.mTime.Value());
  }
  return *this;
}


bool
DoubleOrCSSNumericValue::TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    double& memberSlot = RawSetAsDouble();
    if (!ValueToPrimitive<double, eDefault>(cx, value, "Double branch of (double or CSSNumericValue)", &memberSlot)) {
      return false;
    } else if (!std::isfinite(memberSlot)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("Double branch of (double or CSSNumericValue)");
      return false;
    }
  }
  return true;
}

bool
DoubleOrCSSNumericValue::TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToDouble(cx, value, tryNext, passedToJSImpl);
}







bool
DoubleOrCSSNumericValue::TrySetToCSSNumericValue(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::CSSNumericValue>& memberSlot = RawSetAsCSSNumericValue();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSNumericValue, mozilla::dom::CSSNumericValue>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyCSSNumericValue();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
DoubleOrCSSNumericValue::TrySetToCSSNumericValue(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToCSSNumericValue(cx, value, tryNext, passedToJSImpl);
}







bool
DoubleOrCSSNumericValue::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToCSSNumericValue(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToDouble(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "CSSNumericValue");
    return false;
  }
  return true;
}

bool
DoubleOrCSSNumericValue::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
DoubleOrCSSNumericValue::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eDouble: {
      rval.set(JS_NumberValue(double(mValue.mDouble.Value())));
      return true;
    }
    case eCSSNumericValue: {
      if (!GetOrCreateDOMReflector(cx, mValue.mCSSNumericValue.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningDoubleOrCSSNumericValue::OwningDoubleOrCSSNumericValue(OwningDoubleOrCSSNumericValue&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eDouble: {
      mType = eDouble;
      mValue.mDouble.SetValue(std::move(aOther.mValue.mDouble.Value()));
      break;
    }
    case eCSSNumericValue: {
      mType = eCSSNumericValue;
      mValue.mCSSNumericValue.SetValue(std::move(aOther.mValue.mCSSNumericValue.Value()));
      break;
    }
  }
}



bool
OwningDoubleOrCSSNumericValue::TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    double& memberSlot = RawSetAsDouble();
    if (!ValueToPrimitive<double, eDefault>(cx, value, "Double branch of (double or CSSNumericValue)", &memberSlot)) {
      return false;
    } else if (!std::isfinite(memberSlot)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("Double branch of (double or CSSNumericValue)");
      return false;
    }
  }
  return true;
}

bool
OwningDoubleOrCSSNumericValue::TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToDouble(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] double&
OwningDoubleOrCSSNumericValue::RawSetAsDouble()
{
  if (mType == eDouble) {
    return mValue.mDouble.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eDouble;
  return mValue.mDouble.SetValue();
}

[[nodiscard]] double&
OwningDoubleOrCSSNumericValue::SetAsDouble()
{
  if (mType == eDouble) {
    return mValue.mDouble.Value();
  }
  Uninit();
  mType = eDouble;
  return mValue.mDouble.SetValue();
}


void
OwningDoubleOrCSSNumericValue::DestroyDouble()
{
  MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
  mValue.mDouble.Destroy();
  mType = eUninitialized;
}



bool
OwningDoubleOrCSSNumericValue::TrySetToCSSNumericValue(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::CSSNumericValue>& memberSlot = RawSetAsCSSNumericValue();
    static_assert(IsRefcounted<mozilla::dom::CSSNumericValue>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSNumericValue, mozilla::dom::CSSNumericValue>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyCSSNumericValue();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningDoubleOrCSSNumericValue::TrySetToCSSNumericValue(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToCSSNumericValue(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::CSSNumericValue>&
OwningDoubleOrCSSNumericValue::RawSetAsCSSNumericValue()
{
  if (mType == eCSSNumericValue) {
    return mValue.mCSSNumericValue.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eCSSNumericValue;
  return mValue.mCSSNumericValue.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::CSSNumericValue>&
OwningDoubleOrCSSNumericValue::SetAsCSSNumericValue()
{
  if (mType == eCSSNumericValue) {
    return mValue.mCSSNumericValue.Value();
  }
  Uninit();
  mType = eCSSNumericValue;
  return mValue.mCSSNumericValue.SetValue();
}


void
OwningDoubleOrCSSNumericValue::DestroyCSSNumericValue()
{
  MOZ_RELEASE_ASSERT(IsCSSNumericValue(), "Wrong type!");
  mValue.mCSSNumericValue.Destroy();
  mType = eUninitialized;
}



bool
OwningDoubleOrCSSNumericValue::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToCSSNumericValue(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToDouble(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "CSSNumericValue");
    return false;
  }
  return true;
}

bool
OwningDoubleOrCSSNumericValue::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningDoubleOrCSSNumericValue::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eDouble: {
      DestroyDouble();
      break;
    }
    case eCSSNumericValue: {
      DestroyCSSNumericValue();
      break;
    }
  }
}

bool
OwningDoubleOrCSSNumericValue::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eDouble: {
      rval.set(JS_NumberValue(double(mValue.mDouble.Value())));
      return true;
    }
    case eCSSNumericValue: {
      if (!GetOrCreateDOMReflector(cx, mValue.mCSSNumericValue.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningDoubleOrCSSNumericValue&
OwningDoubleOrCSSNumericValue::operator=(OwningDoubleOrCSSNumericValue&& aOther)
{
  this->~OwningDoubleOrCSSNumericValue();
  new (this) OwningDoubleOrCSSNumericValue (std::move(aOther));
  return *this;
}


OwningDoubleOrCSSNumericValue&
OwningDoubleOrCSSNumericValue::operator=(const OwningDoubleOrCSSNumericValue& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eDouble: {
      SetAsDouble() = aOther.GetAsDouble();
      break;
    }
    case eCSSNumericValue: {
      SetAsCSSNumericValue() = aOther.GetAsCSSNumericValue();
      break;
    }
  }
  return *this;
}


namespace CSSNumericValue_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<CSSStyleValue_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
add(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "CSSNumericValue.add");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSNumericValue", "add", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CSSNumericValue*>(void_self);
  AutoSequence<OwningDoubleOrCSSNumericValue> arg0;
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      OwningDoubleOrCSSNumericValue& slot = *arg0.AppendElement();
      if (!slot.Init(cx, args[variadicArg], "Argument 1", false)) {
        return false;
      }
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::CSSNumericValue>(MOZ_KnownLive(self)->Add(Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CSSNumericValue.add"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo add_methodinfo = {
  { (JSJitGetterOp)add },
  { prototypes::id::CSSNumericValue },
  { PrototypeTraits<prototypes::id::CSSNumericValue>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
sub(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "CSSNumericValue.sub");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSNumericValue", "sub", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CSSNumericValue*>(void_self);
  AutoSequence<OwningDoubleOrCSSNumericValue> arg0;
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      OwningDoubleOrCSSNumericValue& slot = *arg0.AppendElement();
      if (!slot.Init(cx, args[variadicArg], "Argument 1", false)) {
        return false;
      }
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::CSSNumericValue>(MOZ_KnownLive(self)->Sub(Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CSSNumericValue.sub"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo sub_methodinfo = {
  { (JSJitGetterOp)sub },
  { prototypes::id::CSSNumericValue },
  { PrototypeTraits<prototypes::id::CSSNumericValue>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
mul(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "CSSNumericValue.mul");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSNumericValue", "mul", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CSSNumericValue*>(void_self);
  AutoSequence<OwningDoubleOrCSSNumericValue> arg0;
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      OwningDoubleOrCSSNumericValue& slot = *arg0.AppendElement();
      if (!slot.Init(cx, args[variadicArg], "Argument 1", false)) {
        return false;
      }
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::CSSNumericValue>(MOZ_KnownLive(self)->Mul(Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CSSNumericValue.mul"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo mul_methodinfo = {
  { (JSJitGetterOp)mul },
  { prototypes::id::CSSNumericValue },
  { PrototypeTraits<prototypes::id::CSSNumericValue>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
div(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "CSSNumericValue.div");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSNumericValue", "div", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CSSNumericValue*>(void_self);
  AutoSequence<OwningDoubleOrCSSNumericValue> arg0;
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      OwningDoubleOrCSSNumericValue& slot = *arg0.AppendElement();
      if (!slot.Init(cx, args[variadicArg], "Argument 1", false)) {
        return false;
      }
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::CSSNumericValue>(MOZ_KnownLive(self)->Div(Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CSSNumericValue.div"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo div_methodinfo = {
  { (JSJitGetterOp)div },
  { prototypes::id::CSSNumericValue },
  { PrototypeTraits<prototypes::id::CSSNumericValue>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
min(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "CSSNumericValue.min");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSNumericValue", "min", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CSSNumericValue*>(void_self);
  AutoSequence<OwningDoubleOrCSSNumericValue> arg0;
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      OwningDoubleOrCSSNumericValue& slot = *arg0.AppendElement();
      if (!slot.Init(cx, args[variadicArg], "Argument 1", false)) {
        return false;
      }
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::CSSNumericValue>(MOZ_KnownLive(self)->Min(Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CSSNumericValue.min"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo min_methodinfo = {
  { (JSJitGetterOp)min },
  { prototypes::id::CSSNumericValue },
  { PrototypeTraits<prototypes::id::CSSNumericValue>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
max(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "CSSNumericValue.max");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSNumericValue", "max", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CSSNumericValue*>(void_self);
  AutoSequence<OwningDoubleOrCSSNumericValue> arg0;
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      OwningDoubleOrCSSNumericValue& slot = *arg0.AppendElement();
      if (!slot.Init(cx, args[variadicArg], "Argument 1", false)) {
        return false;
      }
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::CSSNumericValue>(MOZ_KnownLive(self)->Max(Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CSSNumericValue.max"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo max_methodinfo = {
  { (JSJitGetterOp)max },
  { prototypes::id::CSSNumericValue },
  { PrototypeTraits<prototypes::id::CSSNumericValue>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
equals(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "CSSNumericValue.equals");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSNumericValue", "equals", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CSSNumericValue*>(void_self);
  AutoSequence<OwningDoubleOrCSSNumericValue> arg0;
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      OwningDoubleOrCSSNumericValue& slot = *arg0.AppendElement();
      if (!slot.Init(cx, args[variadicArg], "Argument 1", false)) {
        return false;
      }
    }
  }
  bool result(MOZ_KnownLive(self)->Equals(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo equals_methodinfo = {
  { (JSJitGetterOp)equals },
  { prototypes::id::CSSNumericValue },
  { PrototypeTraits<prototypes::id::CSSNumericValue>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
to(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSNumericValue", "to", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CSSNumericValue*>(void_self);
  if (!args.requireAtLeast(cx, "CSSNumericValue.to", 1)) {
    return false;
  }
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(MOZ_KnownLive(self)->To(Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CSSNumericValue.to"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo to_methodinfo = {
  { (JSJitGetterOp)to },
  { prototypes::id::CSSNumericValue },
  { PrototypeTraits<prototypes::id::CSSNumericValue>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
toSum(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSNumericValue", "toSum", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CSSNumericValue*>(void_self);
  AutoSequence<nsCString> arg0;
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      nsCString& slot = *arg0.AppendElement();
      if (!ConvertJSValueToString(cx, args[variadicArg], eStringify, eStringify, slot)) {
        return false;
      }
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::CSSMathSum>(MOZ_KnownLive(self)->ToSum(Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CSSNumericValue.toSum"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo toSum_methodinfo = {
  { (JSJitGetterOp)toSum },
  { prototypes::id::CSSNumericValue },
  { PrototypeTraits<prototypes::id::CSSNumericValue>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
type(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSNumericValue", "type", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CSSNumericValue*>(void_self);
  CSSNumericType result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Type(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->Type(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToObjectInternal(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo type_methodinfo = {
  { (JSJitGetterOp)type },
  { prototypes::id::CSSNumericValue },
  { PrototypeTraits<prototypes::id::CSSNumericValue>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
parse(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSNumericValue", "parse", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSSNumericValue.parse", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::CSSNumericValue>(mozilla::dom::CSSNumericValue::Parse(global, Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CSSNumericValue.parse"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::CSSNumericValue* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::CSSNumericValue>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::CSSNumericValue>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sStaticMethods_specs[] = {
  JS_FNSPEC("parse", parse, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};

static const PrefableDisablers sStaticMethods_disablers0 = {
  WebIDLPrefIndex::NoPref, GlobalNames::DedicatedWorkerGlobalScope | GlobalNames::PaintWorkletGlobalScope | GlobalNames::ServiceWorkerGlobalScope | GlobalNames::SharedWorkerGlobalScope, false, OriginTrial(0), nullptr
};

static const Prefable<const JSFunctionSpec> sStaticMethods[] = {
  { &sStaticMethods_disablers0, &sStaticMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("add", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&add_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("sub", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&sub_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("mul", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&mul_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("div", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&div_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("min", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&min_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("max", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&max_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("equals", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&equals_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("to", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&to_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("toSum", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&toSum_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("type", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&type_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(10 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[11];
static PropertyInfo sNativeProperties_propertyInfos[11];

static const NativePropertiesN<2> sNativeProperties = {
  true,  0 /* sStaticMethods */,
  false, 0,
  true,  1 /* sMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  11,
  sNativeProperties_sortedPropertyIndices,
  {
    { sStaticMethods, &sNativeProperties_propertyInfos[0] },
    { sMethods, &sNativeProperties_propertyInfos[1] }
  }
};
static_assert(11 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::CSSNumericValue,
  constructors::id::CSSNumericValue,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  CSSStyleValue_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::CSSNumericValue>::Depth,
  prototypes::id::CSSNumericValue,
  true,
  0,
  "CSSNumericValue",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "CSSNumericValuePrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::CSSNumericValue,
  PrototypeTraits<prototypes::id::CSSNumericValue>::Depth,
  &sNativePropertyHooks,
  CSSStyleValue_Binding::GetProtoObject
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return StaticPrefs::layout_css_typed_om_enabled();
}

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "CSSNumericValue",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::CSSNumericValue>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::CSSStyleValue, prototypes::id::CSSNumericValue, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::CSSNumericValue>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::CSSNumericValue>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::CSSNumericValue>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::CSSNumericValue>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::CSSNumericValue* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::CSSNumericValue>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::CSSNumericValue*>);
  MOZ_ASSERT(static_cast<mozilla::dom::CSSStyleValue*>(aObject) ==
             reinterpret_cast<mozilla::dom::CSSStyleValue*>(aObject),
             "Multiple inheritance for mozilla::dom::CSSStyleValue is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::CSSNumericValue> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::CSSNumericValue);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::CSSNumericValue);

  JS::Handle<JSObject*> parentProto(CSSStyleValue_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(CSSStyleValue_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "CSSNumericValue",
                              ShouldExpose<CSSNumericValue_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::CSSNumericValue,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JSObject*
GetProtoObject(JSContext* aCx)
{
  return GetProtoObjectHandle(aCx);
}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::CSSNumericValue,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace CSSNumericValue_Binding



} // namespace dom


} // namespace mozilla
