//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef PQuota_h
#define PQuota_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "mozilla/dom/quota/Client.h"
#include "mozilla/dom/quota/CommonMetadataArray.h"
#include "mozilla/dom/quota/PersistenceType.h"
#include "mozilla/dom/quota/UsageInfo.h"
#include "mozilla/ipc/IPDLStructMember.h"
#include "mozilla/ipc/PBackgroundSharedTypes.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union BoolResponse|
//
namespace mozilla {
namespace ipc {
class BoolResponse final
{
public:
    enum Type {
        T__None,
        Tnsresult = 1,
        Tbool,
        T__Last = Tbool
    };

private:
    typedef ::nsresult nsresult;
    typedef nsresult nsresult__tdef;
    typedef bool bool__tdef;

    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }
    bool*
    ptr_bool()
    {
        return (&(mVbool));
    }
    const bool*
    constptr_bool() const
    {
        return (&(mVbool));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT BoolResponse() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT BoolResponse(const nsresult& aOther);

    MOZ_IMPLICIT BoolResponse(nsresult&& aOther);

    MOZ_IMPLICIT BoolResponse(const bool& aOther);

    MOZ_IMPLICIT BoolResponse(bool&& aOther);

    MOZ_IMPLICIT BoolResponse(const BoolResponse& aOther);

    MOZ_IMPLICIT BoolResponse(BoolResponse&& aOther);

    ~BoolResponse();

    Type
    type() const
    {
        return mType;
    }

    BoolResponse&
    operator=(const nsresult& aRhs);

    BoolResponse&
    operator=(nsresult&& aRhs);

    BoolResponse&
    operator=(const bool& aRhs);

    BoolResponse&
    operator=(bool&& aRhs);

    BoolResponse&
    operator=(const BoolResponse& aRhs);

    BoolResponse&
    operator=(BoolResponse&& aRhs);

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

    bool&
    get_bool()
    {
        AssertSanity(Tbool);
        return (*(ptr_bool()));
    }
    const bool&
    get_bool() const
    {
        AssertSanity(Tbool);
        return (*(constptr_bool()));
    }
    operator bool&()
    {
        return get_bool();
    }
    operator const bool&() const
    {
        return get_bool();
    }

private:
    union {
        nsresult mVnsresult;
        bool mVbool;
    };
    Type mType;
};
} // namespace ipc
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::ipc::BoolResponse>
{
    typedef ::mozilla::ipc::BoolResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union UInt64Response|
//
namespace mozilla {
namespace ipc {
class UInt64Response final
{
public:
    enum Type {
        T__None,
        Tnsresult = 1,
        Tuint64_t,
        T__Last = Tuint64_t
    };

private:
    typedef ::nsresult nsresult;
    typedef ::uint64_t uint64_t;
    typedef nsresult nsresult__tdef;
    typedef uint64_t uint64_t__tdef;

    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }
    uint64_t*
    ptr_uint64_t()
    {
        return (&(mVuint64_t));
    }
    const uint64_t*
    constptr_uint64_t() const
    {
        return (&(mVuint64_t));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT UInt64Response() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT UInt64Response(const nsresult& aOther);

    MOZ_IMPLICIT UInt64Response(nsresult&& aOther);

    MOZ_IMPLICIT UInt64Response(const uint64_t& aOther);

    MOZ_IMPLICIT UInt64Response(uint64_t&& aOther);

    MOZ_IMPLICIT UInt64Response(const UInt64Response& aOther);

    MOZ_IMPLICIT UInt64Response(UInt64Response&& aOther);

    ~UInt64Response();

    Type
    type() const
    {
        return mType;
    }

    UInt64Response&
    operator=(const nsresult& aRhs);

    UInt64Response&
    operator=(nsresult&& aRhs);

    UInt64Response&
    operator=(const uint64_t& aRhs);

    UInt64Response&
    operator=(uint64_t&& aRhs);

    UInt64Response&
    operator=(const UInt64Response& aRhs);

    UInt64Response&
    operator=(UInt64Response&& aRhs);

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

    uint64_t&
    get_uint64_t()
    {
        AssertSanity(Tuint64_t);
        return (*(ptr_uint64_t()));
    }
    const uint64_t&
    get_uint64_t() const
    {
        AssertSanity(Tuint64_t);
        return (*(constptr_uint64_t()));
    }
    operator uint64_t&()
    {
        return get_uint64_t();
    }
    operator const uint64_t&() const
    {
        return get_uint64_t();
    }

private:
    union {
        nsresult mVnsresult;
        uint64_t mVuint64_t;
    };
    Type mType;
};
} // namespace ipc
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::ipc::UInt64Response>
{
    typedef ::mozilla::ipc::UInt64Response paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union CStringArrayResponse|
//
namespace mozilla {
namespace ipc {
class CStringArrayResponse final
{
public:
    enum Type {
        T__None,
        Tnsresult = 1,
        TArrayOfnsCString,
        T__Last = TArrayOfnsCString
    };

private:
    typedef ::nsresult nsresult;
    typedef ::nsCString nsCString;
    typedef nsresult nsresult__tdef;
    typedef nsTArray<nsCString> ArrayOfnsCString__tdef;

    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }
    nsTArray<nsCString>*
    ptr_ArrayOfnsCString()
    {
        return (&(mVArrayOfnsCString));
    }
    const nsTArray<nsCString>*
    constptr_ArrayOfnsCString() const
    {
        return (&(mVArrayOfnsCString));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT CStringArrayResponse() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT CStringArrayResponse(const nsresult& aOther);

    MOZ_IMPLICIT CStringArrayResponse(nsresult&& aOther);

    MOZ_IMPLICIT CStringArrayResponse(const nsTArray<nsCString>& aOther);

    MOZ_IMPLICIT CStringArrayResponse(nsTArray<nsCString>&& aOther);

    MOZ_IMPLICIT CStringArrayResponse(const CStringArrayResponse& aOther);

    MOZ_IMPLICIT CStringArrayResponse(CStringArrayResponse&& aOther);

    ~CStringArrayResponse();

    Type
    type() const
    {
        return mType;
    }

    CStringArrayResponse&
    operator=(const nsresult& aRhs);

    CStringArrayResponse&
    operator=(nsresult&& aRhs);

    CStringArrayResponse&
    operator=(const nsTArray<nsCString>& aRhs);

    CStringArrayResponse&
    operator=(nsTArray<nsCString>&& aRhs);

    CStringArrayResponse&
    operator=(const CStringArrayResponse& aRhs);

    CStringArrayResponse&
    operator=(CStringArrayResponse&& aRhs);

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

    nsTArray<nsCString>&
    get_ArrayOfnsCString()
    {
        AssertSanity(TArrayOfnsCString);
        return (*(ptr_ArrayOfnsCString()));
    }
    const nsTArray<nsCString>&
    get_ArrayOfnsCString() const
    {
        AssertSanity(TArrayOfnsCString);
        return (*(constptr_ArrayOfnsCString()));
    }
    operator nsTArray<nsCString>&()
    {
        return get_ArrayOfnsCString();
    }
    operator const nsTArray<nsCString>&() const
    {
        return get_ArrayOfnsCString();
    }

private:
    union {
        nsresult mVnsresult;
        nsTArray<nsCString> mVArrayOfnsCString;
    };
    Type mType;
};
} // namespace ipc
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::ipc::CStringArrayResponse>
{
    typedef ::mozilla::ipc::CStringArrayResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union OriginUsageMetadataArrayResponse|
//
namespace mozilla {
namespace dom {
namespace quota {
class OriginUsageMetadataArrayResponse final
{
public:
    enum Type {
        T__None,
        Tnsresult = 1,
        TOriginUsageMetadataArray,
        T__Last = TOriginUsageMetadataArray
    };

private:
    typedef ::nsresult nsresult;
    typedef ::mozilla::dom::quota::OriginUsageMetadataArray OriginUsageMetadataArray;
    typedef nsresult nsresult__tdef;
    typedef OriginUsageMetadataArray OriginUsageMetadataArray__tdef;

    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }
    OriginUsageMetadataArray*
    ptr_OriginUsageMetadataArray()
    {
        return (&(mVOriginUsageMetadataArray));
    }
    const OriginUsageMetadataArray*
    constptr_OriginUsageMetadataArray() const
    {
        return (&(mVOriginUsageMetadataArray));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT OriginUsageMetadataArrayResponse() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT OriginUsageMetadataArrayResponse(const nsresult& aOther);

    MOZ_IMPLICIT OriginUsageMetadataArrayResponse(nsresult&& aOther);

    MOZ_IMPLICIT OriginUsageMetadataArrayResponse(OriginUsageMetadataArray&& aOther);

    MOZ_IMPLICIT OriginUsageMetadataArrayResponse(OriginUsageMetadataArrayResponse&& aOther);

    ~OriginUsageMetadataArrayResponse();

    Type
    type() const
    {
        return mType;
    }

    OriginUsageMetadataArrayResponse&
    operator=(const nsresult& aRhs);

    OriginUsageMetadataArrayResponse&
    operator=(nsresult&& aRhs);

    OriginUsageMetadataArrayResponse&
    operator=(OriginUsageMetadataArray&& aRhs);

    OriginUsageMetadataArrayResponse&
    operator=(OriginUsageMetadataArrayResponse&& aRhs);

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

    OriginUsageMetadataArray&
    get_OriginUsageMetadataArray()
    {
        AssertSanity(TOriginUsageMetadataArray);
        return (*(ptr_OriginUsageMetadataArray()));
    }
    const OriginUsageMetadataArray&
    get_OriginUsageMetadataArray() const
    {
        AssertSanity(TOriginUsageMetadataArray);
        return (*(constptr_OriginUsageMetadataArray()));
    }
    operator OriginUsageMetadataArray&()
    {
        return get_OriginUsageMetadataArray();
    }
    operator const OriginUsageMetadataArray&() const
    {
        return get_OriginUsageMetadataArray();
    }

private:
    union {
        nsresult mVnsresult;
        OriginUsageMetadataArray mVOriginUsageMetadataArray;
    };
    Type mType;
};
} // namespace quota
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::quota::OriginUsageMetadataArrayResponse>
{
    typedef ::mozilla::dom::quota::OriginUsageMetadataArrayResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            paramType&& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union UsageInfoResponse|
//
namespace mozilla {
namespace dom {
namespace quota {
class UsageInfoResponse final
{
public:
    enum Type {
        T__None,
        Tnsresult = 1,
        TUsageInfo,
        T__Last = TUsageInfo
    };

private:
    typedef ::nsresult nsresult;
    typedef ::mozilla::dom::quota::UsageInfo UsageInfo;
    typedef nsresult nsresult__tdef;
    typedef UsageInfo UsageInfo__tdef;

    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }
    UsageInfo*
    ptr_UsageInfo()
    {
        return (&(mVUsageInfo));
    }
    const UsageInfo*
    constptr_UsageInfo() const
    {
        return (&(mVUsageInfo));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT UsageInfoResponse() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT UsageInfoResponse(const nsresult& aOther);

    MOZ_IMPLICIT UsageInfoResponse(nsresult&& aOther);

    MOZ_IMPLICIT UsageInfoResponse(const UsageInfo& aOther);

    MOZ_IMPLICIT UsageInfoResponse(UsageInfo&& aOther);

    MOZ_IMPLICIT UsageInfoResponse(const UsageInfoResponse& aOther);

    MOZ_IMPLICIT UsageInfoResponse(UsageInfoResponse&& aOther);

    ~UsageInfoResponse();

    Type
    type() const
    {
        return mType;
    }

    UsageInfoResponse&
    operator=(const nsresult& aRhs);

    UsageInfoResponse&
    operator=(nsresult&& aRhs);

    UsageInfoResponse&
    operator=(const UsageInfo& aRhs);

    UsageInfoResponse&
    operator=(UsageInfo&& aRhs);

    UsageInfoResponse&
    operator=(const UsageInfoResponse& aRhs);

    UsageInfoResponse&
    operator=(UsageInfoResponse&& aRhs);

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

    UsageInfo&
    get_UsageInfo()
    {
        AssertSanity(TUsageInfo);
        return (*(ptr_UsageInfo()));
    }
    const UsageInfo&
    get_UsageInfo() const
    {
        AssertSanity(TUsageInfo);
        return (*(constptr_UsageInfo()));
    }
    operator UsageInfo&()
    {
        return get_UsageInfo();
    }
    operator const UsageInfo&() const
    {
        return get_UsageInfo();
    }

private:
    union {
        nsresult mVnsresult;
        UsageInfo mVUsageInfo;
    };
    Type mType;
};
} // namespace quota
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::quota::UsageInfoResponse>
{
    typedef ::mozilla::dom::quota::UsageInfoResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct StorageNameParams|
//
namespace mozilla {
namespace dom {
namespace quota {
class StorageNameParams final
{
private:

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    StorageNameParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

private:
};
} // namespace quota
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::quota::StorageNameParams>
{
    typedef ::mozilla::dom::quota::StorageNameParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct GetFullOriginMetadataParams|
//
namespace mozilla {
namespace dom {
namespace quota {
class GetFullOriginMetadataParams final
{
private:
    typedef ::mozilla::dom::quota::PersistenceType PersistenceType;
    typedef ::mozilla::ipc::PrincipalInfo PrincipalInfo;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    GetFullOriginMetadataParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT GetFullOriginMetadataParams(
            const PersistenceType& _persistenceType,
            const PrincipalInfo& _principalInfo) :
        persistenceType_(_persistenceType),
        principalInfo_(_principalInfo)
    {
    }

    MOZ_IMPLICIT GetFullOriginMetadataParams(
            PersistenceType&& _persistenceType,
            PrincipalInfo&& _principalInfo) :
        persistenceType_(std::move(_persistenceType)),
        principalInfo_(std::move(_principalInfo))
    {
    }

    PersistenceType&
    persistenceType()
    {
        return persistenceType_;
    }
    const PersistenceType&
    persistenceType() const
    {
        return persistenceType_;
    }

    PrincipalInfo&
    principalInfo()
    {
        return principalInfo_;
    }
    const PrincipalInfo&
    principalInfo() const
    {
        return principalInfo_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<PersistenceType> persistenceType_;
    ::mozilla::ipc::IPDLStructMember<PrincipalInfo> principalInfo_;
};
} // namespace quota
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::quota::GetFullOriginMetadataParams>
{
    typedef ::mozilla::dom::quota::GetFullOriginMetadataParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClearResetOriginParams|
//
namespace mozilla {
namespace dom {
namespace quota {
class ClearResetOriginParams final
{
private:
    typedef ::mozilla::ipc::PrincipalInfo PrincipalInfo;
    typedef ::mozilla::dom::quota::PersistenceType PersistenceType;
    typedef ::mozilla::dom::quota::Client::Type Type;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClearResetOriginParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClearResetOriginParams(
            const PrincipalInfo& _principalInfo,
            const PersistenceType& _persistenceType,
            const bool& _persistenceTypeIsExplicit,
            const Type& _clientType,
            const bool& _clientTypeIsExplicit) :
        principalInfo_(_principalInfo),
        persistenceType_(_persistenceType),
        persistenceTypeIsExplicit_(_persistenceTypeIsExplicit),
        clientType_(_clientType),
        clientTypeIsExplicit_(_clientTypeIsExplicit)
    {
    }

    MOZ_IMPLICIT ClearResetOriginParams(
            PrincipalInfo&& _principalInfo,
            PersistenceType&& _persistenceType,
            bool&& _persistenceTypeIsExplicit,
            Type&& _clientType,
            bool&& _clientTypeIsExplicit) :
        principalInfo_(std::move(_principalInfo)),
        persistenceType_(std::move(_persistenceType)),
        persistenceTypeIsExplicit_(std::move(_persistenceTypeIsExplicit)),
        clientType_(std::move(_clientType)),
        clientTypeIsExplicit_(std::move(_clientTypeIsExplicit))
    {
    }

    PrincipalInfo&
    principalInfo()
    {
        return principalInfo_;
    }
    const PrincipalInfo&
    principalInfo() const
    {
        return principalInfo_;
    }

    PersistenceType&
    persistenceType()
    {
        return persistenceType_;
    }
    const PersistenceType&
    persistenceType() const
    {
        return persistenceType_;
    }

    bool&
    persistenceTypeIsExplicit()
    {
        return persistenceTypeIsExplicit_;
    }
    const bool&
    persistenceTypeIsExplicit() const
    {
        return persistenceTypeIsExplicit_;
    }

    Type&
    clientType()
    {
        return clientType_;
    }
    const Type&
    clientType() const
    {
        return clientType_;
    }

    bool&
    clientTypeIsExplicit()
    {
        return clientTypeIsExplicit_;
    }
    const bool&
    clientTypeIsExplicit() const
    {
        return clientTypeIsExplicit_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<PrincipalInfo> principalInfo_;
    ::mozilla::ipc::IPDLStructMember<PersistenceType> persistenceType_;
    ::mozilla::ipc::IPDLStructMember<bool> persistenceTypeIsExplicit_;
    ::mozilla::ipc::IPDLStructMember<Type> clientType_;
    ::mozilla::ipc::IPDLStructMember<bool> clientTypeIsExplicit_;
};
} // namespace quota
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::quota::ClearResetOriginParams>
{
    typedef ::mozilla::dom::quota::ClearResetOriginParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct PersistedParams|
//
namespace mozilla {
namespace dom {
namespace quota {
class PersistedParams final
{
private:
    typedef ::mozilla::ipc::PrincipalInfo PrincipalInfo;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    PersistedParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT PersistedParams(const PrincipalInfo& _principalInfo) :
        principalInfo_(_principalInfo)
    {
    }

    MOZ_IMPLICIT PersistedParams(PrincipalInfo&& _principalInfo) :
        principalInfo_(std::move(_principalInfo))
    {
    }

    PrincipalInfo&
    principalInfo()
    {
        return principalInfo_;
    }
    const PrincipalInfo&
    principalInfo() const
    {
        return principalInfo_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<PrincipalInfo> principalInfo_;
};
} // namespace quota
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::quota::PersistedParams>
{
    typedef ::mozilla::dom::quota::PersistedParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct PersistParams|
//
namespace mozilla {
namespace dom {
namespace quota {
class PersistParams final
{
private:
    typedef ::mozilla::ipc::PrincipalInfo PrincipalInfo;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    PersistParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT PersistParams(const PrincipalInfo& _principalInfo) :
        principalInfo_(_principalInfo)
    {
    }

    MOZ_IMPLICIT PersistParams(PrincipalInfo&& _principalInfo) :
        principalInfo_(std::move(_principalInfo))
    {
    }

    PrincipalInfo&
    principalInfo()
    {
        return principalInfo_;
    }
    const PrincipalInfo&
    principalInfo() const
    {
        return principalInfo_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<PrincipalInfo> principalInfo_;
};
} // namespace quota
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::quota::PersistParams>
{
    typedef ::mozilla::dom::quota::PersistParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct EstimateParams|
//
namespace mozilla {
namespace dom {
namespace quota {
class EstimateParams final
{
private:
    typedef ::mozilla::ipc::PrincipalInfo PrincipalInfo;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    EstimateParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT EstimateParams(const PrincipalInfo& _principalInfo) :
        principalInfo_(_principalInfo)
    {
    }

    MOZ_IMPLICIT EstimateParams(PrincipalInfo&& _principalInfo) :
        principalInfo_(std::move(_principalInfo))
    {
    }

    PrincipalInfo&
    principalInfo()
    {
        return principalInfo_;
    }
    const PrincipalInfo&
    principalInfo() const
    {
        return principalInfo_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<PrincipalInfo> principalInfo_;
};
} // namespace quota
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::quota::EstimateParams>
{
    typedef ::mozilla::dom::quota::EstimateParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union RequestParams|
//
namespace mozilla {
namespace dom {
namespace quota {
class RequestParams final
{
public:
    enum Type {
        T__None,
        TStorageNameParams = 1,
        TGetFullOriginMetadataParams,
        TPersistedParams,
        TPersistParams,
        TEstimateParams,
        T__Last = TEstimateParams
    };

private:
    typedef ::mozilla::dom::quota::StorageNameParams StorageNameParams;
    typedef ::mozilla::dom::quota::GetFullOriginMetadataParams GetFullOriginMetadataParams;
    typedef ::mozilla::dom::quota::PersistedParams PersistedParams;
    typedef ::mozilla::dom::quota::PersistParams PersistParams;
    typedef ::mozilla::dom::quota::EstimateParams EstimateParams;
    typedef StorageNameParams StorageNameParams__tdef;
    typedef GetFullOriginMetadataParams GetFullOriginMetadataParams__tdef;
    typedef PersistedParams PersistedParams__tdef;
    typedef PersistParams PersistParams__tdef;
    typedef EstimateParams EstimateParams__tdef;

    StorageNameParams*
    ptr_StorageNameParams()
    {
        return (&(mVStorageNameParams));
    }
    const StorageNameParams*
    constptr_StorageNameParams() const
    {
        return (&(mVStorageNameParams));
    }
    GetFullOriginMetadataParams*
    ptr_GetFullOriginMetadataParams()
    {
        return (&(mVGetFullOriginMetadataParams));
    }
    const GetFullOriginMetadataParams*
    constptr_GetFullOriginMetadataParams() const
    {
        return (&(mVGetFullOriginMetadataParams));
    }
    PersistedParams*
    ptr_PersistedParams()
    {
        return (&(mVPersistedParams));
    }
    const PersistedParams*
    constptr_PersistedParams() const
    {
        return (&(mVPersistedParams));
    }
    PersistParams*
    ptr_PersistParams()
    {
        return (&(mVPersistParams));
    }
    const PersistParams*
    constptr_PersistParams() const
    {
        return (&(mVPersistParams));
    }
    EstimateParams*
    ptr_EstimateParams()
    {
        return (&(mVEstimateParams));
    }
    const EstimateParams*
    constptr_EstimateParams() const
    {
        return (&(mVEstimateParams));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT RequestParams() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT RequestParams(const StorageNameParams& aOther);

    MOZ_IMPLICIT RequestParams(StorageNameParams&& aOther);

    MOZ_IMPLICIT RequestParams(const GetFullOriginMetadataParams& aOther);

    MOZ_IMPLICIT RequestParams(GetFullOriginMetadataParams&& aOther);

    MOZ_IMPLICIT RequestParams(const PersistedParams& aOther);

    MOZ_IMPLICIT RequestParams(PersistedParams&& aOther);

    MOZ_IMPLICIT RequestParams(const PersistParams& aOther);

    MOZ_IMPLICIT RequestParams(PersistParams&& aOther);

    MOZ_IMPLICIT RequestParams(const EstimateParams& aOther);

    MOZ_IMPLICIT RequestParams(EstimateParams&& aOther);

    MOZ_IMPLICIT RequestParams(const RequestParams& aOther);

    MOZ_IMPLICIT RequestParams(RequestParams&& aOther);

    ~RequestParams();

    Type
    type() const
    {
        return mType;
    }

    RequestParams&
    operator=(const StorageNameParams& aRhs);

    RequestParams&
    operator=(StorageNameParams&& aRhs);

    RequestParams&
    operator=(const GetFullOriginMetadataParams& aRhs);

    RequestParams&
    operator=(GetFullOriginMetadataParams&& aRhs);

    RequestParams&
    operator=(const PersistedParams& aRhs);

    RequestParams&
    operator=(PersistedParams&& aRhs);

    RequestParams&
    operator=(const PersistParams& aRhs);

    RequestParams&
    operator=(PersistParams&& aRhs);

    RequestParams&
    operator=(const EstimateParams& aRhs);

    RequestParams&
    operator=(EstimateParams&& aRhs);

    RequestParams&
    operator=(const RequestParams& aRhs);

    RequestParams&
    operator=(RequestParams&& aRhs);

    StorageNameParams&
    get_StorageNameParams()
    {
        AssertSanity(TStorageNameParams);
        return (*(ptr_StorageNameParams()));
    }
    const StorageNameParams&
    get_StorageNameParams() const
    {
        AssertSanity(TStorageNameParams);
        return (*(constptr_StorageNameParams()));
    }
    operator StorageNameParams&()
    {
        return get_StorageNameParams();
    }
    operator const StorageNameParams&() const
    {
        return get_StorageNameParams();
    }

    GetFullOriginMetadataParams&
    get_GetFullOriginMetadataParams()
    {
        AssertSanity(TGetFullOriginMetadataParams);
        return (*(ptr_GetFullOriginMetadataParams()));
    }
    const GetFullOriginMetadataParams&
    get_GetFullOriginMetadataParams() const
    {
        AssertSanity(TGetFullOriginMetadataParams);
        return (*(constptr_GetFullOriginMetadataParams()));
    }
    operator GetFullOriginMetadataParams&()
    {
        return get_GetFullOriginMetadataParams();
    }
    operator const GetFullOriginMetadataParams&() const
    {
        return get_GetFullOriginMetadataParams();
    }

    PersistedParams&
    get_PersistedParams()
    {
        AssertSanity(TPersistedParams);
        return (*(ptr_PersistedParams()));
    }
    const PersistedParams&
    get_PersistedParams() const
    {
        AssertSanity(TPersistedParams);
        return (*(constptr_PersistedParams()));
    }
    operator PersistedParams&()
    {
        return get_PersistedParams();
    }
    operator const PersistedParams&() const
    {
        return get_PersistedParams();
    }

    PersistParams&
    get_PersistParams()
    {
        AssertSanity(TPersistParams);
        return (*(ptr_PersistParams()));
    }
    const PersistParams&
    get_PersistParams() const
    {
        AssertSanity(TPersistParams);
        return (*(constptr_PersistParams()));
    }
    operator PersistParams&()
    {
        return get_PersistParams();
    }
    operator const PersistParams&() const
    {
        return get_PersistParams();
    }

    EstimateParams&
    get_EstimateParams()
    {
        AssertSanity(TEstimateParams);
        return (*(ptr_EstimateParams()));
    }
    const EstimateParams&
    get_EstimateParams() const
    {
        AssertSanity(TEstimateParams);
        return (*(constptr_EstimateParams()));
    }
    operator EstimateParams&()
    {
        return get_EstimateParams();
    }
    operator const EstimateParams&() const
    {
        return get_EstimateParams();
    }

private:
    union {
        StorageNameParams mVStorageNameParams;
        GetFullOriginMetadataParams mVGetFullOriginMetadataParams;
        PersistedParams mVPersistedParams;
        PersistParams mVPersistParams;
        EstimateParams mVEstimateParams;
    };
    Type mType;
};
} // namespace quota
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::quota::RequestParams>
{
    typedef ::mozilla::dom::quota::RequestParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace dom {
namespace quota {
class PQuotaParent;
} // namespace quota
} // namespace dom
} // namespace mozilla
namespace mozilla {
namespace dom {
namespace quota {
class PQuotaChild;
} // namespace quota
} // namespace dom
} // namespace mozilla

//-----------------------------------------------------------------------------
// Code common to PQuotaChild and PQuotaParent
//
namespace mozilla {
namespace dom {
namespace quota {
namespace PQuota {

nsresult
CreateEndpoints(
        mozilla::ipc::EndpointProcInfo aParentDestInfo,
        mozilla::ipc::EndpointProcInfo aChildDestInfo,
        mozilla::ipc::Endpoint<::mozilla::dom::quota::PQuotaParent>* aParent,
        mozilla::ipc::Endpoint<::mozilla::dom::quota::PQuotaChild>* aChild);

enum MessageType {
    PQuotaStart = PQuotaMsgStart << 16,
    Msg___delete____ID,
    Reply___delete____ID,
    Msg_PQuotaRequestConstructor__ID,
    Reply_PQuotaRequestConstructor__ID,
    Msg_StorageInitialized__ID,
    Reply_StorageInitialized__ID,
    Msg_PersistentStorageInitialized__ID,
    Reply_PersistentStorageInitialized__ID,
    Msg_TemporaryStorageInitialized__ID,
    Reply_TemporaryStorageInitialized__ID,
    Msg_TemporaryGroupInitialized__ID,
    Reply_TemporaryGroupInitialized__ID,
    Msg_PersistentOriginInitialized__ID,
    Reply_PersistentOriginInitialized__ID,
    Msg_TemporaryOriginInitialized__ID,
    Reply_TemporaryOriginInitialized__ID,
    Msg_InitializeStorage__ID,
    Reply_InitializeStorage__ID,
    Msg_InitializePersistentStorage__ID,
    Reply_InitializePersistentStorage__ID,
    Msg_InitializeAllTemporaryOrigins__ID,
    Reply_InitializeAllTemporaryOrigins__ID,
    Msg_InitializeTemporaryGroup__ID,
    Reply_InitializeTemporaryGroup__ID,
    Msg_InitializePersistentOrigin__ID,
    Reply_InitializePersistentOrigin__ID,
    Msg_InitializeTemporaryOrigin__ID,
    Reply_InitializeTemporaryOrigin__ID,
    Msg_InitializePersistentClient__ID,
    Reply_InitializePersistentClient__ID,
    Msg_InitializeTemporaryClient__ID,
    Reply_InitializeTemporaryClient__ID,
    Msg_InitializeTemporaryStorage__ID,
    Reply_InitializeTemporaryStorage__ID,
    Msg_GetUsage__ID,
    Reply_GetUsage__ID,
    Msg_GetOriginUsage__ID,
    Reply_GetOriginUsage__ID,
    Msg_GetCachedOriginUsage__ID,
    Reply_GetCachedOriginUsage__ID,
    Msg_ListOrigins__ID,
    Reply_ListOrigins__ID,
    Msg_ListCachedOrigins__ID,
    Reply_ListCachedOrigins__ID,
    Msg_ClearStoragesForOrigin__ID,
    Reply_ClearStoragesForOrigin__ID,
    Msg_ClearStoragesForClient__ID,
    Reply_ClearStoragesForClient__ID,
    Msg_ClearStoragesForOriginPrefix__ID,
    Reply_ClearStoragesForOriginPrefix__ID,
    Msg_ClearStoragesForOriginAttributesPattern__ID,
    Reply_ClearStoragesForOriginAttributesPattern__ID,
    Msg_ClearStoragesForPrivateBrowsing__ID,
    Reply_ClearStoragesForPrivateBrowsing__ID,
    Msg_ClearStorage__ID,
    Reply_ClearStorage__ID,
    Msg_ShutdownStoragesForOrigin__ID,
    Reply_ShutdownStoragesForOrigin__ID,
    Msg_ShutdownStoragesForClient__ID,
    Reply_ShutdownStoragesForClient__ID,
    Msg_ShutdownStorage__ID,
    Reply_ShutdownStorage__ID,
    Msg_StartIdleMaintenance__ID,
    Msg_StopIdleMaintenance__ID,
    Msg_AbortOperationsForProcess__ID,
    Msg_SetThumbnailPrivateIdentityId__ID,
    PQuotaEnd
};

mozilla::UniquePtr<IPC::Message>
Msg___delete__(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply___delete__(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PQuotaRequestConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PQuotaRequestConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_StorageInitialized(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_StorageInitialized(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PersistentStorageInitialized(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PersistentStorageInitialized(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_TemporaryStorageInitialized(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_TemporaryStorageInitialized(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_TemporaryGroupInitialized(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_TemporaryGroupInitialized(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PersistentOriginInitialized(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PersistentOriginInitialized(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_TemporaryOriginInitialized(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_TemporaryOriginInitialized(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitializeStorage(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_InitializeStorage(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitializePersistentStorage(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_InitializePersistentStorage(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitializeAllTemporaryOrigins(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_InitializeAllTemporaryOrigins(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitializeTemporaryGroup(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_InitializeTemporaryGroup(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitializePersistentOrigin(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_InitializePersistentOrigin(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitializeTemporaryOrigin(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_InitializeTemporaryOrigin(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitializePersistentClient(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_InitializePersistentClient(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitializeTemporaryClient(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_InitializeTemporaryClient(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitializeTemporaryStorage(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_InitializeTemporaryStorage(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetUsage(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetUsage(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetOriginUsage(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetOriginUsage(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetCachedOriginUsage(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetCachedOriginUsage(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ListOrigins(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_ListOrigins(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ListCachedOrigins(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_ListCachedOrigins(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ClearStoragesForOrigin(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_ClearStoragesForOrigin(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ClearStoragesForClient(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_ClearStoragesForClient(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ClearStoragesForOriginPrefix(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_ClearStoragesForOriginPrefix(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ClearStoragesForOriginAttributesPattern(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_ClearStoragesForOriginAttributesPattern(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ClearStoragesForPrivateBrowsing(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_ClearStoragesForPrivateBrowsing(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ClearStorage(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_ClearStorage(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ShutdownStoragesForOrigin(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_ShutdownStoragesForOrigin(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ShutdownStoragesForClient(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_ShutdownStoragesForClient(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ShutdownStorage(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_ShutdownStorage(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_StartIdleMaintenance(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_StopIdleMaintenance(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AbortOperationsForProcess(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetThumbnailPrivateIdentityId(IPC::Message::routeid_t routingId);



} // namespace PQuota
} // namespace quota
} // namespace dom
} // namespace mozilla

#endif // ifndef PQuota_h
