// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
	"github.com/go-acme/jdcloud-sdk-go/core"
)

type ModifyDomainRequest struct {
	core.JDCloudRequest

	/* 实例所属的地域ID  */
	RegionId string `json:"regionId"`

	/* 域名ID，请使用describeDomains接口获取。  */
	DomainId string `json:"domainId"`

	/* 需要修改的主域名，请使用describeDomains接口获取  */
	DomainName string `json:"domainName"`
}

/*
 * param regionId: 实例所属的地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 * param domainName: 需要修改的主域名，请使用describeDomains接口获取 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewModifyDomainRequest(
	regionId string,
	domainId string,
	domainName string,
) *ModifyDomainRequest {

	return &ModifyDomainRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}",
			Method:  "PUT",
			Header:  nil,
			Version: "v2",
		},
		RegionId:   regionId,
		DomainId:   domainId,
		DomainName: domainName,
	}
}

/*
 * param regionId: 实例所属的地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 * param domainName: 需要修改的主域名，请使用describeDomains接口获取 (Required)
 */
func NewModifyDomainRequestWithAllParams(
	regionId string,
	domainId string,
	domainName string,
) *ModifyDomainRequest {

	return &ModifyDomainRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}",
			Method:  "PUT",
			Header:  nil,
			Version: "v2",
		},
		RegionId:   regionId,
		DomainId:   domainId,
		DomainName: domainName,
	}
}

/* This constructor has better compatible ability when API parameters changed */
func NewModifyDomainRequestWithoutParam() *ModifyDomainRequest {

	return &ModifyDomainRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}",
			Method:  "PUT",
			Header:  nil,
			Version: "v2",
		},
	}
}

/* param regionId: 实例所属的地域ID(Required) */
func (r *ModifyDomainRequest) SetRegionId(regionId string) {
	r.RegionId = regionId
}

/* param domainId: 域名ID，请使用describeDomains接口获取。(Required) */
func (r *ModifyDomainRequest) SetDomainId(domainId string) {
	r.DomainId = domainId
}

/* param domainName: 需要修改的主域名，请使用describeDomains接口获取(Required) */
func (r *ModifyDomainRequest) SetDomainName(domainName string) {
	r.DomainName = domainName
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r ModifyDomainRequest) GetRegionId() string {
	return r.RegionId
}

type ModifyDomainResponse struct {
	RequestID string             `json:"requestId"`
	Error     core.ErrorResponse `json:"error"`
	Result    ModifyDomainResult `json:"result"`
}

type ModifyDomainResult struct {
}
