/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	intstr "k8s.io/apimachinery/pkg/util/intstr"
)

// CircuitBreakerApplyConfiguration represents a declarative configuration of the CircuitBreaker type for use
// with apply.
type CircuitBreakerApplyConfiguration struct {
	Expression       *string             `json:"expression,omitempty"`
	CheckPeriod      *intstr.IntOrString `json:"checkPeriod,omitempty"`
	FallbackDuration *intstr.IntOrString `json:"fallbackDuration,omitempty"`
	RecoveryDuration *intstr.IntOrString `json:"recoveryDuration,omitempty"`
	ResponseCode     *int                `json:"responseCode,omitempty"`
}

// CircuitBreakerApplyConfiguration constructs a declarative configuration of the CircuitBreaker type for use with
// apply.
func CircuitBreaker() *CircuitBreakerApplyConfiguration {
	return &CircuitBreakerApplyConfiguration{}
}

// WithExpression sets the Expression field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Expression field is set to the value of the last call.
func (b *CircuitBreakerApplyConfiguration) WithExpression(value string) *CircuitBreakerApplyConfiguration {
	b.Expression = &value
	return b
}

// WithCheckPeriod sets the CheckPeriod field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CheckPeriod field is set to the value of the last call.
func (b *CircuitBreakerApplyConfiguration) WithCheckPeriod(value intstr.IntOrString) *CircuitBreakerApplyConfiguration {
	b.CheckPeriod = &value
	return b
}

// WithFallbackDuration sets the FallbackDuration field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FallbackDuration field is set to the value of the last call.
func (b *CircuitBreakerApplyConfiguration) WithFallbackDuration(value intstr.IntOrString) *CircuitBreakerApplyConfiguration {
	b.FallbackDuration = &value
	return b
}

// WithRecoveryDuration sets the RecoveryDuration field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RecoveryDuration field is set to the value of the last call.
func (b *CircuitBreakerApplyConfiguration) WithRecoveryDuration(value intstr.IntOrString) *CircuitBreakerApplyConfiguration {
	b.RecoveryDuration = &value
	return b
}

// WithResponseCode sets the ResponseCode field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResponseCode field is set to the value of the last call.
func (b *CircuitBreakerApplyConfiguration) WithResponseCode(value int) *CircuitBreakerApplyConfiguration {
	b.ResponseCode = &value
	return b
}
