// Display images inside a terminal
// Copyright (C) 2023  JustKidding
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef WAYLAND_SHM_H
#define WAYLAND_SHM_H

#include <string>
#include <wayland-client.h>

class WaylandShm
{
  public:
    WaylandShm(int width, int height, int scale_factor, struct wl_shm *shm);
    ~WaylandShm();

    struct wl_buffer *buffer = nullptr;
    uint8_t *pool_data;

  private:
    void create_shm_file();
    void allocate_pool_buffers();

    struct wl_shm *shm = nullptr;

    int fd = 0;
    std::string shm_path;

    int width = 0;
    int height = 0;
    int stride = 0;
    int pool_size = 0;
};

#endif
