// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off
#include <QJSValue>
#include <QObject>
#include <QProperty>
#include <qqmlregistration.h>


#include <properties/ShadowProperty.h>

#include "OffsetPropertyGroup.h"
#include "LinePropertyGroup.h"
#include "LinePropertyGroup.h"
#include "LinePropertyGroup.h"
#include "LinePropertyGroup.h"
#include "CornerPropertyGroup.h"
#include "CornerPropertyGroup.h"
#include "CornerPropertyGroup.h"
#include "CornerPropertyGroup.h"
// clang-format on

class QuickStyle;

/*!
 * \qmltype ShadowPropertyGroup
 * \inqmlmodule org.kde.union.impl
 * \ingroup qtquick-properties
 *
 * \brief A group object exposing the properties of ShadowProperty to QML.
 */
class ShadowPropertyGroup : public QObject
{
    Q_OBJECT
    QML_ANONYMOUS

public:
    explicit ShadowPropertyGroup(QuickStyle *style);

    void update(Union::Properties::ShadowProperty *newState);
    Q_SIGNAL void updated();

    void refreshColors();

    /*!
     * \qmlproperty OffsetPropertyGroup ShadowPropertyGroup::offset
     *
     * Exposes ShadowProperty::OffsetProperty to QML.
     */
    Q_PROPERTY(OffsetPropertyGroup *offset READ offset CONSTANT)
    OffsetPropertyGroup *offset() const;

    /*!
     * \qmlproperty Union::Color ShadowPropertyGroup::color
     *
     * Exposes ShadowProperty::color to QML.
     */
    Q_PROPERTY(QJSValue color READ color NOTIFY colorChanged)
    QJSValue color() const;
    Q_SIGNAL void colorChanged();

    /*!
     * \qmlproperty qreal ShadowPropertyGroup::size
     *
     * Exposes ShadowProperty::size to QML.
     */
    Q_PROPERTY(QJSValue size READ size NOTIFY sizeChanged)
    QJSValue size() const;
    Q_SIGNAL void sizeChanged();

    /*!
     * \qmlproperty qreal ShadowPropertyGroup::blur
     *
     * Exposes ShadowProperty::blur to QML.
     */
    Q_PROPERTY(QJSValue blur READ blur NOTIFY blurChanged)
    QJSValue blur() const;
    Q_SIGNAL void blurChanged();

    /*!
     * \qmlproperty LinePropertyGroup ShadowPropertyGroup::left
     *
     * Exposes ShadowProperty::LineProperty to QML.
     */
    Q_PROPERTY(LinePropertyGroup *left READ left CONSTANT)
    LinePropertyGroup *left() const;

    /*!
     * \qmlproperty LinePropertyGroup ShadowPropertyGroup::right
     *
     * Exposes ShadowProperty::LineProperty to QML.
     */
    Q_PROPERTY(LinePropertyGroup *right READ right CONSTANT)
    LinePropertyGroup *right() const;

    /*!
     * \qmlproperty LinePropertyGroup ShadowPropertyGroup::top
     *
     * Exposes ShadowProperty::LineProperty to QML.
     */
    Q_PROPERTY(LinePropertyGroup *top READ top CONSTANT)
    LinePropertyGroup *top() const;

    /*!
     * \qmlproperty LinePropertyGroup ShadowPropertyGroup::bottom
     *
     * Exposes ShadowProperty::LineProperty to QML.
     */
    Q_PROPERTY(LinePropertyGroup *bottom READ bottom CONSTANT)
    LinePropertyGroup *bottom() const;

    /*!
     * \qmlproperty CornerPropertyGroup ShadowPropertyGroup::topLeft
     *
     * Exposes ShadowProperty::CornerProperty to QML.
     */
    Q_PROPERTY(CornerPropertyGroup *topLeft READ topLeft CONSTANT)
    CornerPropertyGroup *topLeft() const;

    /*!
     * \qmlproperty CornerPropertyGroup ShadowPropertyGroup::topRight
     *
     * Exposes ShadowProperty::CornerProperty to QML.
     */
    Q_PROPERTY(CornerPropertyGroup *topRight READ topRight CONSTANT)
    CornerPropertyGroup *topRight() const;

    /*!
     * \qmlproperty CornerPropertyGroup ShadowPropertyGroup::bottomLeft
     *
     * Exposes ShadowProperty::CornerProperty to QML.
     */
    Q_PROPERTY(CornerPropertyGroup *bottomLeft READ bottomLeft CONSTANT)
    CornerPropertyGroup *bottomLeft() const;

    /*!
     * \qmlproperty CornerPropertyGroup ShadowPropertyGroup::bottomRight
     *
     * Exposes ShadowProperty::CornerProperty to QML.
     */
    Q_PROPERTY(CornerPropertyGroup *bottomRight READ bottomRight CONSTANT)
    CornerPropertyGroup *bottomRight() const;

private:
    QuickStyle *m_style = nullptr;
    std::unique_ptr<OffsetPropertyGroup> m_offset;
    std::unique_ptr<LinePropertyGroup> m_left;
    std::unique_ptr<LinePropertyGroup> m_right;
    std::unique_ptr<LinePropertyGroup> m_top;
    std::unique_ptr<LinePropertyGroup> m_bottom;
    std::unique_ptr<CornerPropertyGroup> m_topLeft;
    std::unique_ptr<CornerPropertyGroup> m_topRight;
    std::unique_ptr<CornerPropertyGroup> m_bottomLeft;
    std::unique_ptr<CornerPropertyGroup> m_bottomRight;

    Union::Properties::ShadowProperty *m_state = nullptr;
};