// python wrapper for vtkmFilterOverrides
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkmFilterOverrides.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkmFilterOverrides(PyObject *dict); }

static PyObject *
PyvtkmFilterOverrides_SetEnabled(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetEnabled");

  bool temp0 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkmFilterOverrides::SetEnabled(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkmFilterOverrides_GetEnabled(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetEnabled");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkmFilterOverrides::GetEnabled();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkmFilterOverrides_EnabledOn(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "EnabledOn");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkmFilterOverrides::EnabledOn();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkmFilterOverrides_EnabledOff(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "EnabledOff");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkmFilterOverrides::EnabledOff();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkmFilterOverrides_Methods[] = {
  {"SetEnabled", PyvtkmFilterOverrides_SetEnabled, METH_VARARGS,
   "SetEnabled(value:bool) -> None\nC++: static void SetEnabled(bool value)\n\nRuntime enable/disable for Viskores filter overrides using the\nobject factory. This only has effect if the cmake option\n`VTK_ENABLE_VISKORES_OVERRIDES` is set. This also only affects\nfilters that have a Viskores override. Disabled by default.\n"},
  {"GetEnabled", PyvtkmFilterOverrides_GetEnabled, METH_VARARGS,
   "GetEnabled() -> bool\nC++: static bool GetEnabled()\n\n"},
  {"EnabledOn", PyvtkmFilterOverrides_EnabledOn, METH_VARARGS,
   "EnabledOn() -> None\nC++: static void EnabledOn()\n\n"},
  {"EnabledOff", PyvtkmFilterOverrides_EnabledOff, METH_VARARGS,
   "EnabledOff() -> None\nC++: static void EnabledOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkmFilterOverrides_GetSets[] = {
  {
    /*name=*/pystr("enabled"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkmFilterOverrides_GetEnabled(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkmFilterOverrides_SetEnabled(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkmFilterOverrides_SetEnabled(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnabled/SetEnabled\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkmFilterOverrides_vtkmFilterOverrides_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkmFilterOverrides");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkmFilterOverrides *op = new vtkmFilterOverrides();

    result = PyVTKSpecialObject_New("vtkmFilterOverrides", op);
  }

  return result;
}

static PyObject *
PyvtkmFilterOverrides_vtkmFilterOverrides_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkmFilterOverrides");

  vtkmFilterOverrides *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkmFilterOverrides"))
  {
    vtkmFilterOverrides *op = new vtkmFilterOverrides(*temp0);

    result = PyVTKSpecialObject_New("vtkmFilterOverrides", op);
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyMethodDef PyvtkmFilterOverrides_vtkmFilterOverrides_Methods[] = {
  {"vtkmFilterOverrides", PyvtkmFilterOverrides_vtkmFilterOverrides_s2, METH_VARARGS,
   "@W vtkmFilterOverrides"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkmFilterOverrides_vtkmFilterOverrides(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkmFilterOverrides_vtkmFilterOverrides_s1(self, args);
    case 1:
      return PyvtkmFilterOverrides_vtkmFilterOverrides_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkmFilterOverrides");
  return nullptr;
}


static const char *PyvtkmFilterOverrides_Doc =

  "vtkmFilterOverrides() -> vtkmFilterOverrides\nC++: vtkmFilterOverrides()\nvtkmFilterOverrides(__a:vtkmFilterOverrides) -> vtkmFilterOverrides\nC++: vtkmFilterOverrides(const &vtkmFilterOverrides)\n""\n"
  "vtkmFilterOverrides - A class with static methods to turn viskores\nfilter overrides on/off at runtime\n\n"
;

static PyObject *
PyvtkmFilterOverrides_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkmFilterOverrides_vtkmFilterOverrides(nullptr, args);
}

static void PyvtkmFilterOverrides_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkmFilterOverrides *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkmFilterOverrides_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkmFilterOverrides_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkAcceleratorsVTKmFilters.vtkmFilterOverrides", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkmFilterOverrides_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkmFilterOverrides_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkmFilterOverrides_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkmFilterOverrides_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static void *PyvtkmFilterOverrides_CCopy(const void *obj)
{
  if (obj)
  {
    return new vtkmFilterOverrides(*static_cast<const vtkmFilterOverrides*>(obj));
  }
  return nullptr;
}

#ifndef DECLARED_PyvtkmFilterOverrides_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkmFilterOverrides_TypeNew(); }
#define DECLARED_PyvtkmFilterOverrides_TypeNew
#endif

PyObject *PyvtkmFilterOverrides_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkmFilterOverrides_Type,
    PyvtkmFilterOverrides_Methods,
    PyvtkmFilterOverrides_GetSets,
    PyvtkmFilterOverrides_vtkmFilterOverrides_Methods,
    &PyvtkmFilterOverrides_CCopy);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkmFilterOverrides(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkmFilterOverrides_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkmFilterOverrides", o) != 0)
  {
    Py_DECREF(o);
  }

}

