// python wrapper for vtkPResampleWithDataSet
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPResampleWithDataSet.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPResampleWithDataSet(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPResampleWithDataSet_ClassNew(); }


static PyObject *
PyvtkPResampleWithDataSet_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPResampleWithDataSet::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPResampleWithDataSet_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPResampleWithDataSet *op = static_cast<vtkPResampleWithDataSet *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPResampleWithDataSet::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPResampleWithDataSet_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPResampleWithDataSet *tempr = vtkPResampleWithDataSet::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPResampleWithDataSet_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPResampleWithDataSet *op = static_cast<vtkPResampleWithDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPResampleWithDataSet *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPResampleWithDataSet::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPResampleWithDataSet_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPResampleWithDataSet::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPResampleWithDataSet_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPResampleWithDataSet *op = static_cast<vtkPResampleWithDataSet *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPResampleWithDataSet::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPResampleWithDataSet_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPResampleWithDataSet *op = static_cast<vtkPResampleWithDataSet *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkPResampleWithDataSet::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPResampleWithDataSet_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPResampleWithDataSet *op = static_cast<vtkPResampleWithDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkPResampleWithDataSet::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPResampleWithDataSet_SetUseBalancedPartitionForPointsLookup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseBalancedPartitionForPointsLookup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPResampleWithDataSet *op = static_cast<vtkPResampleWithDataSet *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseBalancedPartitionForPointsLookup(temp0);
    }
    else
    {
      op->vtkPResampleWithDataSet::SetUseBalancedPartitionForPointsLookup(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPResampleWithDataSet_GetUseBalancedPartitionForPointsLookup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseBalancedPartitionForPointsLookup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPResampleWithDataSet *op = static_cast<vtkPResampleWithDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseBalancedPartitionForPointsLookup() :
      op->vtkPResampleWithDataSet::GetUseBalancedPartitionForPointsLookup());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPResampleWithDataSet_UseBalancedPartitionForPointsLookupOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseBalancedPartitionForPointsLookupOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPResampleWithDataSet *op = static_cast<vtkPResampleWithDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseBalancedPartitionForPointsLookupOn();
    }
    else
    {
      op->vtkPResampleWithDataSet::UseBalancedPartitionForPointsLookupOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPResampleWithDataSet_UseBalancedPartitionForPointsLookupOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseBalancedPartitionForPointsLookupOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPResampleWithDataSet *op = static_cast<vtkPResampleWithDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseBalancedPartitionForPointsLookupOff();
    }
    else
    {
      op->vtkPResampleWithDataSet::UseBalancedPartitionForPointsLookupOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPResampleWithDataSet_Methods[] = {
  {"IsTypeOf", PyvtkPResampleWithDataSet_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPResampleWithDataSet_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPResampleWithDataSet_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPResampleWithDataSet\nC++: static vtkPResampleWithDataSet *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPResampleWithDataSet_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPResampleWithDataSet\nC++: vtkPResampleWithDataSet *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPResampleWithDataSet_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPResampleWithDataSet_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetController", PyvtkPResampleWithDataSet_SetController, METH_VARARGS,
   "SetController(self, __a:vtkMultiProcessController) -> None\nC++: virtual void SetController(vtkMultiProcessController *)\n\nBy default this filter uses the global controller, but this\nmethod can be used to set another instead.\n"},
  {"GetController", PyvtkPResampleWithDataSet_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController()\n\n"},
  {"SetUseBalancedPartitionForPointsLookup", PyvtkPResampleWithDataSet_SetUseBalancedPartitionForPointsLookup, METH_VARARGS,
   "SetUseBalancedPartitionForPointsLookup(self, _arg:bool) -> None\nC++: virtual void SetUseBalancedPartitionForPointsLookup(\n    bool _arg)\n\nSet/Get if the filter should use Balanced Partitioning for fast\nlookup of the input points. Balanced Partitioning partitions the\npoints into similar sized bins. It takes logarithmic time to\nsearch for the candidate bins, but search inside border bins\ntakes constant time. The default is to use Regular Partitioning\nwhich partitions the space of the points into regular sized bins.\nBased on their distribution, the bins may contain widely varying\nnumber of points. It takes constant time to search for the\ncandidate bins but search within border bins can vary. For most\ncases, both techniques perform the same with Regular Partitioning\nbeing slightly better. Balanced Partitioning may perform better\nwhen the points distribution is highly skewed.\n"},
  {"GetUseBalancedPartitionForPointsLookup", PyvtkPResampleWithDataSet_GetUseBalancedPartitionForPointsLookup, METH_VARARGS,
   "GetUseBalancedPartitionForPointsLookup(self) -> bool\nC++: virtual bool GetUseBalancedPartitionForPointsLookup()\n\n"},
  {"UseBalancedPartitionForPointsLookupOn", PyvtkPResampleWithDataSet_UseBalancedPartitionForPointsLookupOn, METH_VARARGS,
   "UseBalancedPartitionForPointsLookupOn(self) -> None\nC++: virtual void UseBalancedPartitionForPointsLookupOn()\n\n"},
  {"UseBalancedPartitionForPointsLookupOff", PyvtkPResampleWithDataSet_UseBalancedPartitionForPointsLookupOff, METH_VARARGS,
   "UseBalancedPartitionForPointsLookupOff(self) -> None\nC++: virtual void UseBalancedPartitionForPointsLookupOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPResampleWithDataSet_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPResampleWithDataSet_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPResampleWithDataSet_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPResampleWithDataSet_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_balanced_partition_for_points_lookup"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPResampleWithDataSet_GetUseBalancedPartitionForPointsLookup(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPResampleWithDataSet_SetUseBalancedPartitionForPointsLookup(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPResampleWithDataSet_SetUseBalancedPartitionForPointsLookup(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseBalancedPartitionForPointsLookup/SetUseBalancedPartitionForPointsLookup\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPResampleWithDataSet_Doc =
  "vtkPResampleWithDataSet - points from another dataset.\n\n"
  "Superclass: vtkResampleWithDataSet\n\n"
  "vtkPResampleWithDataSet is the parallel version of\n"
  "vtkResampleWithDataSet filter\n"
  "@sa\n"
  "vtkResampleWithDataSet vtkPResampleToImage\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPResampleWithDataSet_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkFiltersParallelDIY2.vtkPResampleWithDataSet", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPResampleWithDataSet_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPResampleWithDataSet_StaticNew()
{
  return vtkPResampleWithDataSet::New();
}

PyObject *PyvtkPResampleWithDataSet_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPResampleWithDataSet_Type, PyvtkPResampleWithDataSet_Methods,
    "vtkPResampleWithDataSet",
 &PyvtkPResampleWithDataSet_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkResampleWithDataSet");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPResampleWithDataSet_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPResampleWithDataSet(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPResampleWithDataSet_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPResampleWithDataSet", o) != 0)
  {
    Py_DECREF(o);
  }

}

