// python wrapper for vtkAnariLightNode
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkAnariLightNode.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkAnariLightNode(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkAnariLightNode_ClassNew(); }


static PyObject *
PyvtkAnariLightNode_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkAnariLightNode::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariLightNode *op = static_cast<vtkAnariLightNode *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkAnariLightNode::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkAnariLightNode *tempr = vtkAnariLightNode::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariLightNode *op = static_cast<vtkAnariLightNode *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAnariLightNode *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkAnariLightNode::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkAnariLightNode::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariLightNode *op = static_cast<vtkAnariLightNode *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkAnariLightNode::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_Build(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Build");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariLightNode *op = static_cast<vtkAnariLightNode *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Build(temp0);
    }
    else
    {
      op->vtkAnariLightNode::Build(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_Synchronize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Synchronize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariLightNode *op = static_cast<vtkAnariLightNode *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Synchronize(temp0);
    }
    else
    {
      op->vtkAnariLightNode::Synchronize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_Render(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Render");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariLightNode *op = static_cast<vtkAnariLightNode *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Render(temp0);
    }
    else
    {
      op->vtkAnariLightNode::Render(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_Invalidate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Invalidate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariLightNode *op = static_cast<vtkAnariLightNode *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Invalidate(temp0);
    }
    else
    {
      op->vtkAnariLightNode::Invalidate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_LIGHT_SCALE(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "LIGHT_SCALE");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationDoubleKey *tempr = vtkAnariLightNode::LIGHT_SCALE();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_SetLightScale(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetLightScale");

  double temp0;
  vtkLight *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkLight"))
  {
    vtkAnariLightNode::SetLightScale(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_GetLightScale(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetLightScale");

  vtkLight *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkLight"))
  {
    double tempr = vtkAnariLightNode::GetLightScale(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_RADIUS(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RADIUS");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationDoubleKey *tempr = vtkAnariLightNode::RADIUS();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_SetRadius(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetRadius");

  double temp0;
  vtkLight *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkLight"))
  {
    vtkAnariLightNode::SetRadius(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_GetRadius(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetRadius");

  vtkLight *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkLight"))
  {
    double tempr = vtkAnariLightNode::GetRadius(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_FALLOFF_ANGLE(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "FALLOFF_ANGLE");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationDoubleKey *tempr = vtkAnariLightNode::FALLOFF_ANGLE();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_SetFalloffAngle(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetFalloffAngle");

  double temp0;
  vtkLight *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkLight"))
  {
    vtkAnariLightNode::SetFalloffAngle(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariLightNode_GetFalloffAngle(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetFalloffAngle");

  vtkLight *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkLight"))
  {
    double tempr = vtkAnariLightNode::GetFalloffAngle(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkAnariLightNode_Methods[] = {
  {"IsTypeOf", PyvtkAnariLightNode_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkAnariLightNode_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkAnariLightNode_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkAnariLightNode\nC++: static vtkAnariLightNode *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkAnariLightNode_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkAnariLightNode\nC++: vtkAnariLightNode *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkAnariLightNode_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkAnariLightNode_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Build", PyvtkAnariLightNode_Build, METH_VARARGS,
   "Build(self, prepass:bool) -> None\nC++: void Build(bool prepass) override;\n\nEnsure the right type of ANARICamera object is being held.\n"},
  {"Synchronize", PyvtkAnariLightNode_Synchronize, METH_VARARGS,
   "Synchronize(self, prepass:bool) -> None\nC++: void Synchronize(bool prepass) override;\n\nSync ANARICamera parameters with vtkCamera.\n"},
  {"Render", PyvtkAnariLightNode_Render, METH_VARARGS,
   "Render(self, prepass:bool) -> None\nC++: void Render(bool prepass) override;\n\nMake ANARI calls to render me.\n"},
  {"Invalidate", PyvtkAnariLightNode_Invalidate, METH_VARARGS,
   "Invalidate(self, prepass:bool) -> None\nC++: void Invalidate(bool prepass) override;\n\nInvalidates cached rendering data.\n"},
  {"LIGHT_SCALE", PyvtkAnariLightNode_LIGHT_SCALE, METH_VARARGS,
   "LIGHT_SCALE() -> vtkInformationDoubleKey\nC++: static vtkInformationDoubleKey *LIGHT_SCALE()\n\nA global multiplier to all ANARI lights. default is 1.0\n"},
  {"SetLightScale", PyvtkAnariLightNode_SetLightScale, METH_VARARGS,
   "SetLightScale(__a:float, __b:vtkLight) -> None\nC++: static void SetLightScale(double, vtkLight *)\n\nConvenience method to set/get LIGHT_SCALE on a vtkLight\n"},
  {"GetLightScale", PyvtkAnariLightNode_GetLightScale, METH_VARARGS,
   "GetLightScale(__a:vtkLight) -> float\nC++: static double GetLightScale(vtkLight *)\n\n"},
  {"RADIUS", PyvtkAnariLightNode_RADIUS, METH_VARARGS,
   "RADIUS() -> vtkInformationDoubleKey\nC++: static vtkInformationDoubleKey *RADIUS()\n\nThe radius setting, when > 0.0, produces soft shadows in the path\ntracer.\n"},
  {"SetRadius", PyvtkAnariLightNode_SetRadius, METH_VARARGS,
   "SetRadius(__a:float, __b:vtkLight) -> None\nC++: static void SetRadius(double, vtkLight *)\n\nConvenience method to set/get RADIUS on a vtkLight.\n"},
  {"GetRadius", PyvtkAnariLightNode_GetRadius, METH_VARARGS,
   "GetRadius(__a:vtkLight) -> float\nC++: static double GetRadius(vtkLight *)\n\nConvenience method to set/get RADIUS on a vtkLight.\n"},
  {"FALLOFF_ANGLE", PyvtkAnariLightNode_FALLOFF_ANGLE, METH_VARARGS,
   "FALLOFF_ANGLE() -> vtkInformationDoubleKey\nC++: static vtkInformationDoubleKey *FALLOFF_ANGLE()\n\nFor cone-shaped lights, size (angle in radians) of the region\nbetween the rim (of the illumination cone) and full intensity of\nthe spot; should be smaller than half of openingAngle\n"},
  {"SetFalloffAngle", PyvtkAnariLightNode_SetFalloffAngle, METH_VARARGS,
   "SetFalloffAngle(__a:float, __b:vtkLight) -> None\nC++: static void SetFalloffAngle(double, vtkLight *)\n\nConvenience method to set/get FALLOFF_ANGLE on a vtkLight.\n"},
  {"GetFalloffAngle", PyvtkAnariLightNode_GetFalloffAngle, METH_VARARGS,
   "GetFalloffAngle(__a:vtkLight) -> float\nC++: static double GetFalloffAngle(vtkLight *)\n\nConvenience method to set/get FALLOFF_ANGLE on a vtkLight.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkAnariLightNode_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkAnariLightNode_Doc =
  "vtkAnariLightNode - links vtkLights to ANARI\n\n"
  "Superclass: vtkLightNode\n\n"
  "Translates vtkLight state into ANARILight state. Lights in ANARI are\n"
  "virtual objects that emit light into the world and thus illuminate\n"
  "objects.\n\n"
  "@par Thanks: Kevin Griffin kgriffin\n\n"
  "vidia.com for creating and contributing the class and NVIDIA for\n"
  "supporting this work.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkAnariLightNode_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingAnari.vtkAnariLightNode", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkAnariLightNode_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkAnariLightNode_StaticNew()
{
  return vtkAnariLightNode::New();
}

PyObject *PyvtkAnariLightNode_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkAnariLightNode_Type, PyvtkAnariLightNode_Methods,
    "vtkAnariLightNode",
 &PyvtkAnariLightNode_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkLightNode");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkAnariLightNode_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkAnariLightNode(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkAnariLightNode_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkAnariLightNode", o) != 0)
  {
    Py_DECREF(o);
  }

}

