// python wrapper for vtkVRRenderWindow
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkEventData.h"
#include "vtkVRRenderWindow.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkVRRenderWindow(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkVRRenderWindow_ClassNew(); }


static PyObject *
PyvtkVRRenderWindow_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkVRRenderWindow::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkVRRenderWindow::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkVRRenderWindow *tempr = vtkVRRenderWindow::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkVRRenderWindow *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkVRRenderWindow::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkVRRenderWindow::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkVRRenderWindow::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_MakeRenderWindowInteractor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MakeRenderWindowInteractor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    vtkRenderWindowInteractor *tempr = op->MakeRenderWindowInteractor();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetRenderBufferSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderBufferSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->GetRenderBufferSize(temp0, temp1);
    }
    else
    {
      op->vtkVRRenderWindow::GetRenderBufferSize(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(0, temp0);
    }
    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(1, temp1);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetModelForDevice(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetModelForDevice");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  vtkEventDataDevice temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkEventDataDevice"))
  {
    vtkVRModel *tempr = (ap.IsBound() ?
      op->GetModelForDevice(temp0) :
      op->vtkVRRenderWindow::GetModelForDevice(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetDeviceToPhysicalMatrixForDevice(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDeviceToPhysicalMatrixForDevice");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  vtkEventDataDevice temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkEventDataDevice"))
  {
    vtkMatrix4x4 *tempr = (ap.IsBound() ?
      op->GetDeviceToPhysicalMatrixForDevice(temp0) :
      op->vtkVRRenderWindow::GetDeviceToPhysicalMatrixForDevice(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetDeviceToWorldMatrixForDevice(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDeviceToWorldMatrixForDevice");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  vtkEventDataDevice temp0;
  vtkMatrix4x4 *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetEnumValue(temp0, "vtkEventDataDevice") &&
      ap.GetVTKObject(temp1, "vtkMatrix4x4"))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDeviceToWorldMatrixForDevice(temp0, temp1) :
      op->vtkVRRenderWindow::GetDeviceToWorldMatrixForDevice(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_InitializeViewFromCamera(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InitializeViewFromCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  vtkCamera *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCamera"))
  {
    if (ap.IsBound())
    {
      op->InitializeViewFromCamera(temp0);
    }
    else
    {
      op->vtkVRRenderWindow::InitializeViewFromCamera(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_AddRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    if (ap.IsBound())
    {
      op->AddRenderer(temp0);
    }
    else
    {
      op->vtkVRRenderWindow::AddRenderer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_MakeCurrent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MakeCurrent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MakeCurrent();
    }
    else
    {
      op->vtkVRRenderWindow::MakeCurrent();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_ReleaseCurrent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReleaseCurrent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ReleaseCurrent();
    }
    else
    {
      op->vtkVRRenderWindow::ReleaseCurrent();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_IsCurrent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsCurrent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsCurrent() :
      op->vtkVRRenderWindow::IsCurrent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_ReportCapabilities(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReportCapabilities");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->ReportCapabilities() :
      op->vtkVRRenderWindow::ReportCapabilities());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_IsDirect(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsDirect");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->IsDirect() :
      op->vtkVRRenderWindow::IsDirect());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetEventPending(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEventPending");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetEventPending() :
      op->vtkVRRenderWindow::GetEventPending());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetScreenSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetScreenSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetScreenSize() :
      op->vtkVRRenderWindow::GetScreenSize());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_SetSize_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetSize(temp0, temp1);
    }
    else
    {
      op->vtkVRRenderWindow::SetSize(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkVRRenderWindow_SetSize_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  int save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetSize(temp0);
    }
    else
    {
      op->vtkVRRenderWindow::SetSize(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkVRRenderWindow_SetSize(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkVRRenderWindow_SetSize_s1(self, args);
    case 1:
      return PyvtkVRRenderWindow_SetSize_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetSize");
  return nullptr;
}


static PyObject *
PyvtkVRRenderWindow_GetGenericDisplayId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenericDisplayId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    void  *tempr = (ap.IsBound() ?
      op->GetGenericDisplayId() :
      op->vtkVRRenderWindow::GetGenericDisplayId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetGenericWindowId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenericWindowId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    void  *tempr = (ap.IsBound() ?
      op->GetGenericWindowId() :
      op->vtkVRRenderWindow::GetGenericWindowId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetGenericParentId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenericParentId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    void  *tempr = (ap.IsBound() ?
      op->GetGenericParentId() :
      op->vtkVRRenderWindow::GetGenericParentId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetGenericContext(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenericContext");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    void  *tempr = (ap.IsBound() ?
      op->GetGenericContext() :
      op->vtkVRRenderWindow::GetGenericContext());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetGenericDrawable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenericDrawable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    void  *tempr = (ap.IsBound() ?
      op->GetGenericDrawable() :
      op->vtkVRRenderWindow::GetGenericDrawable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_SupportsOpenGL(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SupportsOpenGL");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->SupportsOpenGL() :
      op->vtkVRRenderWindow::SupportsOpenGL());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_Render(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Render");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
#ifdef VTK_PYTHON_FULL_THREADSAFE
    PyThreadState *ts = PyEval_SaveThread();
#endif

    if (ap.IsBound())
    {
      op->Render();
    }
    else
    {
      op->vtkVRRenderWindow::Render();
    }

#ifdef VTK_PYTHON_FULL_THREADSAFE
    PyEval_RestoreThread(ts);
#endif

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetHelperWindow(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHelperWindow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkOpenGLRenderWindow *tempr = (ap.IsBound() ?
      op->GetHelperWindow() :
      op->vtkVRRenderWindow::GetHelperWindow());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_SetHelperWindow(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHelperWindow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  vtkOpenGLRenderWindow *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkOpenGLRenderWindow"))
  {
    if (ap.IsBound())
    {
      op->SetHelperWindow(temp0);
    }
    else
    {
      op->vtkVRRenderWindow::SetHelperWindow(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetState(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkOpenGLState *tempr = (ap.IsBound() ?
      op->GetState() :
      op->vtkVRRenderWindow::GetState());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_ReleaseGraphicsResources(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReleaseGraphicsResources");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  vtkWindow *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkWindow"))
  {
    if (ap.IsBound())
    {
      op->ReleaseGraphicsResources(temp0);
    }
    else
    {
      op->vtkVRRenderWindow::ReleaseGraphicsResources(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_RenderModels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RenderModels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    op->RenderModels();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_SetTrackHMD(PyObject *self, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated method SetTrackHMD."
    " (" "Please use vtkVRCamera::SetTrackHMD() instead." ")"
    " -- Deprecated since version " "9.4.0" ".", 1);

  vtkPythonArgs ap(self, args, "SetTrackHMD");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTrackHMD(temp0);
    }
    else
    {
      op->vtkVRRenderWindow::SetTrackHMD(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetTrackHMD(PyObject *self, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated method GetTrackHMD."
    " (" "Please use vtkVRCamera::GetTrackHMD() instead." ")"
    " -- Deprecated since version " "9.4.0" ".", 1);

  vtkPythonArgs ap(self, args, "GetTrackHMD");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTrackHMD() :
      op->vtkVRRenderWindow::GetTrackHMD());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetBaseStationVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBaseStationVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetBaseStationVisibility() :
      op->vtkVRRenderWindow::GetBaseStationVisibility());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_SetBaseStationVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBaseStationVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBaseStationVisibility(temp0);
    }
    else
    {
      op->vtkVRRenderWindow::SetBaseStationVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_BaseStationVisibilityOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "BaseStationVisibilityOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->BaseStationVisibilityOn();
    }
    else
    {
      op->vtkVRRenderWindow::BaseStationVisibilityOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_BaseStationVisibilityOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "BaseStationVisibilityOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->BaseStationVisibilityOff();
    }
    else
    {
      op->vtkVRRenderWindow::BaseStationVisibilityOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_UpdateHMDMatrixPose(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateHMDMatrixPose");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UpdateHMDMatrixPose();
    }
    else
    {
      op->vtkVRRenderWindow::UpdateHMDMatrixPose();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindow_GetVRInitialized(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVRInitialized");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindow *op = static_cast<vtkVRRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetVRInitialized() :
      op->vtkVRRenderWindow::GetVRInitialized());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkVRRenderWindow_Methods[] = {
  {"IsTypeOf", PyvtkVRRenderWindow_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkVRRenderWindow_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkVRRenderWindow_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkVRRenderWindow\nC++: static vtkVRRenderWindow *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkVRRenderWindow_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkVRRenderWindow\nC++: vtkVRRenderWindow *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkVRRenderWindow_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkVRRenderWindow_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"MakeRenderWindowInteractor", PyvtkVRRenderWindow_MakeRenderWindowInteractor, METH_VARARGS,
   "MakeRenderWindowInteractor(self) -> vtkRenderWindowInteractor\nC++: vtkRenderWindowInteractor *MakeRenderWindowInteractor()\n    override = 0;\n\nCreate an interactor to control renderers in this window. Must be\noverridden to instantiate a specific interactor depending on the\nAPI\n"},
  {"GetRenderBufferSize", PyvtkVRRenderWindow_GetRenderBufferSize, METH_VARARGS,
   "GetRenderBufferSize(self, width:int, height:int) -> None\nC++: void GetRenderBufferSize(int &width, int &height)\n\n"},
  {"GetModelForDevice", PyvtkVRRenderWindow_GetModelForDevice, METH_VARARGS,
   "GetModelForDevice(self, idx:vtkEventDataDevice) -> vtkVRModel\nC++: vtkVRModel *GetModelForDevice(vtkEventDataDevice idx)\n\nGet the VRModel corresponding to the device or device handle.\n"},
  {"GetDeviceToPhysicalMatrixForDevice", PyvtkVRRenderWindow_GetDeviceToPhysicalMatrixForDevice, METH_VARARGS,
   "GetDeviceToPhysicalMatrixForDevice(self, idx:vtkEventDataDevice)\n    -> vtkMatrix4x4\nC++: vtkMatrix4x4 *GetDeviceToPhysicalMatrixForDevice(\n    vtkEventDataDevice idx)\n\nGet the DeviceToPhysical matrix corresponding to the device or\ndevice handle. e.g. 0,0,0,1 pushed through this matrix will give\nyou the location of the device in physical coordinates.\n"},
  {"GetDeviceToWorldMatrixForDevice", PyvtkVRRenderWindow_GetDeviceToWorldMatrixForDevice, METH_VARARGS,
   "GetDeviceToWorldMatrixForDevice(self, device:vtkEventDataDevice,\n    deviceToWorldMatrix:vtkMatrix4x4) -> bool\nC++: bool GetDeviceToWorldMatrixForDevice(\n    vtkEventDataDevice device, vtkMatrix4x4 *deviceToWorldMatrix)\n    override;\n\nStore in deviceToWorldMatrix the matrix that goes from device\ncoordinates to world coordinates. e.g. if you push 0,0,0,1\nthrough this matrix you will get the location of the device in\nworld coordinates. Return true if the query is valid, else false.\n"},
  {"InitializeViewFromCamera", PyvtkVRRenderWindow_InitializeViewFromCamera, METH_VARARGS,
   "InitializeViewFromCamera(self, cam:vtkCamera) -> None\nC++: virtual void InitializeViewFromCamera(vtkCamera *cam)\n\nInitialize the HMD to World setting and camera settings so that\nthe VR world view most closely matched the view from the provided\ncamera. This method is useful for initializing a VR world from an\nexisting on screen window and camera. The Renderer and its camera\nmust already be created and set when this is called.\n"},
  {"AddRenderer", PyvtkVRRenderWindow_AddRenderer, METH_VARARGS,
   "AddRenderer(self, __a:vtkRenderer) -> None\nC++: void AddRenderer(vtkRenderer *) override;\n\nAdd a renderer to the list of renderers.\n"},
  {"MakeCurrent", PyvtkVRRenderWindow_MakeCurrent, METH_VARARGS,
   "MakeCurrent(self) -> None\nC++: void MakeCurrent() override;\n\nMake this windows OpenGL context the current context.\n"},
  {"ReleaseCurrent", PyvtkVRRenderWindow_ReleaseCurrent, METH_VARARGS,
   "ReleaseCurrent(self) -> None\nC++: void ReleaseCurrent() override;\n\nRelease the current context.\n"},
  {"IsCurrent", PyvtkVRRenderWindow_IsCurrent, METH_VARARGS,
   "IsCurrent(self) -> bool\nC++: bool IsCurrent() override;\n\nTells if this window is the current OpenGL context for the\ncalling thread.\n"},
  {"ReportCapabilities", PyvtkVRRenderWindow_ReportCapabilities, METH_VARARGS,
   "ReportCapabilities(self) -> str\nC++: const char *ReportCapabilities() override;\n\nGet report of capabilities for the render window\n"},
  {"IsDirect", PyvtkVRRenderWindow_IsDirect, METH_VARARGS,
   "IsDirect(self) -> int\nC++: vtkTypeBool IsDirect() override;\n\nIs this render window using hardware acceleration? 0-false,\n1-true\n"},
  {"GetEventPending", PyvtkVRRenderWindow_GetEventPending, METH_VARARGS,
   "GetEventPending(self) -> int\nC++: vtkTypeBool GetEventPending() override;\n\nCheck to see if a mouse button has been pressed or mouse wheel\nactivated. All other events are ignored by this method. Maybe\nshould return 1 always?\n"},
  {"GetScreenSize", PyvtkVRRenderWindow_GetScreenSize, METH_VARARGS,
   "GetScreenSize(self) -> (int, int)\nC++: int *GetScreenSize() override;\n\nGet the current size of the screen in pixels.\n"},
  {"SetSize", PyvtkVRRenderWindow_SetSize, METH_VARARGS,
   "SetSize(self, width:int, height:int) -> None\nC++: void SetSize(int width, int height) override;\nSetSize(self, a:[int, int]) -> None\nC++: void SetSize(int a[2]) override;\n\nSet the size of the window in screen coordinates in pixels. This\nresizes the operating system's window and redraws it.\n\nIf the size has changed, this method will fire\nvtkCommand::WindowResizeEvent.\n"},
  {"GetGenericDisplayId", PyvtkVRRenderWindow_GetGenericDisplayId, METH_VARARGS,
   "GetGenericDisplayId(self) -> Pointer\nC++: void *GetGenericDisplayId() override;\n\nImplement required virtual functions.\n"},
  {"GetGenericWindowId", PyvtkVRRenderWindow_GetGenericWindowId, METH_VARARGS,
   "GetGenericWindowId(self) -> Pointer\nC++: void *GetGenericWindowId() override;\n\n"},
  {"GetGenericParentId", PyvtkVRRenderWindow_GetGenericParentId, METH_VARARGS,
   "GetGenericParentId(self) -> Pointer\nC++: void *GetGenericParentId() override;\n\n"},
  {"GetGenericContext", PyvtkVRRenderWindow_GetGenericContext, METH_VARARGS,
   "GetGenericContext(self) -> Pointer\nC++: void *GetGenericContext() override;\n\n"},
  {"GetGenericDrawable", PyvtkVRRenderWindow_GetGenericDrawable, METH_VARARGS,
   "GetGenericDrawable(self) -> Pointer\nC++: void *GetGenericDrawable() override;\n\n"},
  {"SupportsOpenGL", PyvtkVRRenderWindow_SupportsOpenGL, METH_VARARGS,
   "SupportsOpenGL(self) -> int\nC++: int SupportsOpenGL() override;\n\nDoes this render window support OpenGL? 0-false, 1-true\n"},
  {"Render", PyvtkVRRenderWindow_Render, METH_VARARGS,
   "Render(self) -> None\nC++: void Render() override;\n\nOverridden to not release resources that would interfere with an\nexternal application's rendering. Avoiding round trip.\n"},
  {"GetHelperWindow", PyvtkVRRenderWindow_GetHelperWindow, METH_VARARGS,
   "GetHelperWindow(self) -> vtkOpenGLRenderWindow\nC++: virtual vtkOpenGLRenderWindow *GetHelperWindow()\n\nSet/Get the window to use for the openGL context\n"},
  {"SetHelperWindow", PyvtkVRRenderWindow_SetHelperWindow, METH_VARARGS,
   "SetHelperWindow(self, val:vtkOpenGLRenderWindow) -> None\nC++: void SetHelperWindow(vtkOpenGLRenderWindow *val)\n\n"},
  {"GetState", PyvtkVRRenderWindow_GetState, METH_VARARGS,
   "GetState(self) -> vtkOpenGLState\nC++: vtkOpenGLState *GetState() override;\n\nGet the state object used to keep track of OpenGL state.\n"},
  {"ReleaseGraphicsResources", PyvtkVRRenderWindow_ReleaseGraphicsResources, METH_VARARGS,
   "ReleaseGraphicsResources(self, __a:vtkWindow) -> None\nC++: void ReleaseGraphicsResources(vtkWindow *) override;\n\nFree up any graphics resources associated with this window a\nvalue of nullptr means the context may already be destroyed\n"},
  {"RenderModels", PyvtkVRRenderWindow_RenderModels, METH_VARARGS,
   "RenderModels(self) -> None\nC++: virtual void RenderModels()\n\nRender the controller and base station models\n"},
  {"SetTrackHMD", PyvtkVRRenderWindow_SetTrackHMD, METH_VARARGS,
   "SetTrackHMD(self, __a:bool) -> None\nC++: virtual void SetTrackHMD(bool)\n\nWhen on the camera will track the HMD position. On is the\ndefault.\n"},
  {"GetTrackHMD", PyvtkVRRenderWindow_GetTrackHMD, METH_VARARGS,
   "GetTrackHMD(self) -> bool\nC++: virtual bool GetTrackHMD()\n\n"},
  {"GetBaseStationVisibility", PyvtkVRRenderWindow_GetBaseStationVisibility, METH_VARARGS,
   "GetBaseStationVisibility(self) -> bool\nC++: virtual bool GetBaseStationVisibility()\n\nSet/Get the visibility of the base stations. Defaults to false\n"},
  {"SetBaseStationVisibility", PyvtkVRRenderWindow_SetBaseStationVisibility, METH_VARARGS,
   "SetBaseStationVisibility(self, _arg:bool) -> None\nC++: virtual void SetBaseStationVisibility(bool _arg)\n\n"},
  {"BaseStationVisibilityOn", PyvtkVRRenderWindow_BaseStationVisibilityOn, METH_VARARGS,
   "BaseStationVisibilityOn(self) -> None\nC++: virtual void BaseStationVisibilityOn()\n\n"},
  {"BaseStationVisibilityOff", PyvtkVRRenderWindow_BaseStationVisibilityOff, METH_VARARGS,
   "BaseStationVisibilityOff(self) -> None\nC++: virtual void BaseStationVisibilityOff()\n\n"},
  {"UpdateHMDMatrixPose", PyvtkVRRenderWindow_UpdateHMDMatrixPose, METH_VARARGS,
   "UpdateHMDMatrixPose(self) -> None\nC++: virtual void UpdateHMDMatrixPose()\n\nUpdate the HMD pose.\n"},
  {"GetVRInitialized", PyvtkVRRenderWindow_GetVRInitialized, METH_VARARGS,
   "GetVRInitialized(self) -> bool\nC++: virtual bool GetVRInitialized()\n\nGet whether the XR components of the window have been initialized\nsuccessfully.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkVRRenderWindow_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRRenderWindow_SetSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRRenderWindow_SetSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("helper_window"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindow_GetHelperWindow(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRRenderWindow_SetHelperWindow(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRRenderWindow_SetHelperWindow(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetHelperWindow/SetHelperWindow\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("track_hmd"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindow_GetTrackHMD(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRRenderWindow_SetTrackHMD(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRRenderWindow_SetTrackHMD(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTrackHMD/SetTrackHMD\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("base_station_visibility"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindow_GetBaseStationVisibility(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRRenderWindow_SetBaseStationVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRRenderWindow_SetBaseStationVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBaseStationVisibility/SetBaseStationVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("event_pending"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindow_GetEventPending(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEventPending\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("screen_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindow_GetScreenSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetScreenSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generic_display_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindow_GetGenericDisplayId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetGenericDisplayId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generic_window_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindow_GetGenericWindowId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetGenericWindowId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generic_parent_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindow_GetGenericParentId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetGenericParentId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generic_context"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindow_GetGenericContext(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetGenericContext\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generic_drawable"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindow_GetGenericDrawable(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetGenericDrawable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("state"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindow_GetState(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetState\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("vr_initialized"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindow_GetVRInitialized(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetVRInitialized\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkVRRenderWindow_Doc =
  "vtkVRRenderWindow - VR rendering window\n\n"
  "Superclass: vtkOpenGLRenderWindow\n\n"
  "vtkVRRenderWindow is a abstract class to define a RenderWindow in a\n"
  "VR context.\n\n"
  "VR provides HMD and controller positions in the \"Physical\" coordinate\n"
  "system. For room scale VR this is based on the room setup per the\n"
  "underlying VR API being used. Units are in meters.\n\n"
  "Renderer shows actors in the World coordinate system. Transformation\n"
  "between Physical and World coordinate systems is defined by\n"
  "PhysicalToWorldMatrix. This matrix determines the user's position and\n"
  "orientation in the rendered scene and scaling (magnification) of\n"
  "rendered actors.\n\n"
  "This class introduces the notion of DeviceHandles. A DeviceHandle is\n"
  "a uint32_t handle that represents a device in the underlying VR API\n"
  "such as OpenVR or OpenXR. Implementations of this class are\n"
  "responsible for mapping the actual devices from that API into unique\n"
  "DeviceHandles. Typically these devices are handheld controllers,\n"
  "HMDs, stylus etc. The subclass should call AddDeviceHandle when it\n"
  "first sees a new device.\n\n"
  "This class also uses the term Device from vtkEventDataDevice to\n"
  "represent a generic device type that is used in the event handling\n"
  "system. Multiple DeviceHandles could point to the same Device though\n"
  "most often there is a one to one mapping. For example\n"
  "vtkEventDataDevice::LeftController will typically have one or zero\n"
  "DeviceHandles that map to it.\n\n"
  "Most event processing works with generic devices and this class\n"
  "provides a number of methods to support that. This class also\n"
  "provides a number of methods that work on DeviceHandles which are\n"
  "typically used by VR classes and their subclasses.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkVRRenderWindow_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingVR.vtkVRRenderWindow", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkVRRenderWindow_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkVRRenderWindow_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkVRRenderWindow_Type, PyvtkVRRenderWindow_Methods,
    "vtkVRRenderWindow",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkOpenGLRenderWindow");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 2; c++)
  {
    static const struct { const char *name; int value; }
      constants[2] = {
        { "LeftEye", vtkVRRenderWindow::LeftEye },
        { "RightEye", vtkVRRenderWindow::RightEye },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkVRRenderWindow_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkVRRenderWindow(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkVRRenderWindow_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkVRRenderWindow", o) != 0)
  {
    Py_DECREF(o);
  }

}

