// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkCellGridShaderCommonDefs.h"

const char *vtkCellGridShaderCommonDefs =
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"// NB: NumIntPt does *NOT* have to be equivalent to NumPtsPerCell.\n"
"//     They are different when the \"shape\" attribute has a different\n"
"//     interpolation order than the \"color\" attribute.\n"
"\n"
"// Number Of corner vertices per (triangular) side\n"
"#define NumPtsPerSide {NumPtsPerSide}\n"
"// Number of corner vertices per (tetrahedral) cell\n"
"#define NumPtsPerCell {NumPtsPerCell}\n"
"// The starting ID of all sides of this type (or 0 when DrawingCellsNotSides is true).\n"
"#define SideOffset {SideOffset}\n"
"// Non-zero (true) when coloring by a scalar field (i.e., color_vals is provided)\n"
"#define HaveColors {HaveColors}\n"
"// Non-zero (true) when drawing cells rather than sides of cells\n"
"#define DrawingCellsNotSides {DrawingCellsNotSides}\n"
"\n"
"// Defines SHAPE_hexahedron, SHAPE_tetrahedron, etc. based on the shape of cell being processed.\n"
"// This is used to determine \"normal\" direction vectors from the shape gradient.\n"
"#define SHAPE_{ShapeName} {ShapeName}\n"
"\n"
"// Ensure only the basis functions required are processed by the GLSL compiler.\n"
"#define BASIS_{ShapeBasisName}\n"
"#ifndef BASIS_{ColorBasisName}\n"
"   // Now, the color basis and shape basis might be the same.\n"
"   // Prevent a warning; do not define the same BASIS_xxx macro twice.\n"
"#  define BASIS_{ColorBasisName}\n"
"#endif\n"
"\n"
"// Define which interpolation functions to call for the cell shape and color.\n"
"#define axisPermutationForSide {ShapeName}_axisPermutationForSide\n"
"#define normalToSideAt {ShapeName}_normalToSideAt\n"
"\n"
"// Define different kinds of color override types\n"
"#define ScalarVisualizationOverride_NONE {ScalarVisualizationOverride_NONE}\n"
"#define ScalarVisualizationOverride_R {ScalarVisualizationOverride_R}\n"
"#define ScalarVisualizationOverride_S {ScalarVisualizationOverride_S}\n"
"#define ScalarVisualizationOverride_T {ScalarVisualizationOverride_T}\n"
"#define ScalarVisualizationOverride_L2_NORM_R_S {ScalarVisualizationOverride_L2_NORM_R_S}\n"
"#define ScalarVisualizationOverride_L2_NORM_S_T {ScalarVisualizationOverride_L2_NORM_S_T}\n"
"#define ScalarVisualizationOverride_L2_NORM_T_R {ScalarVisualizationOverride_L2_NORM_T_R}\n"
"";
