// java wrapper for vtkChart object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkChart.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkContextItem_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkChart_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkChart",dType)) { return me; }
  if ((res= vtkContextItem_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkChart_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkChart_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChart_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChart_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChart_Paint_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContext2D * temp0;
  bool   temp20;
  temp0 = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Paint(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChart_AddPlot_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkPlot * temp20;
  temp0 = id0;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddPlot(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChart_AddPlot_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPlot * temp0;
  long long   temp20;
  temp0 = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, id0));

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddPlot(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChart_RemovePlot_17(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RemovePlot(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChart_RemovePlotInstance_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPlot * temp0;
  bool   temp20;
  temp0 = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, id0));

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RemovePlotInstance(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChart_RemovePlot_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPlot * temp0;
  bool   temp20;
  temp0 = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, id0));

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RemovePlot(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_ClearPlots_110(JNIEnv* env, jobject obj)
{

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearPlots();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_RemoveAllPlots_111(JNIEnv* env, jobject obj)
{

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllPlots();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChart_GetPlot_112(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkPlot * temp20;
  temp0 = id0;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlot(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChart_GetNumberOfPlots_113(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPlots();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChart_GetAxis_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkAxis * temp20;
  temp0 = id0;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxis(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetAxis_115(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkAxis * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, id1));

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxis(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChart_GetNumberOfAxes_116(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_RecalculateBounds_117(JNIEnv* env, jobject obj)
{

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->RecalculateBounds();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetSelectionMethod_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionMethod(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkChart_GetSelectionMethod_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionMethod();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetAnnotationLink_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAnnotationLink * temp0;
  temp0 = static_cast<vtkAnnotationLink*>(vtkJavaGetPointerFromObject(env, id0));

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAnnotationLink(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChart_GetAnnotationLink_121(JNIEnv* env, jobject obj)
{
  vtkAnnotationLink * temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnnotationLink();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetGeometry_122(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGeometry(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetGeometry_123(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGeometry(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkChart_GetGeometry_124(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGeometry();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetPoint1_125(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint1(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetPoint1_126(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint1(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkChart_GetPoint1_127(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint1();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetPoint2_128(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint2(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetPoint2_129(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint2(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkChart_GetPoint2_130(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint2();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetShowLegend_131(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowLegend(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChart_GetShowLegend_132(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowLegend();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChart_GetLegend_133(JNIEnv* env, jobject obj)
{
  vtkChartLegend * temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLegend();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetTitle_134(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitle(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkChart_GetTitle_135(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitle();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChart_GetTitleProperties_136(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleProperties();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetBottomBorder_137(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBottomBorder(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetTopBorder_138(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTopBorder(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetLeftBorder_139(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLeftBorder(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetRightBorder_140(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRightBorder(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetBorders_141(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorders(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetLayoutStrategy_142(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkChart_GetLayoutStrategy_143(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLayoutStrategy();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetAutoSize_144(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAutoSize(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChart_GetAutoSize_145(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutoSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetRenderEmpty_146(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderEmpty(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChart_GetRenderEmpty_147(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderEmpty();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetActionToButton_148(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetActionToButton(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkChart_GetActionToButton_149(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActionToButton(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetClickActionToButton_150(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClickActionToButton(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkChart_GetClickActionToButton_151(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClickActionToButton(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetBackgroundBrush_152(JNIEnv* env, jobject obj,jobject id0)
{
  vtkBrush * temp0;
  temp0 = static_cast<vtkBrush*>(vtkJavaGetPointerFromObject(env, id0));

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackgroundBrush(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChart_GetBackgroundBrush_153(JNIEnv* env, jobject obj)
{
  vtkBrush * temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackgroundBrush();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChart_SetSelectionMode_154(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkChart_GetSelectionModeMinValue_155(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkChart_GetSelectionModeMaxValue_156(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkChart_GetSelectionMode_157(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkChart* op = static_cast<vtkChart*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionMode();
  return temp20;

}
