// java wrapper for vtkCharArray object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCharArray.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataArray_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCharArray_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCharArray",dType)) { return me; }
  if ((res= vtkDataArray_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}

// Array conversion routines
extern "C" JNIEXPORT jbyteArray JNICALL Java_vtk_vtkCharArray_GetJavaArray_10(JNIEnv* env, jobject obj)
{
  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  char* buffer = op->GetPointer(0);
  return vtkJavaMakeJArrayOfByte(env, reinterpret_cast<jbyte*>(buffer), op->GetSize());
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCharArray_SetJavaArray_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfTuples(len0 / op->GetNumberOfComponents());
  char* buffer = op->GetPointer(0);
  env->GetByteArrayRegion(id0, 0, len0, reinterpret_cast<jbyte*>(buffer));
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCharArray_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCharArray_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCharArray_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCharArray_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCharArray_ExtendedNew_14(JNIEnv* env, jobject obj)
{
  vtkCharArray * temp20;

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCharArray_GetDataType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCharArray_GetTypedTuple_16(JNIEnv* env, jobject obj,jlong id0, jbyteArray id1, jint len1)
{
  long long   temp0;
  char * temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetTypedTuple(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT jchar  JNICALL Java_vtk_vtkCharArray_GetValue_17(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  char   temp20;
  temp0 = id0;

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCharArray_GetValueRange_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  char * temp20;
  temp0 = id0;

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValueRange(temp0);
  return vtkJavaMakeJArrayOfByte(env, reinterpret_cast<jbyte*>(temp20), 2);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCharArray_GetValueRange_19(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValueRange();
  return vtkJavaMakeJArrayOfByte(env, reinterpret_cast<jbyte*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCharArray_SetTypedTuple_110(JNIEnv* env, jobject obj,jlong id0, jbyteArray id1, jint len1)
{
  long long   temp0;
  char * temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTypedTuple(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCharArray_InsertTypedTuple_111(JNIEnv* env, jobject obj,jlong id0, jbyteArray id1, jint len1)
{
  long long   temp0;
  char * temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTypedTuple(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCharArray_InsertNextTypedTuple_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextTypedTuple(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCharArray_SetValue_113(JNIEnv* env, jobject obj,jlong id0,jchar id1)
{
  long long   temp0;
  char   temp1;
  temp0 = id0;
  temp1 = static_cast<char>(0xff & id1);

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValue(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCharArray_SetNumberOfValues_114(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNumberOfValues(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCharArray_InsertValue_115(JNIEnv* env, jobject obj,jlong id0,jchar id1)
{
  long long   temp0;
  char   temp1;
  temp0 = id0;
  temp1 = static_cast<char>(0xff & id1);

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertValue(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCharArray_InsertNextValue_116(JNIEnv* env, jobject obj,jchar id0)
{
  char   temp0;
  long long   temp20;
  temp0 = static_cast<char>(0xff & id0);

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCharArray_WritePointer_117(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  char * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->WritePointer(temp0,temp1);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCharArray_GetPointer_118(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  char * temp20;
  temp0 = id0;

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointer(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCharArray_SetArray_119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jlong id1,jint id2)
{
  char * temp0;
  long long   temp1;
  int   temp2;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArray(temp0,temp1,temp2);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCharArray_SetArray_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jlong id1,jint id2,jint id3)
{
  char * temp0;
  long long   temp1;
  int   temp2;
  int   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArray(temp0,temp1,temp2,temp3);
  delete[] temp0;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCharArray_FastDownCast_121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  vtkCharArray * temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FastDownCast(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jchar  JNICALL Java_vtk_vtkCharArray_GetDataTypeValueMin_122(JNIEnv* env, jobject obj)
{
  char   temp20;

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeValueMin();
  return temp20;

}

extern "C" JNIEXPORT jchar  JNICALL Java_vtk_vtkCharArray_GetDataTypeValueMax_123(JNIEnv* env, jobject obj)
{
  char   temp20;

  vtkCharArray* op = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeValueMax();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCharArray_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCharArray::New());
}
