// java wrapper for vtkCollection object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCollection.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCollection_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCollection",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCollection_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCollection_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCollection_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCollection_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollection_AddItem_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkObject * temp0;
  temp0 = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddItem(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollection_InsertItem_15(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkObject * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertItem(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollection_ReplaceItem_16(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkObject * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReplaceItem(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollection_RemoveItem_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveItem(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollection_RemoveItem_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkObject * temp0;
  temp0 = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveItem(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollection_RemoveAllItems_19(JNIEnv* env, jobject obj)
{

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllItems();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCollection_IsItemPresent_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkObject * temp0;
  int   temp20;
  temp0 = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsItemPresent(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCollection_IndexOfFirstOccurence_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkObject * temp0;
  int   temp20;
  temp0 = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IndexOfFirstOccurence(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCollection_GetNumberOfItems_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfItems();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollection_InitTraversal_113(JNIEnv* env, jobject obj)
{

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitTraversal();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCollection_GetNextItemAsObject_114(JNIEnv* env, jobject obj)
{
  vtkObject * temp20;

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNextItemAsObject();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCollection_GetItemAsObject_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkObject * temp20;
  temp0 = id0;

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetItemAsObject(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCollection_NewIterator_116(JNIEnv* env, jobject obj)
{
  vtkCollectionIterator * temp20;

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewIterator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCollection_UsesGarbageCollector_117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCollection* op = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UsesGarbageCollector();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCollection_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCollection::New());
}
