// java wrapper for vtkSignedCharArray object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSignedCharArray.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataArray_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSignedCharArray_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSignedCharArray",dType)) { return me; }
  if ((res= vtkDataArray_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}

// Array conversion routines
extern "C" JNIEXPORT jbyteArray JNICALL Java_vtk_vtkSignedCharArray_GetJavaArray_10(JNIEnv* env, jobject obj)
{
  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  signed char* buffer = op->GetPointer(0);
  return vtkJavaMakeJArrayOfByte(env, reinterpret_cast<jbyte*>(buffer), op->GetSize());
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSignedCharArray_SetJavaArray_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfTuples(len0 / op->GetNumberOfComponents());
  signed char* buffer = op->GetPointer(0);
  env->GetByteArrayRegion(id0, 0, len0, reinterpret_cast<jbyte*>(buffer));
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSignedCharArray_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSignedCharArray_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSignedCharArray_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSignedCharArray_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSignedCharArray_ExtendedNew_14(JNIEnv* env, jobject obj)
{
  vtkSignedCharArray * temp20;

  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSignedCharArray_GetDataType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataType();
  return temp20;

}

extern "C" JNIEXPORT jbyte  JNICALL Java_vtk_vtkSignedCharArray_GetValue_16(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  signed char   temp20;
  temp0 = id0;

  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSignedCharArray_GetValueRange_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  signed char * temp20;
  temp0 = id0;

  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValueRange(temp0);
  return vtkJavaMakeJArrayOfByte(env, reinterpret_cast<jbyte*>(temp20), 2);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSignedCharArray_GetValueRange_18(JNIEnv* env, jobject obj)
{
  signed char * temp20;

  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValueRange();
  return vtkJavaMakeJArrayOfByte(env, reinterpret_cast<jbyte*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSignedCharArray_SetValue_19(JNIEnv* env, jobject obj,jlong id0,jbyte id1)
{
  long long   temp0;
  signed char   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValue(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSignedCharArray_SetNumberOfValues_110(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNumberOfValues(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSignedCharArray_InsertValue_111(JNIEnv* env, jobject obj,jlong id0,jbyte id1)
{
  long long   temp0;
  signed char   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertValue(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSignedCharArray_InsertNextValue_112(JNIEnv* env, jobject obj,jbyte id0)
{
  signed char   temp0;
  long long   temp20;
  temp0 = id0;

  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSignedCharArray_FastDownCast_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  vtkSignedCharArray * temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FastDownCast(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jbyte  JNICALL Java_vtk_vtkSignedCharArray_GetDataTypeValueMin_114(JNIEnv* env, jobject obj)
{
  signed char   temp20;

  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeValueMin();
  return temp20;

}

extern "C" JNIEXPORT jbyte  JNICALL Java_vtk_vtkSignedCharArray_GetDataTypeValueMax_115(JNIEnv* env, jobject obj)
{
  signed char   temp20;

  vtkSignedCharArray* op = static_cast<vtkSignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeValueMax();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSignedCharArray_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSignedCharArray::New());
}
