// java wrapper for vtkAnnotation object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkAnnotation.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkAnnotation_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkAnnotation",dType)) { return me; }
  if ((res= vtkDataObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAnnotation_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAnnotation_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAnnotation_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAnnotation_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAnnotation_GetDataObjectType_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAnnotation_GetSelection_15(JNIEnv* env, jobject obj)
{
  vtkSelection * temp20;

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAnnotation_SetSelection_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkSelection * temp0;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelection(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAnnotation_GetData_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkAnnotation * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAnnotation_GetData_18(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkAnnotation * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAnnotation_LABEL_19(JNIEnv* env, jobject obj)
{
  vtkInformationStringKey * temp20;

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->LABEL();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAnnotation_COLOR_110(JNIEnv* env, jobject obj)
{
  vtkInformationDoubleVectorKey * temp20;

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->COLOR();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAnnotation_OPACITY_111(JNIEnv* env, jobject obj)
{
  vtkInformationDoubleKey * temp20;

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->OPACITY();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAnnotation_ICON_1INDEX_112(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ICON_INDEX();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAnnotation_ENABLE_113(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ENABLE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAnnotation_HIDE_114(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HIDE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAnnotation_DATA_115(JNIEnv* env, jobject obj)
{
  vtkInformationDataObjectKey * temp20;

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DATA();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAnnotation_Initialize_116(JNIEnv* env, jobject obj)
{

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAnnotation_ShallowCopy_117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAnnotation_DeepCopy_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAnnotation_GetMTime_119(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkAnnotation* op = static_cast<vtkAnnotation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkAnnotation_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkAnnotation::New());
}
