// java wrapper for vtkBezierTriangle object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkBezierTriangle.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkHigherOrderTriangle_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkBezierTriangle_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkBezierTriangle",dType)) { return me; }
  if ((res= vtkHigherOrderTriangle_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBezierTriangle_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBezierTriangle* op = static_cast<vtkBezierTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBezierTriangle_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBezierTriangle* op = static_cast<vtkBezierTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBezierTriangle_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBezierTriangle* op = static_cast<vtkBezierTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBezierTriangle_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBezierTriangle* op = static_cast<vtkBezierTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBezierTriangle_GetCellType_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBezierTriangle* op = static_cast<vtkBezierTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBezierTriangle_GetEdge_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkBezierTriangle* op = static_cast<vtkBezierTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdge(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBezierTriangle_SetRationalWeightsFromPointData_16(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkPointData * temp0;
  long long   temp1;
  temp0 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkBezierTriangle* op = static_cast<vtkBezierTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRationalWeightsFromPointData(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBezierTriangle_GetEdgeCell_17(JNIEnv* env, jobject obj)
{
  vtkHigherOrderCurve * temp20;

  vtkBezierTriangle* op = static_cast<vtkBezierTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeCell();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBezierTriangle_GetRationalWeights_18(JNIEnv* env, jobject obj)
{
  vtkDoubleArray * temp20;

  vtkBezierTriangle* op = static_cast<vtkBezierTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRationalWeights();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkBezierTriangle_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkBezierTriangle::New());
}
