// java wrapper for vtkBox object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkBox.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImplicitFunction_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkBox_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkBox",dType)) { return me; }
  if ((res= vtkImplicitFunction_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBox_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBox_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBox_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBox_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkBox_EvaluateFunction_14(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EvaluateFunction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBox_EvaluateGradient_15(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  op->EvaluateGradient(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBox_SetXMin_16(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXMin(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBox_SetXMin_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXMin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBox_GetXMin_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetXMin(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBox_SetXMax_19(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXMax(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBox_SetXMax_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXMax(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBox_GetXMax_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetXMax(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBox_SetBounds_112(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBox_SetBounds_113(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBox_GetBounds_114(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkBox_GetBounds_115(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBox_AddBounds_116(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddBounds(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBox_IntersectWithPlane_117(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[6];
  double temp1[3];
  double temp2[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IntersectWithPlane(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBox_IntersectWithPlane_118(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3)
{
  double temp0[6];
  double temp1[3];
  double temp2[3];
  double temp3[18];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 18, &temp3[0]);

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IntersectWithPlane(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->SetDoubleArrayRegion(id3, 0, 18, &temp3[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBox_IsBoxInFrustum_119(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[24];
  double temp1[6];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 24, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsBoxInFrustum(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 24, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBox_EvaluateFunction_120(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  op->EvaluateFunction(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkBox_EvaluateFunction_121(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkBox* op = static_cast<vtkBox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EvaluateFunction(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkBox_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkBox::New());
}
