// java wrapper for vtkGraph object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGraph.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGraph_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGraph",dType)) { return me; }
  if ((res= vtkDataObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGraph_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGraph_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetVertexData_14(JNIEnv* env, jobject obj)
{
  vtkDataSetAttributes * temp20;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetEdgeData_15(JNIEnv* env, jobject obj)
{
  vtkDataSetAttributes * temp20;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGraph_GetDataObjectType_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_Initialize_17(JNIEnv* env, jobject obj)
{

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_GetPoint_18(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetPoints_19(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoints();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_SetPoints_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints * temp0;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoints(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_ComputeBounds_111(JNIEnv* env, jobject obj)
{

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeBounds();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_GetBounds_112(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetMTime_113(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_GetOutEdges_114(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkOutEdgeIterator * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkOutEdgeIterator*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetOutEdges(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetDegree_115(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDegree(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetOutDegree_116(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutDegree(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_GetOutEdge_117(JNIEnv* env, jobject obj,jlong id0,jlong id1,jobject id2)
{
  long long   temp0;
  long long   temp1;
  vtkGraphEdge * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkGraphEdge*>(vtkJavaGetPointerFromObject(env, id2));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetOutEdge(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_GetInEdges_118(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkInEdgeIterator * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkInEdgeIterator*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetInEdges(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetInDegree_119(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInDegree(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_GetInEdge_120(JNIEnv* env, jobject obj,jlong id0,jlong id1,jobject id2)
{
  long long   temp0;
  long long   temp1;
  vtkGraphEdge * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkGraphEdge*>(vtkJavaGetPointerFromObject(env, id2));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetInEdge(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_GetAdjacentVertices_121(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkAdjacentVertexIterator * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkAdjacentVertexIterator*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetAdjacentVertices(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_GetEdges_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkEdgeListIterator * temp0;
  temp0 = static_cast<vtkEdgeListIterator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetEdges(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetNumberOfEdges_123(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdges();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_GetVertices_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkVertexListIterator * temp0;
  temp0 = static_cast<vtkVertexListIterator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetVertices(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetNumberOfVertices_125(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfVertices();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_SetDistributedGraphHelper_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDistributedGraphHelper * temp0;
  temp0 = static_cast<vtkDistributedGraphHelper*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDistributedGraphHelper(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetDistributedGraphHelper_127(JNIEnv* env, jobject obj)
{
  vtkDistributedGraphHelper * temp20;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistributedGraphHelper();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_ShallowCopy_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_DeepCopy_129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_CopyStructure_130(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGraph * temp0;
  temp0 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyStructure(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGraph_CheckedShallowCopy_131(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGraph * temp0;
  bool   temp20;
  temp0 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CheckedShallowCopy(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGraph_CheckedDeepCopy_132(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGraph * temp0;
  bool   temp20;
  temp0 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CheckedDeepCopy(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_Squeeze_133(JNIEnv* env, jobject obj)
{

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->Squeeze();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetActualMemorySize_134(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetData_135(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkGraph * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetData_136(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkGraph * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_ReorderOutVertices_137(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdTypeArray * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReorderOutVertices(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGraph_IsSameStructure_138(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGraph * temp0;
  bool   temp20;
  temp0 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsSameStructure(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetSourceVertex_139(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSourceVertex(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetTargetVertex_140(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTargetVertex(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetNumberOfEdgePoints_141(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdgePoints(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkGraph_GetEdgePoint_142(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  double * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgePoint(temp0,temp1);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_ClearEdgePoints_143(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearEdgePoints(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_SetEdgePoint_144(JNIEnv* env, jobject obj,jlong id0,jlong id1,jdoubleArray id2)
{
  long long   temp0;
  long long   temp1;
  double temp2[3];
  temp0 = id0;
  temp1 = id1;
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgePoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_SetEdgePoint_145(JNIEnv* env, jobject obj,jlong id0,jlong id1,jdouble id2,jdouble id3,jdouble id4)
{
  long long   temp0;
  long long   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgePoint(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_AddEdgePoint_146(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddEdgePoint(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_AddEdgePoint_147(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2,jdouble id3)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddEdgePoint(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_ShallowCopyEdgePoints_148(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGraph * temp0;
  temp0 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopyEdgePoints(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_DeepCopyEdgePoints_149(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGraph * temp0;
  temp0 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopyEdgePoints(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetGraphInternals_150(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  vtkGraphInternals * temp20;
  temp0 = (id0 != 0) ? true : false;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGraphInternals(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_GetInducedEdges_151(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkIdTypeArray * temp0;
  vtkIdTypeArray * temp1;
  temp0 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetInducedEdges(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetAttributesAsFieldData_152(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkFieldData * temp20;
  temp0 = id0;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributesAsFieldData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetNumberOfElements_153(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElements(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraph_Dump_154(JNIEnv* env, jobject obj)
{

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->Dump();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraph_GetEdgeId_155(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeId(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGraph_ToDirectedGraph_156(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDirectedGraph * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDirectedGraph*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ToDirectedGraph(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGraph_ToUndirectedGraph_157(JNIEnv* env, jobject obj,jobject id0)
{
  vtkUndirectedGraph * temp0;
  bool   temp20;
  temp0 = static_cast<vtkUndirectedGraph*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraph* op = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ToUndirectedGraph(temp0);
  return temp20;

}
