// java wrapper for vtkTable object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTable.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTable_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTable",dType)) { return me; }
  if ((res= vtkDataObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_ExtendedNew_10(JNIEnv* env, jobject obj)
{
  vtkTable * temp20;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTable_IsTypeOf_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTable_IsA_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_GetNumberOfGenerationsFromBaseType_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_GetNumberOfGenerationsFromBase_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_Dump_15(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->Dump(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTable_GetDataObjectType_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_GetActualMemorySize_17(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_GetRowData_18(JNIEnv* env, jobject obj)
{
  vtkDataSetAttributes * temp20;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRowData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_SetRowData_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSetAttributes * temp0;
  temp0 = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRowData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_GetNumberOfRows_110(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfRows();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_SetNumberOfRows_111(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfRows(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_SqueezeRows_112(JNIEnv* env, jobject obj)
{

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SqueezeRows();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_GetRow_113(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkVariantArray * temp20;
  temp0 = id0;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRow(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_GetRow_114(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkVariantArray * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetRow(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_SetRow_115(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkVariantArray * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRow(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_InsertRow_116(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertRow(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_InsertRows_117(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertRows(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_InsertNextBlankRow_118(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  long long   temp20;
  temp0 = id0;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextBlankRow(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_InsertNextRow_119(JNIEnv* env, jobject obj,jobject id0)
{
  vtkVariantArray * temp0;
  long long   temp20;
  temp0 = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextRow(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_RemoveRow_120(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveRow(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_RemoveRows_121(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveRows(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_RemoveAllRows_122(JNIEnv* env, jobject obj)
{

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllRows();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_GetNumberOfColumns_123(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfColumns();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTable_GetColumnName_124(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const char * temp20;
  temp0 = id0;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColumnName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_GetColumnByName_125(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkAbstractArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColumnByName(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_GetColumnIndex_126(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColumnIndex(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_GetColumn_127(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkAbstractArray * temp20;
  temp0 = id0;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColumn(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_AddColumn_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddColumn(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_InsertColumn_129(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkAbstractArray * temp0;
  long long   temp1;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertColumn(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_RemoveColumnByName_130(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveColumnByName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_RemoveColumn_131(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveColumn(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_RemoveAllColumns_132(JNIEnv* env, jobject obj)
{

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllColumns();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_Initialize_133(JNIEnv* env, jobject obj)
{

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_GetData_134(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkTable * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_GetData_135(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkTable * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_ShallowCopy_136(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTable_DeepCopy_137(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_GetAttributesAsFieldData_138(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkFieldData * temp20;
  temp0 = id0;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributesAsFieldData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTable_GetNumberOfElements_139(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkTable* op = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElements(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTable_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTable::New());
}
