// java wrapper for vtkCenterOfMass object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCenterOfMass.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPointSetAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCenterOfMass_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCenterOfMass",dType)) { return me; }
  if ((res= vtkPointSetAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCenterOfMass_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCenterOfMass* op = static_cast<vtkCenterOfMass*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCenterOfMass_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCenterOfMass* op = static_cast<vtkCenterOfMass*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCenterOfMass_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCenterOfMass* op = static_cast<vtkCenterOfMass*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCenterOfMass_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCenterOfMass* op = static_cast<vtkCenterOfMass*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCenterOfMass_SetCenter_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCenterOfMass* op = static_cast<vtkCenterOfMass*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCenter(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCenterOfMass_SetCenter_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCenterOfMass* op = static_cast<vtkCenterOfMass*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCenter(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCenterOfMass_GetCenter_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCenterOfMass* op = static_cast<vtkCenterOfMass*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCenter();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCenterOfMass_SetUseScalarsAsWeights_17(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCenterOfMass* op = static_cast<vtkCenterOfMass*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseScalarsAsWeights(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCenterOfMass_GetUseScalarsAsWeights_18(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCenterOfMass* op = static_cast<vtkCenterOfMass*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseScalarsAsWeights();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCenterOfMass_ComputeCenterOfMass_19(JNIEnv* env, jobject obj,jobject id0,jobject id1,jdoubleArray id2)
{
  vtkPoints * temp0;
  vtkDataArray * temp1;
  double temp2[3];
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkCenterOfMass* op = static_cast<vtkCenterOfMass*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeCenterOfMass(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCenterOfMass_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCenterOfMass::New());
}
