// java wrapper for vtkRIBExporter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkRIBExporter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkExporter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkRIBExporter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkRIBExporter",dType)) { return me; }
  if ((res= vtkExporter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRIBExporter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRIBExporter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRIBExporter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRIBExporter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRIBExporter_SetSize_14(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRIBExporter_SetSize_15(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkRIBExporter_GetSize_16(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRIBExporter_SetPixelSamples_17(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPixelSamples(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRIBExporter_SetPixelSamples_18(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPixelSamples(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkRIBExporter_GetPixelSamples_19(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPixelSamples();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRIBExporter_SetFilePrefix_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFilePrefix(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRIBExporter_GetFilePrefix_111(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFilePrefix();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRIBExporter_SetTexturePrefix_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTexturePrefix(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRIBExporter_GetTexturePrefix_113(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTexturePrefix();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRIBExporter_SetBackground_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackground(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRIBExporter_GetBackground_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackground();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRIBExporter_BackgroundOn_116(JNIEnv* env, jobject obj)
{

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->BackgroundOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRIBExporter_BackgroundOff_117(JNIEnv* env, jobject obj)
{

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->BackgroundOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRIBExporter_SetExportArrays_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExportArrays(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRIBExporter_GetExportArraysMinValue_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExportArraysMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRIBExporter_GetExportArraysMaxValue_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExportArraysMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRIBExporter_ExportArraysOn_121(JNIEnv* env, jobject obj)
{

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ExportArraysOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRIBExporter_ExportArraysOff_122(JNIEnv* env, jobject obj)
{

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ExportArraysOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRIBExporter_GetExportArrays_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRIBExporter* op = static_cast<vtkRIBExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExportArrays();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkRIBExporter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkRIBExporter::New());
}
