// java wrapper for vtkImporter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImporter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImporter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImporter",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImporter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImporter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImporter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImporter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImporter_GetRenderer_14(JNIEnv* env, jobject obj)
{
  vtkRenderer * temp20;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderer();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImporter_GetSceneHierarchy_15(JNIEnv* env, jobject obj)
{
  vtkDataAssembly * temp20;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSceneHierarchy();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImporter_GetImportedActors_16(JNIEnv* env, jobject obj)
{
  vtkActorCollection * temp20;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImportedActors();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImporter_GetImportedCameras_17(JNIEnv* env, jobject obj)
{
  vtkCollection * temp20;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImportedCameras();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImporter_GetImportedLights_18(JNIEnv* env, jobject obj)
{
  vtkLightCollection * temp20;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImportedLights();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImporter_SetRenderWindow_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderWindow(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImporter_GetRenderWindow_110(JNIEnv* env, jobject obj)
{
  vtkRenderWindow * temp20;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderWindow();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkImporter_Update_111(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Update();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImporter_Read_112(JNIEnv* env, jobject obj)
{

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->Read();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImporter_GetOutputsDescription_113(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputsDescription();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImporter_GetAnimationSupportLevel_114(JNIEnv* env, jobject obj)
{
  vtkImporter::AnimationSupportLevel   temp20;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnimationSupportLevel();
  return static_cast<jint>(temp20);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImporter_GetNumberOfAnimations_115(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfAnimations();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImporter_GetAnimationName_116(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  std::string   temp20;
  temp0 = id0;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnimationName(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImporter_EnableAnimation_117(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAnimation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImporter_DisableAnimation_118(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAnimation(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkImporter_IsAnimationEnabled_119(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsAnimationEnabled(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImporter_GetNumberOfCameras_120(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCameras();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImporter_GetCameraName_121(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  std::string   temp20;
  temp0 = id0;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCameraName(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImporter_SetCamera_122(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCamera(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImporter_UpdateTimeStep_123(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateTimeStep(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkImporter_UpdateAtTimeValue_124(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  bool   temp20;
  temp0 = id0;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UpdateAtTimeValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImporter_SetImportArmature_125(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImportArmature(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkImporter_GetImportArmature_126(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImportArmature();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImporter_ImportArmatureOn_127(JNIEnv* env, jobject obj)
{

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ImportArmatureOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImporter_ImportArmatureOff_128(JNIEnv* env, jobject obj)
{

  vtkImporter* op = static_cast<vtkImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ImportArmatureOff();

}
