// java wrapper for vtkMNIObjectWriter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMNIObjectWriter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWriter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMNIObjectWriter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMNIObjectWriter",dType)) { return me; }
  if ((res= vtkWriter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMNIObjectWriter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMNIObjectWriter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMNIObjectWriter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMNIObjectWriter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMNIObjectWriter_GetFileExtensions_14(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileExtensions();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMNIObjectWriter_GetDescriptiveName_15(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDescriptiveName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMNIObjectWriter_SetProperty_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMNIObjectWriter_GetProperty_17(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMNIObjectWriter_SetMapper_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMapper * temp0;
  temp0 = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMapper(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMNIObjectWriter_GetMapper_19(JNIEnv* env, jobject obj)
{
  vtkMapper * temp20;

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMapper();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMNIObjectWriter_SetLookupTable_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkLookupTable * temp0;
  temp0 = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLookupTable(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMNIObjectWriter_GetLookupTable_111(JNIEnv* env, jobject obj)
{
  vtkLookupTable * temp20;

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLookupTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMNIObjectWriter_GetInput_112(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMNIObjectWriter_GetInput_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkPolyData * temp20;
  temp0 = id0;

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMNIObjectWriter_SetFileName_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMNIObjectWriter_GetFileName_115(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMNIObjectWriter_SetFileType_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMNIObjectWriter_GetFileTypeMinValue_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileTypeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMNIObjectWriter_GetFileTypeMaxValue_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileTypeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMNIObjectWriter_GetFileType_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMNIObjectWriter_SetFileTypeToASCII_120(JNIEnv* env, jobject obj)
{

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileTypeToASCII();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMNIObjectWriter_SetFileTypeToBinary_121(JNIEnv* env, jobject obj)
{

  vtkMNIObjectWriter* op = static_cast<vtkMNIObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileTypeToBinary();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkMNIObjectWriter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkMNIObjectWriter::New());
}
