// java wrapper for vtkMPASReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMPASReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkUnstructuredGridAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMPASReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMPASReader",dType)) { return me; }
  if ((res= vtkUnstructuredGridAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMPASReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMPASReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMPASReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMPASReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMPASReader_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMPASReader_GetMaximumCells_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumCells();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMPASReader_GetMaximumPoints_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumPoints();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMPASReader_GetNumberOfCellVars_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellVars();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMPASReader_GetNumberOfPointVars_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointVars();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMPASReader_GetOutput_110(JNIEnv* env, jobject obj)
{
  vtkUnstructuredGrid * temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMPASReader_GetOutput_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkUnstructuredGrid * temp20;
  temp0 = id0;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutput(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_SetUseDimensionedArrayNames_112(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseDimensionedArrayNames(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMPASReader_GetUseDimensionedArrayNames_113(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseDimensionedArrayNames();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_UseDimensionedArrayNamesOn_114(JNIEnv* env, jobject obj)
{

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseDimensionedArrayNamesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_UseDimensionedArrayNamesOff_115(JNIEnv* env, jobject obj)
{

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseDimensionedArrayNamesOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMPASReader_GetNumberOfPointArrays_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMPASReader_GetPointArrayName_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMPASReader_GetPointArrayStatus_118(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_SetPointArrayStatus_119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_DisableAllPointArrays_120(JNIEnv* env, jobject obj)
{

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllPointArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_EnableAllPointArrays_121(JNIEnv* env, jobject obj)
{

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllPointArrays();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMPASReader_GetNumberOfCellArrays_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMPASReader_GetCellArrayName_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMPASReader_GetCellArrayStatus_124(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_SetCellArrayStatus_125(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_DisableAllCellArrays_126(JNIEnv* env, jobject obj)
{

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllCellArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_EnableAllCellArrays_127(JNIEnv* env, jobject obj)
{

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllCellArrays();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMPASReader_GetNumberOfDimensions_128(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfDimensions();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMPASReader_GetDimensionName_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  std::string   temp20;
  temp0 = id0;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensionName(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMPASReader_GetAllDimensions_130(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAllDimensions();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMPASReader_GetDimensionCurrentIndex_131(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensionCurrentIndex(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_SetDimensionCurrentIndex_132(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  std::string temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = id1;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensionCurrentIndex(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMPASReader_GetDimensionSize_133(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensionSize(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_SetVerticalDimension_134(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string   temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVerticalDimension(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMPASReader_GetVerticalDimension_135(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVerticalDimension();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_SetVerticalLevel_136(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVerticalLevel(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMPASReader_GetVerticalLevel_137(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVerticalLevel();
  return temp20;

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkMPASReader_GetVerticalLevelRange_138(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVerticalLevelRange();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_SetLayerThickness_139(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayerThickness(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMPASReader_GetLayerThickness_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLayerThickness();
  return temp20;

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkMPASReader_GetLayerThicknessRange_141(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLayerThicknessRange();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_SetCenterLon_142(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCenterLon(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkMPASReader_GetCenterLonRange_143(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCenterLonRange();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_SetProjectLatLon_144(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProjectLatLon(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMPASReader_GetProjectLatLon_145(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProjectLatLon();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_SetIsAtmosphere_146(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIsAtmosphere(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMPASReader_GetIsAtmosphere_147(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIsAtmosphere();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_SetIsZeroCentered_148(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIsZeroCentered(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMPASReader_GetIsZeroCentered_149(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIsZeroCentered();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMPASReader_SetShowMultilayerView_150(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowMultilayerView(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMPASReader_GetShowMultilayerView_151(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowMultilayerView();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMPASReader_CanReadFile_152(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMPASReader_GetMTime_153(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkMPASReader* op = static_cast<vtkMPASReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkMPASReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkMPASReader::New());
}
