// java wrapper for vtkCheckerboardSplatter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCheckerboardSplatter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCheckerboardSplatter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCheckerboardSplatter",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCheckerboardSplatter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCheckerboardSplatter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetSampleDimensions_14(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSampleDimensions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetSampleDimensions_15(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSampleDimensions(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkCheckerboardSplatter_GetSampleDimensions_16(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSampleDimensions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetModelBounds_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetModelBounds_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelBounds(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCheckerboardSplatter_GetModelBounds_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModelBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetFootprint_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFootprint(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_GetFootprintMinValue_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFootprintMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_GetFootprintMaxValue_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFootprintMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_GetFootprint_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFootprint();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetRadius_114(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCheckerboardSplatter_GetRadiusMinValue_115(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCheckerboardSplatter_GetRadiusMaxValue_116(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCheckerboardSplatter_GetRadius_117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetScaleFactor_118(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaleFactor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCheckerboardSplatter_GetScaleFactorMinValue_119(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScaleFactorMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCheckerboardSplatter_GetScaleFactorMaxValue_120(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScaleFactorMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCheckerboardSplatter_GetScaleFactor_121(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScaleFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetExponentFactor_122(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExponentFactor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCheckerboardSplatter_GetExponentFactor_123(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExponentFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetScalarWarping_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarWarping(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_GetScalarWarping_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarWarping();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_ScalarWarpingOn_126(JNIEnv* env, jobject obj)
{

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalarWarpingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_ScalarWarpingOff_127(JNIEnv* env, jobject obj)
{

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalarWarpingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetNormalWarping_128(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalWarping(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_GetNormalWarping_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormalWarping();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_NormalWarpingOn_130(JNIEnv* env, jobject obj)
{

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->NormalWarpingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_NormalWarpingOff_131(JNIEnv* env, jobject obj)
{

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->NormalWarpingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetEccentricity_132(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEccentricity(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCheckerboardSplatter_GetEccentricityMinValue_133(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEccentricityMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCheckerboardSplatter_GetEccentricityMaxValue_134(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEccentricityMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCheckerboardSplatter_GetEccentricity_135(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEccentricity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetAccumulationMode_136(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAccumulationMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_GetAccumulationModeMinValue_137(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAccumulationModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_GetAccumulationModeMaxValue_138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAccumulationModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_GetAccumulationMode_139(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAccumulationMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetAccumulationModeToMin_140(JNIEnv* env, jobject obj)
{

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAccumulationModeToMin();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetAccumulationModeToMax_141(JNIEnv* env, jobject obj)
{

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAccumulationModeToMax();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetAccumulationModeToSum_142(JNIEnv* env, jobject obj)
{

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAccumulationModeToSum();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCheckerboardSplatter_GetAccumulationModeAsString_143(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAccumulationModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetOutputScalarType_144(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputScalarType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_GetOutputScalarType_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputScalarType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetOutputScalarTypeToDouble_146(JNIEnv* env, jobject obj)
{

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputScalarTypeToDouble();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetOutputScalarTypeToFloat_147(JNIEnv* env, jobject obj)
{

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputScalarTypeToFloat();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetCapping_148(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCapping(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_GetCapping_149(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCapping();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_CappingOn_150(JNIEnv* env, jobject obj)
{

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->CappingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_CappingOff_151(JNIEnv* env, jobject obj)
{

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->CappingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetCapValue_152(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCapValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCheckerboardSplatter_GetCapValue_153(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCapValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetNullValue_154(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNullValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCheckerboardSplatter_GetNullValue_155(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNullValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetMaximumDimension_156(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumDimension(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_GetMaximumDimensionMinValue_157(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumDimensionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_GetMaximumDimensionMaxValue_158(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumDimensionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_GetMaximumDimension_159(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumDimension();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_SetParallelSplatCrossover_160(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetParallelSplatCrossover(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_GetParallelSplatCrossoverMinValue_161(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParallelSplatCrossoverMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_GetParallelSplatCrossoverMaxValue_162(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParallelSplatCrossoverMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCheckerboardSplatter_GetParallelSplatCrossover_163(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParallelSplatCrossover();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCheckerboardSplatter_ComputeModelBounds_164(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkDataSet * temp0;
  vtkImageData * temp1;
  vtkInformation * temp2;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id2));

  vtkCheckerboardSplatter* op = static_cast<vtkCheckerboardSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeModelBounds(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCheckerboardSplatter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCheckerboardSplatter::New());
}
