// java wrapper for vtkImageCanvasSource2D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageCanvasSource2D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageCanvasSource2D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageCanvasSource2D",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageCanvasSource2D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageCanvasSource2D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageCanvasSource2D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageCanvasSource2D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetDrawColor_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawColor(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetDrawColor_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageCanvasSource2D_GetDrawColor_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetDrawColor_17(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawColor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetDrawColor_18(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawColor(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetDrawColor_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_InitializeCanvasVolume_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageData * temp0;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeCanvasVolume(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_FillBox_111(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->FillBox(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_FillTube_112(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jdouble id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  double   temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->FillTube(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_FillTriangle_113(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->FillTriangle(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_DrawCircle_114(JNIEnv* env, jobject obj,jint id0,jint id1,jdouble id2)
{
  int   temp0;
  int   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawCircle(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_DrawPoint_115(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawPoint(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_DrawSegment_116(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawSegment(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_DrawSegment3D_117(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawSegment3D(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_DrawImage_118(JNIEnv* env, jobject obj,jint id0,jint id1,jobject id2)
{
  int   temp0;
  int   temp1;
  vtkImageData * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id2));

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawImage(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_DrawImage_119(JNIEnv* env, jobject obj,jint id0,jint id1,jobject id2,jint id3,jint id4,jint id5,jint id6)
{
  int   temp0;
  int   temp1;
  vtkImageData * temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  int   temp6;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawImage(temp0,temp1,temp2,temp3,temp4,temp5,temp6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_FillPixel_120(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->FillPixel(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetExtent_121(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetDefaultZ_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDefaultZ(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageCanvasSource2D_GetDefaultZ_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDefaultZ();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetRatio_124(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRatio(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetRatio_125(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRatio(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageCanvasSource2D_GetRatio_126(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRatio();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetNumberOfScalarComponents_127(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfScalarComponents(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageCanvasSource2D_GetNumberOfScalarComponents_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfScalarComponents();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetScalarTypeToFloat_129(JNIEnv* env, jobject obj)
{

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToFloat();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetScalarTypeToDouble_130(JNIEnv* env, jobject obj)
{

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToDouble();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetScalarTypeToInt_131(JNIEnv* env, jobject obj)
{

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToInt();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetScalarTypeToUnsignedInt_132(JNIEnv* env, jobject obj)
{

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToUnsignedInt();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetScalarTypeToLong_133(JNIEnv* env, jobject obj)
{

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToLong();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetScalarTypeToUnsignedLong_134(JNIEnv* env, jobject obj)
{

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToUnsignedLong();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetScalarTypeToShort_135(JNIEnv* env, jobject obj)
{

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetScalarTypeToUnsignedShort_136(JNIEnv* env, jobject obj)
{

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToUnsignedShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetScalarTypeToUnsignedChar_137(JNIEnv* env, jobject obj)
{

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToUnsignedChar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetScalarTypeToChar_138(JNIEnv* env, jobject obj)
{

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToChar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCanvasSource2D_SetScalarType_139(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageCanvasSource2D_GetScalarType_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageCanvasSource2D* op = static_cast<vtkImageCanvasSource2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarType();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageCanvasSource2D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageCanvasSource2D::New());
}
