// java wrapper for vtkImageAccumulate object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageAccumulate.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageAccumulate_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageAccumulate",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageAccumulate_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageAccumulate_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageAccumulate_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageAccumulate_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageAccumulate_SetComponentSpacing_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComponentSpacing(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageAccumulate_SetComponentSpacing_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComponentSpacing(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageAccumulate_GetComponentSpacing_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComponentSpacing();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageAccumulate_SetComponentOrigin_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComponentOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageAccumulate_SetComponentOrigin_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComponentOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageAccumulate_GetComponentOrigin_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComponentOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageAccumulate_SetComponentExtent_110(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComponentExtent(temp0);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageAccumulate_SetComponentExtent_111(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComponentExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageAccumulate_GetComponentExtent_112(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetComponentExtent(temp0);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageAccumulate_GetComponentExtent_113(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComponentExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageAccumulate_SetStencilData_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageStencilData * temp0;
  temp0 = static_cast<vtkImageStencilData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStencilData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageAccumulate_GetStencil_115(JNIEnv* env, jobject obj)
{
  vtkImageStencilData * temp20;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStencil();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageAccumulate_SetReverseStencil_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReverseStencil(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageAccumulate_GetReverseStencilMinValue_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReverseStencilMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageAccumulate_GetReverseStencilMaxValue_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReverseStencilMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageAccumulate_ReverseStencilOn_119(JNIEnv* env, jobject obj)
{

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReverseStencilOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageAccumulate_ReverseStencilOff_120(JNIEnv* env, jobject obj)
{

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReverseStencilOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageAccumulate_GetReverseStencil_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReverseStencil();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageAccumulate_GetMin_122(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageAccumulate_GetMax_123(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMax();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageAccumulate_GetMean_124(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMean();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageAccumulate_GetStandardDeviation_125(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStandardDeviation();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageAccumulate_GetVoxelCount_126(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVoxelCount();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageAccumulate_SetIgnoreZero_127(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIgnoreZero(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageAccumulate_GetIgnoreZeroMinValue_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIgnoreZeroMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageAccumulate_GetIgnoreZeroMaxValue_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIgnoreZeroMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageAccumulate_GetIgnoreZero_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIgnoreZero();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageAccumulate_IgnoreZeroOn_131(JNIEnv* env, jobject obj)
{

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  op->IgnoreZeroOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageAccumulate_IgnoreZeroOff_132(JNIEnv* env, jobject obj)
{

  vtkImageAccumulate* op = static_cast<vtkImageAccumulate*>(vtkJavaGetPointerFromObject(env, obj));
  op->IgnoreZeroOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageAccumulate_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageAccumulate::New());
}
