// java wrapper for vtkImageViewer2 object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageViewer2.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageViewer2_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageViewer2",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageViewer2_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageViewer2_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageViewer2_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageViewer2_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageViewer2_GetWindowName_14(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWindowName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_Render_15(JNIEnv* env, jobject obj)
{

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetInputData_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageData * temp0;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageViewer2_GetInput_17(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetInputConnection_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputConnection(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageViewer2_GetSliceOrientation_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliceOrientation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetSliceOrientation_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSliceOrientation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetSliceOrientationToXY_111(JNIEnv* env, jobject obj)
{

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSliceOrientationToXY();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetSliceOrientationToYZ_112(JNIEnv* env, jobject obj)
{

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSliceOrientationToYZ();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetSliceOrientationToXZ_113(JNIEnv* env, jobject obj)
{

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSliceOrientationToXZ();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageViewer2_GetSlice_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSlice();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetSlice_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSlice(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_UpdateDisplayExtent_116(JNIEnv* env, jobject obj)
{

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateDisplayExtent();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageViewer2_GetSliceMin_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliceMin();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageViewer2_GetSliceMax_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliceMax();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_GetSliceRange_119(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSliceRange(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageViewer2_GetColorWindow_120(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorWindow();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageViewer2_GetColorLevel_121(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorLevel();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetColorWindow_122(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorWindow(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetColorLevel_123(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorLevel(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageViewer2_GetPosition_124(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetPosition_125(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetPosition_126(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageViewer2_GetSize_127(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetSize_128(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetSize_129(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageViewer2_GetRenderWindow_130(JNIEnv* env, jobject obj)
{
  vtkRenderWindow * temp20;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderWindow();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageViewer2_GetRenderer_131(JNIEnv* env, jobject obj)
{
  vtkRenderer * temp20;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderer();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageViewer2_GetImageActor_132(JNIEnv* env, jobject obj)
{
  vtkImageActor * temp20;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageActor();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageViewer2_GetWindowLevel_133(JNIEnv* env, jobject obj)
{
  vtkImageMapToWindowLevelColors * temp20;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWindowLevel();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageViewer2_GetInteractorStyle_134(JNIEnv* env, jobject obj)
{
  vtkInteractorStyleImage * temp20;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteractorStyle();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetRenderWindow_135(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderWindow(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetRenderer_136(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetupInteractor_137(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindowInteractor * temp0;
  temp0 = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetupInteractor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_SetOffScreenRendering_138(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOffScreenRendering(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageViewer2_GetOffScreenRendering_139(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffScreenRendering();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_OffScreenRenderingOn_140(JNIEnv* env, jobject obj)
{

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->OffScreenRenderingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer2_OffScreenRenderingOff_141(JNIEnv* env, jobject obj)
{

  vtkImageViewer2* op = static_cast<vtkImageViewer2*>(vtkJavaGetPointerFromObject(env, obj));
  op->OffScreenRenderingOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageViewer2_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageViewer2::New());
}
