// java wrapper for vtkBalloonRepresentation object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkBalloonRepresentation.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWidgetRepresentation_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkBalloonRepresentation_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkBalloonRepresentation",dType)) { return me; }
  if ((res= vtkWidgetRepresentation_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBalloonRepresentation_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBalloonRepresentation_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBalloonRepresentation_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBalloonRepresentation_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetBalloonImage_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageData * temp0;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBalloonImage(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBalloonRepresentation_GetBalloonImage_15(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBalloonImage();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkBalloonRepresentation_GetBalloonText_16(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBalloonText();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetBalloonText_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBalloonText(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetImageSize_18(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImageSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetImageSize_19(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImageSize(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkBalloonRepresentation_GetImageSize_110(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetTextProperty_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBalloonRepresentation_GetTextProperty_112(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetFrameProperty_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty2D * temp0;
  temp0 = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrameProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBalloonRepresentation_GetFrameProperty_114(JNIEnv* env, jobject obj)
{
  vtkProperty2D * temp20;

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetImageProperty_115(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty2D * temp0;
  temp0 = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImageProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBalloonRepresentation_GetImageProperty_116(JNIEnv* env, jobject obj)
{
  vtkProperty2D * temp20;

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetBalloonLayout_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBalloonLayout(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBalloonRepresentation_GetBalloonLayout_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBalloonLayout();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetBalloonLayoutToImageLeft_119(JNIEnv* env, jobject obj)
{

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBalloonLayoutToImageLeft();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetBalloonLayoutToImageRight_120(JNIEnv* env, jobject obj)
{

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBalloonLayoutToImageRight();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetBalloonLayoutToImageBottom_121(JNIEnv* env, jobject obj)
{

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBalloonLayoutToImageBottom();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetBalloonLayoutToImageTop_122(JNIEnv* env, jobject obj)
{

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBalloonLayoutToImageTop();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetBalloonLayoutToTextLeft_123(JNIEnv* env, jobject obj)
{

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBalloonLayoutToTextLeft();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetBalloonLayoutToTextRight_124(JNIEnv* env, jobject obj)
{

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBalloonLayoutToTextRight();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetBalloonLayoutToTextTop_125(JNIEnv* env, jobject obj)
{

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBalloonLayoutToTextTop();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetBalloonLayoutToTextBottom_126(JNIEnv* env, jobject obj)
{

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBalloonLayoutToTextBottom();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetOffset_127(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOffset(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetOffset_128(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOffset(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkBalloonRepresentation_GetOffset_129(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffset();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_SetPadding_130(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPadding(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBalloonRepresentation_GetPaddingMinValue_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPaddingMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBalloonRepresentation_GetPaddingMaxValue_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPaddingMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBalloonRepresentation_GetPadding_133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPadding();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_StartWidgetInteraction_134(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartWidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_EndWidgetInteraction_135(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndWidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_BuildRepresentation_136(JNIEnv* env, jobject obj)
{

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildRepresentation();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBalloonRepresentation_ComputeInteractionState_137(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeInteractionState(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonRepresentation_ReleaseGraphicsResources_138(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBalloonRepresentation_RenderOverlay_139(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBalloonRepresentation* op = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkBalloonRepresentation_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkBalloonRepresentation::New());
}
