// java wrapper for vtkContext3D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkContext3D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkContext3D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkContext3D",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContext3D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkContext3D* op = static_cast<vtkContext3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContext3D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkContext3D* op = static_cast<vtkContext3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContext3D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkContext3D* op = static_cast<vtkContext3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContext3D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkContext3D* op = static_cast<vtkContext3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkContext3D_Begin_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContextDevice3D * temp0;
  bool   temp20;
  temp0 = static_cast<vtkContextDevice3D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext3D* op = static_cast<vtkContext3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Begin(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContext3D_GetDevice_15(JNIEnv* env, jobject obj)
{
  vtkContextDevice3D * temp20;

  vtkContext3D* op = static_cast<vtkContext3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDevice();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkContext3D_End_16(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkContext3D* op = static_cast<vtkContext3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->End();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext3D_ApplyPen_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPen * temp0;
  temp0 = static_cast<vtkPen*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext3D* op = static_cast<vtkContext3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyPen(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext3D_ApplyBrush_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkBrush * temp0;
  temp0 = static_cast<vtkBrush*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext3D* op = static_cast<vtkContext3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyBrush(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext3D_SetTransform_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTransform * temp0;
  temp0 = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext3D* op = static_cast<vtkContext3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransform(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContext3D_GetTransform_110(JNIEnv* env, jobject obj)
{
  vtkTransform * temp20;

  vtkContext3D* op = static_cast<vtkContext3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext3D_AppendTransform_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTransform * temp0;
  temp0 = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext3D* op = static_cast<vtkContext3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AppendTransform(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext3D_PushMatrix_112(JNIEnv* env, jobject obj)
{

  vtkContext3D* op = static_cast<vtkContext3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->PushMatrix();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext3D_PopMatrix_113(JNIEnv* env, jobject obj)
{

  vtkContext3D* op = static_cast<vtkContext3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->PopMatrix();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext3D_DisableClippingPlane_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkContext3D* op = static_cast<vtkContext3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableClippingPlane(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkContext3D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkContext3D::New());
}
