// java wrapper for vtkCompositeDataDisplayAttributes object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCompositeDataDisplayAttributes.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCompositeDataDisplayAttributes_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCompositeDataDisplayAttributes",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockVisibilities_14(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockVisibilities();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_SetBlockVisibility_15(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkDataObject * temp0;
  bool   temp1;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockVisibility(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetBlockVisibility_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockVisibility(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockVisibility_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockVisibility(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockVisibility_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockVisibility(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockVisibilities_19(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockVisibilities();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockPickabilities_110(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockPickabilities();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_SetBlockPickability_111(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkDataObject * temp0;
  bool   temp1;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockPickability(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetBlockPickability_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockPickability(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockPickability_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockPickability(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockPickability_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockPickability(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockPickabilities_115(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockPickabilities();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_SetBlockScalarVisibility_116(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkDataObject * temp0;
  bool   temp1;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockScalarVisibility(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetBlockScalarVisibility_117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockScalarVisibility(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockScalarVisibility_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockScalarVisibility(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockScalarVisibilities_119(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockScalarVisibilities();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockScalarVisibility_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockScalarVisibility(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockScalarVisibilities_121(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockScalarVisibilities();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_SetBlockUseLookupTableScalarRange_122(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkDataObject * temp0;
  bool   temp1;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockUseLookupTableScalarRange(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetBlockUseLookupTableScalarRange_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockUseLookupTableScalarRange(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockUseLookupTableScalarRange_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockUseLookupTableScalarRange(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockUseLookupTableScalarRanges_125(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockUseLookupTableScalarRanges();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockUseLookupTableScalarRange_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockUseLookupTableScalarRange(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockUseLookupTableScalarRanges_127(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockUseLookupTableScalarRanges();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_SetBlockInterpolateScalarsBeforeMapping_128(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkDataObject * temp0;
  bool   temp1;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockInterpolateScalarsBeforeMapping(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetBlockInterpolateScalarsBeforeMapping_129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockInterpolateScalarsBeforeMapping(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockInterpolateScalarsBeforeMapping_130(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockInterpolateScalarsBeforeMapping(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockInterpolateScalarsBeforeMappings_131(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockInterpolateScalarsBeforeMappings();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockInterpolateScalarsBeforeMapping_132(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockInterpolateScalarsBeforeMapping(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockInterpolateScalarsBeforeMappings_133(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockInterpolateScalarsBeforeMappings();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_SetBlockColor_134(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1)
{
  vtkDataObject * temp0;
  double temp1[3];
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockColor(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetBlockColor_135(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1)
{
  vtkDataObject * temp0;
  double temp1[3];
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBlockColor(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockColors_136(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockColors();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockColor_137(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockColor(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockColor_138(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockColor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockColors_139(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockColors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_SetBlockOpacity_140(JNIEnv* env, jobject obj,jobject id0,jdouble id1)
{
  vtkDataObject * temp0;
  double   temp1;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockOpacity(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetBlockOpacity_141(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  double   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockOpacity(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockOpacities_142(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockOpacities();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockOpacity_143(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockOpacity(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockOpacity_144(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockOpacity(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockOpacities_145(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockOpacities();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_SetBlockMaterial_146(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1)
{
  vtkDataObject * temp0;
  std::string temp1;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockMaterial(temp0,temp1);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetBlockMaterial_147(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  const std::string * temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = &(op)->GetBlockMaterial(temp0);
  return vtkJavaStringToUTF8(env, *temp20);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockMaterials_148(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockMaterials();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockMaterial_149(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockMaterial(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockMaterial_150(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockMaterial(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockMaterials_151(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockMaterials();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_SetBlockColorMode_152(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkDataObject * temp0;
  int   temp1;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockColorMode(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetBlockColorMode_153(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockColorMode(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockColorMode_154(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockColorMode(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockColorModes_155(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockColorModes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockColorMode_156(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockColorMode(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockColorModes_157(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockColorModes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_SetBlockScalarMode_158(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkDataObject * temp0;
  int   temp1;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockScalarMode(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetBlockScalarMode_159(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockScalarMode(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockScalarMode_160(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockScalarMode(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockScalarModes_161(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockScalarModes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockScalarMode_162(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockScalarMode(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockScalarModes_163(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockScalarModes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_SetBlockArrayAccessMode_164(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkDataObject * temp0;
  int   temp1;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockArrayAccessMode(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetBlockArrayAccessMode_165(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockArrayAccessMode(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockArrayAccessMode_166(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockArrayAccessMode(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockArrayAccessModes_167(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockArrayAccessModes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockArrayAccessMode_168(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockArrayAccessMode(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockArrayAccessModes_169(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockArrayAccessModes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_SetBlockArrayComponent_170(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkDataObject * temp0;
  int   temp1;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockArrayComponent(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetBlockArrayComponent_171(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockArrayComponent(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockArrayComponent_172(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockArrayComponent(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockArrayComponents_173(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockArrayComponents();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockArrayComponent_174(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockArrayComponent(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockArrayComponents_175(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockArrayComponents();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_SetBlockArrayId_176(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkDataObject * temp0;
  int   temp1;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockArrayId(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetBlockArrayId_177(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockArrayId(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockArrayId_178(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockArrayId(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockArrayIds_179(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockArrayIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockArrayId_180(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockArrayId(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockArrayIds_181(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockArrayIds();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockScalarRange_182(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockScalarRange(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockScalarRanges_183(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockScalarRanges();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockScalarRange_184(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockScalarRange(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockScalarRanges_185(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockScalarRanges();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_SetBlockArrayName_186(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1)
{
  vtkDataObject * temp0;
  std::string temp1;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockArrayName(temp0,temp1);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetBlockArrayName_187(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  std::string   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockArrayName(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockArrayName_188(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockArrayName(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockArrayNames_189(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockArrayNames();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockArrayName_190(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockArrayName(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockArrayNames_191(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockArrayNames();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_SetBlockFieldDataTupleId_192(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkDataObject * temp0;
  long long   temp1;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockFieldDataTupleId(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_GetBlockFieldDataTupleId_193(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  long long   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockFieldDataTupleId(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockFieldDataTupleId_194(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockFieldDataTupleId(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockFieldDataTupleIds_195(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockFieldDataTupleIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockFieldDataTupleId_196(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockFieldDataTupleId(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockFieldDataTupleIds_197(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockFieldDataTupleIds();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockLookupTable_198(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockLookupTable(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_HasBlockLookupTables_199(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasBlockLookupTables();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockLookupTable_1100(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockLookupTable(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_RemoveBlockLookupTables_1101(JNIEnv* env, jobject obj)
{

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockLookupTables();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_ComputeVisibleBounds_1102(JNIEnv* env, jobject obj,jobject id0,jobject id1,jdoubleArray id2)
{
  vtkCompositeDataDisplayAttributes * temp0;
  vtkDataObject * temp1;
  double temp2[6];
  temp0 = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));
  env->GetDoubleArrayRegion(id2, 0, 6, &temp2[0]);

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeVisibleBounds(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 6, &temp2[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_DataObjectFromIndex_1103(JNIEnv* env, jobject obj,jint id0,jobject id1,jint id2)
{
   unsigned int   temp0;
  vtkDataObject * temp1;
   unsigned int   temp2;
  vtkDataObject * temp20;
  temp0 = id0;
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkCompositeDataDisplayAttributes* op = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DataObjectFromIndex(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCompositeDataDisplayAttributes_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCompositeDataDisplayAttributes::New());
}
