// java wrapper for vtkPicker object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPicker.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractPropPicker_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPicker_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPicker",dType)) { return me; }
  if ((res= vtkAbstractPropPicker_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPicker_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPicker_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPicker_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPicker_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPicker_SetTolerance_14(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTolerance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPicker_GetTolerance_15(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTolerance();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPicker_GetMapperPosition_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMapperPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPicker_GetMapper_17(JNIEnv* env, jobject obj)
{
  vtkAbstractMapper3D * temp20;

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMapper();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPicker_GetDataSet_18(JNIEnv* env, jobject obj)
{
  vtkDataSet * temp20;

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSet();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPicker_GetCompositeDataSet_19(JNIEnv* env, jobject obj)
{
  vtkCompositeDataSet * temp20;

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCompositeDataSet();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPicker_GetFlatBlockIndex_110(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFlatBlockIndex();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPicker_GetProp3Ds_111(JNIEnv* env, jobject obj)
{
  vtkProp3DCollection * temp20;

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProp3Ds();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPicker_GetActors_112(JNIEnv* env, jobject obj)
{
  vtkActorCollection * temp20;

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActors();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPicker_GetPickedPositions_113(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickedPositions();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPicker_Pick_114(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jobject id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  vtkRenderer * temp3;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id3));

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Pick(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPicker_Pick_115(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1)
{
  double temp0[3];
  vtkRenderer * temp1;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Pick(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPicker_Pick3DPoint_116(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1)
{
  double temp0[3];
  vtkRenderer * temp1;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Pick3DPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPicker_Pick3DPoint_117(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jobject id2)
{
  double temp0[3];
  double temp1[3];
  vtkRenderer * temp2;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id2));

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Pick3DPoint(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPicker_Pick3DRay_118(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jobject id2)
{
  double temp0[3];
  double temp1[4];
  vtkRenderer * temp2;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);
  temp2 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id2));

  vtkPicker* op = static_cast<vtkPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Pick3DRay(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPicker_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPicker::New());
}
