// java wrapper for vtkRenderWindowInteractor3D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkRenderWindowInteractor3D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkRenderWindowInteractor_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkRenderWindowInteractor3D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkRenderWindowInteractor3D",dType)) { return me; }
  if ((res= vtkRenderWindowInteractor_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor3D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor3D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindowInteractor3D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindowInteractor3D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_Enable_14(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Enable();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_Disable_15(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Disable();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_GetWorldEventPose_16(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkMatrix4x4 * temp0;
  int   temp1;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetWorldEventPose(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_GetLastWorldEventPose_17(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkMatrix4x4 * temp0;
  int   temp1;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetLastWorldEventPose(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_SetPhysicalEventPosition_18(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jint id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  int   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalEventPosition(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_SetPhysicalEventPose_19(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkMatrix4x4 * temp0;
  int   temp1;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalEventPose(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_GetPhysicalEventPose_110(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkMatrix4x4 * temp0;
  int   temp1;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPhysicalEventPose(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_GetLastPhysicalEventPose_111(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkMatrix4x4 * temp0;
  int   temp1;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetLastPhysicalEventPose(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_GetStartingPhysicalEventPose_112(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkMatrix4x4 * temp0;
  int   temp1;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetStartingPhysicalEventPose(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_GetStartingPhysicalToWorldMatrix_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetStartingPhysicalToWorldMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_SetStartingPhysicalToWorldMatrix_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStartingPhysicalToWorldMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_SetWorldEventPosition_115(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jint id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  int   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWorldEventPosition(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_SetWorldEventOrientation_116(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jint id4)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  int   temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWorldEventOrientation(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_SetWorldEventPose_117(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkMatrix4x4 * temp0;
  int   temp1;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWorldEventPose(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_RightButtonPressEvent_118(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->RightButtonPressEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_RightButtonReleaseEvent_119(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->RightButtonReleaseEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_MiddleButtonPressEvent_120(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->MiddleButtonPressEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_MiddleButtonReleaseEvent_121(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->MiddleButtonReleaseEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_SetPhysicalViewDirection_122(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalViewDirection(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_SetPhysicalViewUp_123(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalViewUp(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_SetPhysicalTranslation_124(JNIEnv* env, jobject obj,jobject id0,jdouble id1,jdouble id2,jdouble id3)
{
  vtkCamera * temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalTranslation(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_SetPhysicalScale_125(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalScale(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderWindowInteractor3D_GetPhysicalScale_126(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPhysicalScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor3D_SetTranslation3D_127(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTranslation3D(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkRenderWindowInteractor3D_GetTranslation3D_128(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTranslation3D();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkRenderWindowInteractor3D_GetLastTranslation3D_129(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkRenderWindowInteractor3D* op = static_cast<vtkRenderWindowInteractor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastTranslation3D();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkRenderWindowInteractor3D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkRenderWindowInteractor3D::New());
}
