// java wrapper for vtkSkybox object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSkybox.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkActor_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSkybox_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSkybox",dType)) { return me; }
  if ((res= vtkActor_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSkybox_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSkybox_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSkybox_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSkybox_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSkybox_GetProjection_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProjection();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSkybox_SetProjection_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProjection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSkybox_SetProjectionToCube_16(JNIEnv* env, jobject obj)
{

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProjectionToCube();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSkybox_SetProjectionToSphere_17(JNIEnv* env, jobject obj)
{

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProjectionToSphere();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSkybox_SetProjectionToStereoSphere_18(JNIEnv* env, jobject obj)
{

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProjectionToStereoSphere();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSkybox_SetProjectionToFloor_19(JNIEnv* env, jobject obj)
{

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProjectionToFloor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSkybox_SetFloorPlane_110(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2,jfloat id3)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFloorPlane(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSkybox_SetFloorPlane_111(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[4];
  env->GetFloatArrayRegion(id0, 0, 4, &temp0[0]);

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFloorPlane(temp0);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkSkybox_GetFloorPlane_112(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFloorPlane();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSkybox_SetFloorRight_113(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2)
{
  float   temp0;
  float   temp1;
  float   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFloorRight(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSkybox_SetFloorRight_114(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFloorRight(temp0);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkSkybox_GetFloorRight_115(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFloorRight();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 3);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkSkybox_GetFloorTexCoordScale_116(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFloorTexCoordScale();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSkybox_SetFloorTexCoordScale_117(JNIEnv* env, jobject obj,jfloat id0,jfloat id1)
{
  float   temp0;
  float   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFloorTexCoordScale(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSkybox_SetFloorTexCoordScale_118(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[2];
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFloorTexCoordScale(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSkybox_GetGammaCorrect_119(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGammaCorrect();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSkybox_SetGammaCorrect_120(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGammaCorrect(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSkybox_GammaCorrectOn_121(JNIEnv* env, jobject obj)
{

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  op->GammaCorrectOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSkybox_GammaCorrectOff_122(JNIEnv* env, jobject obj)
{

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  op->GammaCorrectOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSkybox_GetBounds_123(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkSkybox* op = static_cast<vtkSkybox*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSkybox_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSkybox::New());
}
