// java wrapper for vtkTextProperty object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTextProperty.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTextProperty_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTextProperty",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextProperty_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextProperty_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetColor_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetColor_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkTextProperty_GetColor_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetOpacity_17(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOpacity(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTextProperty_GetOpacityMinValue_18(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacityMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTextProperty_GetOpacityMaxValue_19(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacityMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTextProperty_GetOpacity_110(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetBackgroundColor_111(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackgroundColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetBackgroundColor_112(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackgroundColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkTextProperty_GetBackgroundColor_113(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackgroundColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetBackgroundOpacity_114(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackgroundOpacity(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTextProperty_GetBackgroundOpacityMinValue_115(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackgroundOpacityMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTextProperty_GetBackgroundOpacityMaxValue_116(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackgroundOpacityMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTextProperty_GetBackgroundOpacity_117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackgroundOpacity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetBackgroundRGBA_118(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackgroundRGBA(temp0);
  env->SetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetBackgroundRGBA_119(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackgroundRGBA(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_GetBackgroundRGBA_120(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBackgroundRGBA(temp0);
  env->SetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetFrameColor_121(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrameColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetFrameColor_122(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrameColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkTextProperty_GetFrameColor_123(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetFrame_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrame(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetFrame_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrame();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_FrameOn_126(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->FrameOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_FrameOff_127(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->FrameOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetFrameWidth_128(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrameWidth(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetFrameWidthMinValue_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameWidthMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetFrameWidthMaxValue_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameWidthMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetFrameWidth_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameWidth();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTextProperty_GetFontFamilyAsString_132(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFontFamilyAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetFontFamilyAsString_133(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFontFamilyAsString(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetFontFamily_134(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFontFamily(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetFontFamily_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFontFamily();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetFontFamilyMinValue_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFontFamilyMinValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetFontFamilyToArial_137(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFontFamilyToArial();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetFontFamilyToCourier_138(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFontFamilyToCourier();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetFontFamilyToTimes_139(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFontFamilyToTimes();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetFontFamilyFromString_140(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFontFamilyFromString(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTextProperty_GetFontFamilyAsString_141(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFontFamilyAsString(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTextProperty_GetFontFile_142(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFontFile();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetFontFile_143(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFontFile(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetFontSize_144(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFontSize(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetFontSizeMinValue_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFontSizeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetFontSizeMaxValue_146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFontSizeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetFontSize_147(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFontSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetBold_148(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBold(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetBold_149(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBold();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_BoldOn_150(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->BoldOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_BoldOff_151(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->BoldOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetItalic_152(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetItalic(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetItalic_153(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetItalic();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_ItalicOn_154(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ItalicOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_ItalicOff_155(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ItalicOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetShadow_156(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShadow(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetShadow_157(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShadow();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_ShadowOn_158(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShadowOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_ShadowOff_159(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShadowOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetShadowOffset_160(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShadowOffset(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetShadowOffset_161(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShadowOffset(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkTextProperty_GetShadowOffset_162(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShadowOffset();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_GetShadowColor_163(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetShadowColor(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetJustification_164(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetJustification(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetJustificationMinValue_165(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetJustificationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetJustificationMaxValue_166(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetJustificationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetJustification_167(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetJustification();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetJustificationToLeft_168(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetJustificationToLeft();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetJustificationToCentered_169(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetJustificationToCentered();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetJustificationToRight_170(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetJustificationToRight();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTextProperty_GetJustificationAsString_171(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetJustificationAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetVerticalJustification_172(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVerticalJustification(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetVerticalJustificationMinValue_173(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVerticalJustificationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetVerticalJustificationMaxValue_174(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVerticalJustificationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetVerticalJustification_175(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVerticalJustification();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetVerticalJustificationToBottom_176(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVerticalJustificationToBottom();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetVerticalJustificationToCentered_177(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVerticalJustificationToCentered();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetVerticalJustificationToTop_178(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVerticalJustificationToTop();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTextProperty_GetVerticalJustificationAsString_179(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVerticalJustificationAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetUseTightBoundingBox_180(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseTightBoundingBox(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetUseTightBoundingBox_181(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseTightBoundingBox();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_UseTightBoundingBoxOn_182(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseTightBoundingBoxOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_UseTightBoundingBoxOff_183(JNIEnv* env, jobject obj)
{

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseTightBoundingBoxOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetOrientation_184(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientation(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTextProperty_GetOrientation_185(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetLineSpacing_186(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineSpacing(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTextProperty_GetLineSpacing_187(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineSpacing();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetLineOffset_188(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineOffset(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTextProperty_GetLineOffset_189(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetCellOffset_190(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellOffset(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTextProperty_GetCellOffset_191(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetInteriorLinesVisibility_192(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteriorLinesVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextProperty_GetInteriorLinesVisibility_193(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteriorLinesVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetInteriorLinesWidth_194(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteriorLinesWidth(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextProperty_GetInteriorLinesWidth_195(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteriorLinesWidth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetInteriorLinesColor_196(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteriorLinesColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_SetInteriorLinesColor_197(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteriorLinesColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkTextProperty_GetInteriorLinesColor_198(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteriorLinesColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextProperty_ShallowCopy_199(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextProperty* op = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTextProperty_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTextProperty::New());
}
