// java wrapper for vtkLabeledDataMapper object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkLabeledDataMapper.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkMapper2D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkLabeledDataMapper_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkLabeledDataMapper",dType)) { return me; }
  if ((res= vtkMapper2D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabeledDataMapper_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabeledDataMapper_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabeledDataMapper_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabeledDataMapper_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetLabelFormat_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelFormat(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLabeledDataMapper_GetLabelFormat_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelFormat();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetLabeledComponent_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabeledComponent(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabeledDataMapper_GetLabeledComponent_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabeledComponent();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetComponentSeparator_18(JNIEnv* env, jobject obj,jchar id0)
{
  char   temp0;
  temp0 = static_cast<char>(0xff & id0);

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComponentSeparator(temp0);

}

extern "C" JNIEXPORT jchar  JNICALL Java_vtk_vtkLabeledDataMapper_GetComponentSeparator_19(JNIEnv* env, jobject obj)
{
  char   temp20;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComponentSeparator();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetFieldDataArray_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFieldDataArray(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabeledDataMapper_GetFieldDataArrayMinValue_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldDataArrayMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabeledDataMapper_GetFieldDataArrayMaxValue_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldDataArrayMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabeledDataMapper_GetFieldDataArray_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldDataArray();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetFieldDataName_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFieldDataName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLabeledDataMapper_GetFieldDataName_115(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldDataName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetInputData_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabeledDataMapper_GetInput_117(JNIEnv* env, jobject obj)
{
  vtkDataSet * temp20;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetLabelMode_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabeledDataMapper_GetLabelMode_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetLabelModeToLabelIds_120(JNIEnv* env, jobject obj)
{

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelModeToLabelIds();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetLabelModeToLabelScalars_121(JNIEnv* env, jobject obj)
{

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelModeToLabelScalars();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetLabelModeToLabelVectors_122(JNIEnv* env, jobject obj)
{

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelModeToLabelVectors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetLabelModeToLabelNormals_123(JNIEnv* env, jobject obj)
{

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelModeToLabelNormals();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetLabelModeToLabelTCoords_124(JNIEnv* env, jobject obj)
{

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelModeToLabelTCoords();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetLabelModeToLabelTensors_125(JNIEnv* env, jobject obj)
{

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelModeToLabelTensors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetLabelModeToLabelFieldData_126(JNIEnv* env, jobject obj)
{

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelModeToLabelFieldData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetLabelTextProperty_127(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabeledDataMapper_GetLabelTextProperty_128(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetLabelTextProperty_129(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkTextProperty * temp0;
  int   temp1;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelTextProperty(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabeledDataMapper_GetLabelTextProperty_130(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkTextProperty * temp20;
  temp0 = id0;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelTextProperty(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_RenderOpaqueGeometry_131(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkViewport * temp0;
  vtkActor2D * temp1;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkActor2D*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderOpaqueGeometry(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_RenderOverlay_132(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkViewport * temp0;
  vtkActor2D * temp1;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkActor2D*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderOverlay(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_ReleaseGraphicsResources_133(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabeledDataMapper_GetTransform_134(JNIEnv* env, jobject obj)
{
  vtkTransform * temp20;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetTransform_135(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTransform * temp0;
  temp0 = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransform(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabeledDataMapper_GetCoordinateSystem_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoordinateSystem();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_SetCoordinateSystem_137(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoordinateSystem(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabeledDataMapper_GetCoordinateSystemMinValue_138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoordinateSystemMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabeledDataMapper_GetCoordinateSystemMaxValue_139(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoordinateSystemMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_CoordinateSystemWorld_140(JNIEnv* env, jobject obj)
{

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->CoordinateSystemWorld();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_CoordinateSystemDisplay_141(JNIEnv* env, jobject obj)
{

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->CoordinateSystemDisplay();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabeledDataMapper_GetMTime_142(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabeledDataMapper_GetNumberOfLabels_143(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLabels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabeledDataMapper_GetLabelPosition_144(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetLabelPosition(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLabeledDataMapper_GetLabelText_145(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkLabeledDataMapper* op = static_cast<vtkLabeledDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelText(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkLabeledDataMapper_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkLabeledDataMapper::New());
}
