// java wrapper for vtkDirectionEncoder object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDirectionEncoder.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDirectionEncoder_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDirectionEncoder",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDirectionEncoder_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDirectionEncoder* op = static_cast<vtkDirectionEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDirectionEncoder_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDirectionEncoder* op = static_cast<vtkDirectionEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDirectionEncoder_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDirectionEncoder* op = static_cast<vtkDirectionEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDirectionEncoder_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDirectionEncoder* op = static_cast<vtkDirectionEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDirectionEncoder_GetEncodedDirection_14(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  int   temp20;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkDirectionEncoder* op = static_cast<vtkDirectionEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEncodedDirection(temp0);
  env->SetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkDirectionEncoder_GetDecodedGradient_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  float * temp20;
  temp0 = id0;

  vtkDirectionEncoder* op = static_cast<vtkDirectionEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDecodedGradient(temp0);
  return vtkJavaMakeJArrayOfFloat(env, temp20, 3);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDirectionEncoder_GetNumberOfEncodedDirections_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDirectionEncoder* op = static_cast<vtkDirectionEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEncodedDirections();
  return temp20;

}
