// java wrapper for vtkHeatmapItem object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkHeatmapItem.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkContextItem_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkHeatmapItem_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkHeatmapItem",dType)) { return me; }
  if ((res= vtkContextItem_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHeatmapItem_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHeatmapItem_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHeatmapItem_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHeatmapItem_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHeatmapItem_SetTable_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTable * temp0;
  temp0 = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTable(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHeatmapItem_GetTable_15(JNIEnv* env, jobject obj)
{
  vtkTable * temp20;

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHeatmapItem_GetRowNames_16(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRowNames();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkHeatmapItem_GetNameColumn_17(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNameColumn();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHeatmapItem_SetNameColumn_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString   temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNameColumn(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHeatmapItem_SetOrientation_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHeatmapItem_GetOrientation_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientation();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHeatmapItem_GetTextAngleForOrientation_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextAngleForOrientation(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHeatmapItem_SetPosition_112(JNIEnv* env, jobject obj,jfloat id0,jfloat id1)
{
  float   temp0;
  float   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHeatmapItem_SetPosition_113(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[2];
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkHeatmapItem_GetPosition_114(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 2);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHeatmapItem_GetCellHeight_115(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellHeight();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHeatmapItem_SetCellHeight_116(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellHeight(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHeatmapItem_GetCellWidth_117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellWidth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHeatmapItem_SetCellWidth_118(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellWidth(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHeatmapItem_GetBounds_119(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHeatmapItem_MarkRowAsBlank_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->MarkRowAsBlank(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHeatmapItem_Paint_121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContext2D * temp0;
  bool   temp20;
  temp0 = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Paint(temp0);
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkHeatmapItem_GetRowLabelWidth_122(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRowLabelWidth();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkHeatmapItem_GetColumnLabelWidth_123(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkHeatmapItem* op = static_cast<vtkHeatmapItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColumnLabelWidth();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkHeatmapItem_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkHeatmapItem::New());
}
