// java wrapper for vtkWebGLDataSet object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkWebGLDataSet.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkWebGLDataSet_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkWebGLDataSet",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebGLDataSet_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWebGLDataSet* op = static_cast<vtkWebGLDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebGLDataSet_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWebGLDataSet* op = static_cast<vtkWebGLDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWebGLDataSet_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWebGLDataSet* op = static_cast<vtkWebGLDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWebGLDataSet_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWebGLDataSet* op = static_cast<vtkWebGLDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebGLDataSet_SetType_14(JNIEnv* env, jobject obj,jint id0)
{
  WebGLObjectTypes   temp0;
  temp0 = static_cast<WebGLObjectTypes>(id0);

  vtkWebGLDataSet* op = static_cast<vtkWebGLDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebGLDataSet_GetBinarySize_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWebGLDataSet* op = static_cast<vtkWebGLDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBinarySize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebGLDataSet_GenerateBinaryData_16(JNIEnv* env, jobject obj)
{

  vtkWebGLDataSet* op = static_cast<vtkWebGLDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateBinaryData();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkWebGLDataSet_HasChanged_17(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkWebGLDataSet* op = static_cast<vtkWebGLDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasChanged();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkWebGLDataSet_GetMD5_18(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkWebGLDataSet* op = static_cast<vtkWebGLDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMD5();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkWebGLDataSet_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkWebGLDataSet::New());
}
