package naturaldate

// Code generated by peg -inline -switch grammar.peg DO NOT EDIT

import (
	"fmt"
	"io"
	"os"
	"sort"
	"strconv"
	"time"
)

const endSymbol rune = 1114112

/* The rule types inferred from the grammar are below. */
type pegRule uint8

const (
	ruleUnknown pegRule = iota
	ruleQuery
	ruleExpr
	ruleRelativeMinutes
	ruleRelativeHours
	ruleRelativeDays
	ruleRelativeWeeks
	ruleRelativeMonth
	ruleRelativeYear
	ruleRelativeWeekdays
	ruleDate
	ruleTime
	ruleClock12Hour
	ruleClock24Hour
	ruleMinutes
	ruleSeconds
	ruleNumber
	ruleWeekday
	ruleMonth
	ruleIn
	ruleLast
	ruleNext
	ruleOrdinal
	ruleWord
	ruleYEARS
	ruleMONTHS
	ruleWEEKS
	ruleDAYS
	ruleHOURS
	ruleMINUTES
	ruleYESTERDAY
	ruleTOMORROW
	ruleTODAY
	ruleAGO
	ruleFROM_NOW
	ruleNOW
	ruleAM
	rulePM
	ruleNEXT
	ruleIN
	ruleLAST
	rule_
	ruleWhitespace
	ruleEOL
	ruleEOF
	ruleAction0
	ruleAction1
	ruleAction2
	ruleAction3
	ruleAction4
	ruleAction5
	ruleAction6
	ruleAction7
	ruleAction8
	ruleAction9
	ruleAction10
	ruleAction11
	ruleAction12
	ruleAction13
	ruleAction14
	ruleAction15
	ruleAction16
	ruleAction17
	ruleAction18
	ruleAction19
	ruleAction20
	ruleAction21
	ruleAction22
	ruleAction23
	ruleAction24
	ruleAction25
	ruleAction26
	ruleAction27
	ruleAction28
	ruleAction29
	ruleAction30
	ruleAction31
	ruleAction32
	ruleAction33
	ruleAction34
	ruleAction35
	ruleAction36
	ruleAction37
	ruleAction38
	ruleAction39
	ruleAction40
	ruleAction41
	ruleAction42
	ruleAction43
	ruleAction44
	rulePegText
	ruleAction45
	ruleAction46
	ruleAction47
	ruleAction48
	ruleAction49
	ruleAction50
	ruleAction51
	ruleAction52
	ruleAction53
	ruleAction54
	ruleAction55
	ruleAction56
	ruleAction57
	ruleAction58
	ruleAction59
	ruleAction60
	ruleAction61
	ruleAction62
	ruleAction63
	ruleAction64
	ruleAction65
	ruleAction66
	ruleAction67
	ruleAction68
	ruleAction69
	ruleAction70
	ruleAction71
	ruleAction72
	ruleAction73
	ruleAction74
	ruleAction75
	ruleAction76
	ruleAction77
)

var rul3s = [...]string{
	"Unknown",
	"Query",
	"Expr",
	"RelativeMinutes",
	"RelativeHours",
	"RelativeDays",
	"RelativeWeeks",
	"RelativeMonth",
	"RelativeYear",
	"RelativeWeekdays",
	"Date",
	"Time",
	"Clock12Hour",
	"Clock24Hour",
	"Minutes",
	"Seconds",
	"Number",
	"Weekday",
	"Month",
	"In",
	"Last",
	"Next",
	"Ordinal",
	"Word",
	"YEARS",
	"MONTHS",
	"WEEKS",
	"DAYS",
	"HOURS",
	"MINUTES",
	"YESTERDAY",
	"TOMORROW",
	"TODAY",
	"AGO",
	"FROM_NOW",
	"NOW",
	"AM",
	"PM",
	"NEXT",
	"IN",
	"LAST",
	"_",
	"Whitespace",
	"EOL",
	"EOF",
	"Action0",
	"Action1",
	"Action2",
	"Action3",
	"Action4",
	"Action5",
	"Action6",
	"Action7",
	"Action8",
	"Action9",
	"Action10",
	"Action11",
	"Action12",
	"Action13",
	"Action14",
	"Action15",
	"Action16",
	"Action17",
	"Action18",
	"Action19",
	"Action20",
	"Action21",
	"Action22",
	"Action23",
	"Action24",
	"Action25",
	"Action26",
	"Action27",
	"Action28",
	"Action29",
	"Action30",
	"Action31",
	"Action32",
	"Action33",
	"Action34",
	"Action35",
	"Action36",
	"Action37",
	"Action38",
	"Action39",
	"Action40",
	"Action41",
	"Action42",
	"Action43",
	"Action44",
	"PegText",
	"Action45",
	"Action46",
	"Action47",
	"Action48",
	"Action49",
	"Action50",
	"Action51",
	"Action52",
	"Action53",
	"Action54",
	"Action55",
	"Action56",
	"Action57",
	"Action58",
	"Action59",
	"Action60",
	"Action61",
	"Action62",
	"Action63",
	"Action64",
	"Action65",
	"Action66",
	"Action67",
	"Action68",
	"Action69",
	"Action70",
	"Action71",
	"Action72",
	"Action73",
	"Action74",
	"Action75",
	"Action76",
	"Action77",
}

type token32 struct {
	pegRule
	begin, end uint32
}

func (t *token32) String() string {
	return fmt.Sprintf("\x1B[34m%v\x1B[m %v %v", rul3s[t.pegRule], t.begin, t.end)
}

type node32 struct {
	token32
	up, next *node32
}

func (node *node32) print(w io.Writer, pretty bool, buffer string) {
	var print func(node *node32, depth int)
	print = func(node *node32, depth int) {
		for node != nil {
			for c := 0; c < depth; c++ {
				fmt.Fprintf(w, " ")
			}
			rule := rul3s[node.pegRule]
			quote := strconv.Quote(string(([]rune(buffer)[node.begin:node.end])))
			if !pretty {
				fmt.Fprintf(w, "%v %v\n", rule, quote)
			} else {
				fmt.Fprintf(w, "\x1B[34m%v\x1B[m %v\n", rule, quote)
			}
			if node.up != nil {
				print(node.up, depth+1)
			}
			node = node.next
		}
	}
	print(node, 0)
}

func (node *node32) Print(w io.Writer, buffer string) {
	node.print(w, false, buffer)
}

func (node *node32) PrettyPrint(w io.Writer, buffer string) {
	node.print(w, true, buffer)
}

type tokens32 struct {
	tree []token32
}

func (t *tokens32) Trim(length uint32) {
	t.tree = t.tree[:length]
}

func (t *tokens32) Print() {
	for _, token := range t.tree {
		fmt.Println(token.String())
	}
}

func (t *tokens32) AST() *node32 {
	type element struct {
		node *node32
		down *element
	}
	tokens := t.Tokens()
	var stack *element
	for _, token := range tokens {
		if token.begin == token.end {
			continue
		}
		node := &node32{token32: token}
		for stack != nil && stack.node.begin >= token.begin && stack.node.end <= token.end {
			stack.node.next = node.up
			node.up = stack.node
			stack = stack.down
		}
		stack = &element{node: node, down: stack}
	}
	if stack != nil {
		return stack.node
	}
	return nil
}

func (t *tokens32) PrintSyntaxTree(buffer string) {
	t.AST().Print(os.Stdout, buffer)
}

func (t *tokens32) WriteSyntaxTree(w io.Writer, buffer string) {
	t.AST().Print(w, buffer)
}

func (t *tokens32) PrettyPrintSyntaxTree(buffer string) {
	t.AST().PrettyPrint(os.Stdout, buffer)
}

func (t *tokens32) Add(rule pegRule, begin, end, index uint32) {
	tree, i := t.tree, int(index)
	if i >= len(tree) {
		t.tree = append(tree, token32{pegRule: rule, begin: begin, end: end})
		return
	}
	tree[i] = token32{pegRule: rule, begin: begin, end: end}
}

func (t *tokens32) Tokens() []token32 {
	return t.tree
}

type parser struct {
	t         time.Time
	number    int
	month     time.Month
	weekday   time.Weekday
	direction int

	Buffer string
	buffer []rune
	rules  [124]func() bool
	parse  func(rule ...int) error
	reset  func()
	Pretty bool
	tokens32
}

func (p *parser) Parse(rule ...int) error {
	return p.parse(rule...)
}

func (p *parser) Reset() {
	p.reset()
}

type textPosition struct {
	line, symbol int
}

type textPositionMap map[int]textPosition

func translatePositions(buffer []rune, positions []int) textPositionMap {
	length, translations, j, line, symbol := len(positions), make(textPositionMap, len(positions)), 0, 1, 0
	sort.Ints(positions)

search:
	for i, c := range buffer {
		if c == '\n' {
			line, symbol = line+1, 0
		} else {
			symbol++
		}
		if i == positions[j] {
			translations[positions[j]] = textPosition{line, symbol}
			for j++; j < length; j++ {
				if i != positions[j] {
					continue search
				}
			}
			break search
		}
	}

	return translations
}

type parseError struct {
	p   *parser
	max token32
}

func (e *parseError) Error() string {
	tokens, err := []token32{e.max}, "\n"
	positions, p := make([]int, 2*len(tokens)), 0
	for _, token := range tokens {
		positions[p], p = int(token.begin), p+1
		positions[p], p = int(token.end), p+1
	}
	translations := translatePositions(e.p.buffer, positions)
	format := "parse error near %v (line %v symbol %v - line %v symbol %v):\n%v\n"
	if e.p.Pretty {
		format = "parse error near \x1B[34m%v\x1B[m (line %v symbol %v - line %v symbol %v):\n%v\n"
	}
	for _, token := range tokens {
		begin, end := int(token.begin), int(token.end)
		err += fmt.Sprintf(format,
			rul3s[token.pegRule],
			translations[begin].line, translations[begin].symbol,
			translations[end].line, translations[end].symbol,
			strconv.Quote(string(e.p.buffer[begin:end])))
	}

	return err
}

func (p *parser) PrintSyntaxTree() {
	if p.Pretty {
		p.tokens32.PrettyPrintSyntaxTree(p.Buffer)
	} else {
		p.tokens32.PrintSyntaxTree(p.Buffer)
	}
}

func (p *parser) WriteSyntaxTree(w io.Writer) {
	p.tokens32.WriteSyntaxTree(w, p.Buffer)
}

func (p *parser) Execute() {
	buffer, _buffer, text, begin, end := p.Buffer, p.buffer, "", 0, 0
	for _, token := range p.Tokens() {
		switch token.pegRule {

		case rulePegText:
			begin, end = int(token.begin), int(token.end)
			text = string(_buffer[begin:end])

		case ruleAction0:

			p.t = p.t.Add(-time.Minute * time.Duration(p.number))

		case ruleAction1:

			p.t = p.t.Add(time.Minute * time.Duration(p.number))

		case ruleAction2:

			p.t = p.t.Add(-time.Minute * time.Duration(p.number))

		case ruleAction3:

			p.t = p.t.Add(time.Minute * time.Duration(p.number))

		case ruleAction4:

			p.t = p.t.Add(p.withDirection(time.Minute) * time.Duration(p.number))

		case ruleAction5:

			p.t = p.t.Add(-time.Hour * time.Duration(p.number))

		case ruleAction6:

			p.t = p.t.Add(time.Hour * time.Duration(p.number))

		case ruleAction7:

			p.t = p.t.Add(-time.Hour * time.Duration(p.number))

		case ruleAction8:

			p.t = p.t.Add(time.Hour * time.Duration(p.number))

		case ruleAction9:

			p.t = p.t.Add(p.withDirection(time.Hour) * time.Duration(p.number))

		case ruleAction10:

			p.t = truncateDay(p.t.Add(-day * time.Duration(p.number)))

		case ruleAction11:

			p.t = p.t.Add(day * time.Duration(p.number))

		case ruleAction12:

			p.t = truncateDay(p.t.Add(-day * time.Duration(p.number)))

		case ruleAction13:

			p.t = truncateDay(p.t.Add(day * time.Duration(p.number)))

		case ruleAction14:

			p.t = truncateDay(p.t.Add(p.withDirection(day) * time.Duration(p.number)))

		case ruleAction15:

			p.t = truncateDay(p.t.Add(-week * time.Duration(p.number)))

		case ruleAction16:

			p.t = p.t.Add(week * time.Duration(p.number))

		case ruleAction17:

			p.t = truncateDay(p.t.Add(-week * time.Duration(p.number)))

		case ruleAction18:

			p.t = truncateDay(p.t.Add(week * time.Duration(p.number)))

		case ruleAction19:

			p.t = truncateDay(p.t.Add(p.withDirection(week) * time.Duration(p.number)))

		case ruleAction20:

			p.t = p.t.AddDate(0, -p.number, 0)

		case ruleAction21:

			p.t = p.t.AddDate(0, p.number, 0)

		case ruleAction22:

			p.t = p.t.AddDate(0, -p.number, 0)

		case ruleAction23:

			p.t = p.t.AddDate(0, p.number, 0)

		case ruleAction24:

			p.t = prevMonth(p.t, p.month)

		case ruleAction25:

			p.t = nextMonth(p.t, p.month)

		case ruleAction26:

			if p.direction < 0 {
				p.t = prevMonth(p.t, p.month)
			} else {
				p.t = nextMonth(p.t, p.month)
			}

		case ruleAction27:

			p.t = p.t.AddDate(-p.number, 0, 0)

		case ruleAction28:

			p.t = p.t.AddDate(p.number, 0, 0)

		case ruleAction29:

			p.t = p.t.AddDate(-p.number, 0, 0)

		case ruleAction30:

			p.t = p.t.AddDate(p.number, 0, 0)

		case ruleAction31:

			p.t = time.Date(p.t.Year()-1, 1, 1, 0, 0, 0, 0, p.t.Location())

		case ruleAction32:

			p.t = time.Date(p.t.Year()+1, 1, 1, 0, 0, 0, 0, p.t.Location())

		case ruleAction33:

			p.t = truncateDay(p.t)

		case ruleAction34:

			p.t = truncateDay(p.t.Add(-day))

		case ruleAction35:

			p.t = truncateDay(p.t.Add(+day))

		case ruleAction36:

			p.t = truncateDay(prevWeekday(p.t, p.weekday))

		case ruleAction37:

			p.t = truncateDay(nextWeekday(p.t, p.weekday))

		case ruleAction38:

			if p.direction < 0 {
				p.t = truncateDay(prevWeekday(p.t, p.weekday))
			} else {
				p.t = truncateDay(nextWeekday(p.t, p.weekday))
			}

		case ruleAction39:

			t := p.t
			year, month, _ := t.Date()
			hour, min, sec := t.Clock()
			p.t = time.Date(year, month, p.number, hour, min, sec, 0, t.Location())

		case ruleAction40:

			year, month, day := p.t.Date()
			p.t = time.Date(year, month, day, p.number, 0, 0, 0, p.t.Location())

		case ruleAction41:

			year, month, day := p.t.Date()
			p.t = time.Date(year, month, day, p.number+12, 0, 0, 0, p.t.Location())

		case ruleAction42:

			year, month, day := p.t.Date()
			p.t = time.Date(year, month, day, p.number, 0, 0, 0, p.t.Location())

		case ruleAction43:

			t := p.t
			year, month, day := t.Date()
			hour, _, _ := t.Clock()
			p.t = time.Date(year, month, day, hour, p.number, 0, 0, t.Location())

		case ruleAction44:

			t := p.t
			year, month, day := t.Date()
			hour, min, _ := t.Clock()
			p.t = time.Date(year, month, day, hour, min, p.number, 0, t.Location())

		case ruleAction45:
			n, _ := strconv.Atoi(text)
			p.number = n
		case ruleAction46:
			p.number = 1
		case ruleAction47:
			p.number = 2
		case ruleAction48:
			p.number = 3
		case ruleAction49:
			p.number = 4
		case ruleAction50:
			p.number = 5
		case ruleAction51:
			p.number = 6
		case ruleAction52:
			p.number = 7
		case ruleAction53:
			p.number = 8
		case ruleAction54:
			p.number = 9
		case ruleAction55:
			p.number = 10
		case ruleAction56:
			p.weekday = time.Sunday
		case ruleAction57:
			p.weekday = time.Monday
		case ruleAction58:
			p.weekday = time.Tuesday
		case ruleAction59:
			p.weekday = time.Wednesday
		case ruleAction60:
			p.weekday = time.Thursday
		case ruleAction61:
			p.weekday = time.Friday
		case ruleAction62:
			p.weekday = time.Saturday
		case ruleAction63:
			p.month = time.January
		case ruleAction64:
			p.month = time.February
		case ruleAction65:
			p.month = time.March
		case ruleAction66:
			p.month = time.April
		case ruleAction67:
			p.month = time.May
		case ruleAction68:
			p.month = time.June
		case ruleAction69:
			p.month = time.July
		case ruleAction70:
			p.month = time.August
		case ruleAction71:
			p.month = time.September
		case ruleAction72:
			p.month = time.October
		case ruleAction73:
			p.month = time.November
		case ruleAction74:
			p.month = time.December
		case ruleAction75:
			p.number = 1
		case ruleAction76:
			p.number = 1
		case ruleAction77:
			p.number = 1

		}
	}
	_, _, _, _, _ = buffer, _buffer, text, begin, end
}

func Pretty(pretty bool) func(*parser) error {
	return func(p *parser) error {
		p.Pretty = pretty
		return nil
	}
}

func Size(size int) func(*parser) error {
	return func(p *parser) error {
		p.tokens32 = tokens32{tree: make([]token32, 0, size)}
		return nil
	}
}
func (p *parser) Init(options ...func(*parser) error) error {
	var (
		max                  token32
		position, tokenIndex uint32
		buffer               []rune
	)
	for _, option := range options {
		err := option(p)
		if err != nil {
			return err
		}
	}
	p.reset = func() {
		max = token32{}
		position, tokenIndex = 0, 0

		p.buffer = []rune(p.Buffer)
		if len(p.buffer) == 0 || p.buffer[len(p.buffer)-1] != endSymbol {
			p.buffer = append(p.buffer, endSymbol)
		}
		buffer = p.buffer
	}
	p.reset()

	_rules := p.rules
	tree := p.tokens32
	p.parse = func(rule ...int) error {
		r := 1
		if len(rule) > 0 {
			r = rule[0]
		}
		matches := p.rules[r]()
		p.tokens32 = tree
		if matches {
			p.Trim(tokenIndex)
			return nil
		}
		return &parseError{p, max}
	}

	add := func(rule pegRule, begin uint32) {
		tree.Add(rule, begin, position, tokenIndex)
		tokenIndex++
		if begin != position && position > max.end {
			max = token32{rule, begin, position}
		}
	}

	matchDot := func() bool {
		if buffer[position] != endSymbol {
			position++
			return true
		}
		return false
	}

	/*matchChar := func(c byte) bool {
		if buffer[position] == c {
			position++
			return true
		}
		return false
	}*/

	/*matchRange := func(lower byte, upper byte) bool {
		if c := buffer[position]; c >= lower && c <= upper {
			position++
			return true
		}
		return false
	}*/

	_rules = [...]func() bool{
		nil,
		/* 0 Query <- <(_ Expr+ EOF)> */
		func() bool {
			position0, tokenIndex0 := position, tokenIndex
			{
				position1 := position
				if !_rules[rule_]() {
					goto l0
				}
				{
					position4 := position
					{
						position5, tokenIndex5 := position, tokenIndex
						{
							position7 := position
							if buffer[position] != rune('n') {
								goto l6
							}
							position++
							if buffer[position] != rune('o') {
								goto l6
							}
							position++
							if buffer[position] != rune('w') {
								goto l6
							}
							position++
							if !_rules[rule_]() {
								goto l6
							}
							add(ruleNOW, position7)
						}
						goto l5
					l6:
						position, tokenIndex = position5, tokenIndex5
						{
							position9 := position
							{
								position10, tokenIndex10 := position, tokenIndex
								if !_rules[ruleNumber]() {
									goto l11
								}
								if !_rules[ruleMINUTES]() {
									goto l11
								}
								if !_rules[ruleAGO]() {
									goto l11
								}
								{
									add(ruleAction0, position)
								}
								goto l10
							l11:
								position, tokenIndex = position10, tokenIndex10
								{
									position14, tokenIndex14 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l15
									}
									if !_rules[ruleMINUTES]() {
										goto l15
									}
									if !_rules[ruleFROM_NOW]() {
										goto l15
									}
									goto l14
								l15:
									position, tokenIndex = position14, tokenIndex14
									if !_rules[ruleIn]() {
										goto l13
									}
									{
										position16, tokenIndex16 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l16
										}
										goto l17
									l16:
										position, tokenIndex = position16, tokenIndex16
									}
								l17:
									if !_rules[ruleMINUTES]() {
										goto l13
									}
									{
										position18, tokenIndex18 := position, tokenIndex
										if !_rules[ruleFROM_NOW]() {
											goto l18
										}
										goto l19
									l18:
										position, tokenIndex = position18, tokenIndex18
									}
								l19:
								}
							l14:
								{
									add(ruleAction1, position)
								}
								goto l10
							l13:
								position, tokenIndex = position10, tokenIndex10
								if !_rules[ruleLast]() {
									goto l21
								}
								{
									position22, tokenIndex22 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l22
									}
									goto l23
								l22:
									position, tokenIndex = position22, tokenIndex22
								}
							l23:
								if !_rules[ruleMINUTES]() {
									goto l21
								}
								{
									add(ruleAction2, position)
								}
								goto l10
							l21:
								position, tokenIndex = position10, tokenIndex10
								if !_rules[ruleNext]() {
									goto l25
								}
								{
									position26, tokenIndex26 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l26
									}
									goto l27
								l26:
									position, tokenIndex = position26, tokenIndex26
								}
							l27:
								if !_rules[ruleMINUTES]() {
									goto l25
								}
								{
									add(ruleAction3, position)
								}
								goto l10
							l25:
								position, tokenIndex = position10, tokenIndex10
								if !_rules[ruleNumber]() {
									goto l8
								}
								if !_rules[ruleMINUTES]() {
									goto l8
								}
								{
									add(ruleAction4, position)
								}
							}
						l10:
							add(ruleRelativeMinutes, position9)
						}
						goto l5
					l8:
						position, tokenIndex = position5, tokenIndex5
						{
							position31 := position
							{
								position32, tokenIndex32 := position, tokenIndex
								if !_rules[ruleNumber]() {
									goto l33
								}
								if !_rules[ruleHOURS]() {
									goto l33
								}
								if !_rules[ruleAGO]() {
									goto l33
								}
								{
									add(ruleAction5, position)
								}
								goto l32
							l33:
								position, tokenIndex = position32, tokenIndex32
								{
									position36, tokenIndex36 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l37
									}
									if !_rules[ruleHOURS]() {
										goto l37
									}
									if !_rules[ruleFROM_NOW]() {
										goto l37
									}
									goto l36
								l37:
									position, tokenIndex = position36, tokenIndex36
									if !_rules[ruleIn]() {
										goto l35
									}
									{
										position38, tokenIndex38 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l38
										}
										goto l39
									l38:
										position, tokenIndex = position38, tokenIndex38
									}
								l39:
									if !_rules[ruleHOURS]() {
										goto l35
									}
									{
										position40, tokenIndex40 := position, tokenIndex
										if !_rules[ruleFROM_NOW]() {
											goto l40
										}
										goto l41
									l40:
										position, tokenIndex = position40, tokenIndex40
									}
								l41:
								}
							l36:
								{
									add(ruleAction6, position)
								}
								goto l32
							l35:
								position, tokenIndex = position32, tokenIndex32
								if !_rules[ruleLast]() {
									goto l43
								}
								{
									position44, tokenIndex44 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l44
									}
									goto l45
								l44:
									position, tokenIndex = position44, tokenIndex44
								}
							l45:
								if !_rules[ruleHOURS]() {
									goto l43
								}
								{
									add(ruleAction7, position)
								}
								goto l32
							l43:
								position, tokenIndex = position32, tokenIndex32
								if !_rules[ruleNext]() {
									goto l47
								}
								{
									position48, tokenIndex48 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l48
									}
									goto l49
								l48:
									position, tokenIndex = position48, tokenIndex48
								}
							l49:
								if !_rules[ruleHOURS]() {
									goto l47
								}
								{
									add(ruleAction8, position)
								}
								goto l32
							l47:
								position, tokenIndex = position32, tokenIndex32
								if !_rules[ruleNumber]() {
									goto l30
								}
								if !_rules[ruleHOURS]() {
									goto l30
								}
								{
									add(ruleAction9, position)
								}
							}
						l32:
							add(ruleRelativeHours, position31)
						}
						goto l5
					l30:
						position, tokenIndex = position5, tokenIndex5
						{
							position53 := position
							{
								position54, tokenIndex54 := position, tokenIndex
								if !_rules[ruleNumber]() {
									goto l55
								}
								if !_rules[ruleDAYS]() {
									goto l55
								}
								if !_rules[ruleAGO]() {
									goto l55
								}
								{
									add(ruleAction10, position)
								}
								goto l54
							l55:
								position, tokenIndex = position54, tokenIndex54
								{
									position58, tokenIndex58 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l59
									}
									if !_rules[ruleDAYS]() {
										goto l59
									}
									if !_rules[ruleFROM_NOW]() {
										goto l59
									}
									goto l58
								l59:
									position, tokenIndex = position58, tokenIndex58
									if !_rules[ruleIn]() {
										goto l57
									}
									{
										position60, tokenIndex60 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l60
										}
										goto l61
									l60:
										position, tokenIndex = position60, tokenIndex60
									}
								l61:
									if !_rules[ruleDAYS]() {
										goto l57
									}
									{
										position62, tokenIndex62 := position, tokenIndex
										if !_rules[ruleFROM_NOW]() {
											goto l62
										}
										goto l63
									l62:
										position, tokenIndex = position62, tokenIndex62
									}
								l63:
								}
							l58:
								{
									add(ruleAction11, position)
								}
								goto l54
							l57:
								position, tokenIndex = position54, tokenIndex54
								if !_rules[ruleLast]() {
									goto l65
								}
								{
									position66, tokenIndex66 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l66
									}
									goto l67
								l66:
									position, tokenIndex = position66, tokenIndex66
								}
							l67:
								if !_rules[ruleDAYS]() {
									goto l65
								}
								{
									add(ruleAction12, position)
								}
								goto l54
							l65:
								position, tokenIndex = position54, tokenIndex54
								if !_rules[ruleNext]() {
									goto l69
								}
								{
									position70, tokenIndex70 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l70
									}
									goto l71
								l70:
									position, tokenIndex = position70, tokenIndex70
								}
							l71:
								if !_rules[ruleDAYS]() {
									goto l69
								}
								{
									add(ruleAction13, position)
								}
								goto l54
							l69:
								position, tokenIndex = position54, tokenIndex54
								if !_rules[ruleNumber]() {
									goto l52
								}
								if !_rules[ruleDAYS]() {
									goto l52
								}
								{
									add(ruleAction14, position)
								}
							}
						l54:
							add(ruleRelativeDays, position53)
						}
						goto l5
					l52:
						position, tokenIndex = position5, tokenIndex5
						{
							position75 := position
							{
								position76, tokenIndex76 := position, tokenIndex
								if !_rules[ruleNumber]() {
									goto l77
								}
								if !_rules[ruleWEEKS]() {
									goto l77
								}
								if !_rules[ruleAGO]() {
									goto l77
								}
								{
									add(ruleAction15, position)
								}
								goto l76
							l77:
								position, tokenIndex = position76, tokenIndex76
								{
									position80, tokenIndex80 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l81
									}
									if !_rules[ruleWEEKS]() {
										goto l81
									}
									if !_rules[ruleFROM_NOW]() {
										goto l81
									}
									goto l80
								l81:
									position, tokenIndex = position80, tokenIndex80
									if !_rules[ruleIn]() {
										goto l79
									}
									{
										position82, tokenIndex82 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l82
										}
										goto l83
									l82:
										position, tokenIndex = position82, tokenIndex82
									}
								l83:
									if !_rules[ruleWEEKS]() {
										goto l79
									}
									{
										position84, tokenIndex84 := position, tokenIndex
										if !_rules[ruleFROM_NOW]() {
											goto l84
										}
										goto l85
									l84:
										position, tokenIndex = position84, tokenIndex84
									}
								l85:
								}
							l80:
								{
									add(ruleAction16, position)
								}
								goto l76
							l79:
								position, tokenIndex = position76, tokenIndex76
								if !_rules[ruleLast]() {
									goto l87
								}
								{
									position88, tokenIndex88 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l88
									}
									goto l89
								l88:
									position, tokenIndex = position88, tokenIndex88
								}
							l89:
								if !_rules[ruleWEEKS]() {
									goto l87
								}
								{
									add(ruleAction17, position)
								}
								goto l76
							l87:
								position, tokenIndex = position76, tokenIndex76
								if !_rules[ruleNext]() {
									goto l91
								}
								{
									position92, tokenIndex92 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l92
									}
									goto l93
								l92:
									position, tokenIndex = position92, tokenIndex92
								}
							l93:
								if !_rules[ruleWEEKS]() {
									goto l91
								}
								{
									add(ruleAction18, position)
								}
								goto l76
							l91:
								position, tokenIndex = position76, tokenIndex76
								if !_rules[ruleNumber]() {
									goto l74
								}
								if !_rules[ruleWEEKS]() {
									goto l74
								}
								{
									add(ruleAction19, position)
								}
							}
						l76:
							add(ruleRelativeWeeks, position75)
						}
						goto l5
					l74:
						position, tokenIndex = position5, tokenIndex5
						{
							position97 := position
							{
								position98, tokenIndex98 := position, tokenIndex
								{
									position100 := position
									if buffer[position] != rune('t') {
										goto l99
									}
									position++
									if buffer[position] != rune('o') {
										goto l99
									}
									position++
									if buffer[position] != rune('d') {
										goto l99
									}
									position++
									if buffer[position] != rune('a') {
										goto l99
									}
									position++
									if buffer[position] != rune('y') {
										goto l99
									}
									position++
									if !_rules[rule_]() {
										goto l99
									}
									add(ruleTODAY, position100)
								}
								{
									add(ruleAction33, position)
								}
								goto l98
							l99:
								position, tokenIndex = position98, tokenIndex98
								{
									position103 := position
									if buffer[position] != rune('t') {
										goto l102
									}
									position++
									if buffer[position] != rune('o') {
										goto l102
									}
									position++
									if buffer[position] != rune('m') {
										goto l102
									}
									position++
									if buffer[position] != rune('o') {
										goto l102
									}
									position++
									if buffer[position] != rune('r') {
										goto l102
									}
									position++
									if buffer[position] != rune('r') {
										goto l102
									}
									position++
									if buffer[position] != rune('o') {
										goto l102
									}
									position++
									if buffer[position] != rune('w') {
										goto l102
									}
									position++
									if !_rules[rule_]() {
										goto l102
									}
									add(ruleTOMORROW, position103)
								}
								{
									add(ruleAction35, position)
								}
								goto l98
							l102:
								position, tokenIndex = position98, tokenIndex98
								{
									switch buffer[position] {
									case 'n':
										if !_rules[ruleNEXT]() {
											goto l96
										}
										if !_rules[ruleWeekday]() {
											goto l96
										}
										{
											add(ruleAction37, position)
										}
										break
									case 'y':
										{
											position107 := position
											if buffer[position] != rune('y') {
												goto l96
											}
											position++
											if buffer[position] != rune('e') {
												goto l96
											}
											position++
											if buffer[position] != rune('s') {
												goto l96
											}
											position++
											if buffer[position] != rune('t') {
												goto l96
											}
											position++
											if buffer[position] != rune('e') {
												goto l96
											}
											position++
											if buffer[position] != rune('r') {
												goto l96
											}
											position++
											if buffer[position] != rune('d') {
												goto l96
											}
											position++
											if buffer[position] != rune('a') {
												goto l96
											}
											position++
											if buffer[position] != rune('y') {
												goto l96
											}
											position++
											if !_rules[rule_]() {
												goto l96
											}
											add(ruleYESTERDAY, position107)
										}
										{
											add(ruleAction34, position)
										}
										break
									case 'l', 'p':
										if !_rules[ruleLAST]() {
											goto l96
										}
										if !_rules[ruleWeekday]() {
											goto l96
										}
										{
											add(ruleAction36, position)
										}
										break
									default:
										if !_rules[ruleWeekday]() {
											goto l96
										}
										{
											add(ruleAction38, position)
										}
										break
									}
								}

							}
						l98:
							add(ruleRelativeWeekdays, position97)
						}
						goto l5
					l96:
						position, tokenIndex = position5, tokenIndex5
						{
							position112 := position
							{
								position113, tokenIndex113 := position, tokenIndex
								if !_rules[ruleNumber]() {
									goto l114
								}
								if !_rules[ruleMONTHS]() {
									goto l114
								}
								if !_rules[ruleAGO]() {
									goto l114
								}
								{
									add(ruleAction20, position)
								}
								goto l113
							l114:
								position, tokenIndex = position113, tokenIndex113
								{
									position117, tokenIndex117 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l118
									}
									if !_rules[ruleMONTHS]() {
										goto l118
									}
									if !_rules[ruleFROM_NOW]() {
										goto l118
									}
									goto l117
								l118:
									position, tokenIndex = position117, tokenIndex117
									if !_rules[ruleIn]() {
										goto l116
									}
									{
										position119, tokenIndex119 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l119
										}
										goto l120
									l119:
										position, tokenIndex = position119, tokenIndex119
									}
								l120:
									if !_rules[ruleMONTHS]() {
										goto l116
									}
									{
										position121, tokenIndex121 := position, tokenIndex
										if !_rules[ruleFROM_NOW]() {
											goto l121
										}
										goto l122
									l121:
										position, tokenIndex = position121, tokenIndex121
									}
								l122:
								}
							l117:
								{
									add(ruleAction21, position)
								}
								goto l113
							l116:
								position, tokenIndex = position113, tokenIndex113
								if !_rules[ruleLast]() {
									goto l124
								}
								{
									position125, tokenIndex125 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l125
									}
									goto l126
								l125:
									position, tokenIndex = position125, tokenIndex125
								}
							l126:
								if !_rules[ruleMONTHS]() {
									goto l124
								}
								{
									add(ruleAction22, position)
								}
								goto l113
							l124:
								position, tokenIndex = position113, tokenIndex113
								if !_rules[ruleNext]() {
									goto l128
								}
								{
									position129, tokenIndex129 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l129
									}
									goto l130
								l129:
									position, tokenIndex = position129, tokenIndex129
								}
							l130:
								if !_rules[ruleMONTHS]() {
									goto l128
								}
								{
									add(ruleAction23, position)
								}
								goto l113
							l128:
								position, tokenIndex = position113, tokenIndex113
								if !_rules[ruleLAST]() {
									goto l132
								}
								if !_rules[ruleMonth]() {
									goto l132
								}
								{
									add(ruleAction24, position)
								}
								goto l113
							l132:
								position, tokenIndex = position113, tokenIndex113
								if !_rules[ruleNEXT]() {
									goto l134
								}
								if !_rules[ruleMonth]() {
									goto l134
								}
								{
									add(ruleAction25, position)
								}
								goto l113
							l134:
								position, tokenIndex = position113, tokenIndex113
								if !_rules[ruleMonth]() {
									goto l111
								}
								{
									add(ruleAction26, position)
								}
							}
						l113:
							add(ruleRelativeMonth, position112)
						}
						goto l5
					l111:
						position, tokenIndex = position5, tokenIndex5
						{
							position138 := position
							{
								position139, tokenIndex139 := position, tokenIndex
								if !_rules[ruleNumber]() {
									goto l140
								}
								if !_rules[ruleYEARS]() {
									goto l140
								}
								if !_rules[ruleAGO]() {
									goto l140
								}
								{
									add(ruleAction27, position)
								}
								goto l139
							l140:
								position, tokenIndex = position139, tokenIndex139
								{
									position143, tokenIndex143 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l144
									}
									if !_rules[ruleYEARS]() {
										goto l144
									}
									if !_rules[ruleFROM_NOW]() {
										goto l144
									}
									goto l143
								l144:
									position, tokenIndex = position143, tokenIndex143
									if !_rules[ruleIn]() {
										goto l142
									}
									{
										position145, tokenIndex145 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l145
										}
										goto l146
									l145:
										position, tokenIndex = position145, tokenIndex145
									}
								l146:
									if !_rules[ruleYEARS]() {
										goto l142
									}
									{
										position147, tokenIndex147 := position, tokenIndex
										if !_rules[ruleFROM_NOW]() {
											goto l147
										}
										goto l148
									l147:
										position, tokenIndex = position147, tokenIndex147
									}
								l148:
								}
							l143:
								{
									add(ruleAction28, position)
								}
								goto l139
							l142:
								position, tokenIndex = position139, tokenIndex139
								if !_rules[ruleLast]() {
									goto l150
								}
								{
									position151, tokenIndex151 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l151
									}
									goto l152
								l151:
									position, tokenIndex = position151, tokenIndex151
								}
							l152:
								if !_rules[ruleYEARS]() {
									goto l150
								}
								{
									add(ruleAction29, position)
								}
								goto l139
							l150:
								position, tokenIndex = position139, tokenIndex139
								if !_rules[ruleNext]() {
									goto l154
								}
								{
									position155, tokenIndex155 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l155
									}
									goto l156
								l155:
									position, tokenIndex = position155, tokenIndex155
								}
							l156:
								if !_rules[ruleYEARS]() {
									goto l154
								}
								{
									add(ruleAction30, position)
								}
								goto l139
							l154:
								position, tokenIndex = position139, tokenIndex139
								if !_rules[ruleLAST]() {
									goto l158
								}
								if !_rules[ruleYEARS]() {
									goto l158
								}
								{
									add(ruleAction31, position)
								}
								goto l139
							l158:
								position, tokenIndex = position139, tokenIndex139
								if !_rules[ruleNEXT]() {
									goto l137
								}
								if !_rules[ruleYEARS]() {
									goto l137
								}
								{
									add(ruleAction32, position)
								}
							}
						l139:
							add(ruleRelativeYear, position138)
						}
						goto l5
					l137:
						position, tokenIndex = position5, tokenIndex5
						{
							position162 := position
							{
								position163, tokenIndex163 := position, tokenIndex
								if !_rules[ruleNumber]() {
									goto l164
								}
								{
									position165 := position
									{
										switch buffer[position] {
										case 't':
											if buffer[position] != rune('t') {
												goto l164
											}
											position++
											if buffer[position] != rune('h') {
												goto l164
											}
											position++
											break
										case 'r':
											if buffer[position] != rune('r') {
												goto l164
											}
											position++
											if buffer[position] != rune('d') {
												goto l164
											}
											position++
											break
										case 'n':
											if buffer[position] != rune('n') {
												goto l164
											}
											position++
											if buffer[position] != rune('d') {
												goto l164
											}
											position++
											break
										default:
											if buffer[position] != rune('s') {
												goto l164
											}
											position++
											if buffer[position] != rune('t') {
												goto l164
											}
											position++
											break
										}
									}

									if !_rules[rule_]() {
										goto l164
									}
									add(ruleOrdinal, position165)
								}
								goto l163
							l164:
								position, tokenIndex = position163, tokenIndex163
								if !_rules[ruleLast]() {
									goto l161
								}
								{
									position167, tokenIndex167 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l167
									}
									goto l168
								l167:
									position, tokenIndex = position167, tokenIndex167
								}
							l168:
								if !_rules[ruleNumber]() {
									goto l161
								}
							}
						l163:
							{
								add(ruleAction39, position)
							}
							add(ruleDate, position162)
						}
						goto l5
					l161:
						position, tokenIndex = position5, tokenIndex5
						{
							position171 := position
							{
								position172, tokenIndex172 := position, tokenIndex
								{
									position174 := position
									{
										position175, tokenIndex175 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l176
										}
										{
											add(ruleAction40, position)
										}
										{
											position178, tokenIndex178 := position, tokenIndex
											if !_rules[ruleMinutes]() {
												goto l178
											}
											{
												position180, tokenIndex180 := position, tokenIndex
												if !_rules[ruleSeconds]() {
													goto l180
												}
												goto l181
											l180:
												position, tokenIndex = position180, tokenIndex180
											}
										l181:
											goto l179
										l178:
											position, tokenIndex = position178, tokenIndex178
										}
									l179:
										{
											position182 := position
											if buffer[position] != rune('a') {
												goto l176
											}
											position++
											if buffer[position] != rune('m') {
												goto l176
											}
											position++
											if !_rules[rule_]() {
												goto l176
											}
											add(ruleAM, position182)
										}
										goto l175
									l176:
										position, tokenIndex = position175, tokenIndex175
										if !_rules[ruleNumber]() {
											goto l173
										}
										{
											add(ruleAction41, position)
										}
										{
											position184, tokenIndex184 := position, tokenIndex
											if !_rules[ruleMinutes]() {
												goto l184
											}
											{
												position186, tokenIndex186 := position, tokenIndex
												if !_rules[ruleSeconds]() {
													goto l186
												}
												goto l187
											l186:
												position, tokenIndex = position186, tokenIndex186
											}
										l187:
											goto l185
										l184:
											position, tokenIndex = position184, tokenIndex184
										}
									l185:
										{
											position188 := position
											if buffer[position] != rune('p') {
												goto l173
											}
											position++
											if buffer[position] != rune('m') {
												goto l173
											}
											position++
											if !_rules[rule_]() {
												goto l173
											}
											add(rulePM, position188)
										}
									}
								l175:
									add(ruleClock12Hour, position174)
								}
								goto l172
							l173:
								position, tokenIndex = position172, tokenIndex172
								{
									position189 := position
									if !_rules[ruleNumber]() {
										goto l170
									}
									{
										add(ruleAction42, position)
									}
									{
										position191, tokenIndex191 := position, tokenIndex
										if !_rules[ruleMinutes]() {
											goto l191
										}
										{
											position193, tokenIndex193 := position, tokenIndex
											if !_rules[ruleSeconds]() {
												goto l193
											}
											goto l194
										l193:
											position, tokenIndex = position193, tokenIndex193
										}
									l194:
										goto l192
									l191:
										position, tokenIndex = position191, tokenIndex191
									}
								l192:
									add(ruleClock24Hour, position189)
								}
							}
						l172:
							add(ruleTime, position171)
						}
						goto l5
					l170:
						position, tokenIndex = position5, tokenIndex5
						{
							position195 := position
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l0
							}
							position++
						l196:
							{
								position197, tokenIndex197 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('z') {
									goto l197
								}
								position++
								goto l196
							l197:
								position, tokenIndex = position197, tokenIndex197
							}
							if !_rules[rule_]() {
								goto l0
							}
							add(ruleWord, position195)
						}
					}
				l5:
					add(ruleExpr, position4)
				}
			l2:
				{
					position3, tokenIndex3 := position, tokenIndex
					{
						position198 := position
						{
							position199, tokenIndex199 := position, tokenIndex
							{
								position201 := position
								if buffer[position] != rune('n') {
									goto l200
								}
								position++
								if buffer[position] != rune('o') {
									goto l200
								}
								position++
								if buffer[position] != rune('w') {
									goto l200
								}
								position++
								if !_rules[rule_]() {
									goto l200
								}
								add(ruleNOW, position201)
							}
							goto l199
						l200:
							position, tokenIndex = position199, tokenIndex199
							{
								position203 := position
								{
									position204, tokenIndex204 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l205
									}
									if !_rules[ruleMINUTES]() {
										goto l205
									}
									if !_rules[ruleAGO]() {
										goto l205
									}
									{
										add(ruleAction0, position)
									}
									goto l204
								l205:
									position, tokenIndex = position204, tokenIndex204
									{
										position208, tokenIndex208 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l209
										}
										if !_rules[ruleMINUTES]() {
											goto l209
										}
										if !_rules[ruleFROM_NOW]() {
											goto l209
										}
										goto l208
									l209:
										position, tokenIndex = position208, tokenIndex208
										if !_rules[ruleIn]() {
											goto l207
										}
										{
											position210, tokenIndex210 := position, tokenIndex
											if !_rules[ruleNumber]() {
												goto l210
											}
											goto l211
										l210:
											position, tokenIndex = position210, tokenIndex210
										}
									l211:
										if !_rules[ruleMINUTES]() {
											goto l207
										}
										{
											position212, tokenIndex212 := position, tokenIndex
											if !_rules[ruleFROM_NOW]() {
												goto l212
											}
											goto l213
										l212:
											position, tokenIndex = position212, tokenIndex212
										}
									l213:
									}
								l208:
									{
										add(ruleAction1, position)
									}
									goto l204
								l207:
									position, tokenIndex = position204, tokenIndex204
									if !_rules[ruleLast]() {
										goto l215
									}
									{
										position216, tokenIndex216 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l216
										}
										goto l217
									l216:
										position, tokenIndex = position216, tokenIndex216
									}
								l217:
									if !_rules[ruleMINUTES]() {
										goto l215
									}
									{
										add(ruleAction2, position)
									}
									goto l204
								l215:
									position, tokenIndex = position204, tokenIndex204
									if !_rules[ruleNext]() {
										goto l219
									}
									{
										position220, tokenIndex220 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l220
										}
										goto l221
									l220:
										position, tokenIndex = position220, tokenIndex220
									}
								l221:
									if !_rules[ruleMINUTES]() {
										goto l219
									}
									{
										add(ruleAction3, position)
									}
									goto l204
								l219:
									position, tokenIndex = position204, tokenIndex204
									if !_rules[ruleNumber]() {
										goto l202
									}
									if !_rules[ruleMINUTES]() {
										goto l202
									}
									{
										add(ruleAction4, position)
									}
								}
							l204:
								add(ruleRelativeMinutes, position203)
							}
							goto l199
						l202:
							position, tokenIndex = position199, tokenIndex199
							{
								position225 := position
								{
									position226, tokenIndex226 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l227
									}
									if !_rules[ruleHOURS]() {
										goto l227
									}
									if !_rules[ruleAGO]() {
										goto l227
									}
									{
										add(ruleAction5, position)
									}
									goto l226
								l227:
									position, tokenIndex = position226, tokenIndex226
									{
										position230, tokenIndex230 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l231
										}
										if !_rules[ruleHOURS]() {
											goto l231
										}
										if !_rules[ruleFROM_NOW]() {
											goto l231
										}
										goto l230
									l231:
										position, tokenIndex = position230, tokenIndex230
										if !_rules[ruleIn]() {
											goto l229
										}
										{
											position232, tokenIndex232 := position, tokenIndex
											if !_rules[ruleNumber]() {
												goto l232
											}
											goto l233
										l232:
											position, tokenIndex = position232, tokenIndex232
										}
									l233:
										if !_rules[ruleHOURS]() {
											goto l229
										}
										{
											position234, tokenIndex234 := position, tokenIndex
											if !_rules[ruleFROM_NOW]() {
												goto l234
											}
											goto l235
										l234:
											position, tokenIndex = position234, tokenIndex234
										}
									l235:
									}
								l230:
									{
										add(ruleAction6, position)
									}
									goto l226
								l229:
									position, tokenIndex = position226, tokenIndex226
									if !_rules[ruleLast]() {
										goto l237
									}
									{
										position238, tokenIndex238 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l238
										}
										goto l239
									l238:
										position, tokenIndex = position238, tokenIndex238
									}
								l239:
									if !_rules[ruleHOURS]() {
										goto l237
									}
									{
										add(ruleAction7, position)
									}
									goto l226
								l237:
									position, tokenIndex = position226, tokenIndex226
									if !_rules[ruleNext]() {
										goto l241
									}
									{
										position242, tokenIndex242 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l242
										}
										goto l243
									l242:
										position, tokenIndex = position242, tokenIndex242
									}
								l243:
									if !_rules[ruleHOURS]() {
										goto l241
									}
									{
										add(ruleAction8, position)
									}
									goto l226
								l241:
									position, tokenIndex = position226, tokenIndex226
									if !_rules[ruleNumber]() {
										goto l224
									}
									if !_rules[ruleHOURS]() {
										goto l224
									}
									{
										add(ruleAction9, position)
									}
								}
							l226:
								add(ruleRelativeHours, position225)
							}
							goto l199
						l224:
							position, tokenIndex = position199, tokenIndex199
							{
								position247 := position
								{
									position248, tokenIndex248 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l249
									}
									if !_rules[ruleDAYS]() {
										goto l249
									}
									if !_rules[ruleAGO]() {
										goto l249
									}
									{
										add(ruleAction10, position)
									}
									goto l248
								l249:
									position, tokenIndex = position248, tokenIndex248
									{
										position252, tokenIndex252 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l253
										}
										if !_rules[ruleDAYS]() {
											goto l253
										}
										if !_rules[ruleFROM_NOW]() {
											goto l253
										}
										goto l252
									l253:
										position, tokenIndex = position252, tokenIndex252
										if !_rules[ruleIn]() {
											goto l251
										}
										{
											position254, tokenIndex254 := position, tokenIndex
											if !_rules[ruleNumber]() {
												goto l254
											}
											goto l255
										l254:
											position, tokenIndex = position254, tokenIndex254
										}
									l255:
										if !_rules[ruleDAYS]() {
											goto l251
										}
										{
											position256, tokenIndex256 := position, tokenIndex
											if !_rules[ruleFROM_NOW]() {
												goto l256
											}
											goto l257
										l256:
											position, tokenIndex = position256, tokenIndex256
										}
									l257:
									}
								l252:
									{
										add(ruleAction11, position)
									}
									goto l248
								l251:
									position, tokenIndex = position248, tokenIndex248
									if !_rules[ruleLast]() {
										goto l259
									}
									{
										position260, tokenIndex260 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l260
										}
										goto l261
									l260:
										position, tokenIndex = position260, tokenIndex260
									}
								l261:
									if !_rules[ruleDAYS]() {
										goto l259
									}
									{
										add(ruleAction12, position)
									}
									goto l248
								l259:
									position, tokenIndex = position248, tokenIndex248
									if !_rules[ruleNext]() {
										goto l263
									}
									{
										position264, tokenIndex264 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l264
										}
										goto l265
									l264:
										position, tokenIndex = position264, tokenIndex264
									}
								l265:
									if !_rules[ruleDAYS]() {
										goto l263
									}
									{
										add(ruleAction13, position)
									}
									goto l248
								l263:
									position, tokenIndex = position248, tokenIndex248
									if !_rules[ruleNumber]() {
										goto l246
									}
									if !_rules[ruleDAYS]() {
										goto l246
									}
									{
										add(ruleAction14, position)
									}
								}
							l248:
								add(ruleRelativeDays, position247)
							}
							goto l199
						l246:
							position, tokenIndex = position199, tokenIndex199
							{
								position269 := position
								{
									position270, tokenIndex270 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l271
									}
									if !_rules[ruleWEEKS]() {
										goto l271
									}
									if !_rules[ruleAGO]() {
										goto l271
									}
									{
										add(ruleAction15, position)
									}
									goto l270
								l271:
									position, tokenIndex = position270, tokenIndex270
									{
										position274, tokenIndex274 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l275
										}
										if !_rules[ruleWEEKS]() {
											goto l275
										}
										if !_rules[ruleFROM_NOW]() {
											goto l275
										}
										goto l274
									l275:
										position, tokenIndex = position274, tokenIndex274
										if !_rules[ruleIn]() {
											goto l273
										}
										{
											position276, tokenIndex276 := position, tokenIndex
											if !_rules[ruleNumber]() {
												goto l276
											}
											goto l277
										l276:
											position, tokenIndex = position276, tokenIndex276
										}
									l277:
										if !_rules[ruleWEEKS]() {
											goto l273
										}
										{
											position278, tokenIndex278 := position, tokenIndex
											if !_rules[ruleFROM_NOW]() {
												goto l278
											}
											goto l279
										l278:
											position, tokenIndex = position278, tokenIndex278
										}
									l279:
									}
								l274:
									{
										add(ruleAction16, position)
									}
									goto l270
								l273:
									position, tokenIndex = position270, tokenIndex270
									if !_rules[ruleLast]() {
										goto l281
									}
									{
										position282, tokenIndex282 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l282
										}
										goto l283
									l282:
										position, tokenIndex = position282, tokenIndex282
									}
								l283:
									if !_rules[ruleWEEKS]() {
										goto l281
									}
									{
										add(ruleAction17, position)
									}
									goto l270
								l281:
									position, tokenIndex = position270, tokenIndex270
									if !_rules[ruleNext]() {
										goto l285
									}
									{
										position286, tokenIndex286 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l286
										}
										goto l287
									l286:
										position, tokenIndex = position286, tokenIndex286
									}
								l287:
									if !_rules[ruleWEEKS]() {
										goto l285
									}
									{
										add(ruleAction18, position)
									}
									goto l270
								l285:
									position, tokenIndex = position270, tokenIndex270
									if !_rules[ruleNumber]() {
										goto l268
									}
									if !_rules[ruleWEEKS]() {
										goto l268
									}
									{
										add(ruleAction19, position)
									}
								}
							l270:
								add(ruleRelativeWeeks, position269)
							}
							goto l199
						l268:
							position, tokenIndex = position199, tokenIndex199
							{
								position291 := position
								{
									position292, tokenIndex292 := position, tokenIndex
									{
										position294 := position
										if buffer[position] != rune('t') {
											goto l293
										}
										position++
										if buffer[position] != rune('o') {
											goto l293
										}
										position++
										if buffer[position] != rune('d') {
											goto l293
										}
										position++
										if buffer[position] != rune('a') {
											goto l293
										}
										position++
										if buffer[position] != rune('y') {
											goto l293
										}
										position++
										if !_rules[rule_]() {
											goto l293
										}
										add(ruleTODAY, position294)
									}
									{
										add(ruleAction33, position)
									}
									goto l292
								l293:
									position, tokenIndex = position292, tokenIndex292
									{
										position297 := position
										if buffer[position] != rune('t') {
											goto l296
										}
										position++
										if buffer[position] != rune('o') {
											goto l296
										}
										position++
										if buffer[position] != rune('m') {
											goto l296
										}
										position++
										if buffer[position] != rune('o') {
											goto l296
										}
										position++
										if buffer[position] != rune('r') {
											goto l296
										}
										position++
										if buffer[position] != rune('r') {
											goto l296
										}
										position++
										if buffer[position] != rune('o') {
											goto l296
										}
										position++
										if buffer[position] != rune('w') {
											goto l296
										}
										position++
										if !_rules[rule_]() {
											goto l296
										}
										add(ruleTOMORROW, position297)
									}
									{
										add(ruleAction35, position)
									}
									goto l292
								l296:
									position, tokenIndex = position292, tokenIndex292
									{
										switch buffer[position] {
										case 'n':
											if !_rules[ruleNEXT]() {
												goto l290
											}
											if !_rules[ruleWeekday]() {
												goto l290
											}
											{
												add(ruleAction37, position)
											}
											break
										case 'y':
											{
												position301 := position
												if buffer[position] != rune('y') {
													goto l290
												}
												position++
												if buffer[position] != rune('e') {
													goto l290
												}
												position++
												if buffer[position] != rune('s') {
													goto l290
												}
												position++
												if buffer[position] != rune('t') {
													goto l290
												}
												position++
												if buffer[position] != rune('e') {
													goto l290
												}
												position++
												if buffer[position] != rune('r') {
													goto l290
												}
												position++
												if buffer[position] != rune('d') {
													goto l290
												}
												position++
												if buffer[position] != rune('a') {
													goto l290
												}
												position++
												if buffer[position] != rune('y') {
													goto l290
												}
												position++
												if !_rules[rule_]() {
													goto l290
												}
												add(ruleYESTERDAY, position301)
											}
											{
												add(ruleAction34, position)
											}
											break
										case 'l', 'p':
											if !_rules[ruleLAST]() {
												goto l290
											}
											if !_rules[ruleWeekday]() {
												goto l290
											}
											{
												add(ruleAction36, position)
											}
											break
										default:
											if !_rules[ruleWeekday]() {
												goto l290
											}
											{
												add(ruleAction38, position)
											}
											break
										}
									}

								}
							l292:
								add(ruleRelativeWeekdays, position291)
							}
							goto l199
						l290:
							position, tokenIndex = position199, tokenIndex199
							{
								position306 := position
								{
									position307, tokenIndex307 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l308
									}
									if !_rules[ruleMONTHS]() {
										goto l308
									}
									if !_rules[ruleAGO]() {
										goto l308
									}
									{
										add(ruleAction20, position)
									}
									goto l307
								l308:
									position, tokenIndex = position307, tokenIndex307
									{
										position311, tokenIndex311 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l312
										}
										if !_rules[ruleMONTHS]() {
											goto l312
										}
										if !_rules[ruleFROM_NOW]() {
											goto l312
										}
										goto l311
									l312:
										position, tokenIndex = position311, tokenIndex311
										if !_rules[ruleIn]() {
											goto l310
										}
										{
											position313, tokenIndex313 := position, tokenIndex
											if !_rules[ruleNumber]() {
												goto l313
											}
											goto l314
										l313:
											position, tokenIndex = position313, tokenIndex313
										}
									l314:
										if !_rules[ruleMONTHS]() {
											goto l310
										}
										{
											position315, tokenIndex315 := position, tokenIndex
											if !_rules[ruleFROM_NOW]() {
												goto l315
											}
											goto l316
										l315:
											position, tokenIndex = position315, tokenIndex315
										}
									l316:
									}
								l311:
									{
										add(ruleAction21, position)
									}
									goto l307
								l310:
									position, tokenIndex = position307, tokenIndex307
									if !_rules[ruleLast]() {
										goto l318
									}
									{
										position319, tokenIndex319 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l319
										}
										goto l320
									l319:
										position, tokenIndex = position319, tokenIndex319
									}
								l320:
									if !_rules[ruleMONTHS]() {
										goto l318
									}
									{
										add(ruleAction22, position)
									}
									goto l307
								l318:
									position, tokenIndex = position307, tokenIndex307
									if !_rules[ruleNext]() {
										goto l322
									}
									{
										position323, tokenIndex323 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l323
										}
										goto l324
									l323:
										position, tokenIndex = position323, tokenIndex323
									}
								l324:
									if !_rules[ruleMONTHS]() {
										goto l322
									}
									{
										add(ruleAction23, position)
									}
									goto l307
								l322:
									position, tokenIndex = position307, tokenIndex307
									if !_rules[ruleLAST]() {
										goto l326
									}
									if !_rules[ruleMonth]() {
										goto l326
									}
									{
										add(ruleAction24, position)
									}
									goto l307
								l326:
									position, tokenIndex = position307, tokenIndex307
									if !_rules[ruleNEXT]() {
										goto l328
									}
									if !_rules[ruleMonth]() {
										goto l328
									}
									{
										add(ruleAction25, position)
									}
									goto l307
								l328:
									position, tokenIndex = position307, tokenIndex307
									if !_rules[ruleMonth]() {
										goto l305
									}
									{
										add(ruleAction26, position)
									}
								}
							l307:
								add(ruleRelativeMonth, position306)
							}
							goto l199
						l305:
							position, tokenIndex = position199, tokenIndex199
							{
								position332 := position
								{
									position333, tokenIndex333 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l334
									}
									if !_rules[ruleYEARS]() {
										goto l334
									}
									if !_rules[ruleAGO]() {
										goto l334
									}
									{
										add(ruleAction27, position)
									}
									goto l333
								l334:
									position, tokenIndex = position333, tokenIndex333
									{
										position337, tokenIndex337 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l338
										}
										if !_rules[ruleYEARS]() {
											goto l338
										}
										if !_rules[ruleFROM_NOW]() {
											goto l338
										}
										goto l337
									l338:
										position, tokenIndex = position337, tokenIndex337
										if !_rules[ruleIn]() {
											goto l336
										}
										{
											position339, tokenIndex339 := position, tokenIndex
											if !_rules[ruleNumber]() {
												goto l339
											}
											goto l340
										l339:
											position, tokenIndex = position339, tokenIndex339
										}
									l340:
										if !_rules[ruleYEARS]() {
											goto l336
										}
										{
											position341, tokenIndex341 := position, tokenIndex
											if !_rules[ruleFROM_NOW]() {
												goto l341
											}
											goto l342
										l341:
											position, tokenIndex = position341, tokenIndex341
										}
									l342:
									}
								l337:
									{
										add(ruleAction28, position)
									}
									goto l333
								l336:
									position, tokenIndex = position333, tokenIndex333
									if !_rules[ruleLast]() {
										goto l344
									}
									{
										position345, tokenIndex345 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l345
										}
										goto l346
									l345:
										position, tokenIndex = position345, tokenIndex345
									}
								l346:
									if !_rules[ruleYEARS]() {
										goto l344
									}
									{
										add(ruleAction29, position)
									}
									goto l333
								l344:
									position, tokenIndex = position333, tokenIndex333
									if !_rules[ruleNext]() {
										goto l348
									}
									{
										position349, tokenIndex349 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l349
										}
										goto l350
									l349:
										position, tokenIndex = position349, tokenIndex349
									}
								l350:
									if !_rules[ruleYEARS]() {
										goto l348
									}
									{
										add(ruleAction30, position)
									}
									goto l333
								l348:
									position, tokenIndex = position333, tokenIndex333
									if !_rules[ruleLAST]() {
										goto l352
									}
									if !_rules[ruleYEARS]() {
										goto l352
									}
									{
										add(ruleAction31, position)
									}
									goto l333
								l352:
									position, tokenIndex = position333, tokenIndex333
									if !_rules[ruleNEXT]() {
										goto l331
									}
									if !_rules[ruleYEARS]() {
										goto l331
									}
									{
										add(ruleAction32, position)
									}
								}
							l333:
								add(ruleRelativeYear, position332)
							}
							goto l199
						l331:
							position, tokenIndex = position199, tokenIndex199
							{
								position356 := position
								{
									position357, tokenIndex357 := position, tokenIndex
									if !_rules[ruleNumber]() {
										goto l358
									}
									{
										position359 := position
										{
											switch buffer[position] {
											case 't':
												if buffer[position] != rune('t') {
													goto l358
												}
												position++
												if buffer[position] != rune('h') {
													goto l358
												}
												position++
												break
											case 'r':
												if buffer[position] != rune('r') {
													goto l358
												}
												position++
												if buffer[position] != rune('d') {
													goto l358
												}
												position++
												break
											case 'n':
												if buffer[position] != rune('n') {
													goto l358
												}
												position++
												if buffer[position] != rune('d') {
													goto l358
												}
												position++
												break
											default:
												if buffer[position] != rune('s') {
													goto l358
												}
												position++
												if buffer[position] != rune('t') {
													goto l358
												}
												position++
												break
											}
										}

										if !_rules[rule_]() {
											goto l358
										}
										add(ruleOrdinal, position359)
									}
									goto l357
								l358:
									position, tokenIndex = position357, tokenIndex357
									if !_rules[ruleLast]() {
										goto l355
									}
									{
										position361, tokenIndex361 := position, tokenIndex
										if !_rules[ruleNumber]() {
											goto l361
										}
										goto l362
									l361:
										position, tokenIndex = position361, tokenIndex361
									}
								l362:
									if !_rules[ruleNumber]() {
										goto l355
									}
								}
							l357:
								{
									add(ruleAction39, position)
								}
								add(ruleDate, position356)
							}
							goto l199
						l355:
							position, tokenIndex = position199, tokenIndex199
							{
								position365 := position
								{
									position366, tokenIndex366 := position, tokenIndex
									{
										position368 := position
										{
											position369, tokenIndex369 := position, tokenIndex
											if !_rules[ruleNumber]() {
												goto l370
											}
											{
												add(ruleAction40, position)
											}
											{
												position372, tokenIndex372 := position, tokenIndex
												if !_rules[ruleMinutes]() {
													goto l372
												}
												{
													position374, tokenIndex374 := position, tokenIndex
													if !_rules[ruleSeconds]() {
														goto l374
													}
													goto l375
												l374:
													position, tokenIndex = position374, tokenIndex374
												}
											l375:
												goto l373
											l372:
												position, tokenIndex = position372, tokenIndex372
											}
										l373:
											{
												position376 := position
												if buffer[position] != rune('a') {
													goto l370
												}
												position++
												if buffer[position] != rune('m') {
													goto l370
												}
												position++
												if !_rules[rule_]() {
													goto l370
												}
												add(ruleAM, position376)
											}
											goto l369
										l370:
											position, tokenIndex = position369, tokenIndex369
											if !_rules[ruleNumber]() {
												goto l367
											}
											{
												add(ruleAction41, position)
											}
											{
												position378, tokenIndex378 := position, tokenIndex
												if !_rules[ruleMinutes]() {
													goto l378
												}
												{
													position380, tokenIndex380 := position, tokenIndex
													if !_rules[ruleSeconds]() {
														goto l380
													}
													goto l381
												l380:
													position, tokenIndex = position380, tokenIndex380
												}
											l381:
												goto l379
											l378:
												position, tokenIndex = position378, tokenIndex378
											}
										l379:
											{
												position382 := position
												if buffer[position] != rune('p') {
													goto l367
												}
												position++
												if buffer[position] != rune('m') {
													goto l367
												}
												position++
												if !_rules[rule_]() {
													goto l367
												}
												add(rulePM, position382)
											}
										}
									l369:
										add(ruleClock12Hour, position368)
									}
									goto l366
								l367:
									position, tokenIndex = position366, tokenIndex366
									{
										position383 := position
										if !_rules[ruleNumber]() {
											goto l364
										}
										{
											add(ruleAction42, position)
										}
										{
											position385, tokenIndex385 := position, tokenIndex
											if !_rules[ruleMinutes]() {
												goto l385
											}
											{
												position387, tokenIndex387 := position, tokenIndex
												if !_rules[ruleSeconds]() {
													goto l387
												}
												goto l388
											l387:
												position, tokenIndex = position387, tokenIndex387
											}
										l388:
											goto l386
										l385:
											position, tokenIndex = position385, tokenIndex385
										}
									l386:
										add(ruleClock24Hour, position383)
									}
								}
							l366:
								add(ruleTime, position365)
							}
							goto l199
						l364:
							position, tokenIndex = position199, tokenIndex199
							{
								position389 := position
								if c := buffer[position]; c < rune('a') || c > rune('z') {
									goto l3
								}
								position++
							l390:
								{
									position391, tokenIndex391 := position, tokenIndex
									if c := buffer[position]; c < rune('a') || c > rune('z') {
										goto l391
									}
									position++
									goto l390
								l391:
									position, tokenIndex = position391, tokenIndex391
								}
								if !_rules[rule_]() {
									goto l3
								}
								add(ruleWord, position389)
							}
						}
					l199:
						add(ruleExpr, position198)
					}
					goto l2
				l3:
					position, tokenIndex = position3, tokenIndex3
				}
				{
					position392 := position
					{
						position393, tokenIndex393 := position, tokenIndex
						if !matchDot() {
							goto l393
						}
						goto l0
					l393:
						position, tokenIndex = position393, tokenIndex393
					}
					add(ruleEOF, position392)
				}
				add(ruleQuery, position1)
			}
			return true
		l0:
			position, tokenIndex = position0, tokenIndex0
			return false
		},
		/* 1 Expr <- <(NOW / RelativeMinutes / RelativeHours / RelativeDays / RelativeWeeks / RelativeWeekdays / RelativeMonth / RelativeYear / Date / Time / Word)> */
		nil,
		/* 2 RelativeMinutes <- <((Number MINUTES AGO Action0) / (((Number MINUTES FROM_NOW) / (In Number? MINUTES FROM_NOW?)) Action1) / (Last Number? MINUTES Action2) / (Next Number? MINUTES Action3) / (Number MINUTES Action4))> */
		nil,
		/* 3 RelativeHours <- <((Number HOURS AGO Action5) / (((Number HOURS FROM_NOW) / (In Number? HOURS FROM_NOW?)) Action6) / (Last Number? HOURS Action7) / (Next Number? HOURS Action8) / (Number HOURS Action9))> */
		nil,
		/* 4 RelativeDays <- <((Number DAYS AGO Action10) / (((Number DAYS FROM_NOW) / (In Number? DAYS FROM_NOW?)) Action11) / (Last Number? DAYS Action12) / (Next Number? DAYS Action13) / (Number DAYS Action14))> */
		nil,
		/* 5 RelativeWeeks <- <((Number WEEKS AGO Action15) / (((Number WEEKS FROM_NOW) / (In Number? WEEKS FROM_NOW?)) Action16) / (Last Number? WEEKS Action17) / (Next Number? WEEKS Action18) / (Number WEEKS Action19))> */
		nil,
		/* 6 RelativeMonth <- <((Number MONTHS AGO Action20) / (((Number MONTHS FROM_NOW) / (In Number? MONTHS FROM_NOW?)) Action21) / (Last Number? MONTHS Action22) / (Next Number? MONTHS Action23) / (LAST Month Action24) / (NEXT Month Action25) / (Month Action26))> */
		nil,
		/* 7 RelativeYear <- <((Number YEARS AGO Action27) / (((Number YEARS FROM_NOW) / (In Number? YEARS FROM_NOW?)) Action28) / (Last Number? YEARS Action29) / (Next Number? YEARS Action30) / (LAST YEARS Action31) / (NEXT YEARS Action32))> */
		nil,
		/* 8 RelativeWeekdays <- <((TODAY Action33) / (TOMORROW Action35) / ((&('n') (NEXT Weekday Action37)) | (&('y') (YESTERDAY Action34)) | (&('l' | 'p') (LAST Weekday Action36)) | (&('f' | 'm' | 's' | 't' | 'w') (Weekday Action38))))> */
		nil,
		/* 9 Date <- <(((Number Ordinal) / (Last Number? Number)) Action39)> */
		nil,
		/* 10 Time <- <(Clock12Hour / Clock24Hour)> */
		nil,
		/* 11 Clock12Hour <- <((Number Action40 (Minutes Seconds?)? AM) / (Number Action41 (Minutes Seconds?)? PM))> */
		nil,
		/* 12 Clock24Hour <- <(Number Action42 (Minutes Seconds?)?)> */
		nil,
		/* 13 Minutes <- <(':' Number Action43)> */
		func() bool {
			position406, tokenIndex406 := position, tokenIndex
			{
				position407 := position
				if buffer[position] != rune(':') {
					goto l406
				}
				position++
				if !_rules[ruleNumber]() {
					goto l406
				}
				{
					add(ruleAction43, position)
				}
				add(ruleMinutes, position407)
			}
			return true
		l406:
			position, tokenIndex = position406, tokenIndex406
			return false
		},
		/* 14 Seconds <- <(':' Number Action44)> */
		func() bool {
			position409, tokenIndex409 := position, tokenIndex
			{
				position410 := position
				if buffer[position] != rune(':') {
					goto l409
				}
				position++
				if !_rules[ruleNumber]() {
					goto l409
				}
				{
					add(ruleAction44, position)
				}
				add(ruleSeconds, position410)
			}
			return true
		l409:
			position, tokenIndex = position409, tokenIndex409
			return false
		},
		/* 15 Number <- <(('t' 'w' 'o' _ Action47) / ('t' 'h' 'r' 'e' 'e' _ Action48) / ('f' 'o' 'u' 'r' _ Action49) / ('s' 'i' 'x' _ Action51) / ((&('t') ('t' 'e' 'n' _ Action55)) | (&('n') ('n' 'i' 'n' 'e' _ Action54)) | (&('e') ('e' 'i' 'g' 'h' 't' _ Action53)) | (&('s') ('s' 'e' 'v' 'e' 'n' _ Action52)) | (&('f') ('f' 'i' 'v' 'e' _ Action50)) | (&('o') ('o' 'n' 'e' _ Action46)) | (&('0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9') (<[0-9]+> _ Action45))))> */
		func() bool {
			position412, tokenIndex412 := position, tokenIndex
			{
				position413 := position
				{
					position414, tokenIndex414 := position, tokenIndex
					if buffer[position] != rune('t') {
						goto l415
					}
					position++
					if buffer[position] != rune('w') {
						goto l415
					}
					position++
					if buffer[position] != rune('o') {
						goto l415
					}
					position++
					if !_rules[rule_]() {
						goto l415
					}
					{
						add(ruleAction47, position)
					}
					goto l414
				l415:
					position, tokenIndex = position414, tokenIndex414
					if buffer[position] != rune('t') {
						goto l417
					}
					position++
					if buffer[position] != rune('h') {
						goto l417
					}
					position++
					if buffer[position] != rune('r') {
						goto l417
					}
					position++
					if buffer[position] != rune('e') {
						goto l417
					}
					position++
					if buffer[position] != rune('e') {
						goto l417
					}
					position++
					if !_rules[rule_]() {
						goto l417
					}
					{
						add(ruleAction48, position)
					}
					goto l414
				l417:
					position, tokenIndex = position414, tokenIndex414
					if buffer[position] != rune('f') {
						goto l419
					}
					position++
					if buffer[position] != rune('o') {
						goto l419
					}
					position++
					if buffer[position] != rune('u') {
						goto l419
					}
					position++
					if buffer[position] != rune('r') {
						goto l419
					}
					position++
					if !_rules[rule_]() {
						goto l419
					}
					{
						add(ruleAction49, position)
					}
					goto l414
				l419:
					position, tokenIndex = position414, tokenIndex414
					if buffer[position] != rune('s') {
						goto l421
					}
					position++
					if buffer[position] != rune('i') {
						goto l421
					}
					position++
					if buffer[position] != rune('x') {
						goto l421
					}
					position++
					if !_rules[rule_]() {
						goto l421
					}
					{
						add(ruleAction51, position)
					}
					goto l414
				l421:
					position, tokenIndex = position414, tokenIndex414
					{
						switch buffer[position] {
						case 't':
							if buffer[position] != rune('t') {
								goto l412
							}
							position++
							if buffer[position] != rune('e') {
								goto l412
							}
							position++
							if buffer[position] != rune('n') {
								goto l412
							}
							position++
							if !_rules[rule_]() {
								goto l412
							}
							{
								add(ruleAction55, position)
							}
							break
						case 'n':
							if buffer[position] != rune('n') {
								goto l412
							}
							position++
							if buffer[position] != rune('i') {
								goto l412
							}
							position++
							if buffer[position] != rune('n') {
								goto l412
							}
							position++
							if buffer[position] != rune('e') {
								goto l412
							}
							position++
							if !_rules[rule_]() {
								goto l412
							}
							{
								add(ruleAction54, position)
							}
							break
						case 'e':
							if buffer[position] != rune('e') {
								goto l412
							}
							position++
							if buffer[position] != rune('i') {
								goto l412
							}
							position++
							if buffer[position] != rune('g') {
								goto l412
							}
							position++
							if buffer[position] != rune('h') {
								goto l412
							}
							position++
							if buffer[position] != rune('t') {
								goto l412
							}
							position++
							if !_rules[rule_]() {
								goto l412
							}
							{
								add(ruleAction53, position)
							}
							break
						case 's':
							if buffer[position] != rune('s') {
								goto l412
							}
							position++
							if buffer[position] != rune('e') {
								goto l412
							}
							position++
							if buffer[position] != rune('v') {
								goto l412
							}
							position++
							if buffer[position] != rune('e') {
								goto l412
							}
							position++
							if buffer[position] != rune('n') {
								goto l412
							}
							position++
							if !_rules[rule_]() {
								goto l412
							}
							{
								add(ruleAction52, position)
							}
							break
						case 'f':
							if buffer[position] != rune('f') {
								goto l412
							}
							position++
							if buffer[position] != rune('i') {
								goto l412
							}
							position++
							if buffer[position] != rune('v') {
								goto l412
							}
							position++
							if buffer[position] != rune('e') {
								goto l412
							}
							position++
							if !_rules[rule_]() {
								goto l412
							}
							{
								add(ruleAction50, position)
							}
							break
						case 'o':
							if buffer[position] != rune('o') {
								goto l412
							}
							position++
							if buffer[position] != rune('n') {
								goto l412
							}
							position++
							if buffer[position] != rune('e') {
								goto l412
							}
							position++
							if !_rules[rule_]() {
								goto l412
							}
							{
								add(ruleAction46, position)
							}
							break
						default:
							{
								position430 := position
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l412
								}
								position++
							l431:
								{
									position432, tokenIndex432 := position, tokenIndex
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l432
									}
									position++
									goto l431
								l432:
									position, tokenIndex = position432, tokenIndex432
								}
								add(rulePegText, position430)
							}
							if !_rules[rule_]() {
								goto l412
							}
							{
								add(ruleAction45, position)
							}
							break
						}
					}

				}
			l414:
				add(ruleNumber, position413)
			}
			return true
		l412:
			position, tokenIndex = position412, tokenIndex412
			return false
		},
		/* 16 Weekday <- <(('s' 'u' 'n' 'd' 'a' 'y' _ Action56) / ('t' 'u' 'e' 's' 'd' 'a' 'y' _ Action58) / ((&('s') ('s' 'a' 't' 'u' 'r' 'd' 'a' 'y' _ Action62)) | (&('f') ('f' 'r' 'i' 'd' 'a' 'y' _ Action61)) | (&('t') ('t' 'h' 'u' 'r' 's' 'd' 'a' 'y' _ Action60)) | (&('w') ('w' 'e' 'd' 'n' 'e' 's' 'd' 'a' 'y' _ Action59)) | (&('m') ('m' 'o' 'n' 'd' 'a' 'y' _ Action57))))> */
		func() bool {
			position434, tokenIndex434 := position, tokenIndex
			{
				position435 := position
				{
					position436, tokenIndex436 := position, tokenIndex
					if buffer[position] != rune('s') {
						goto l437
					}
					position++
					if buffer[position] != rune('u') {
						goto l437
					}
					position++
					if buffer[position] != rune('n') {
						goto l437
					}
					position++
					if buffer[position] != rune('d') {
						goto l437
					}
					position++
					if buffer[position] != rune('a') {
						goto l437
					}
					position++
					if buffer[position] != rune('y') {
						goto l437
					}
					position++
					if !_rules[rule_]() {
						goto l437
					}
					{
						add(ruleAction56, position)
					}
					goto l436
				l437:
					position, tokenIndex = position436, tokenIndex436
					if buffer[position] != rune('t') {
						goto l439
					}
					position++
					if buffer[position] != rune('u') {
						goto l439
					}
					position++
					if buffer[position] != rune('e') {
						goto l439
					}
					position++
					if buffer[position] != rune('s') {
						goto l439
					}
					position++
					if buffer[position] != rune('d') {
						goto l439
					}
					position++
					if buffer[position] != rune('a') {
						goto l439
					}
					position++
					if buffer[position] != rune('y') {
						goto l439
					}
					position++
					if !_rules[rule_]() {
						goto l439
					}
					{
						add(ruleAction58, position)
					}
					goto l436
				l439:
					position, tokenIndex = position436, tokenIndex436
					{
						switch buffer[position] {
						case 's':
							if buffer[position] != rune('s') {
								goto l434
							}
							position++
							if buffer[position] != rune('a') {
								goto l434
							}
							position++
							if buffer[position] != rune('t') {
								goto l434
							}
							position++
							if buffer[position] != rune('u') {
								goto l434
							}
							position++
							if buffer[position] != rune('r') {
								goto l434
							}
							position++
							if buffer[position] != rune('d') {
								goto l434
							}
							position++
							if buffer[position] != rune('a') {
								goto l434
							}
							position++
							if buffer[position] != rune('y') {
								goto l434
							}
							position++
							if !_rules[rule_]() {
								goto l434
							}
							{
								add(ruleAction62, position)
							}
							break
						case 'f':
							if buffer[position] != rune('f') {
								goto l434
							}
							position++
							if buffer[position] != rune('r') {
								goto l434
							}
							position++
							if buffer[position] != rune('i') {
								goto l434
							}
							position++
							if buffer[position] != rune('d') {
								goto l434
							}
							position++
							if buffer[position] != rune('a') {
								goto l434
							}
							position++
							if buffer[position] != rune('y') {
								goto l434
							}
							position++
							if !_rules[rule_]() {
								goto l434
							}
							{
								add(ruleAction61, position)
							}
							break
						case 't':
							if buffer[position] != rune('t') {
								goto l434
							}
							position++
							if buffer[position] != rune('h') {
								goto l434
							}
							position++
							if buffer[position] != rune('u') {
								goto l434
							}
							position++
							if buffer[position] != rune('r') {
								goto l434
							}
							position++
							if buffer[position] != rune('s') {
								goto l434
							}
							position++
							if buffer[position] != rune('d') {
								goto l434
							}
							position++
							if buffer[position] != rune('a') {
								goto l434
							}
							position++
							if buffer[position] != rune('y') {
								goto l434
							}
							position++
							if !_rules[rule_]() {
								goto l434
							}
							{
								add(ruleAction60, position)
							}
							break
						case 'w':
							if buffer[position] != rune('w') {
								goto l434
							}
							position++
							if buffer[position] != rune('e') {
								goto l434
							}
							position++
							if buffer[position] != rune('d') {
								goto l434
							}
							position++
							if buffer[position] != rune('n') {
								goto l434
							}
							position++
							if buffer[position] != rune('e') {
								goto l434
							}
							position++
							if buffer[position] != rune('s') {
								goto l434
							}
							position++
							if buffer[position] != rune('d') {
								goto l434
							}
							position++
							if buffer[position] != rune('a') {
								goto l434
							}
							position++
							if buffer[position] != rune('y') {
								goto l434
							}
							position++
							if !_rules[rule_]() {
								goto l434
							}
							{
								add(ruleAction59, position)
							}
							break
						default:
							if buffer[position] != rune('m') {
								goto l434
							}
							position++
							if buffer[position] != rune('o') {
								goto l434
							}
							position++
							if buffer[position] != rune('n') {
								goto l434
							}
							position++
							if buffer[position] != rune('d') {
								goto l434
							}
							position++
							if buffer[position] != rune('a') {
								goto l434
							}
							position++
							if buffer[position] != rune('y') {
								goto l434
							}
							position++
							if !_rules[rule_]() {
								goto l434
							}
							{
								add(ruleAction57, position)
							}
							break
						}
					}

				}
			l436:
				add(ruleWeekday, position435)
			}
			return true
		l434:
			position, tokenIndex = position434, tokenIndex434
			return false
		},
		/* 17 Month <- <(('j' 'a' 'n' 'u' 'a' 'r' 'y' _ Action63) / ('m' 'a' 'r' 'c' 'h' _ Action65) / ('a' 'p' 'r' 'i' 'l' _ Action66) / ('j' 'u' 'n' 'e' _ Action68) / ((&('d') ('d' 'e' 'c' 'e' 'm' 'b' 'e' 'r' _ Action74)) | (&('n') ('n' 'o' 'v' 'e' 'm' 'b' 'e' 'r' _ Action73)) | (&('o') ('o' 'c' 't' 'o' 'b' 'e' 'r' _ Action72)) | (&('s') ('s' 'e' 'p' 't' 'e' 'm' 'b' 'e' 'r' _ Action71)) | (&('a') ('a' 'u' 'g' 'u' 's' 't' _ Action70)) | (&('j') ('j' 'u' 'l' 'y' _ Action69)) | (&('m') ('m' 'a' 'y' _ Action67)) | (&('f') ('f' 'e' 'b' 'r' 'u' 'a' 'r' 'y' _ Action64))))> */
		func() bool {
			position447, tokenIndex447 := position, tokenIndex
			{
				position448 := position
				{
					position449, tokenIndex449 := position, tokenIndex
					if buffer[position] != rune('j') {
						goto l450
					}
					position++
					if buffer[position] != rune('a') {
						goto l450
					}
					position++
					if buffer[position] != rune('n') {
						goto l450
					}
					position++
					if buffer[position] != rune('u') {
						goto l450
					}
					position++
					if buffer[position] != rune('a') {
						goto l450
					}
					position++
					if buffer[position] != rune('r') {
						goto l450
					}
					position++
					if buffer[position] != rune('y') {
						goto l450
					}
					position++
					if !_rules[rule_]() {
						goto l450
					}
					{
						add(ruleAction63, position)
					}
					goto l449
				l450:
					position, tokenIndex = position449, tokenIndex449
					if buffer[position] != rune('m') {
						goto l452
					}
					position++
					if buffer[position] != rune('a') {
						goto l452
					}
					position++
					if buffer[position] != rune('r') {
						goto l452
					}
					position++
					if buffer[position] != rune('c') {
						goto l452
					}
					position++
					if buffer[position] != rune('h') {
						goto l452
					}
					position++
					if !_rules[rule_]() {
						goto l452
					}
					{
						add(ruleAction65, position)
					}
					goto l449
				l452:
					position, tokenIndex = position449, tokenIndex449
					if buffer[position] != rune('a') {
						goto l454
					}
					position++
					if buffer[position] != rune('p') {
						goto l454
					}
					position++
					if buffer[position] != rune('r') {
						goto l454
					}
					position++
					if buffer[position] != rune('i') {
						goto l454
					}
					position++
					if buffer[position] != rune('l') {
						goto l454
					}
					position++
					if !_rules[rule_]() {
						goto l454
					}
					{
						add(ruleAction66, position)
					}
					goto l449
				l454:
					position, tokenIndex = position449, tokenIndex449
					if buffer[position] != rune('j') {
						goto l456
					}
					position++
					if buffer[position] != rune('u') {
						goto l456
					}
					position++
					if buffer[position] != rune('n') {
						goto l456
					}
					position++
					if buffer[position] != rune('e') {
						goto l456
					}
					position++
					if !_rules[rule_]() {
						goto l456
					}
					{
						add(ruleAction68, position)
					}
					goto l449
				l456:
					position, tokenIndex = position449, tokenIndex449
					{
						switch buffer[position] {
						case 'd':
							if buffer[position] != rune('d') {
								goto l447
							}
							position++
							if buffer[position] != rune('e') {
								goto l447
							}
							position++
							if buffer[position] != rune('c') {
								goto l447
							}
							position++
							if buffer[position] != rune('e') {
								goto l447
							}
							position++
							if buffer[position] != rune('m') {
								goto l447
							}
							position++
							if buffer[position] != rune('b') {
								goto l447
							}
							position++
							if buffer[position] != rune('e') {
								goto l447
							}
							position++
							if buffer[position] != rune('r') {
								goto l447
							}
							position++
							if !_rules[rule_]() {
								goto l447
							}
							{
								add(ruleAction74, position)
							}
							break
						case 'n':
							if buffer[position] != rune('n') {
								goto l447
							}
							position++
							if buffer[position] != rune('o') {
								goto l447
							}
							position++
							if buffer[position] != rune('v') {
								goto l447
							}
							position++
							if buffer[position] != rune('e') {
								goto l447
							}
							position++
							if buffer[position] != rune('m') {
								goto l447
							}
							position++
							if buffer[position] != rune('b') {
								goto l447
							}
							position++
							if buffer[position] != rune('e') {
								goto l447
							}
							position++
							if buffer[position] != rune('r') {
								goto l447
							}
							position++
							if !_rules[rule_]() {
								goto l447
							}
							{
								add(ruleAction73, position)
							}
							break
						case 'o':
							if buffer[position] != rune('o') {
								goto l447
							}
							position++
							if buffer[position] != rune('c') {
								goto l447
							}
							position++
							if buffer[position] != rune('t') {
								goto l447
							}
							position++
							if buffer[position] != rune('o') {
								goto l447
							}
							position++
							if buffer[position] != rune('b') {
								goto l447
							}
							position++
							if buffer[position] != rune('e') {
								goto l447
							}
							position++
							if buffer[position] != rune('r') {
								goto l447
							}
							position++
							if !_rules[rule_]() {
								goto l447
							}
							{
								add(ruleAction72, position)
							}
							break
						case 's':
							if buffer[position] != rune('s') {
								goto l447
							}
							position++
							if buffer[position] != rune('e') {
								goto l447
							}
							position++
							if buffer[position] != rune('p') {
								goto l447
							}
							position++
							if buffer[position] != rune('t') {
								goto l447
							}
							position++
							if buffer[position] != rune('e') {
								goto l447
							}
							position++
							if buffer[position] != rune('m') {
								goto l447
							}
							position++
							if buffer[position] != rune('b') {
								goto l447
							}
							position++
							if buffer[position] != rune('e') {
								goto l447
							}
							position++
							if buffer[position] != rune('r') {
								goto l447
							}
							position++
							if !_rules[rule_]() {
								goto l447
							}
							{
								add(ruleAction71, position)
							}
							break
						case 'a':
							if buffer[position] != rune('a') {
								goto l447
							}
							position++
							if buffer[position] != rune('u') {
								goto l447
							}
							position++
							if buffer[position] != rune('g') {
								goto l447
							}
							position++
							if buffer[position] != rune('u') {
								goto l447
							}
							position++
							if buffer[position] != rune('s') {
								goto l447
							}
							position++
							if buffer[position] != rune('t') {
								goto l447
							}
							position++
							if !_rules[rule_]() {
								goto l447
							}
							{
								add(ruleAction70, position)
							}
							break
						case 'j':
							if buffer[position] != rune('j') {
								goto l447
							}
							position++
							if buffer[position] != rune('u') {
								goto l447
							}
							position++
							if buffer[position] != rune('l') {
								goto l447
							}
							position++
							if buffer[position] != rune('y') {
								goto l447
							}
							position++
							if !_rules[rule_]() {
								goto l447
							}
							{
								add(ruleAction69, position)
							}
							break
						case 'm':
							if buffer[position] != rune('m') {
								goto l447
							}
							position++
							if buffer[position] != rune('a') {
								goto l447
							}
							position++
							if buffer[position] != rune('y') {
								goto l447
							}
							position++
							if !_rules[rule_]() {
								goto l447
							}
							{
								add(ruleAction67, position)
							}
							break
						default:
							if buffer[position] != rune('f') {
								goto l447
							}
							position++
							if buffer[position] != rune('e') {
								goto l447
							}
							position++
							if buffer[position] != rune('b') {
								goto l447
							}
							position++
							if buffer[position] != rune('r') {
								goto l447
							}
							position++
							if buffer[position] != rune('u') {
								goto l447
							}
							position++
							if buffer[position] != rune('a') {
								goto l447
							}
							position++
							if buffer[position] != rune('r') {
								goto l447
							}
							position++
							if buffer[position] != rune('y') {
								goto l447
							}
							position++
							if !_rules[rule_]() {
								goto l447
							}
							{
								add(ruleAction64, position)
							}
							break
						}
					}

				}
			l449:
				add(ruleMonth, position448)
			}
			return true
		l447:
			position, tokenIndex = position447, tokenIndex447
			return false
		},
		/* 18 In <- <(IN Action75)> */
		func() bool {
			position467, tokenIndex467 := position, tokenIndex
			{
				position468 := position
				{
					position469 := position
					{
						position470, tokenIndex470 := position, tokenIndex
						if buffer[position] != rune('i') {
							goto l471
						}
						position++
						if buffer[position] != rune('n') {
							goto l471
						}
						position++
						if buffer[position] != rune(' ') {
							goto l471
						}
						position++
						if buffer[position] != rune('a') {
							goto l471
						}
						position++
						if buffer[position] != rune('n') {
							goto l471
						}
						position++
						goto l470
					l471:
						position, tokenIndex = position470, tokenIndex470
						if buffer[position] != rune('i') {
							goto l472
						}
						position++
						if buffer[position] != rune('n') {
							goto l472
						}
						position++
						if buffer[position] != rune(' ') {
							goto l472
						}
						position++
						if buffer[position] != rune('a') {
							goto l472
						}
						position++
						goto l470
					l472:
						position, tokenIndex = position470, tokenIndex470
						if buffer[position] != rune('i') {
							goto l467
						}
						position++
						if buffer[position] != rune('n') {
							goto l467
						}
						position++
					}
				l470:
					if !_rules[rule_]() {
						goto l467
					}
					add(ruleIN, position469)
				}
				{
					add(ruleAction75, position)
				}
				add(ruleIn, position468)
			}
			return true
		l467:
			position, tokenIndex = position467, tokenIndex467
			return false
		},
		/* 19 Last <- <(LAST Action76)> */
		func() bool {
			position474, tokenIndex474 := position, tokenIndex
			{
				position475 := position
				if !_rules[ruleLAST]() {
					goto l474
				}
				{
					add(ruleAction76, position)
				}
				add(ruleLast, position475)
			}
			return true
		l474:
			position, tokenIndex = position474, tokenIndex474
			return false
		},
		/* 20 Next <- <(NEXT Action77)> */
		func() bool {
			position477, tokenIndex477 := position, tokenIndex
			{
				position478 := position
				if !_rules[ruleNEXT]() {
					goto l477
				}
				{
					add(ruleAction77, position)
				}
				add(ruleNext, position478)
			}
			return true
		l477:
			position, tokenIndex = position477, tokenIndex477
			return false
		},
		/* 21 Ordinal <- <(((&('t') ('t' 'h')) | (&('r') ('r' 'd')) | (&('n') ('n' 'd')) | (&('s') ('s' 't'))) _)> */
		nil,
		/* 22 Word <- <([a-z]+ _)> */
		nil,
		/* 23 YEARS <- <('y' 'e' 'a' 'r' 's'? _)> */
		func() bool {
			position482, tokenIndex482 := position, tokenIndex
			{
				position483 := position
				if buffer[position] != rune('y') {
					goto l482
				}
				position++
				if buffer[position] != rune('e') {
					goto l482
				}
				position++
				if buffer[position] != rune('a') {
					goto l482
				}
				position++
				if buffer[position] != rune('r') {
					goto l482
				}
				position++
				{
					position484, tokenIndex484 := position, tokenIndex
					if buffer[position] != rune('s') {
						goto l484
					}
					position++
					goto l485
				l484:
					position, tokenIndex = position484, tokenIndex484
				}
			l485:
				if !_rules[rule_]() {
					goto l482
				}
				add(ruleYEARS, position483)
			}
			return true
		l482:
			position, tokenIndex = position482, tokenIndex482
			return false
		},
		/* 24 MONTHS <- <('m' 'o' 'n' 't' 'h' 's'? _)> */
		func() bool {
			position486, tokenIndex486 := position, tokenIndex
			{
				position487 := position
				if buffer[position] != rune('m') {
					goto l486
				}
				position++
				if buffer[position] != rune('o') {
					goto l486
				}
				position++
				if buffer[position] != rune('n') {
					goto l486
				}
				position++
				if buffer[position] != rune('t') {
					goto l486
				}
				position++
				if buffer[position] != rune('h') {
					goto l486
				}
				position++
				{
					position488, tokenIndex488 := position, tokenIndex
					if buffer[position] != rune('s') {
						goto l488
					}
					position++
					goto l489
				l488:
					position, tokenIndex = position488, tokenIndex488
				}
			l489:
				if !_rules[rule_]() {
					goto l486
				}
				add(ruleMONTHS, position487)
			}
			return true
		l486:
			position, tokenIndex = position486, tokenIndex486
			return false
		},
		/* 25 WEEKS <- <('w' 'e' 'e' 'k' 's'? _)> */
		func() bool {
			position490, tokenIndex490 := position, tokenIndex
			{
				position491 := position
				if buffer[position] != rune('w') {
					goto l490
				}
				position++
				if buffer[position] != rune('e') {
					goto l490
				}
				position++
				if buffer[position] != rune('e') {
					goto l490
				}
				position++
				if buffer[position] != rune('k') {
					goto l490
				}
				position++
				{
					position492, tokenIndex492 := position, tokenIndex
					if buffer[position] != rune('s') {
						goto l492
					}
					position++
					goto l493
				l492:
					position, tokenIndex = position492, tokenIndex492
				}
			l493:
				if !_rules[rule_]() {
					goto l490
				}
				add(ruleWEEKS, position491)
			}
			return true
		l490:
			position, tokenIndex = position490, tokenIndex490
			return false
		},
		/* 26 DAYS <- <('d' 'a' 'y' 's'? _)> */
		func() bool {
			position494, tokenIndex494 := position, tokenIndex
			{
				position495 := position
				if buffer[position] != rune('d') {
					goto l494
				}
				position++
				if buffer[position] != rune('a') {
					goto l494
				}
				position++
				if buffer[position] != rune('y') {
					goto l494
				}
				position++
				{
					position496, tokenIndex496 := position, tokenIndex
					if buffer[position] != rune('s') {
						goto l496
					}
					position++
					goto l497
				l496:
					position, tokenIndex = position496, tokenIndex496
				}
			l497:
				if !_rules[rule_]() {
					goto l494
				}
				add(ruleDAYS, position495)
			}
			return true
		l494:
			position, tokenIndex = position494, tokenIndex494
			return false
		},
		/* 27 HOURS <- <('h' 'o' 'u' 'r' 's'? _)> */
		func() bool {
			position498, tokenIndex498 := position, tokenIndex
			{
				position499 := position
				if buffer[position] != rune('h') {
					goto l498
				}
				position++
				if buffer[position] != rune('o') {
					goto l498
				}
				position++
				if buffer[position] != rune('u') {
					goto l498
				}
				position++
				if buffer[position] != rune('r') {
					goto l498
				}
				position++
				{
					position500, tokenIndex500 := position, tokenIndex
					if buffer[position] != rune('s') {
						goto l500
					}
					position++
					goto l501
				l500:
					position, tokenIndex = position500, tokenIndex500
				}
			l501:
				if !_rules[rule_]() {
					goto l498
				}
				add(ruleHOURS, position499)
			}
			return true
		l498:
			position, tokenIndex = position498, tokenIndex498
			return false
		},
		/* 28 MINUTES <- <('m' 'i' 'n' 'u' 't' 'e' 's'? _)> */
		func() bool {
			position502, tokenIndex502 := position, tokenIndex
			{
				position503 := position
				if buffer[position] != rune('m') {
					goto l502
				}
				position++
				if buffer[position] != rune('i') {
					goto l502
				}
				position++
				if buffer[position] != rune('n') {
					goto l502
				}
				position++
				if buffer[position] != rune('u') {
					goto l502
				}
				position++
				if buffer[position] != rune('t') {
					goto l502
				}
				position++
				if buffer[position] != rune('e') {
					goto l502
				}
				position++
				{
					position504, tokenIndex504 := position, tokenIndex
					if buffer[position] != rune('s') {
						goto l504
					}
					position++
					goto l505
				l504:
					position, tokenIndex = position504, tokenIndex504
				}
			l505:
				if !_rules[rule_]() {
					goto l502
				}
				add(ruleMINUTES, position503)
			}
			return true
		l502:
			position, tokenIndex = position502, tokenIndex502
			return false
		},
		/* 29 YESTERDAY <- <('y' 'e' 's' 't' 'e' 'r' 'd' 'a' 'y' _)> */
		nil,
		/* 30 TOMORROW <- <('t' 'o' 'm' 'o' 'r' 'r' 'o' 'w' _)> */
		nil,
		/* 31 TODAY <- <('t' 'o' 'd' 'a' 'y' _)> */
		nil,
		/* 32 AGO <- <('a' 'g' 'o' _)> */
		func() bool {
			position509, tokenIndex509 := position, tokenIndex
			{
				position510 := position
				if buffer[position] != rune('a') {
					goto l509
				}
				position++
				if buffer[position] != rune('g') {
					goto l509
				}
				position++
				if buffer[position] != rune('o') {
					goto l509
				}
				position++
				if !_rules[rule_]() {
					goto l509
				}
				add(ruleAGO, position510)
			}
			return true
		l509:
			position, tokenIndex = position509, tokenIndex509
			return false
		},
		/* 33 FROM_NOW <- <('f' 'r' 'o' 'm' ' ' 'n' 'o' 'w' _)> */
		func() bool {
			position511, tokenIndex511 := position, tokenIndex
			{
				position512 := position
				if buffer[position] != rune('f') {
					goto l511
				}
				position++
				if buffer[position] != rune('r') {
					goto l511
				}
				position++
				if buffer[position] != rune('o') {
					goto l511
				}
				position++
				if buffer[position] != rune('m') {
					goto l511
				}
				position++
				if buffer[position] != rune(' ') {
					goto l511
				}
				position++
				if buffer[position] != rune('n') {
					goto l511
				}
				position++
				if buffer[position] != rune('o') {
					goto l511
				}
				position++
				if buffer[position] != rune('w') {
					goto l511
				}
				position++
				if !_rules[rule_]() {
					goto l511
				}
				add(ruleFROM_NOW, position512)
			}
			return true
		l511:
			position, tokenIndex = position511, tokenIndex511
			return false
		},
		/* 34 NOW <- <('n' 'o' 'w' _)> */
		nil,
		/* 35 AM <- <('a' 'm' _)> */
		nil,
		/* 36 PM <- <('p' 'm' _)> */
		nil,
		/* 37 NEXT <- <('n' 'e' 'x' 't' _)> */
		func() bool {
			position516, tokenIndex516 := position, tokenIndex
			{
				position517 := position
				if buffer[position] != rune('n') {
					goto l516
				}
				position++
				if buffer[position] != rune('e') {
					goto l516
				}
				position++
				if buffer[position] != rune('x') {
					goto l516
				}
				position++
				if buffer[position] != rune('t') {
					goto l516
				}
				position++
				if !_rules[rule_]() {
					goto l516
				}
				add(ruleNEXT, position517)
			}
			return true
		l516:
			position, tokenIndex = position516, tokenIndex516
			return false
		},
		/* 38 IN <- <((('i' 'n' ' ' 'a' 'n') / ('i' 'n' ' ' 'a') / ('i' 'n')) _)> */
		nil,
		/* 39 LAST <- <((('l' 'a' 's' 't') / ('p' 'a' 's' 't') / ('p' 'r' 'e' 'v' 'i' 'o' 'u' 's')) _)> */
		func() bool {
			position519, tokenIndex519 := position, tokenIndex
			{
				position520 := position
				{
					position521, tokenIndex521 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l522
					}
					position++
					if buffer[position] != rune('a') {
						goto l522
					}
					position++
					if buffer[position] != rune('s') {
						goto l522
					}
					position++
					if buffer[position] != rune('t') {
						goto l522
					}
					position++
					goto l521
				l522:
					position, tokenIndex = position521, tokenIndex521
					if buffer[position] != rune('p') {
						goto l523
					}
					position++
					if buffer[position] != rune('a') {
						goto l523
					}
					position++
					if buffer[position] != rune('s') {
						goto l523
					}
					position++
					if buffer[position] != rune('t') {
						goto l523
					}
					position++
					goto l521
				l523:
					position, tokenIndex = position521, tokenIndex521
					if buffer[position] != rune('p') {
						goto l519
					}
					position++
					if buffer[position] != rune('r') {
						goto l519
					}
					position++
					if buffer[position] != rune('e') {
						goto l519
					}
					position++
					if buffer[position] != rune('v') {
						goto l519
					}
					position++
					if buffer[position] != rune('i') {
						goto l519
					}
					position++
					if buffer[position] != rune('o') {
						goto l519
					}
					position++
					if buffer[position] != rune('u') {
						goto l519
					}
					position++
					if buffer[position] != rune('s') {
						goto l519
					}
					position++
				}
			l521:
				if !_rules[rule_]() {
					goto l519
				}
				add(ruleLAST, position520)
			}
			return true
		l519:
			position, tokenIndex = position519, tokenIndex519
			return false
		},
		/* 40 _ <- <Whitespace*> */
		func() bool {
			{
				position525 := position
			l526:
				{
					position527, tokenIndex527 := position, tokenIndex
					{
						position528 := position
						{
							switch buffer[position] {
							case '\t':
								if buffer[position] != rune('\t') {
									goto l527
								}
								position++
								break
							case ' ':
								if buffer[position] != rune(' ') {
									goto l527
								}
								position++
								break
							default:
								{
									position530 := position
									{
										position531, tokenIndex531 := position, tokenIndex
										if buffer[position] != rune('\r') {
											goto l532
										}
										position++
										if buffer[position] != rune('\n') {
											goto l532
										}
										position++
										goto l531
									l532:
										position, tokenIndex = position531, tokenIndex531
										if buffer[position] != rune('\n') {
											goto l533
										}
										position++
										goto l531
									l533:
										position, tokenIndex = position531, tokenIndex531
										if buffer[position] != rune('\r') {
											goto l527
										}
										position++
									}
								l531:
									add(ruleEOL, position530)
								}
								break
							}
						}

						add(ruleWhitespace, position528)
					}
					goto l526
				l527:
					position, tokenIndex = position527, tokenIndex527
				}
				add(rule_, position525)
			}
			return true
		},
		/* 41 Whitespace <- <((&('\t') '\t') | (&(' ') ' ') | (&('\n' | '\r') EOL))> */
		nil,
		/* 42 EOL <- <(('\r' '\n') / '\n' / '\r')> */
		nil,
		/* 43 EOF <- <!.> */
		nil,
		/* 45 Action0 <- <{
		   p.t = p.t.Add(-time.Minute * time.Duration(p.number))
		 }> */
		nil,
		/* 46 Action1 <- <{
		   p.t = p.t.Add(time.Minute * time.Duration(p.number))
		 }> */
		nil,
		/* 47 Action2 <- <{
		   p.t = p.t.Add(-time.Minute * time.Duration(p.number))
		 }> */
		nil,
		/* 48 Action3 <- <{
		   p.t = p.t.Add(time.Minute * time.Duration(p.number))
		 }> */
		nil,
		/* 49 Action4 <- <{
		   p.t = p.t.Add(p.withDirection(time.Minute) * time.Duration(p.number))
		 }> */
		nil,
		/* 50 Action5 <- <{
		   p.t = p.t.Add(-time.Hour * time.Duration(p.number))
		 }> */
		nil,
		/* 51 Action6 <- <{
		   p.t = p.t.Add(time.Hour * time.Duration(p.number))
		 }> */
		nil,
		/* 52 Action7 <- <{
		   p.t = p.t.Add(-time.Hour * time.Duration(p.number))
		 }> */
		nil,
		/* 53 Action8 <- <{
		   p.t = p.t.Add(time.Hour * time.Duration(p.number))
		 }> */
		nil,
		/* 54 Action9 <- <{
		   p.t = p.t.Add(p.withDirection(time.Hour) * time.Duration(p.number))
		 }> */
		nil,
		/* 55 Action10 <- <{
		   p.t = truncateDay(p.t.Add(-day * time.Duration(p.number)))
		 }> */
		nil,
		/* 56 Action11 <- <{
		   p.t = p.t.Add(day * time.Duration(p.number))
		 }> */
		nil,
		/* 57 Action12 <- <{
		   p.t = truncateDay(p.t.Add(-day * time.Duration(p.number)))
		 }> */
		nil,
		/* 58 Action13 <- <{
		   p.t = truncateDay(p.t.Add(day * time.Duration(p.number)))
		 }> */
		nil,
		/* 59 Action14 <- <{
		   p.t = truncateDay(p.t.Add(p.withDirection(day) * time.Duration(p.number)))
		 }> */
		nil,
		/* 60 Action15 <- <{
		   p.t = truncateDay(p.t.Add(-week * time.Duration(p.number)))
		 }> */
		nil,
		/* 61 Action16 <- <{
		   p.t = p.t.Add(week * time.Duration(p.number))
		 }> */
		nil,
		/* 62 Action17 <- <{
		   p.t = truncateDay(p.t.Add(-week * time.Duration(p.number)))
		 }> */
		nil,
		/* 63 Action18 <- <{
		   p.t = truncateDay(p.t.Add(week * time.Duration(p.number)))
		 }> */
		nil,
		/* 64 Action19 <- <{
		   p.t = truncateDay(p.t.Add(p.withDirection(week) * time.Duration(p.number)))
		 }> */
		nil,
		/* 65 Action20 <- <{
		   p.t = p.t.AddDate(0, -p.number, 0)
		 }> */
		nil,
		/* 66 Action21 <- <{
		   p.t = p.t.AddDate(0, p.number, 0)
		 }> */
		nil,
		/* 67 Action22 <- <{
		   p.t = p.t.AddDate(0, -p.number, 0)
		 }> */
		nil,
		/* 68 Action23 <- <{
		   p.t = p.t.AddDate(0, p.number, 0)
		 }> */
		nil,
		/* 69 Action24 <- <{
		   p.t = prevMonth(p.t, p.month)
		 }> */
		nil,
		/* 70 Action25 <- <{
		   p.t = nextMonth(p.t, p.month)
		 }> */
		nil,
		/* 71 Action26 <- <{
		   if p.direction < 0 {
		     p.t = prevMonth(p.t, p.month)
		   } else {
		     p.t = nextMonth(p.t, p.month)
		   }
		 }> */
		nil,
		/* 72 Action27 <- <{
		   p.t = p.t.AddDate(-p.number, 0, 0)
		 }> */
		nil,
		/* 73 Action28 <- <{
		   p.t = p.t.AddDate(p.number, 0, 0)
		 }> */
		nil,
		/* 74 Action29 <- <{
		   p.t = p.t.AddDate(-p.number, 0, 0)
		 }> */
		nil,
		/* 75 Action30 <- <{
		   p.t = p.t.AddDate(p.number, 0, 0)
		 }> */
		nil,
		/* 76 Action31 <- <{
		   p.t = time.Date(p.t.Year() - 1, 1, 1, 0, 0, 0, 0, p.t.Location())
		 }> */
		nil,
		/* 77 Action32 <- <{
		   p.t = time.Date(p.t.Year() + 1, 1, 1, 0, 0, 0, 0, p.t.Location())
		 }> */
		nil,
		/* 78 Action33 <- <{
		   p.t = truncateDay(p.t)
		 }> */
		nil,
		/* 79 Action34 <- <{
		   p.t = truncateDay(p.t.Add(-day))
		 }> */
		nil,
		/* 80 Action35 <- <{
		   p.t = truncateDay(p.t.Add(+day))
		 }> */
		nil,
		/* 81 Action36 <- <{
		   p.t = truncateDay(prevWeekday(p.t, p.weekday))
		 }> */
		nil,
		/* 82 Action37 <- <{
		   p.t = truncateDay(nextWeekday(p.t, p.weekday))
		 }> */
		nil,
		/* 83 Action38 <- <{
		   if p.direction < 0 {
		     p.t = truncateDay(prevWeekday(p.t, p.weekday))
		   } else {
		     p.t = truncateDay(nextWeekday(p.t, p.weekday))
		   }
		 }> */
		nil,
		/* 84 Action39 <- <{
		   t := p.t
		   year, month, _ := t.Date()
		   hour, min, sec := t.Clock()
		   p.t = time.Date(year, month, p.number, hour, min, sec, 0, t.Location())
		 }> */
		nil,
		/* 85 Action40 <- <{
		   year, month, day := p.t.Date()
		   p.t = time.Date(year, month, day, p.number, 0, 0, 0, p.t.Location())
		 }> */
		nil,
		/* 86 Action41 <- <{
		   year, month, day := p.t.Date()
		   p.t = time.Date(year, month, day, p.number + 12, 0, 0, 0, p.t.Location())
		 }> */
		nil,
		/* 87 Action42 <- <{
		   year, month, day := p.t.Date()
		   p.t = time.Date(year, month, day, p.number, 0, 0, 0, p.t.Location())
		 }> */
		nil,
		/* 88 Action43 <- <{
		   t := p.t
		   year, month, day := t.Date()
		   hour, _, _ := t.Clock()
		   p.t = time.Date(year, month, day, hour, p.number, 0, 0, t.Location())
		 }> */
		nil,
		/* 89 Action44 <- <{
		   t := p.t
		   year, month, day := t.Date()
		   hour, min, _ := t.Clock()
		   p.t = time.Date(year, month, day, hour, min, p.number, 0, t.Location())
		 }> */
		nil,
		nil,
		/* 91 Action45 <- <{ n, _ := strconv.Atoi(text); p.number = n }> */
		nil,
		/* 92 Action46 <- <{ p.number = 1 }> */
		nil,
		/* 93 Action47 <- <{ p.number = 2 }> */
		nil,
		/* 94 Action48 <- <{ p.number = 3 }> */
		nil,
		/* 95 Action49 <- <{ p.number = 4 }> */
		nil,
		/* 96 Action50 <- <{ p.number = 5 }> */
		nil,
		/* 97 Action51 <- <{ p.number = 6 }> */
		nil,
		/* 98 Action52 <- <{ p.number = 7 }> */
		nil,
		/* 99 Action53 <- <{ p.number = 8 }> */
		nil,
		/* 100 Action54 <- <{ p.number = 9 }> */
		nil,
		/* 101 Action55 <- <{ p.number = 10 }> */
		nil,
		/* 102 Action56 <- <{ p.weekday = time.Sunday }> */
		nil,
		/* 103 Action57 <- <{ p.weekday = time.Monday }> */
		nil,
		/* 104 Action58 <- <{ p.weekday = time.Tuesday }> */
		nil,
		/* 105 Action59 <- <{ p.weekday = time.Wednesday }> */
		nil,
		/* 106 Action60 <- <{ p.weekday = time.Thursday }> */
		nil,
		/* 107 Action61 <- <{ p.weekday = time.Friday }> */
		nil,
		/* 108 Action62 <- <{ p.weekday = time.Saturday }> */
		nil,
		/* 109 Action63 <- <{ p.month = time.January }> */
		nil,
		/* 110 Action64 <- <{ p.month = time.February }> */
		nil,
		/* 111 Action65 <- <{ p.month = time.March }> */
		nil,
		/* 112 Action66 <- <{ p.month = time.April }> */
		nil,
		/* 113 Action67 <- <{ p.month = time.May }> */
		nil,
		/* 114 Action68 <- <{ p.month = time.June }> */
		nil,
		/* 115 Action69 <- <{ p.month = time.July }> */
		nil,
		/* 116 Action70 <- <{ p.month = time.August }> */
		nil,
		/* 117 Action71 <- <{ p.month = time.September }> */
		nil,
		/* 118 Action72 <- <{ p.month = time.October }> */
		nil,
		/* 119 Action73 <- <{ p.month = time.November }> */
		nil,
		/* 120 Action74 <- <{ p.month = time.December }> */
		nil,
		/* 121 Action75 <- <{ p.number = 1}> */
		nil,
		/* 122 Action76 <- <{ p.number = 1 }> */
		nil,
		/* 123 Action77 <- <{ p.number = 1 }> */
		nil,
	}
	p.rules = _rules
	return nil
}
